<?php

namespace Modules\WarehousePod\Controllers;

use Illuminate\Http\Request;
use Modules\WarehousePod\Controllers\Controller;
use Modules\Ticket\Helpers\DBconnect;
use Module;
use Modules\WarehousePod\Models\Printing;
use Modules\WarehousePod\Models\Warehouse;

class ProviderController extends Controller
{
    protected $connection = null;

    public function __construct()
    {        
        parent::__construct();
        if ($this->connection == null) {
            $this->connection = DBconnect::connect($this->market);
        }
    }

    public function index(Request $request)
    {
        $printing = Printing::on($this->configName)
                                ->pluck('name', 'code')
                                ->toArray();
        return view('warehouse-pod::system.provider-printings.index', ['printings' => $printing]);
    }
}
