<?php

namespace Modules\WarehousePod\Controllers\Services;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Modules\WarehousePod\Controllers\Controller;
use Modules\WarehousePod\Models\Log;
use Modules\WarehousePod\Models\Printing;
use Modules\WarehousePod\Models\Country;
use Modules\Ticket\Helpers\DBconnect;

class PrintingService extends Controller
{
    protected $connection = null;
    protected $printings = [];
    public function __construct()
    {
        parent::__construct();
        if ($this->connection == null) {
            $locate = env('APP_LOCALE');
            if ($locate == 'central') {
                $this->configName = 'market_central';
            }
            $this->connection = DBconnect::connect($this->market);
        }
    }

    public function find(Request $request)
    {
        $filter = $this->buildFilter($request);
        $result = $this->getResult($filter);
        $this->decorResult($result);
        $pageId = $filter['page_id'];
        $pageSize = $filter['page_size'];
        unset($filter['page_id']);
        unset($filter['page_size']);
        $filter['metric'] = 'count';
        $total = $this->getResult($filter);
        $pagesCount = $this->recordsCountToPagesCount($total, $pageSize);
        $response = array(
            "status" => 'successful',
            "result" => $result,
            'pagesCount' => $pagesCount,
            'pageId' => $pageId
        );
        return response()->json($response);
    }

    private function decorResult(&$items)
    {
    }

    private function getResult($filter)
    {
        $query = Printing::on($this->configName);
        if (isset($filter['id']) && $filter['id'] != '') {
            $query->where('id', '=', $filter['id']);
        }
        if (isset($filter['keyword']) && $filter['keyword'] != '') {
            $query->where('name', 'LIKE', '%' . $filter['keyword'] . '%');
            $query->orWhere('code', 'LIKE', '%' . $filter['keyword'] . '%');
        }

        $query->orderBy('created_at', 'DESC');
        if (isset($filter['metric']) && $filter['metric'] == 'count') {
            return $query->count();
        } else {
            if (isset($filter['page_size']) && isset($filter['page_id'])) {
                $query->forPage($filter['page_id'] + 1, $filter['page_size']);
            }
            return $query->get();
        }
    }

    private function buildFilter($request)
    {
        $retVal = [];
        $columns = ['id', 'keyword'];
        foreach ($columns as $column) {
            if ($request->has($column)) {
                $retVal[$column] = $request->input($column);
            }
        }
        $retVal['page_size'] = 50;
        $retVal['page_id'] = $request->has('page_id') ? $request->input('page_id') : 0;
        return $retVal;
    }

    public function store(Request $request)
    {
        $data = $this->buildDataPrinting($request);
        $email = $request->has('email') ? $request->get('email') : null;
        $log = [
            'actor_type' => 'staff',
            'actor_email' => $email,
            'target_type' => 'PRINTING',
            'created_at' => new \DateTime()
        ];
        $oldData = null;
        if ($request->has("id")) {
            $data["id"] = $request->get("id");
        }
        if (isset($data['id']) && !empty($data['id'])) {
            $oldData = Printing::on($this->configName)->find($data['id']);
            Printing::on($this->configName)
                ->where('id', '=', $data['id'])
                ->update($data);
            $printing = Printing::on($this->configName)->find($data['id']);
            $log['event_type'] = 'UPDATE';
        } else {
            $isExists = Printing::on($this->configName)
                ->where('name', '=', $data['name'])
                ->exists();
            if ($isExists) {
                $response = [
                    'status' => 'fail',
                    'message' => 'Printing is already exists'
                ];
                return response()->json($response);
            }
            $printing = Printing::on($this->configName)->create($data);
            $log['event_type'] = 'CREATE';
        }
        $log['target_id'] = $printing->id;
        $log['data'] = json_encode($request->all());
        Log::on($this->configName)->create($log);
        $response = [
            'status' => 'successful',
            'result' => $printing
        ];
        return response()->json($response);
    }

    private function buildDataPrinting($request)
    {
        $columns = ['name', 'code', 'description', 'sorder', 'config'];
        $retVal = [];
        foreach ($columns as $column) {
            $retVal[$column] = ($request->has($column)) ? $request->get($column) : NULL;
        }
        return $retVal;
    }

    public function delete(Request $request)
    {
        $id = $request->has('id') ? $request->input('id') : [];
        $email = $request->has('email') ? $request->get('email') : null;
        $response = ['status' => 'fail'];
        if (!empty($id)) {
            $log = [
                'actor_type' => 'staff',
                'actor_email' => $email,
                'target_type' => 'printing',
                'event_type' => 'DELETE',
                'created_at' => new \DateTime()
            ];
            Printing::on($this->configName)
                ->where('id', $id)
                ->delete();
            $log['target_id'] = $id;
            $log['data'] = json_encode($request->all());
            Log::on($this->configName)->create($log);
            $response['status'] = 'successful';
        }
        return response()->json($response);
    }
}
