<?php

namespace Modules\WarehousePod\Controllers\Services;

use App\Utils\SkuHelper;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Modules\WarehousePod\Controllers\Controller;
use Modules\WarehousePod\Models\Printing;
use Modules\Ticket\Helpers\DBconnect;
use Modules\WarehousePod\Models\CategoryNPrint;
use Modules\WarehousePod\Models\Product;
use Modules\WarehousePod\Models\ProductNCategory;
use Modules\WarehousePod\Models\ProductSkuValue;

class WarehouseProductPrintService extends Controller
{
    protected $connection = null;
    protected $printings = [];
    public function __construct()
    {        
        parent::__construct();
        if ($this->connection == null) {
            $this->connection = DBconnect::connect($this->market);
        }
        if (!empty($printings)) {
            $this->printings = Printing::on($this->configName)
                                        ->pluck('name', 'code')
                                        ->toArray();
        }
    }

    public function find(Request $request) {
        $filter = $this->buildFilter($request);
        $result = $this->getResult($filter);
        $pageId = $filter['page_id'];
        $pageSize = $filter['page_size'];
        unset($filter['page_id']);
        unset($filter['page_size']);
        $filter['metric'] = 'count';
        $total = $this->getResult($filter);
        $pagesCount = $this->recordsCountToPagesCount($total, $pageSize);
        $response = array(
            "status" => 'successful',
            "result" => $result,
            'pagesCount' => $pagesCount,
            'pageId' => $pageId
        );
        return response()->json($response);
    }

    private function getResult($filter) {
        $query = CategoryNPrint::on($this->configName);
        if (isset($filter['keyword']) && $filter['keyword'] != '') {
            //@todo delete
            $query->leftJoin('category', 'category.id', '=', 'category_n_print.category_id');
            $query->where('category.name', 'LIKE', '%' . $filter['keyword'] . '%');
        }

        if (isset($filter['metric']) && $filter['metric'] == 'count') {
            return $query->count();
        } else {
            if (isset($filter['page_size']) && isset($filter['page_id'])) {
                $query->forPage($filter['page_id'] + 1, $filter['page_size']);
            }
            return $query->get();
        }
    }

    private function buildFilter($request) {
        $retVal = [];
        $columns = ['print_id', 'keyword'];
        foreach($columns as $column) {
            if ($request->has($column)){
                $retVal[$column] = $request->input($column);
            }
        }
        $retVal['page_size'] = 50;
        $retVal['page_id'] = $request->has('page_id') ? $request->input('page_id') : 0;
        return $retVal;
    }

    public function store(Request $request)
    {
       $input = $request->all();
       if (array_key_exists('category_id', $input) && array_key_exists('print_id', $input)) {
            $dataSave = [
                'category_id' => $input['category_id'],
                'print_id' => $input['print_id'],
                'style' => isset($input['style']) ? implode(",", $input['style']) : null,
                'created_at' => new \DateTime(),
                'updated_at' => new \DateTime(),
            ];
            CategoryNPrint::on($this->configName)
                            ->create($dataSave);
       }
        $response = [
            'status' => 'successful'
        ];
        return response()->json($response);
    }

    public function delete(Request $request) {
        $ids = $request->has('ids') ? $request->input('ids') : [];
        $response = ['status' => 'fail'];
        if (!empty($ids)) {
            CategoryNPrint::on($this->configName)
                                ->whereIn('id', $ids)
                                ->delete();
            $response['status'] = 'successful';
        }
        return response()->json($response);
    }

    public function isPrintByPrintify(Request $request) {
        $response = [
            "status" => "fail",
            "result" => false,
        ];
        if ($request->has('productId')) {
            $result = false;
            $productId = $request->input('productId');
            $skuId = $request->has('skuId') ? $request->input('skuId') : null;
            $product = Product::find($productId);
            if ($skuId) {
                $productSkuValue = ProductSkuValue::where('sku_id', $skuId)
                    ->where("variant_id", 7)
                    ->first(['variant_option_id']);
            }
            $cate = ProductNCategory::where('product_id', $product->id)->where("is_parent", 0)->first();
            $printing = Printing::where("code", "printify")->first();
            if ($cate && $printing) {
                $cateNPrint = CategoryNPrint::where("category_id", $cate->category_id)->where("print_id", $printing->id)->get();
                foreach ($cateNPrint as $item) {
                    $validVariantOption = explode(",", $item->style);
                    if (isset($productSkuValue) && in_array($productSkuValue->variant_option_id, $validVariantOption)) {
                        $result = true;
                    }
                }
            }
            $response = [
                "status" => "successful",
                "result" => $result,
            ];
        }
        return response()->json($response);
    }
}
