<?php

namespace Modules\WarehousePod\Controllers;

use Illuminate\Http\Request;
use Modules\WarehousePod\Controllers\Controller;
use Modules\Ticket\Helpers\DBconnect;
use Module;
use Modules\WarehousePod\Models\Printing;
use Modules\WarehousePod\Models\Warehouse;

class WarehouseProductController extends Controller
{
    protected $connection = null;

    public function __construct()
    {        
        parent::__construct();
        if ($this->connection == null) {
            $this->connection = DBconnect::connect($this->market);
        }
    }

    public function index(Request $request)
    {
        $printing = Printing::on($this->configName)
                                ->pluck('name', 'code')
                                ->toArray();
        $warehouses = Warehouse::on($this->configName)
                                ->orderBy('name', 'ASC')
                                ->pluck('name', 'id')
                                ->toArray();
        $warehouseActives = Warehouse::on($this->configName)
                                    ->where('is_active', '=', 1)
                                    ->orderBy('name', 'ASC')
                                    ->pluck('name', 'id')
                                    ->toArray();
        return view('warehouse-pod::system.product.index', ['printings' => $printing, 'warehouses' => $warehouses, 'warehouseActives' => $warehouseActives]);
    }
}
