<?php

namespace Modules\WarehousePod\Controllers;

use Illuminate\Http\Request;
use Modules\WarehousePod\Controllers\Controller;
use Modules\Ticket\Helpers\DBconnect;
use Module;
use Modules\WarehousePod\Models\Country;
use Modules\WarehousePod\Models\Printing;
use Modules\WarehousePod\Models\Category;
use Modules\WarehousePod\Models\ProductVariant;
use Modules\WarehousePod\Models\WarehouseProviderVariantOption;
class WarehouseProviderController extends Controller
{
    protected $connection = null;

    public function __construct()
    {   
        parent::__construct();
        if ($this->connection == null) {
            $this->connection = DBconnect::connect($this->market);
        }
    }

    public function index(Request $request)
    {
        $categories = Category::on($this->configName)
            ->where('type', '=', 'PRODUCT')
            ->where('is_hidden', '=', 0)
            ->orderBy('name', 'ASC')
            ->pluck('name', 'id')
            ->toArray();
        $options = $this->connection->table('product_variant')
            ->get(['name', 'id']);
        $countries = Country::on($this->configName)
                                ->orderBy('name', 'ASC')
                                ->pluck('name', 'id')
                                ->toArray();
        $countries[-1] = "All countries";
        $printings = Printing::on($this->configName)
            ->pluck('name', 'id')
            ->toArray();
        return view('warehouse-pod::system.provider.index', [
            'countries' => $countries,
            'printings' => $printings,
            'categories' => $categories,
            'options' => $options,
            'isDetail' => false,
        ]);
    }
    public function detail(Request $request, $id)
    {
        $categories = Category::on($this->configName)
            ->where('type', '=', 'PRODUCT')
            ->where('is_hidden', '=', 0)
            ->orderBy('name', 'ASC')
            ->pluck('name', 'id')
            ->toArray();
        $options = $this->connection->table('product_variant')
            ->get(['name', 'id']);
        $countries = Country::on($this->configName)
                                ->orderBy('name', 'ASC')
                                ->pluck('name', 'id')
                                ->toArray();
        $countries[-1] = "All countries";
        $printings = Printing::on($this->configName)
            ->pluck('name', 'id')
            ->toArray();
        return view('warehouse-pod::system.provider.detail', [
            'countries' => $countries,
            'printings' => $printings,
            'categories' => $categories,
            'options' => $options,
            'isDetail' => true,
            'id' => $id,
        ]);
    }
    public function mappingVariant(Request $request)
    {
        $options = ProductVariant::on($this->configName)
            ->get(['name', 'id']);
        $providerVariant = WarehouseProviderVariantOption::on($this->configName)
            ->get(['name', 'id']);
        return view('warehouse-pod::system.provider.mapping-variant', [
            'options' => $options,
            'providerVariant' => $providerVariant,
        ]);
    }
}
