<?php

namespace Modules\WarehousePod\Models;

use Illuminate\Database\Eloquent\Model;

class Warehouse extends Model
{

    protected $table = "warehouse";
    protected $fillable = [
        'name', 'printing_code', 'location', 'country_id', 'phone', 'address', 'province_id', 'district_id', 'is_default', 'is_active', 'type', 'seller_id', 'is_editable', 'rate'
    ];

    public function warehouseConfigs() {
        return $this->hasMany(WarehouseConfig::class, 'warehouse_id');
    }
    public function providers() {
        return $this->hasMany(ProviderNWarehouse::class, 'warehouse_id');
    }
    public function categoryConfigs() {
        return $this->hasMany(WarehouseCategory::class, 'warehouse_id');
    }
    public function warehouseShippingConfigs() {
        return $this->hasMany(WarehouseConfig::class, 'warehouse_id', 'id')->where("is_active", 1)->where("config_type", "shipping");
    }
}
