<?php

namespace Modules\WarehousePod\Models;

use Illuminate\Database\Eloquent\Model;

class WarehouseCategory extends Model
{

    protected $table = "warehouse_category";
    protected $guarded = ['id'];
    protected $fillable = [
        'warehouse_id', 'category_id', 'cost', 'origin_cost', 'cost_bulk', 'origin_cost_bulk', 'ratio_id'
    ];

    public function options() {
        return $this->hasMany(WarehouseCategoryValue::class, 'warehouse_category_id');
    }

    public function products() {
        return $this->hasMany(WarehouseCategoryVariant::class, 'warehouse_category_id');
    }
}
