<?php

namespace Modules\WarehousePod\Models;

use Illuminate\Database\Eloquent\Model;

class WarehouseConfigItem extends Model
{

    const COLUMNS = [
        'warehouse_config_id', 'name', 'type', 'fee_limit', 'fee_if_limit', 'default_shipping_fee', 'default_adding_item', 'origin_shipping_fee', 'origin_adding_fee', 'adding_item', 'shipping_min_time', 'shipping_max_time', 'handling_min_time', 'handling_max_time', 'apply_cate', 'map_id', 'tax',
        'is_bulk', 'origin_shipping_fee_bulk', 'origin_adding_fee_bulk', 'default_shipping_fee_bulk', 'default_adding_item_bulk', 'adding_item_bulk', 'tax_bulk',
        'fee_limit_bulk', 'fee_if_limit_bulk', 'handling_min_time_bulk', 'handling_max_time_bulk', 'shipping_min_time_bulk', 'shipping_max_time_bulk'
    ];

    protected $table = "warehouse_config_item";
    protected $fillable = self::COLUMNS;

    public function options() {
        return $this->hasMany(WarehouseConfigItemValue::class, 'warehouse_config_item_id');
    }

    public function products() {
        return $this->hasMany(WarehouseConfigItemVariant::class, 'warehouse_config_item_id');
    }
}
