<?php

namespace Modules\WarehousePod\Models;

use Illuminate\Database\Eloquent\Model;

class WarehouseProvider extends Model
{

    protected $table = "warehouse_provider";
    protected $fillable = [
        'name', 'category_id', 'provider_info_id', 'supplier_id', 'supplier', 'status', 'has_size', 'has_color', 'size_value_ids', 'color_value_ids'
    ];

    public function warehouseProviderLocations() {
        return $this->hasMany(WarehouseProviderLocation::class, 'warehouse_provider_id');
    }
    public function warehouseProviderVariantConfigs() {
        return $this->hasMany(WarehouseProviderVariantConfig::class, 'warehouse_provider_id');
    }
    public function warehouseProviderVariants() {
        return $this->hasMany(WarehouseProviderVariant::class, 'warehouse_provider_id');
    }
}
