<?php

namespace Modules\WarehousePod\Models;

use Illuminate\Database\Eloquent\Model;

class WarehouseProviderLocation extends Model
{

    protected $table = "warehouse_provider_location";
    protected $fillable = [
        'name', 'status', 'warehouse_provider_id', 'country_id', 'production_min_time', 'production_max_time', 'shipping_min_time', 'shipping_max_time', 'shipping_fee', 'adding_fee', 'shipping_type'
    ];

    public function products() {
        return $this->hasMany(WarehouseProviderLocationVariant::class, 'warehouse_provider_location_id');
    }
}
