system.config(['dynamicNumberStrategyProvider', function(dynamicNumberStrategyProvider){
    dynamicNumberStrategyProvider.addStrategy('price', {
      numInt: 6,
      numFract: 2,
      numSep: '.',
      numPos: true,
      numNeg: true,
      numRound: 'round',
      numThousand: true
    });
  }]);
system.config(function ($mdDateLocaleProvider) {
    $mdDateLocaleProvider.formatDate = function (date) {
        return moment(date).format('DD/MM/YYYY');
    };
});
system.controller("OrderWarningController", OrderWarningController);
function OrderWarningController($scope, $http, $rootScope, $timeout, Upload) {
    $scope.baseController = this.__proto__ = new PaginationController($scope, $http, $rootScope, Upload);
    $scope.filters = {
        page_id: 0
    };
    $scope.isLoading = false;
    $scope.items = [];
    $scope.countSelected = 0;
    $scope.checkedAll = 0;

    $scope.init = function () {
        initDatePicker();
        $scope.find(true);
    }

    $scope.clear = function () {
        $scope.filters = {
            page_id: 0
        }
        initDatePicker();
        $scope.find(true);
    }

    initDatePicker = function () {
        var now = new Date();
        var oneMonthAgo = now.setDate(now.getDate() - 3);
        $scope.filters.date_from = new Date(oneMonthAgo);
        $scope.filters.date_to = new Date();
    };

    $scope.find = function (refresh, sort = null) {
        if (sort != null) {
            $scope.filters.sort = sort;
        }
        if (refresh) {
            $scope.filters.page_id = 0;
        }
        var filter = buildFilter();
        var params = getParams(filter);
        var url = '/service/warehouse/order/warning/find';
        if (params.length > 0) {
            url += '?' + params.join('&');
        }
        $scope.isLoading = true;
        $http.get(url)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    var items = [];
                    if (response.data.result.length > 0) {
                        response.data.result.forEach(function(item) {
                            item.is_checked = 0;
                            items.push(item);
                        });
                    }
                    $scope.items = items;
                    $scope.pagesCount = response.data.pagesCount;
                }
                $scope.isLoading = false;
            }, function (error) {
                $scope.isLoading = false;
            })
    }

    $scope.export = function () {
        var filter = buildFilter();
        var params = getParams(filter);
        var url = '/service/warehouse/order/warning/export';
        if (params.length > 0) {
            url += '?' + params.join('&');
        }
        $scope.isLoading = true;
        $http.get(url)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    toastr.success('Export thành công!');
                    window.open(response.data.result, '_blank');
                }
                $scope.isLoading = false;
            }, function (error) {
                $scope.isLoading = false;
            })
    }

    function buildFilter() {
        var retVal = {};
        if ($scope.filters.keyword) {
            retVal.keyword = $scope.filters.keyword;
        }
        if ($scope.filters.sort) {
            retVal.sort = $scope.filters.sort;
        }
        retVal.from = $scope.formatDate($scope.filters.date_from, "dd/mm/yyyy");
        retVal.to = $scope.formatDate($scope.filters.date_to, "dd/mm/yyyy");
        retVal.page_id = $scope.filters.page_id;
        return retVal;
    }

    getParams = function(filter) {
        var params = [];
        for (var key in filter) {
            var filterValue = filter[key];
            var param = '';
            if (typeof filterValue == 'object' || typeof filterValue == 'array') {
                if (filterValue.length > 0) {
                    param = key + '=' + filterValue.join(',');
                }
            } else {
                param = key + '=' + filterValue;
            }
            if (param != '') {
                params.push(param);
            }
        }
        return params;
    }

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.find(false);
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.find(false);
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.find(false);
        }
    };


    $scope.save = function () {
        var data = buildData();
        var invalid = false;
        if (!data.warehouse_id) {
            invalid = true;
            toastr.error('Vui lòng chọn kho');
        }
        if (!data.apply_product || data.apply_product.length == 0) {
            toastr.error('Vui lòng chọn sản phẩm');
            invalid = true;
        }
        if (invalid) {
            return false;
        }
        var url = 'service/warehouse/product/create';
        
        $http.post(url, data)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.find();
                    $scope.showForm = false;
                    toastr.success('Bạn đã lưu sản phẩm thành công');
                    $('#modalForm').modal('toggle');
                } else {
                    toastr.error('Có lỗi xảy ra, vui lòng thử lại.');
                }
            }, function (error) {
                toastr.error('Đã có lỗi xảy ra');
            })
    }

    function buildData () {
        var retVal = angular.copy($scope.item);
        if (retVal.apply_product.length > 0) {
            var apply_product = [];
            retVal.apply_product.forEach(function(item) {
                var newItem = {
                    product_id: item.product_id,
                    product_sku_id: item.product_sku_id
                };
                apply_product.push(newItem);
            });
            retVal.apply_product = apply_product;
        }
        return retVal;
    }

    
    $scope.openModal = function () {
        $scope.item = {
            apply_product: []
        };
        $('#modalForm').modal('toggle');
    }

    var findFlag;
    $scope.suggestion = function() {
        $scope.itemSuggestions = [];
        $scope.showSuggestion = false;
        clearTimeout(findFlag);
        findFlag = setTimeout(function(){
            findSuggestion();
        },300);
    }

    function findSuggestion() {
        var keyword = $scope.warehouse.keyword;
        var url = "/service/warehouse/product-info/find?keyword=" + keyword;
        $http.get(url).then(function (response) {
            if (response.data.status === "successful" && response.data.result.length > 0) {
                $scope.showSuggestion = true;
                $scope.itemSuggestions = response.data.result;
            }
        });
    }

    $scope.applyItem = function() {
        $scope.warehouse.keyword = null;
        var productIds = [];
        $scope.item.apply_product.forEach(function(item) {
            productIds.push(item.id);
        });
        $scope.itemSuggestions.forEach(function(item) {
            if (item.is_checked) {
                if (productIds.indexOf(item.id) < 0) {
                    $scope.item.apply_product.push(item);
                }
            }
        });
        $scope.showSuggestion = false;
    }

    $scope.cancelSuggestion = function() {
        $scope.showSuggestion = false;
        $scope.showGetSuggestion = false;
    }

    $scope.deleteApplyItem = function(index) {
        $scope.item.apply_product.splice(index,1);
    }

    $scope.checkAll = function() {
        if ($scope.checkedAll) {
            $scope.items.forEach(function (item) {
                item.is_checked = 1;
            });
            $scope.countSelected = $scope.items.length;
        } else {
            $scope.items.forEach(function (item) {
                item.is_checked = 0;
            });
            $scope.countSelected = 0;
        }
    }

    $scope.checkedItem = function() {
        var countSelected = 0;
        $scope.items.forEach(function (item) {
            if (item.is_checked) {
                countSelected += 1;
            }
        });
        if (countSelected == $scope.items.length) {
            $scope.checkedAll = 1;
        }
        $scope.countSelected = countSelected;
    }

    $scope.removeItems = function() {
        $.confirm({
            title: 'Xóa cảnh báo!',
            content: 'Bạn có chắc chắn xóa các cảnh bảo đã chọn',
            buttons: {
                confirm: function () {
                    deletedItems();
                },
                cancel: function () {
                    
                }
            }
        });
    }

    function deletedItems() {
        $scope.isSaving = true;
        let ids = [];
        $scope.items.forEach(function(item) {
            if (item.is_checked) {
                ids.push(item.id);
            }
        });
        let data = {
            'ids': ids
        };
        $http.post('/service/warehouse/order/warning/delete', data)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.find(true);
                    $scope.isSaving = false;
                    toastr.success('Báo cáo spam thành công');
                } else {
                    toastr.error('Có lỗi xảy ra vui lòng thử lại');
                    $scope.isSaving = false;
                }
            });
    }

    $scope.formatDate = function (date, formatString) {
        if (typeof date == "string") {
            var dateStr = date.replace(/^(\d{1,2})\/(\d{1,2})\/(\d{4})$/, "$2/$1/$3");
            date = new Date(dateStr);
        }
        var hours = date.getHours();
        var minutes = date.getMinutes();
        var ampm = hours >= 12 ? "pm" : "am";
        hours = hours % 12;
        hours = hours ? hours : 12; // the hour '0' should be '12'
        minutes = minutes < 10 ? "0" + minutes : minutes;
        var strTime = hours + ":" + minutes + " " + ampm;
        if (formatString == "dd/mm/yyyy") {
            return date.getDate() + "/" + (date.getMonth() + 1) + "/" + date.getFullYear();
        }
        return date.getMonth() + 1 + "/" + date.getDate() + "/" + date.getFullYear() + "  " + strTime;
    };

    $scope.init();
}