system.requires.push('chosen-search');
system.filter("safeHtml", function ($sce) {
    return function (val) {
        return $sce.trustAsHtml(val);
    };
});
system.config(['dynamicNumberStrategyProvider', function(dynamicNumberStrategyProvider){
    dynamicNumberStrategyProvider.addStrategy('price', {
      numInt: 6,
      numFract: 2,
      numSep: '.',
      numPos: true,
      numNeg: true,
      numRound: 'round',
      numThousand: true
    });
}]);
system.directive('tooltip', function(){
    return {
        restrict: 'A',
        link: function(scope, element, attrs){
            element.hover(function(){
                element.tooltip('show');
            }, function(){
                element.tooltip('hide');
            });
        }
    };
});
  
system.controller("WarehouseConfigController", WarehouseConfigController);
function WarehouseConfigController($scope, $http, $rootScope, $timeout, Upload, $window) {
    $scope.baseController = this.__proto__ = new PaginationController($scope, $http, $rootScope, Upload);
    $scope.filters = {
        page_id: 0,
        type: 'custom'
    };
    $scope.isLoading = false;
    $scope.printings = printings;
    $scope.countries = countries;
    $scope.categories = categories;
    $scope.listNotApply = listNotApply;
    $scope.currencyRatios = currencyRatios;
    $scope.ratioByIds = ratioByIds;
    $scope.currencyUnit = currencyUnit;
    $scope.options = options;
    $scope.providers = [];
    $scope.statusses = {
        '1' : 'Hoạt động',
        '0' : 'Dừng hoạt động'
    };
    $scope.types = {
        'custom': 'Kho cấu hình - Tùy chọn',
        'default_ship': 'Kho vận chuyển - Mặc định',
        'default_cost': 'Kho giá vốn sản phẩm - Mặc định'
    }
    $scope.onoff = {
        '1' : 'Bật',
        '0' : 'Tắt'
    };
    $scope.warehouse = {
        is_active : '1',
        shipping_configs: [],
        cost_configs: [],
        category_configs: [
            {
                options: [{}],
                is_show: 1,
            }
        ],
        type: 'custom',
        providerIds: []
    };
    $scope.warehouseTypes = {
        standard: 'Standard',
        premium: 'Premium',
        express: 'Express'
    };
    $scope.filterRatios = {
        has_config_ratio: 'Đã cấu hình tỷ giá',
    };
    $scope.shipping_config_types = [];
    $scope.cost_config_types = [];
    $scope.items = [];
    $scope.showForm = false;
    $scope.variants = {};
    $scope.tabs = [
        {id: 'product', title: 'Cấu Hình Sản Phẩm', is_active: 1},
        {id: 'shipping', title: 'Cấu Hình Vận Chuyển', is_active: 0},
        {id: 'cost', title: 'Cấu Hình Giá Vốn Vận Chuyển', is_active: 0},
    ];
    $scope.tab = $scope.tabs[0].id;

    $scope.shippingActive = 0;
    $scope.costActive = 0;
    $scope.productActive = 1;

    $scope.applyCategories = [];
    $scope.configCategories = {};
    $scope.productCost = {
        category_id: null, 
        cost: null,
        ratio_id: null
    };
    $scope.filterCate = "";
    $scope.typeForm = "normal";
    $scope.variantItemBulk = {};


    $scope.init = function () {
        $(".pending-cate-config").text($scope.listNotApply.length);
        $(document).ready(function(){
            setTimeout(function() {
                $('[data-toggle="popover"]').popover({
                    html: true,
                    trigger: "hover",
                })
            }, 100);
        });
        $scope.getProviders();
        $scope.find(true);
    }
    $scope.getProviders = function (url = null) {
        if (!url) {
            url = "/service/warehouse/provider/v2/find?page_id=0";
        }
        $http.get(url).then(
            function success (response) {
                if (response.data.status == "successful") {
                    $scope.listProviders = response.data.result;
                }
            },
            function error (response) {
            }
        );
    }
    $scope.refundFile = null;

    $scope.changeWarehouseType = function () {
        if ($scope.warehouse.type == 'default_cost') {
            $scope.tabs = [
                {id: 'product', title: 'Cấu Hình Sản Phẩm', is_active: 1}
            ];
            $scope.productActive = 1;
            $scope.shippingActive = 0;
            $scope.costActive = 0;
        } else {
            $scope.tabs = [
                {id: 'product', title: 'Cấu Hình Sản Phẩm', is_active: 1},
                {id: 'shipping', title: 'Cấu Hình Vận Chuyển', is_active: 0},
                {id: 'cost', title: 'Cấu Hình Giá Vốn Vận Chuyển', is_active: 0},
            ];
        }
        if ($scope.warehouse.type == 'default_cost' || $scope.warehouse.type == 'default_ship') {
            $scope.warehouse.name = 'Default';
            $scope.warehouse.printing_code = 'default';
        } else {
            $scope.warehouse.name = null;
            $scope.warehouse.printing_code = null;
        }
    }

    $scope.choosePrinting = function () {
        if ($scope.warehouse.printing_code && ($scope.warehouse.name == '' || $scope.warehouse.name == null)) {
            $scope.warehouse.name = '';
            $scope.warehouse.name = printings[$scope.warehouse.printing_code];
        }

        if ($scope.warehouse.printing_code == 'default' && $scope.warehouse.type == 'custom') {
            $.alert({
                title: 'Cảnh báo!',
                content: 'Vui lòng chọn kho khác Default',
            });
            $scope.warehouse.printing_code = null;
            $scope.warehouse.name = null;
        }
    }

    $scope.buildFilterUrl = function (url) {
        let params = [];
        let columns = ['keyword', 'printing_code', 'is_active', 'country_id', 'page_id'];
        for (let i = 0; i < columns.length; i++) {
            if (typeof $scope.filters[columns[i]] != 'undefined' && $scope.filters[columns[i]] != '' && $scope.filters[columns[i]] != null) {
                params.push(columns[i] + '=' + $scope.filters[columns[i]]);
            }
        }
        url += '?' + params.join('&');
        return url;
    }

    $scope.clear = function () {
        $scope.filters = {
            page_id: 0,
            type: 'custom'
        }
        $scope.find(true);
    }

    $scope.find = async function (refresh, id = null) {
        if (refresh) {
            $scope.filters.page_id = 0;
        }
        var filter = buildFilter();
        if (id) {
            filter.page_id = 0;
        }
        var params = getParams(filter);
        if (id) {
            params.push('id=' + id);
        }
        var url = '/service/warehouse/config/find';
        if (params.length > 0) {
            url += '?' + params.join('&');
        }
        $scope.isLoading = true;
        await $http.get(url)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    var items = [];
                    if (response.data.result.length > 0) {
                        response.data.result.forEach(function(item) {
                            items.push(item);
                        });
                    }
                    for (let index = 0; index < items.length; index++) {
                        const element = items[index];
                        element.is_lost_data = false;
                        for (let i = 0; i < element.warehouse_configs.length; i++) {
                            const warehouseConfig = element.warehouse_configs[i];
                            element[warehouseConfig.type + "_" + warehouseConfig.config_type] = warehouseConfig.warehouse_config_items.length;
                        }
                        if (element["standard_shipping"] && element["standard_shipping"] > element["standard_cost"]) {
                            element.is_lost_data = true;
                        }
                        if (element["premium_shipping"] && element["premium_shipping"] > element["premium_cost"]) {
                            element.is_lost_data = true;
                        }
                        if (element["express_shipping"] && element["express_shipping"] > element["express_cost"]) {
                            element.is_lost_data = true;
                        }
                        element.old_warehouse_configs = angular.copy(element.warehouse_configs);
                        $scope.buildOldCategoryConfig(element);
                    }
                    if (!id) {
                        $scope.items = items;
                        $scope.pagesCount = response.data.pagesCount;
                    } else {
                        $scope.warehouse = items[0];
                    }
                }
                $scope.isLoading = false;
            }, function (error) {
                $scope.isLoading = false;
            })
    }

    $scope.buildOldCategoryConfig = (warehouse) => {
        if (warehouse.warehouse_configs.length > 0) {
            for (let index = 0; index < warehouse.warehouse_configs.length; index++) {
                const element = warehouse.warehouse_configs[index];
                if (element.config_type == 'shipping') {
                    let dataByCate = {};
                    var listConfigByCate = [];
                    for (let i = 0; i < element.warehouse_config_items.length; i++) {
                        const item = element.warehouse_config_items[i];
                        if (item.type == 'default') {
                            dataByCate["-1"] = item;
                            listConfigByCate = arrayUnique(listConfigByCate.concat(["-1"]));
                        } else {
                            let applyCate = [];
                            if (typeof item.apply_cate == 'string' && item.apply_cate != '') {
                                applyCate = item.apply_cate.split(',');
                            }
                            listConfigByCate = arrayUnique(listConfigByCate.concat(applyCate));
                            for (let k = 0; k < applyCate.length; k++) {
                                const value = applyCate[k];
                                dataByCate[value] = item;                            
                            }
                        }
                    }
                    warehouse[element.type + "_shipping_cate_old"] = dataByCate;
                    warehouse[element.type + "_shipping_invalid_cate_old"] = element.invalid_cate;
                    warehouse.allShippingCateConfigOld = arrayUnique(listConfigByCate.concat(warehouse.allShippingCateConfigOld));
                } else {
                    let dataByCate = {};
                    var listConfigByCate = [];
                    for (let i = 0; i < element.warehouse_config_items.length; i++) {
                        const item = element.warehouse_config_items[i];
                        if (item.type == 'default') {
                            dataByCate["-1"] = item;
                            listConfigByCate = arrayUnique(listConfigByCate.concat(["-1"]));
                        } else {
                            let applyCate = [];
                            if (typeof item.apply_cate == 'string' && item.apply_cate != '') {
                                applyCate = item.apply_cate .split(',');
                            }
                            listConfigByCate = arrayUnique(listConfigByCate.concat(applyCate));
                            for (let k = 0; k < applyCate.length; k++) {
                                const value = applyCate[k];
                                dataByCate[value] = item;                            
                            }
                        }
                    }
                    warehouse[element.type + "_cost_cate_old"] = dataByCate;
                    warehouse[element.type + "_cost_invalid_cate_old"] = element.invalid_cate;
                    warehouse.allCostCateConfigOld = arrayUnique(listConfigByCate.concat(warehouse.allCostCateConfigOld));
                }
            }
        }
    }

    $scope.bindPreviewTime = (cateData, invalidCateData, cate, type = 'handling') => {
        if (!invalidCateData || !invalidCateData.includes(cate)) {
            if (type == 'shipping') {
                return `<p>
                    ${cateData[cate] && cateData[cate].shipping_min_time ? cateData[cate].shipping_min_time : cateData["-1"].shipping_min_time}
                    -
                    ${cateData[cate] && cateData[cate].shipping_max_time ? cateData[cate].shipping_max_time : cateData["-1"].shipping_max_time}
                </p>`
            }
            return `<p>
                ${cateData[cate] && cateData[cate].handling_min_time ? cateData[cate].handling_min_time : cateData["-1"].handling_min_time}
                -
                ${cateData[cate] && cateData[cate].handling_max_time ? cateData[cate].handling_max_time : cateData["-1"].handling_max_time}
            </p>`
        }
        return `<p>-</p>`;
    }

    $scope.bindShippingFee = (cateData, invalidCateData, cate, oldCateData, type = 'adding') => {
        let html = "";
        let columnName = "default_adding_item";
        if (type === 'shipping') {
            columnName = "default_shipping_fee";
        }
        if (!invalidCateData || !invalidCateData.includes(cate)) {
            html = `
                <p>
                    ${cateData[cate] && cateData[cate][columnName] >= 0 ? cateData[cate][columnName] : cateData["-1"][columnName]}
                `
                if ((!oldCateData || !oldCateData[cate]) && cateData[cate] && cateData[cate][columnName]) {
                    html += `
                        <span style="color: green; font-weight: bold;">
                            (New)
                        </span>
                    `
                }
                if (oldCateData) {
                    let oldData = oldCateData[cate] ? oldCateData[cate] : oldCateData["-1"];
                    if (cateData && oldCateData[cate] && oldData[columnName] && oldData[columnName] != cateData[cate][columnName])
                        html += `
                            <span style="font-weight: bold;">
                                <span style="color: ${oldCateData[cate][columnName] < cateData[cate][columnName] ? 'green' : 'red'}">
                                    (${oldCateData[cate][columnName]})
                                </span>
                            </span>
                        `
                }
                html += `</p>`
        } else {
            html = `<p>-</p>`;
        }
        return html;

    }

    function buildFilter() {
        var retVal = {};
        if ($scope.filters.keyword) {
            retVal.keyword = $scope.filters.keyword;
        }
        if ($scope.filters.printing_code) {
            retVal.printing_code = $scope.filters.printing_code;
        }
        if ($scope.filters.country_id) {
            retVal.country_id = $scope.filters.country_id;
        }
        if ($scope.filters.is_active) {
            retVal.is_active = $scope.filters.is_active;
        }
        if ($scope.filters.category_id) {
            retVal.category_id = $scope.filters.category_id;
        }
        if ($scope.filters.ship_type) {
            retVal.ship_type = $scope.filters.ship_type;
        }
        if ($scope.filters.has_ratio) {
            retVal.has_ratio = $scope.filters.has_ratio;
        }
        if ($scope.filters.type) {
            retVal.type = $scope.filters.type;
        }
        retVal.page_id = $scope.filters.page_id;
        return retVal;
    }

    getParams = function(filter) {
        var params = [];
        for (var key in filter) {
            var filterValue = filter[key];
            var param = '';
            if (typeof filterValue == 'object' || typeof filterValue == 'array') {
                if (filterValue.length > 0) {
                    param = key + '=' + filterValue.join(',');
                }
            } else {
                param = key + '=' + filterValue;
            }
            if (param != '') {
                params.push(param);
            }
        }
        return params;
    }

    $scope.getById = function (items, id) {
        var retVal = null;
        items.forEach(function (item) {
            if (item.id == id) {
                retVal = item;
                return;
            }
        });
        return retVal;
    }

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.find(false);
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.find(false);
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.find(false);
        }
    };

    $scope.completeSave = function () {
        $.confirm({
            title: 'Hoàn tất chỉnh sửa',
            content: 'Chú ý: kiểm tra lại tất cả cấu hình cẩn thận, lưu ý các cảnh báo. Sau khi nhấn Hoàn Tất Chỉnh Sửa bạn sẽ nhận được 1 file excel tổng hợp và chức năng cấu hình sẽ được khoá lại',
            buttons: {
                confirm: function () {
                    var data = buildData();
                    if (typeof user != 'undefined') {
                        data.email = user.email;
                    }
                    var invalid = false;
                    if (!data.name || data.name == '') {
                        toastr.error('Vui lòng nhập tên kho vận');
                        invalid = true;
                    }
                    if ((!data.location || data.location == '') && data.type == 'custom' ) {
                        toastr.error('Vui lòng nhập vận chuyển từ');
                        invalid = true;
                    }
                    if (invalid) {
                        return false;
                    }
                    var url = 'service/warehouse/config/create';
                    if (data.id) {
                        var url = 'service/warehouse/config/update';
                    }
                    if ($scope.typeForm == "normal") {
                        delete data.category_configs;
                    }
                    data.complete_save = 1;
                    $scope.isLoading = true;
                    $http.post(url, data)
                        .then(function (response) {
                            if (response.data.status == 'successful') {
                                $scope.find();
                                $scope.showForm = false;
                                $window.scrollTo(0, 0);
                                toastr.success('Bạn đã lưu thông tin kho thành công');
                                $scope.exportConfig(response.data.result);
                            } else {
                                toastr.error(response.data.message);
                            }
                            $scope.isLoading = false;
                        }, function (error) {
                            toastr.error('Đã có lỗi xảy ra');
                            $scope.isLoading = false;
                        })
                },
                cancel: function () {
                    
                }
            }
        });
    }


    $scope.save = function () {
        var data = buildData();
        if (typeof user != 'undefined') {
            data.email = user.email;
        }
        var invalid = false;
        if (!data.name || data.name == '') {
            toastr.error('Vui lòng nhập tên kho vận');
            invalid = true;
        }
        if ((!data.location || data.location == '') && data.type == 'custom' ) {
            toastr.error('Vui lòng nhập vận chuyển từ');
            invalid = true;
        }
        if (invalid) {
            return false;
        }
        var url = 'service/warehouse/config/create';
        if (data.id) {
            var url = 'service/warehouse/config/update';
        }
        if ($scope.typeForm == "normal") {
            delete data.category_configs;
        }
        $scope.isLoading = true;
        $http.post(url, data)
            .then(async function (response) {
                if (response.data.status == 'successful') {
                    toastr.success('Bạn đã lưu thông tin kho thành công');
                    if (!data.id) {
                        $scope.showForm = false;
                        $scope.find(true);
                    } else {
                        await $scope.find(false, $scope.warehouse.id);
                        await $scope.openForm($scope.warehouse);
                    }
                } else {
                    toastr.error(response.data.message);
                }
                $scope.isLoading = false;
            }, function (error) {
                toastr.error('Đã có lỗi xảy ra');
                $scope.isLoading = false;
            })
    }

    function buildData () {
        var warehouse = angular.copy($scope.warehouse);
        warehouse.category_configs.forEach(function (config) {
            config.options.forEach(function(option) {
                delete option.variants;
            });
            if (typeof config.products == 'undefined') {
                config.products = [];
            }
        });
        return warehouse;
    }

    $scope.closeForm = function () {
        $scope.showForm = false;
        $window.scrollTo(0, 0);
        $scope.find(false);
    }
    function arrayUnique(array) {
        var a = array.concat();
        for(var i=0; i<a.length; ++i) {
            for(var j=i+1; j<a.length; ++j) {
                if(a[i] === a[j])
                    a.splice(j--, 1);
            }
        }
    
        return a;
    }
    $scope.findCategory = () => {
        if ($scope.previewCateFilter.length > 0) {
            $scope.warehouse.allCateConfig = $scope.warehouse.defaultAllCateConfig.filter(i => i == "-1" || $scope.previewCateFilter.includes(i));
        } else {
            $scope.warehouse.allCateConfig = $scope.warehouse.defaultAllCateConfig;
        }
    }

    $scope.buildShippingCate = () => {
        let listConfigByCate = [];
        if ($scope.tab == 'shipping') {
            for (let index = 0; index < $scope.warehouse.shipping_configs.length; index++) {
                const element = $scope.warehouse.shipping_configs[index];
                let dataByCate = {};
                for (let i = 0; i < element.config_items.length; i++) {
                    const item = element.config_items[i];
                    if (item.is_default == 1) {
                        listConfigByCate = arrayUnique(listConfigByCate.concat(["-1"]));
                    } else {
                        listConfigByCate = arrayUnique(listConfigByCate.concat(item.apply_cate));
                    }
                    if (item.is_default == 1) {
                        dataByCate["-1"] = item;
                    } else {
                        if (item.apply_cate) {
                            for (let k = 0; k < item.apply_cate.length; k++) {
                                const value = item.apply_cate[k];
                                dataByCate[value] = item;                            
                            }
                        }
                    }
                }
                $scope.warehouse[element.type + "_shipping_cate"] = dataByCate;
                $scope.warehouse[element.type + "_shipping_invalid_cate"] = element.invalid_cate;
            }
            $scope.warehouse.allCateConfig = arrayUnique(listConfigByCate);
        } else if ($scope.tab == 'cost') {
            for (let index = 0; index < $scope.warehouse.cost_configs.length; index++) {
                const element = $scope.warehouse.cost_configs[index];
                let dataByCate = {};
                for (let i = 0; i < element.config_items.length; i++) {
                    const item = element.config_items[i];
                    if (item.is_default == 1) {
                        listConfigByCate = arrayUnique(listConfigByCate.concat(["-1"]));
                    } else {
                        listConfigByCate = arrayUnique(listConfigByCate.concat(item.apply_cate));
                    }
                    if (item.is_default == 1) {
                        dataByCate["-1"] = item;
                    } else {
                        if (item.apply_cate) {
                            for (let k = 0; k < item.apply_cate.length; k++) {
                                const value = item.apply_cate[k];
                                dataByCate[value] = item;                            
                            }
                        }
                    }
                }
                $scope.warehouse[element.type + "_cost_cate"] = dataByCate;
                $scope.warehouse[element.type + "_cost_invalid_cate"] = element.invalid_cate;
            }
            $scope.warehouse.allCateConfig = arrayUnique(listConfigByCate);
        }
        $scope.warehouse.allCateConfig.sort((a, b) => {
            var aValue = $scope.categories[a];
            var bValue = $scope.categories[b];
            if (aValue) {
                aValue = aValue.toUpperCase()
            };
            if (bValue) {
                bValue = bValue.toUpperCase()
            };
            if (aValue === undefined && bValue === undefined) {
                return 0;
            } else if (aValue === undefined) {
                return -1;
            } else if (bValue === undefined) {
                return 1;
            } else if (aValue < bValue) {
                return -1;
            } else if (aValue > bValue) {
                return 1;
            } else {
                return 0;
            }
        });
        $scope.warehouse.defaultAllCateConfig = angular.copy($scope.warehouse.allCateConfig);

        $scope.standardShipping = $scope.warehouse.standard_shipping_cate ? $scope.warehouse.standard_shipping_cate : null;
        $scope.premiumShipping = $scope.warehouse.premium_shipping_cate ? $scope.warehouse.premium_shipping_cate : null;
        $scope.expressShipping = $scope.warehouse.express_shipping_cate ? $scope.warehouse.express_shipping_cate : null;
        $scope.standardCost = $scope.warehouse.standard_cost_cate ? $scope.warehouse.standard_cost_cate : null;
        $scope.premiumCost = $scope.warehouse.premium_cost_cate ? $scope.warehouse.premium_cost_cate : null;
        $scope.expressCost = $scope.warehouse.express_cost_cate ? $scope.warehouse.express_cost_cate : null;

        $scope.standardShippingOld = $scope.warehouse.standard_shipping_cate_old ? $scope.warehouse.standard_shipping_cate_old : null;
        $scope.premiumShippingOld = $scope.warehouse.premium_shipping_cate_old ? $scope.warehouse.premium_shipping_cate_old : null;
        $scope.expressShippingOld = $scope.warehouse.express_shipping_cate_old ? $scope.warehouse.express_shipping_cate_old : null;
        $scope.standardCostOld = $scope.warehouse.standard_cost_cate_old ? $scope.warehouse.standard_cost_cate_old : null;
        $scope.premiumCostOld = $scope.warehouse.premium_cost_cate_old ? $scope.warehouse.premium_cost_cate_old : null;
        $scope.expressCostOld = $scope.warehouse.express_cost_cate_old ? $scope.warehouse.express_cost_cate_old : null;
    }
    $scope.changeTab = function(tab) {
        $scope.previewCateFilter = "";
        $scope.tab = tab.id;
        if (tab.id == 'shipping') {
            $scope.shippingActive = 1;
            $scope.costActive = 0;
            $scope.productActive = 0;
            buildCategoryApply();
            $scope.getConfigItems();
        } else if (tab.id == 'cost') {
            $scope.costActive = 1;
            $scope.shippingActive = 0;
            $scope.productActive = 0;
            $scope.getConfigItems();
        } else if (tab.id == 'product') {
            $scope.productActive = 1;
            $scope.costActive = 0;
            $scope.shippingActive = 0;
        }
        $scope.buildShippingCate();

        $scope.tabs.forEach(function(item) {
            if (item.id == tab.id) {
                item.is_active = 1;
            } else {
                item.is_active = 0;
            }
        });
    }

    function buildCategoryApply() {
        $scope.applyCategories = [];
        $scope.configCategories = {};
        $scope.warehouse.category_configs.forEach(function(config) {
            if (config.category_id) {
                $scope.applyCategories.push(config.category_id);
            }
        });
        if ($scope.applyCategories.length > 0) {
            $scope.applyCategories.forEach(function (id) {
                if (typeof categories[id] !== 'undefined') {
                    $scope.configCategories[id] = categories[id];
                }
            })
        }
    }

    $scope.openForm = async function (item) {
        $scope.shippingActive = 0;
        $scope.costActive = 0;
        $scope.productActive = 1;
        $scope.config = {};
        $scope.typeForm = "normal";
        $scope.tab = 'product';
        if (item) {
            if (item.type == 'custom' || item.type == 'default_ship') {
                $scope.tabs = [
                    {id: 'product', title: 'Cấu Hình Sản Phẩm', is_active: 1},
                    {id: 'shipping', title: 'Cấu Hình Vận Chuyển', is_active: 0},
                    {id: 'cost', title: 'Cấu Hình Giá Vốn Vận Chuyển', is_active: 0},
                ];
            } else {
                $scope.tabs = [
                    {id: 'product', title: 'Cấu Hình Sản Phẩm', is_active: 1}
                ];
            }
            await $scope.find(false, item.id);
            // $scope.warehouse = angular.copy(item);
            $scope.warehouse.category_configs = [];
            buildCategoryConfig($scope.warehouse.id, item, 'edit');
            if (item.country_id != -1) {
                $scope.warehouse.country_id = item.country_id.toString();
            } else {
                $scope.warehouse.country_id = null;
            }
            $scope.warehouse.is_active = item.is_active.toString();
            $scope.warehouse.providerIds = [];
            let newProviders = [];
            for (let index = 0; index < $scope.warehouse.providers.length; index++) {
                const element = $scope.warehouse.providers[index];
                $scope.warehouse.providerIds.push(element.provider_id)
                newProviders.push($scope.listProviders.find(i => i.id == element.provider_id));
            }
            $scope.providers = newProviders;
        } else {
            $scope.warehouse = {
                is_active : '0',
                shipping_configs: [],
                cost_configs: [],
                category_configs: [
                    {
                        options: [{}],
                        is_show: 1
                    }
                ],
                'type': 'custom'
            };
            $scope.shipping_config_types = [];
            $scope.cost_config_types = [];
            $scope.tabs = [
                {id: 'product', title: 'Cấu Hình Sản Phẩm', is_active: 1},
                {id: 'shipping', title: 'Cấu Hình Vận Chuyển', is_active: 0},
                {id: 'cost', title: 'Cấu Hình Giá Vốn Vận Chuyển', is_active: 0},
            ];
            $scope.warehouse.providerIds = [];
        }
        $scope.showForm = true;
    }

    $scope.showVariant = (item) => {
        if (item.is_show == 0) {
            var url = "service/warehouse/category/find";
            var data = {
                warehouse_id: item.warehouse_id,
                warehouse_category_id: item.id,
            };
            $scope.isLoading = true;
            $http.post(url, data)
                .then(function (response) {
                    if (response.data.status == 'successful') {
                        if (response.data.result) {
                            $scope.applyCategories = [];
                            var categoryConfigs = {};
                            response.data.result.forEach(function (config) {
                                config.category_id = config.category_id.toString();
                                config.is_show = 1;
                                if (config.options.length == 0) {
                                    config.options.push({});
                                } else {
                                    config.options.forEach(function (option) {
                                        option.option = $scope.getById($scope.options, option.option_id);
                                        if (typeof option.option_value_ids == 'string' && option.option_value_ids != '') {
                                            var variantIds = [];
                                            variantIds = option.option_value_ids.split(',');
                                            option.variant_ids = variantIds;
                                        }
                                    });
                                }
                                config.combination_variants = [];
                                config.options.forEach(function (option) {
                                    option.variantSelecteds = [];
                                    if (typeof option.variant_ids != 'undefined' && option.variant_ids.length > 0) {
                                        option.variant_ids.forEach(function(id) {
                                            if (typeof option.variants[id] != 'undefined') {
                                                var newVariant = {
                                                    id: id,
                                                    name: option.variants[id],
                                                    bulk_selected: false
                                                };
                                                option.variantSelecteds.push(newVariant);
                                            }
                                        })
                                    }
                                    config.combination_variants.push(option.variantSelecteds);
                                });
                                config.products.forEach(function (product) {
                                    product.deleted = parseInt(product.deleted);
                                    product.instock = parseInt(product.instock);
                                });
                                categoryConfigs = config;
                            });
                            for (let index = 0; index < $scope.warehouse.category_configs.length; index++) {
                                const element = $scope.warehouse.category_configs[index];
                                if (element.id == item.id) {
                                    $scope.warehouse.category_configs[index] = categoryConfigs;
                                }
                            }
                        }
                    }
                    $scope.isLoading = false;
                });
        }
        if (item.is_show == 1) {
            item.is_show = 0;
        } else {
            item.is_show = 1;
        }
    }

    $scope.saveCategoryConfig = (item) => {
        var data = {};
        data.categoryConfig = angular.copy(item);
        delete data.categoryConfig.variants;
        if (typeof user != 'undefined') {
            data.email = user.email;
        }
        data.warehouse_id = $scope.warehouse.id;
        var url = 'service/warehouse/category/save';
        $scope.isLoading = true;
        $http.post(url, data).then(function (response) {
            if (response.data.status == 'successful') {
                toastr.success('Lưu thông tin kho thành công.');
                buildCategoryConfig($scope.warehouse.id, item, 'edit');
                item.is_show = 0;
            } else {
                toastr.error(response.data.message);
            }
            $scope.isLoading = false;
        }, function (error) {
            toastr.error('Đã có lỗi xảy ra');
            $scope.isLoading = false;
        })
    }

    $scope.cloneCategoryConfig = (item) => {
        let data = angular.copy(item);
        delete data.id;
        if (data.options) {
            for (let index = 0; index < data.options.length; index++) {
                const element = data.options[index];
                if (element.id) {
                    delete element.id;
                }
                if (element.warehouse_category_id) {
                    delete element.warehouse_category_id;
                }
            }
        }
        if (data.products) {
            for (let index = 0; index < data.products.length; index++) {
                const element = data.products[index];
                if (element.id) {
                    delete element.id;
                }
                if (element.warehouse_category_id) {
                    delete element.warehouse_category_id;
                }
            }
        }
        $scope.warehouse.category_configs.push(data);
    }

    function buildCategoryConfig(id, item, type) {
        var url = "service/warehouse/category/find";
        var data = {
            warehouse_id: id
        };
        $scope.isLoading = true;
        $http.post(url, data)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    if (response.data.result) {
                        $scope.applyCategories = [];
                        var categoryConfigs = [];
                        response.data.result.forEach(function (config) {
                            config.category_id = config.category_id.toString();
                            config.is_show = 0;
                            if (config.options.length == 0) {
                                config.options.push({});
                            } else {
                                config.options.forEach(function (option) {
                                    option.option = $scope.getById($scope.options, option.option_id);
                                    if (typeof option.option_value_ids == 'string' && option.option_value_ids != '') {
                                        var variantIds = [];
                                        variantIds = option.option_value_ids.split(',');
                                        option.variant_ids = variantIds;
                                    }
                                });
                            }
                            config.combination_variants = [];
                            config.options.forEach(function (option) {
                                option.variantSelecteds = [];
                                if (typeof option.variant_ids != 'undefined' && option.variant_ids.length > 0) {
                                    option.variant_ids.forEach(function(id) {
                                        if (typeof option.variants[id] != 'undefined') {
                                            var newVariant = {
                                                id: id,
                                                name: option.variants[id],
                                                bulk_selected: false
                                            };
                                            option.variantSelecteds.push(newVariant);
                                        }
                                    })
                                }
                                config.combination_variants.push(option.variantSelecteds);
                            });
                            config.products.forEach(function (product) {
                                product.deleted = parseInt(product.deleted);
                                product.instock = parseInt(product.instock);
                            });
                            categoryConfigs.push(config);
                            $scope.applyCategories.push(config.category_id);
                        });
                        if ($scope.applyCategories.length > 0) {
                            $scope.applyCategories.forEach(function (id) {
                                if (typeof categories[id] !== 'undefined') {
                                    $scope.configCategories[id] = categories[id];
                                }
                            })
                        }
                        $scope.warehouse.category_configs = categoryConfigs;
                        buildShippingAndCost(item, type);                  
                    }
                    
                }
                $scope.isLoading = false;
            });
    }

    function buildShippingAndCost(item, type) {
        var shippingConfigs = [];
        var costConfigs = [];
        if (item.warehouse_configs && item.warehouse_configs.length > 0) {
            item.warehouse_configs.forEach(function (warehouse_config){
                if (typeof warehouse_config.invalid_cate == 'string' && warehouse_config.invalid_cate != '') {
                    invalid_cate = warehouse_config.invalid_cate.split(',');
                    warehouse_config.invalid_cate = invalid_cate;
                }
                warehouse_config.is_active = warehouse_config.is_active.toString();
                warehouse_config.config_items = [];
                warehouse_config.warehouse_config_items.forEach(function (warehouse_config_item) {
                    if (typeof warehouse_config_item.apply_cate == 'string' && warehouse_config_item.apply_cate != '') {
                        warehouse_config_item.apply_cate = warehouse_config_item.apply_cate.split(',');
                    }

                    warehouse_config_item.is_default = 0;
                    if (warehouse_config_item.type == 'default') {
                        warehouse_config_item.is_default = 1;
                    }
                    warehouse_config_item.fee_limit = parseFloat(warehouse_config_item.fee_limit);
                    warehouse_config_item.fee_if_limit = parseFloat(warehouse_config_item.fee_if_limit);
                    warehouse_config_item.default_shipping_fee = parseFloat(warehouse_config_item.default_shipping_fee);
                    warehouse_config_item.default_adding_item = parseFloat(warehouse_config_item.default_adding_item);
                    warehouse_config_item.origin_shipping_fee = parseFloat(warehouse_config_item.origin_shipping_fee);
                    warehouse_config_item.origin_adding_fee = parseFloat(warehouse_config_item.origin_adding_fee);
                    warehouse_config_item.shipping_min_time = parseInt(warehouse_config_item.shipping_min_time);
                    warehouse_config_item.shipping_max_time = parseInt(warehouse_config_item.shipping_max_time);
                    warehouse_config_item.handling_min_time = parseInt(warehouse_config_item.handling_min_time);
                    warehouse_config_item.handling_max_time = parseInt(warehouse_config_item.handling_max_time);
                    warehouse_config_item.tax = parseInt(warehouse_config_item.tax);
                    warehouse_config.config_items.push(warehouse_config_item);
                })
                warehouse_config.config_items.sort((a, b) => {
                    var aValue = a.name;
                    var bValue = b.name;
                    if (aValue) {
                        aValue = aValue.toUpperCase()
                    };
                    if (bValue) {
                        bValue = bValue.toUpperCase()
                    };
                    if (aValue === undefined && bValue === undefined) {
                        return 0;
                    } else if (aValue === undefined) {
                        return -1;
                    } else if (bValue === undefined) {
                        return 1;
                    } else if (aValue < bValue) {
                        return -1;
                    } else if (aValue > bValue) {
                        return 1;
                    } else {
                        return 0;
                    }
                });
                if (warehouse_config.config_type == 'shipping') {
                    shippingConfigs.push(warehouse_config);
                } else if (warehouse_config.config_type == 'cost') {
                    costConfigs.push(warehouse_config);
                }
            });
            $scope.warehouse.shipping_configs = shippingConfigs;
            $scope.warehouse.cost_configs = costConfigs;
        }
        $scope.shipping_config_types = [];
        $scope.cost_config_types = [];
        shippingConfigs.forEach(function (config) {
            $scope.shipping_config_types.push(config.type);
        });
        costConfigs.forEach(function (config) {
            $scope.cost_config_types.push(config.type);
        });

        if (type == 'clone') {
            buildWarehouseClone();
            if (item.country_id != -1) {
                $scope.warehouse.country_id = item.country_id.toString();
            } else {
                $scope.warehouse.country_id = null;
            }
        }
    }

    $scope.exportConfig = (item) => {
        $http.get("/service/warehouse/export?id=" + item.id)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    window.open(response.data.result, '_blank').focus();
                }
                $scope.isLoading = false;
            }, function (error) {
                $scope.isLoading = false;
            })
    }

    $scope.copyConfig = function (item) {
        $.confirm({
            title: 'Copy cấu hình!',
            content: 'Bạn có chắc chắn tạo kho mới từ kho này?',
            buttons: {
                confirm: function () {
                    var url = "service/warehouse/config/clone";
                    var data = {
                        id: item.id,
                    };
                    $http.post(url, data)
                        .then(function (response) {
                            if (response.data.status == 'successful') {
                                $scope.find();
                            }
                        });
                },
                cancel: function () {
                    
                }
            }
        });
    }

    $scope.cloneConfig = function (item) {
        $scope.typeForm = "clone";
        $scope.shippingActive = 0;
        $scope.costActive = 0;
        $scope.productActive = 1;
        $scope.config = {};
        if (item) {
            if (item.type == 'custom' || item.type == 'default_ship') {
                $scope.tabs = [
                    {id: 'product', title: 'Cấu Hình Sản Phẩm', is_active: 1},
                    {id: 'shipping', title: 'Cấu Hình Vận Chuyển', is_active: 0},
                    {id: 'cost', title: 'Cấu Hình Giá Vốn Vận Chuyển', is_active: 0},
                ];
            } else {
                $scope.tabs = [
                    {id: 'product', title: 'Cấu Hình Sản Phẩm', is_active: 1}
                ];
            }
            $scope.warehouse = angular.copy(item);
            $scope.warehouse.category_configs = [];
            buildCategoryConfig($scope.warehouse.id, item, 'clone');
        }
    }

    function buildWarehouseClone() {
        $scope.warehouse.location = null;
        $scope.warehouse.name += ' (copy)';
        $scope.warehouse.is_active = "0";
        deletePropertyObject($scope.warehouse, ['id']);
        $scope.warehouse.shipping_configs.forEach(function(item) {
            deletePropertyObject(item, ['id', 'warehouse_id']);
            item.config_items.forEach(function (configItem) {
                deletePropertyObject(configItem, ['id', 'warehouse_config_id']);
            })
        });
        $scope.warehouse.cost_configs.forEach(function(item) {
            deletePropertyObject(item, ['id', 'warehouse_id']);
            item.config_items.forEach(function (configItem) {
                deletePropertyObject(configItem, ['id', 'warehouse_config_id']);
            })
        });
        $scope.warehouse.category_configs.forEach(function(item) {
            deletePropertyObject(item, ['id', 'warewawouse_id']);
            item.products.forEach(function (product) {
                deletePropertyObject(product, ['id', 'warehouse_category_id']);
            });
            item.options.forEach(function (option) {
                deletePropertyObject(option, ['id', 'warehouse_category_id']);
            })
        });
        $scope.showForm = true;
    }

    function deletePropertyObject(object, deleted) {
        for (var i = 0; i < deleted.length; i++) {
            delete object[deleted[i]];
        }
    }

    $scope.openModal = function (item) {
        $scope.config = item;
        $scope.filterCate = "";
        if ($scope.config.config_items.length == 0) {
            $scope.config.config_items.push({is_default: 1, name: item.name, map_id: makeId(5)});
        }
        $scope.config.config_items.forEach(element => {
            element.is_show = 1;
            element.is_edit = 0;
            element.cateName = "";
            if (element.apply_cate) {
                for (let index = 0; index < element.apply_cate.length; index++) {
                    const data = element.apply_cate[index];
                    element.cateName += $scope.categories[data];
                    if (index != element.apply_cate.length - 1) {
                        element.cateName += ", ";
                    }
                }
            }
        });
        $timeout(function () {
            $('#modalForm').modal('show');
        });
        $scope.checkConfigBulkVariant();
    }

    $scope.filterCategory = () => {
        $scope.config.config_items.forEach(element => {
            if (element.name && element.name.toLowerCase().includes($scope.filterCate.toLowerCase())) {
                element.is_show = 1;
            } else {
                element.is_show = 0;
            }
            if (!element.name) {
                element.is_show = 1;
            }
            if (element.cateName && element.cateName.toLowerCase().includes($scope.filterCate.toLowerCase())) {
                element.is_show = 1;
            }
        });
    }

    $scope.selectCostType = function () {
        var typeExists = [];
        $scope.warehouse.cost_configs.forEach(function (config) {
            typeExists.push(config.type);
        });
        for (var i = 0; i < $scope.cost_config_types.length; i++) {
            if (typeExists.indexOf($scope.cost_config_types[i]) < 0) {
                var item = {
                    config_type: 'cost',
                    type: $scope.cost_config_types[i],
                    name: capitalizeFirstLetter($scope.cost_config_types[i]),
                    invalid_cate: [],
                    config_items: [{map_id: null, is_default: 1}],
                    is_active: '1'
                };
                $scope.warehouse.cost_configs.push(item);
                $scope.openModal(item);
            }
        }
        if ($scope.cost_config_types.length < typeExists.length) {
            for (var i = 0; i < typeExists.length; i++) {
                if ($scope.cost_config_types.indexOf(typeExists[i]) < 0) {
                    var j = 0;
                    $scope.warehouse.cost_configs.forEach(function (config) {
                        if (config.type == typeExists[i]) {
                            $scope.warehouse.cost_configs.splice(j, 1);
                        }
                        j++;
                    });
                }
            }
        }
    }

    $scope.selectShippingType = function () {
        $scope.cost_config_types = angular.copy($scope.shipping_config_types);
        var typeExists = [];
        $scope.warehouse.shipping_configs.forEach(function (config) {
            typeExists.push(config.type);
        });
        var costTypeExists = [];
        $scope.warehouse.cost_configs.forEach(function(item) {
            costTypeExists.push(item.type);
        });
        for (var i = 0; i < $scope.shipping_config_types.length; i++) {
            if (typeExists.indexOf($scope.shipping_config_types[i]) < 0) {
                var item = {
                    config_type: 'shipping',
                    type: $scope.shipping_config_types[i],
                    name: capitalizeFirstLetter($scope.shipping_config_types[i]),
                    invalid_cate: [],
                    config_items: [{map_id: makeId(5), is_default: 1}],
                    is_active: '1'
                };
                $scope.warehouse.shipping_configs.push(item);
                var costItem = angular.copy(item)
                costItem.config_type = 'cost';
                if (costTypeExists.indexOf(costItem.type) < 0) {
                    $scope.warehouse.cost_configs.push(costItem);
                }
                $scope.openModal(item);
            }
        }
        if ($scope.shipping_config_types.length < typeExists.length) {
            for (var i = 0; i < typeExists.length; i++) {
                if ($scope.shipping_config_types.indexOf(typeExists[i]) < 0) {
                    var j = 0;
                    $scope.warehouse.shipping_configs.forEach(function (config) {
                        if (config.type == typeExists[i]) {
                            $scope.warehouse.shipping_configs.splice(j, 1);
                        }
                        j++;
                    });
                }
                if ($scope.cost_config_types.indexOf(typeExists[i]) < 0) {
                    var j = 0;
                    $scope.warehouse.cost_configs.forEach(function (config) {
                        if (config.type == typeExists[i]) {
                            $scope.warehouse.cost_configs.splice(j, 1);
                        }
                        j++;
                    });
                }
            }
        }
    }

    $scope.changeConfigName = function (config, warehouse) {
        warehouse.cost_configs.forEach(function (cfg){
            if (config.type == cfg.type) {
                cfg.name = config.name;
            }
        });
    }

    function capitalizeFirstLetter(string) {
        return string.charAt(0).toUpperCase() + string.slice(1);
      }

    $scope.addConfigItem = function () {
        $scope.config.config_items.push({
            map_id: makeId(5),
            is_show: 1,
            is_edit: 0,
        });
        
    }

    $scope.removeConfigItem = function (index) {
        $scope.config.config_items.splice(index, 1);
    }
    $scope.editConfigItem = function (index) {
        $scope.config.config_items.forEach((element, i) => {
            if (i == index) {
                element.is_edit = 1;
            }
        });
    }

    $scope.saveApplyCate = function (index) {
        $scope.config.config_items.forEach((element, i) => {
            if (i == index) {
                element.is_edit = 0;
            }
        });
        $scope.config.config_items.forEach(element => {
            element.is_edit = 0;
            element.cateName = "";
            if (element.apply_cate) {
                for (let index = 0; index < element.apply_cate.length; index++) {
                    const data = element.apply_cate[index];
                    element.cateName += $scope.categories[data];
                    if (index != element.apply_cate.length - 1) {
                        element.cateName += ", ";
                    }
                }
            }
        });
    }

    $scope.updateConfig = function (config) {
        var checkMap = true;
        if (config.config_type == 'shipping') { 
            if (checkMap) {
                var costMaps = [];
                var i = 0;
                var position = null;
                $scope.warehouse.cost_configs.forEach(function (item){
                    if (item.type == config.type) {
                        item.config_items.forEach(function (config_item, index) {
                            var mapId = config_item.type + config_item.apply_cate + "cate";
                            costMaps.push(mapId);
                        });
                        position = i;
                        return;
                    }
                    i++;
                });
                var itemByMapId = {};
                var shippingMaps = [];
                if (position != null) {
                    config.config_items.forEach(function (item, index) {
                        var mapId = item.type + item.apply_cate + "cate";
                        shippingMaps.push(mapId);
                        itemByMapId[mapId] = item
                        if (costMaps.indexOf(mapId) < 0) {
                            var newItem = angular.copy(item);
                            newItem.default_shipping_fee = null;
                            newItem.default_adding_item = null;
                            delete newItem.id;
                            delete newItem.warehouse_config_id;
                            $scope.warehouse.cost_configs[position].config_items.push(newItem);
                        }
                    });
                    $scope.warehouse.cost_configs[position].config_items.forEach(function (item, index, object) {
                        var mapId = item.type + item.apply_cate + "cate";
                        if (typeof itemByMapId[mapId] != 'undefined') {
                            item.name = itemByMapId[mapId].name;
                            item.apply_cate = itemByMapId[mapId].apply_cate;
                            item.is_default = itemByMapId[mapId].is_default;
                        }
                        if (shippingMaps.indexOf(mapId) < 0) {
                            object.splice(index, 1);
                        }
                    });
                    $scope.warehouse.cost_configs[position].config_items.sort((a, b) => {
                        var aValue = a.name;
                        var bValue = b.name;
                        if (aValue) {
                            aValue = aValue.toUpperCase()
                        };
                        if (bValue) {
                            bValue = bValue.toUpperCase()
                        };
                        if (aValue === undefined && bValue === undefined) {
                            return 0;
                        } else if (aValue === undefined) {
                            return -1;
                        } else if (bValue === undefined) {
                            return 1;
                        } else if (aValue < bValue) {
                            return -1;
                        } else if (aValue > bValue) {
                            return 1;
                        } else {
                            return 0;
                        }
                    });
                }
            }
        }
        config.config_items.sort((a, b) => {
            var aValue = a.name;
            var bValue = b.name;
            if (aValue) {
                aValue = aValue.toUpperCase()
            };
            if (bValue) {
                bValue = bValue.toUpperCase()
            };
            if (aValue === undefined && bValue === undefined) {
                return 0;
            } else if (aValue === undefined) {
                return -1;
            } else if (bValue === undefined) {
                return 1;
            } else if (aValue < bValue) {
                return -1;
            } else if (aValue > bValue) {
                return 1;
            } else {
                return 0;
            }
        });
        $scope.buildShippingCate()
        $('#modalForm').modal('toggle');
    }

    $scope.updateConfigDefault = function (item, index) {
        if (item.is_default == 1) {
            var id = 0;
            $scope.config.config_items.forEach(function(config) {
                if (index == id) {
                    config.is_default = 1;
                    config.apply_cate = [];
                } else {
                    config.is_default = 0;
                }
                id++;
            });
        } else {
            item.is_default = 1;
        }
    }

    $scope.addProductConfig = function () {
        $scope.warehouse.category_configs.push({
            options: [{}],
            is_show: 1,
        });
    }

    $scope.removeProductConfig = function (index, item) {
        $.confirm({
            title: 'Xóa danh mục!',
            content: 'Bạn có chắc chắn xóa danh mục này?',
            buttons: {
                confirm: function () {
                    var url = "service/warehouse/category/delete";
                    var data = {
                        id: item.id,
                    };
                    $http.post(url, data)
                        .then(function (response) {
                            if (response.data.status == 'successful') {
                                $scope.warehouse.category_configs.splice(index, 1);
                            }
                        });
                },
                cancel: function () {
                    
                }
            }
        });
    }

    $scope.removeOption = function (index, productConfig) {
        productConfig.options.splice(index, 1);
        buildFilterProduct(productConfig);
    }

    $scope.addOption = function(productConfig) {
        if (productConfig.options.length > 3) {
            $.alert({
                title: 'Cảnh báo!',
                content: 'Vui lòng không chọn tổ hợp nhiền hơn 4 biến thể',
            });
        } else {
            productConfig.options.push({});
        }
    }

    $scope.chooseCategory = function(config, index) {
        var category_id = config.category_id;
        var i = 0;
        var check = false;
        $scope.warehouse.category_configs.forEach(function (config) {
            if (config.category_id == category_id && index != i) {
                check = true;
                return;
            }
            i++;
        })
        if (check) {
            $scope.warehouse.category_configs[index].category_id = null;
            $.alert({
                title: 'Cảnh báo!',
                content: 'Danh mục đã được cấu hình, vui lòng chọn danh mục khác',
            });
        }
    }

    $scope.chooseConfigCategory = function (category_id, items, index) {
        var i = 0;
        var check = false;
        items.forEach(function (config) {
            if (config.apply_cate == category_id && index != i) {
                check = true;
                return;
            }
            i++;
        })
        if (check) {
            items[index].apply_cate = null;
            $.alert({
                title: 'Cảnh báo!',
                content: 'Danh mục đã được cấu hình, vui lòng chọn danh mục khác',
            });
        }
    }

    $scope.chooseOption = function(option, config, index) {
        if (typeof config.category_id == 'undefined') {
            delete option.option;
            if (typeof option.option_id != 'undefined') {
                delete option.option_id;
            }
            $.alert({
                title: 'Cảnh báo!',
                content: 'Vui lòng chọn danh mục áp dụng',
            });
            return false;
        }
        var options = config.options;
        if (option.option != null) {
            option.option_id = option.option.id;
            var check = false;
            var i = 0;
            options.forEach(function(item) {
                if (item.option_id == option.option_id && index != i) {
                    check = true;
                    return;
                }
                i++;
            });
            if (!check) {
                var url = '/service/warehouse/product/get-option-value';
                var data = {
                    option_id: option.option_id,
                    category_id: config.category_id
                };
                $http.post(url, data)
                .then(function (response) {
                    if (response.data.status == 'successful') {
                        option.variants = response.data.result.apply_options;
                    } else {
                        delete option.option;
                        if (typeof option.option_id != 'undefined') {
                            delete option.option_id;
                        }
                        $.alert({
                            title: 'Cảnh báo!',
                            content: 'Danh mục này không có sản phẩm của biến thể bạn đã chọn vui lòng chọn thuộc tính khác',
                        });
                    }
                });
            } else {
                delete option.option;
                if (typeof option.option_id != 'undefined') {
                    delete option.option_id;
                }
                $.alert({
                    title: 'Cảnh báo!',
                    content: 'Thuộc tính đã được áp dụng, vui lòng chọn thuộc tính khác',
                });
            }
        }
    }


    $scope.chooseVariant = function (productConfig) {
        buildFilterProduct(productConfig);
    }

    function buildFilterProduct(productConfig) {
        productConfig.combination_variants = [];
        productConfig.options.forEach(function (option) {
            option.variantSelecteds = [];
            var variantSelecteds = [];
            option.variantSelecteds.forEach(function (variant) {
                variantSelecteds.push(variant.id);
            });
            option.variant_ids.forEach(function(id) {
                if (variantSelecteds.indexOf(id) < 0 && typeof option.variants[id] != 'undefined') {
                    var newVariant = {
                        id: id,
                        name: option.variants[id],
                        bulk_selected: false
                    };
                    option.variantSelecteds.push(newVariant);
                }
            })
            productConfig.combination_variants.push(option.variantSelecteds);
        });
        buildProduct(productConfig)
    }

    function buildProduct(productConfig) {
        var arrItems = [];
        var combinationVariantSelecteds = productConfig.combination_variants;
        if (combinationVariantSelecteds.length == 1) {
            arrItems = Combinatorics.cartesianProduct(combinationVariantSelecteds[0]);
        } else if(combinationVariantSelecteds.length == 2) {
            arrItems = Combinatorics.cartesianProduct(combinationVariantSelecteds[0], combinationVariantSelecteds[1]);
        } else if(combinationVariantSelecteds.length == 3) {
            arrItems = Combinatorics.cartesianProduct(combinationVariantSelecteds[0], combinationVariantSelecteds[1], combinationVariantSelecteds[2]);
        } else if(combinationVariantSelecteds.length == 4) {
            arrItems = Combinatorics.cartesianProduct(combinationVariantSelecteds[0], combinationVariantSelecteds[1], combinationVariantSelecteds[2], combinationVariantSelecteds[3]);
        }
        var products = [];
        let listByStrId = {};
        if (!productConfig.products) {
            productConfig.products = [];
        }
        for (let index = 0; index < productConfig.products.length; index++) {
            const element = productConfig.products[index];
            listByStrId[element.str_id] =  element;
        }
        if (arrItems.length > 0) {
            var arrItems = arrItems.toArray();
            for (var i = 0; i < arrItems.length; i++) {
                var product = {
                    str_id: generateStrId(arrItems[i]),
                    variants: arrItems[i], 
                    instock: 1, 
                    deleted: 0
                };
                if (listByStrId[product.str_id]) {
                    product = Object.assign(product, listByStrId[product.str_id]);
                }
                products.push(product);
            }
            
        }
        productConfig.products = products;
    }

    function generateStrId(items) {
        var retVal = '';
        var ids = [];
        for (var j = 0; j < items.length; j++) {
            ids.push(parseInt(items[j].id)); 
        }
        ids.sort(function(a, b) {
            return a - b;
        });
        if (ids.length > 0) {
            retVal = ids.join('-');
        }
        return retVal;
    }

    $scope.selectVariantValue = function (item, productConfig) {
        if (!item.bulk_selected) {
            item.bulk_selected = true;
        } else {
            item.bulk_selected = false;
        }
        var combinationVariantSelecteds = [];
        var checkEmpty = true;
        productConfig.combination_variants.forEach(function (variants) {
            var variantSelecteds = [];
            variants.forEach(function (variant) {
                if (variant.bulk_selected) {
                    variantSelecteds.push(variant);
                }
            })
            if (variantSelecteds.length == 0) {
                variantSelecteds = variants;
            } else {
                checkEmpty = false;
            }
            combinationVariantSelecteds.push(variantSelecteds);
        });
        if (checkEmpty) {
            combinationVariantSelecteds = [];
            productConfig.products.forEach(function(product) {
                product.selected = 0;
            });
            productConfig.show_action = 0;
        }
        var arrItems = [];
        if (combinationVariantSelecteds.length == 1) {
            arrItems = Combinatorics.cartesianProduct(combinationVariantSelecteds[0]);
        } else if(combinationVariantSelecteds.length == 2) {
            arrItems = Combinatorics.cartesianProduct(combinationVariantSelecteds[0], combinationVariantSelecteds[1]);
        } else if(combinationVariantSelecteds.length == 3) {
            arrItems = Combinatorics.cartesianProduct(combinationVariantSelecteds[0], combinationVariantSelecteds[1], combinationVariantSelecteds[2]);
        } else if(combinationVariantSelecteds.length == 4) {
            arrItems = Combinatorics.cartesianProduct(combinationVariantSelecteds[0], combinationVariantSelecteds[1], combinationVariantSelecteds[2], combinationVariantSelecteds[3]);
        }
        if (arrItems.length > 0) {
            var arrItems = arrItems.toArray();
            var strIdSelecteds = [];
            for (var i = 0; i < arrItems.length; i++) {
                var strId = generateStrId(arrItems[i]);
                strIdSelecteds.push(strId);
            }
            productConfig.products.forEach(function(product) {
                var strIds = product.str_id.split('-');
                strIds.sort(function(a, b) {
                    return a - b;
                });
                var strId = strIds.join('-');
                if (strIdSelecteds.indexOf(strId) >= 0) {
                    product.selected = 1;
                } else {
                    product.selected = 0;
                }
            });
            if (strIdSelecteds.length > 0) {
                productConfig.show_action = 1;
            }
        }
    }

    $scope.checkAll = function (productConfig) {
        if (productConfig.check_all) {
            productConfig.show_action = 1;
            productConfig.products.forEach(function(product) {
                product.selected = 1;
            });
        } else {
            productConfig.show_action = 0;
            productConfig.products.forEach(function(product) {
                product.selected = 0;
            });
        }
        
    }

    $scope.checkedProduct = function (product, productConfig) {
        productConfig.show_action = 1;
        if (!product.selected) {
            var showAction = 0;
            productConfig.products.forEach(function(product){
                if (product.selected) {
                    showAction = 1;
                    return
                }
            });
            if (!showAction) {
                productConfig.show_action = 0;
            }
        }
    }

    $scope.removeProduct = function (product) {
        $.confirm({
            title: 'Xóa sản sản phẩm!',
            content: 'Bạn có chắc chắn xóa sản phẩm này?',
            buttons: {
                confirm: function () {
                    $scope.$apply(function () {
                        product.deleted = 1;
                    });
                },
                cancel: function () {
                    
                }
            }
        });
    }

    $scope.deleteProduct = function (productConfig) {
        $.confirm({
            title: 'Xóa sản sản phẩm!',
            content: 'Bạn có chắc chắn xóa sản phẩm đã chọn?',
            buttons: {
                confirm: function () {
                    $scope.$apply(function () {
                        productConfig.products.forEach(function (product) {
                            if (product.selected) {
                                product.deleted = 1;
                            }
                        });
                        clearSelected(productConfig);
                    });
                },
                cancel: function () {
                    
                }
            }
        });
    }

    $scope.updateProductStatus = function (type, productConfig) {
        var text = '';
        if (type == 'instock') {
            text = 'có hàng';
        } else if (type == 'outstock') {
            text = 'không có hàng';
        }
        $.confirm({
            title: 'Cập nhật trạng thái sản phẩm!',
            content: 'Bạn có chắc chắn cập nhật sản phẩm đã chọn là ' + text + '?',
            buttons: {
                confirm: function () {
                    $scope.$apply(function () {
                        productConfig.products.forEach(function (product) {
                            if (product.selected) {
                                if (type == 'instock') {
                                    product.instock = 1;
                                } else if (type == 'outstock') {
                                    product.instock = 0;
                                }
                            }
                        })
                        clearSelected(productConfig);
                    });
                },
                cancel: function () {
                    
                }
            }
        });
        
    }

    function clearSelected(productConfig, type) {
        productConfig.show_action = 0;
        productConfig.products.forEach(function (product) {
            product.selected = 0;
        })
        productConfig.combination_variants.forEach(function (variants) {
            variants.forEach(function (variant) {
                variant.bulk_selected = false;
            })
        })
        if (type != 'show_delete') {
            productConfig.show_deleted = 0;
        }
        productConfig.check_all = 0;
    }

    $scope.showRestoreProduct = function (productConfig) {
        if (!productConfig.show_deleted) {
            productConfig.show_deleted = true;
        } else {
            productConfig.show_deleted = false;
        }
        clearSelected(productConfig, 'show_delete');

    }

    $scope.restoreProduct = function (product) {
        $.confirm({
            title: 'Khôi phục sản phẩm!',
            content: 'Bạn có chắc chắn khôi phục sản phẩm này?',
            buttons: {
                confirm: function () {
                    $scope.$apply(function () {
                        product.deleted = 0;
                    });
                },
                cancel: function () {
                    
                }
            }
        });
    }

    $scope.restoreProductSelected = function (productConfig) {
        $.confirm({
            title: 'Khôi phục sản phẩm!',
            content: 'Bạn có chắc chắn khôi phục sản phẩm đã chọn?',
            buttons: {
                confirm: function () {
                    $scope.$apply(function () {
                        productConfig.products.forEach(function (product) {
                            if (product.selected) {
                                product.deleted = 0;
                            }
                        })
                        productConfig.show_deleted = 0;
                        clearSelected(productConfig);
                    });
                },
                cancel: function () {
                    
                }
            }
        });
        
    }

    function makeId(length) {
        var result = '';
        var characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
        var charactersLength = characters.length;
        for (var i = 0; i < length; i++) {
            result += characters.charAt(Math.floor(Math.random() * charactersLength));
        }
        return result;
    }

    $scope.syncProductByWH = function () {
        $scope.isLoading = true;
        var id = $scope.warehouse.id;
        var url = '/service/warehouse/sync/product-status?id=' + id;
        $http.get(url)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    $.alert({
                        title: 'Thông báo!',
                        content: 'Trạng thái sản phẩm sẽ được đồng bộ theo cấu hình kho chậm nhất sau 24h',
                    });
                    $scope.isLoading = false;
                }
            });
    }

    $scope.updateCost = function (config) {
        $scope.productCost.category_id = config.category_id;
        $('#modalCostForm').modal('toggle');
    }

    $scope.fillCost = function () {
        if ($scope.productCost.category_id != null) {
            $scope.warehouse.category_configs.forEach(function (config) {
                if (config.category_id == $scope.productCost.category_id) {
                    config.products.forEach(function (product) {
                        if (typeof product.selected != 'undefined' && product.selected) {
                            if ($scope.productCost.origin_cost) {
                                product.origin_cost = $scope.productCost.origin_cost;
                                if (!$scope.productCost.cost) {
                                    let rate = null;
                                    if (product.ratio_id) {
                                        rate = $scope.ratioByIds[product.ratio_id];
                                    } else {
                                        if (config.ratio_id) {
                                            rate = $scope.ratioByIds[config.ratio_id];
                                        }
                                    }
                                    if (rate) {
                                        product.cost = Math.round($scope.productCost.origin_cost * rate * 100) / 100;
                                    }
                                }
                            }
                            if ($scope.productCost.cost) {
                                product.cost = $scope.productCost.cost;
                            }
                        }
                    });
                }
            });
        }
        $scope.productCost = {
            category_id: null,
            cost: null,
            ratio_id: null
        };
        $('#modalCostForm').modal('toggle');
    }

    $scope.updateRatio = function (config) {
        $scope.productCost.category_id = config.category_id;
        $('#modalRatioForm').modal('toggle');
    }

    $scope.fillRatio = function () {
        if ($scope.productCost.category_id != null) {
            $scope.warehouse.category_configs.forEach(function (config) {
                if (config.category_id == $scope.productCost.category_id) {
                    config.products.forEach(function (product) {
                        if (typeof product.selected != 'undefined' && product.selected) {
                            if ($scope.productCost.ratio_id) {
                                product.ratio_id = $scope.productCost.ratio_id;
                                if (product.origin_cost) {
                                    let rate = $scope.ratioByIds[$scope.productCost.ratio_id];
                                    product.cost = Math.round(product.origin_cost * rate * 100) / 100;
                                }
                            }
                        }
                    });
                }
            });
        }
        $scope.productCost = {
            category_id: null,
            cost: null,
            ratio_id: null
        };
        $('#modalRatioForm').modal('toggle');
    }

    $scope.handleUploadRefund = function (excelFile, item) {
        if (excelFile) {
            Upload.upload({
                url: '/service/warehouse/import',
                data: { 
                    file: excelFile,
                    id: item.id
                }
            }).then( function (response) {
                if (response.data.status == "successful") {
                    toastr.success('Import thành công');
                    $scope.find(false);
                } else {
                    toastr.error('Có lỗi xảy ra. ' + response.data.message);
                }
            }, function (err) {
                toastr.error('Có lỗi xảy ra trong quá trình Import. Xin vui lòng thử lại.');
            });
        }
    }
    $scope.enableEdit = (item) => {
        $.confirm({
            title: 'Chỉnh sửa kho!',
            content: item.is_editable == 1 ? 'Bạn có chắc chắn bật chỉnh sửa?' : 'Bạn có chắc chắn tắt chỉnh sửa?',
            buttons: {
                confirm: function () {
                    var url = "service/warehouse/enable-edit";
                    var data = {
                        id: item.id,
                        is_editable: item.is_editable,
                    };
                    if (typeof user != 'undefined') {
                        data.email = user.email;
                    }
                    $http.post(url, data)
                        .then(function (response) {
                            if (response.data.status == 'successful') {
                                toastr.success('Sửa thành công');
                            } else {
                                toastr.error(response.data.message);
                                if (item.is_editable == 1) {
                                    $("#enable-edit-" + item.id).prop('checked', false);
                                } else {
                                    $("#enable-edit-" + item.id).prop('checked', true);
                                }
                            }
                        });
                },
                cancel: function () {
                    if (item.is_editable == 1) {
                        $("#enable-edit-" + item.id).prop('checked', false);
                    } else {
                        $("#enable-edit-" + item.id).prop('checked', true);
                    }
                }
            }
        });
    }

    $scope.toVietnameseDate = function (dateTime, withYear) {
        if (dateTime != null && dateTime.length > 0) {
            var outputFormat = "$3/$2";
            if (withYear) {
                outputFormat += "/$1";
            }
            return dateTime.replace(/(\d{4})-(\d{2})-(\d{2})(?:\s+(\d{2}):(\d{2}):.*)?/, outputFormat);
        } else {
            return "";
        }
    };

    $scope.summarizeDateTime = function (dateTime, withYear) {
        if (dateTime != null) {
            var outputFormat = "$3/$2";
            if (withYear) {
                outputFormat += "/$1";
            }
            outputFormat += " $4:$5";
            return dateTime.replace(/(\d{4})-(\d{2})-(\d{2})\s+(\d{1,2}):(\d{1,2}):.*/, outputFormat);
        }
    };

    $scope.changeRate = () => {
        if ($scope.warehouse.rate && $scope.warehouse.rate > 0) {
            for (let index = 0; index < $scope.warehouse.category_configs.length; index++) {
                const element = $scope.warehouse.category_configs[index];
                if (element.origin_cost) {
                    element.cost = Math.round(element.origin_cost * $scope.warehouse.rate * 100) / 100;
                }
                for (let i = 0; i < element.products.length; i++) {
                    const item = element.products[i];
                    if (item.origin_cost) {
                        item.cost = Math.round(item.origin_cost * $scope.warehouse.rate * 100) / 100;
                    }
                }
            }
            for (let index = 0; index < $scope.warehouse.cost_configs.length; index++) {
                const element = $scope.warehouse.cost_configs[index];
                for (let i = 0; i < element.config_items.length; i++) {
                    const item = element.config_items[i];
                    if (item.origin_shipping_fee && item.origin_shipping_fee != 0) {
                        item.default_shipping_fee = Math.round(item.origin_shipping_fee * $scope.warehouse.rate * 100) / 100;
                    }
                    if (item.origin_adding_fee && item.origin_adding_fee != 0) {
                        item.default_adding_fee = Math.round(item.origin_adding_fee * $scope.warehouse.rate * 100) / 100;
                    }
                }
            }
        }
    }

    $scope.getConfigItemVariant = (item) => {
        $scope.currentConfigItem = item;
        var url = "service/warehouse/config/item/find";
        var data = {
            warehouse_config_item_id: item.id
        };
        $scope.warehouseConfigItemData = [];
        $http.post(url, data)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    if (response.data.result) {
                        $scope.applyCategories = [];
                        var categoryConfigs = {
                            options: [],
                            products: []
                        };
                        response.data.result.forEach(function (config) {
                            config.is_show = 1;
                            if (config.options.length == 0) {
                                config.options.push({});
                            } else {
                                config.options.forEach(function (option) {
                                    option.option = $scope.getById($scope.options, option.option_id);
                                    if (typeof option.option_value_ids == 'string' && option.option_value_ids != '') {
                                        var variantIds = [];
                                        variantIds = option.option_value_ids.split(',');
                                        option.variant_ids = variantIds;
                                    }
                                });
                            }
                            config.combination_variants = [];
                            config.options.forEach(function (option) {
                                option.variantSelecteds = [];
                                if (typeof option.variant_ids != 'undefined' && option.variant_ids.length > 0) {
                                    option.variant_ids.forEach(function(id) {
                                        if (typeof option.variants[id] != 'undefined') {
                                            var newVariant = {
                                                id: id,
                                                name: option.variants[id],
                                                bulk_selected: false
                                            };
                                            option.variantSelecteds.push(newVariant);
                                        }
                                    })
                                }
                                config.combination_variants.push(option.variantSelecteds);
                            });
                            categoryConfigs = config;
                        });
                        $scope.warehouseConfigItemData = categoryConfigs;
                    }
                    $("#modalWarehouseConfigItemVariant").modal("toggle");
                }
            });
    }

    $scope.saveConfigItemVariant = (item) => {
        var data = {};
        data.data = angular.copy(item);
        delete data.data.variants;
        if (typeof user != 'undefined') {
            data.email = user.email;
        }
        data.warehouse_config_item_id = $scope.currentConfigItem.id;
        data.warehouse_id = $scope.warehouse.id;
        var url = 'service/warehouse/config/item/save';
        $http.post(url, data).then(function (response) {
            if (response.data.status == 'successful') {
                toastr.success('Lưu thông tin biến thể thành công');
                $timeout(function () {
                    $("#modalWarehouseConfigItemVariant").modal("hide");
                });
            } else {
                toastr.error(response.data.message);
            }
            $scope.checkConfigBulkVariant();
        }, function (error) {
            toastr.error('Đã có lỗi xảy ra trong quá trình lưu biến thể.');
        })
    }

    $scope.checkConfigBulkVariant = () => {
        if ($scope.config.config_items) {
            var ids = [];
            for (var item of $scope.config.config_items) {
                if (item.id && item.type == 'custom') {
                    ids.push(item.id);
                }
            }
            if (ids.length > 0) {
                var url = 'service/warehouse/config/item/check-bulk';
                $http.get(url, {params: { ids: ids.join('-') }}).then(function (response) {
                    if (response.data.status == 'successful') {
                        var configurations = response.data.result || [];
                        for (var item of $scope.config.config_items) {
                            item.is_variant_bulk = (item.id && item.type == 'custom' && configurations.indexOf(item.id) >= 0) ? 1 : 0;
                        }
                    }
                });
            }
        }
    }

    $scope.chooseOptionConfigItem = function(option, config, index) {
        var options = config.options;
        if (option.option != null) {
            option.option_id = option.option.id;
            var check = false;
            var i = 0;
            options.forEach(function(item) {
                if (item.option_id == option.option_id && index != i) {
                    check = true;
                    return;
                }
                i++;
            });
            if (!check) {
                var url = '/service/warehouse/product/get-option-value';
                var data = {
                    option_id: option.option_id,
                };
                $http.post(url, data)
                .then(function (response) {
                    if (response.data.status == 'successful') {
                        option.variants = response.data.result.apply_options;
                    }
                });
            } else {
                delete option.option;
                if (typeof option.option_id != 'undefined') {
                    delete option.option_id;
                }
                $.alert({
                    title: 'Cảnh báo!',
                    content: 'Thuộc tính đã được áp dụng, vui lòng chọn thuộc tính khác',
                });
            }
        }
    }

    $scope.getConfigItems = () => {
        var url = "service/warehouse/config/item/find";
        var data = {
            warehouse_id: $scope.warehouse.id,
            type: $scope.tab
        };
        $http.post(url, data)
            .then(function (response) {
                $scope.listVariantConfig = [];
                $scope.listVariantConfig["standard"] = [];
                $scope.listVariantConfig["premium"] = [];
                $scope.listVariantConfig["express"] = [];
                $scope.listVariantConfigByStrId = {};
                $scope.isShowVariantConfig = false;
                if (response.data.status == 'successful') {
                    for (let index = 0; index < response.data.result.length; index++) {
                        const element = response.data.result[index];
                        for (let i = 0; i < element.products.length; i++) {
                            const product = element.products[i];
                            product.name = product.variants.map(x => x.name).join('-');

                            if (!$scope.listVariantConfigByStrId[product.str_id]) {
                                $scope.listVariantConfigByStrId[product.str_id] = product.name;
                            }
                            $scope.listVariantConfig[element.type][product.str_id] = product;
                        }
                    }
                }
                if (Object.keys($scope.listVariantConfigByStrId).length > 0) {
                    $scope.isShowVariantConfig = true;
                }
            });
    }

    $scope.filterProductLists = function (products, showDeleted) {
        if (products) {
            return products.filter(function (product) {
                if (showDeleted) {
                    return product.deleted == 1;
                } else {
                    return product.deleted == 0;
                }
            });
        }
        return [];
    }

    $scope.chooseVariantShipping = function (productConfig) {
        buildFilterProductShipping(productConfig);
    }

    function buildFilterProductShipping(productConfig) {
        productConfig.combination_variants = [];
        productConfig.options.forEach(function (option) {
            option.variantSelecteds = [];
            var variantSelecteds = [];
            option.variantSelecteds.forEach(function (variant) {
                variantSelecteds.push(variant.id);
            });
            option.variant_ids.forEach(function(id) {
                if (variantSelecteds.indexOf(id) < 0 && typeof option.variants[id] != 'undefined') {
                    var newVariant = {
                        id: id,
                        name: option.variants[id],
                        bulk_selected: false
                    };
                    option.variantSelecteds.push(newVariant);
                }
            })
            productConfig.combination_variants.push(option.variantSelecteds);
        });
        buildProductShipping(productConfig)
    }

    function buildProductShipping(productConfig) {
        var arrItems = [];
        var combinationVariantSelecteds = productConfig.combination_variants;
        if (combinationVariantSelecteds.length == 1) {
            arrItems = Combinatorics.cartesianProduct(combinationVariantSelecteds[0]);
        } else if(combinationVariantSelecteds.length == 2) {
            arrItems = Combinatorics.cartesianProduct(combinationVariantSelecteds[0], combinationVariantSelecteds[1]);
        } else if(combinationVariantSelecteds.length == 3) {
            arrItems = Combinatorics.cartesianProduct(combinationVariantSelecteds[0], combinationVariantSelecteds[1], combinationVariantSelecteds[2]);
        } else if(combinationVariantSelecteds.length == 4) {
            arrItems = Combinatorics.cartesianProduct(combinationVariantSelecteds[0], combinationVariantSelecteds[1], combinationVariantSelecteds[2], combinationVariantSelecteds[3]);
        }
        var products = [];
        let listByStrId = {};
        if (!productConfig.products) {
            productConfig.products = [];
        }
        for (let index = 0; index < productConfig.products.length; index++) {
            const element = productConfig.products[index];
            listByStrId[element.str_id] =  element;
        }
        if (arrItems.length > 0) {
            var arrItems = arrItems.toArray();
            for (var i = 0; i < arrItems.length; i++) {
                var product = {
                    str_id: generateStrId(arrItems[i]),
                    variants: arrItems[i], 
                    selected: 0,
                    default_shipping_fee: 0,
                    default_adding_item: 0,
                    origin_shipping_fee: 0,
                    origin_adding_fee: 0,
                    tax: 0,
                    ratio_id: null
                };
                if (listByStrId[product.str_id]) {
                    product.id = listByStrId[product.str_id].id;
                    product.selected = listByStrId[product.str_id].selected;
                    product.origin_shipping_fee = listByStrId[product.str_id].origin_shipping_fee;
                    product.default_shipping_fee = listByStrId[product.str_id].default_shipping_fee;
                    product.origin_adding_fee = listByStrId[product.str_id].origin_adding_fee;
                    product.default_adding_item = listByStrId[product.str_id].default_adding_item;
                    product.tax = listByStrId[product.str_id].tax || 0;
                    if (listByStrId[product.str_id].ratio_id) {
                        product.ratio_id = listByStrId[product.str_id].ratio_id;
                    }
                }
                products.push(product);
            }
            
        }
        productConfig.products = products;
    }

    $scope.changeCostShipping = (type, item) => {
        if (type == 'shipping') {
            if ($scope.warehouse && $scope.warehouse.rate && item.origin_shipping_fee && item.origin_shipping_fee != 0) {
                item.default_shipping_fee = Math.round(item.origin_shipping_fee * $scope.warehouse.rate * 100) / 100;
            }
        } else if (type == 'adding') {
            if ($scope.warehouse && $scope.warehouse.rate && item.origin_adding_fee && item.origin_adding_fee != 0) {
                item.default_adding_item = Math.round(item.origin_adding_fee * $scope.warehouse.rate * 100) / 100;
            }
        }
    }

    $scope.changeRatioShipping = (item, type, warehouseConfigItemData = null) => {
        let rate = null;
        if (item.ratio_id) {
            rate = $scope.ratioByIds[item.ratio_id];
        } else if (warehouseConfigItemData.ratio_id) {
            rate = $scope.ratioByIds[warehouseConfigItemData.ratio_id];
        }
        if (rate) {
            let rate = $scope.ratioByIds[item.ratio_id];
            if (item.origin_shipping_fee) {
                item.default_shipping_fee = Math.round(item.origin_shipping_fee * rate * 100) / 100;
            }
            if (item.origin_adding_fee) {
                item.default_adding_item = Math.round(item.origin_adding_fee * rate * 100) / 100;
            }
            if (item.is_bulk) {
                if (item.origin_shipping_fee_bulk) {
                    item.default_shipping_fee_bulk = Math.round(item.origin_shipping_fee_bulk * rate * 100) / 100;
                }
                if (item.origin_adding_fee_bulk) {
                    item.default_adding_item_bulk = Math.round(item.origin_adding_fee_bulk * rate * 100) / 100;
                }
            }
        }
    }

    $scope.changeOriginShippingCost = (type, item, warehouseConfigItemData = null) => {
        if (type == 'shipping') {
            if (!item.ratio_id) {
                if (warehouseConfigItemData.ratio_id) {
                    let rate = $scope.ratioByIds[warehouseConfigItemData.ratio_id];
                    item.default_shipping_fee = Math.round(item.origin_shipping_fee * rate * 100) / 100;
                }
            } else {
                let rate = $scope.ratioByIds[item.ratio_id];
                item.default_shipping_fee = Math.round(item.origin_shipping_fee * rate * 100) / 100;
            }
        } else if (type == 'adding') {
            if (!item.ratio_id) {
                if (warehouseConfigItemData.ratio_id) {
                    let rate = $scope.ratioByIds[warehouseConfigItemData.ratio_id];
                    item.default_adding_item = Math.round(item.origin_adding_fee * rate * 100) / 100;
                }
            } else {
                let rate = $scope.ratioByIds[item.ratio_id];
                item.default_adding_item = Math.round(item.origin_adding_fee * rate * 100) / 100;
            }
        }
    }

    $scope.changeRatio = (item, type, categoryConfig = null) => {
        let rate = null;
        if (item.ratio_id) {
            rate = $scope.ratioByIds[item.ratio_id];
        } else if (categoryConfig.ratio_id) {
            rate = $scope.ratioByIds[categoryConfig.ratio_id];
        }
        if (rate) {
            item.cost = Math.round(item.origin_cost * rate * 100) / 100;
            if (item.origin_cost_bulk) {
                item.cost_bulk = Math.round(item.origin_cost_bulk * rate * 100) / 100;
            }
            if (item.products && item.products.length > 0) {
                for (let index = 0; index < item.products.length; index++) {
                    const element = item.products[index];
                    if (!element.ratio_id) {
                        element.cost = Math.round(element.origin_cost * rate * 100) / 100;
                        if (element.origin_cost_bulk) {
                            element.cost_bulk = Math.round(element.origin_cost_bulk * rate * 100) / 100;
                        }
                    }
                }
            }
        }
    }

    $scope.changeCostProduct = (type, item, categoryConfig = null) => {
        if (item.origin_cost == 0) {
            item.cost = 0;
        } else {
            if (type == 'item') {
                let rate = null;
                if (item.ratio_id) {
                    rate = $scope.ratioByIds[item.ratio_id];
                } else if (categoryConfig.ratio_id) {
                    rate = $scope.ratioByIds[categoryConfig.ratio_id];
                }

                if (rate) {
                    item.cost = Math.round(item.origin_cost * rate * 100) / 100;
                    if (item.origin_cost_bulk) {
                        item.cost_bulk = Math.round(item.origin_cost_bulk * rate * 100) / 100;
                    }
                }
            } else if (type == 'category') {
                if (item.origin_cost == 0) {
                    item.cost = 0;
                }
                if (item.ratio_id) {
                    let rate = $scope.ratioByIds[item.ratio_id];
                    item.cost = Math.round(item.origin_cost * rate * 100) / 100;
                    if (item.origin_cost_bulk) {
                        item.cost_bulk = Math.round(item.origin_cost_bulk * rate * 100) / 100;
                    }
                }
            }
        }
    }

    $scope.togglePropVariantItem = function () {
        if ($scope.warehouseConfigItemData && $scope.warehouseConfigItemData.products) {
            for (var product of $scope.warehouseConfigItemData.products) {
                product.selected = angular.copy($scope.warehouseConfigItemData.selected);
            }
        }
        $scope.checkVariantItemBulk();
    }

    $scope.checkVariantItemBulk = function () {
        if ($scope.warehouseConfigItemData && $scope.warehouseConfigItemData.products) {
            var numSelected = 0;
            for (var product of $scope.warehouseConfigItemData.products) {
                if (product.selected) numSelected++;
            }
            $scope.warehouseConfigItemData.numSelected = numSelected;
        }
    }

    $scope.openFormVariantItemBulk = function () {
        $scope.variantItemBulk = {};
        $timeout(function () {
            $('#modalVariantItemBulk').modal('show');
        });
    }

    $scope.applyFormVariantItemBulk = function () {
        if ($scope.warehouseConfigItemData && $scope.warehouseConfigItemData.products) {
            for (var product of $scope.warehouseConfigItemData.products) {
                if (product.selected) {
                    product = Object.assign(product, angular.copy($scope.variantItemBulk));
                }
            }
        }
        $timeout(function () {
            $('#modalVariantItemBulk').modal('hide');
        });
    }

    $scope.init();
}