system.config(['dynamicNumberStrategyProvider', function(dynamicNumberStrategyProvider){
    dynamicNumberStrategyProvider.addStrategy('price', {
      numInt: 6,
      numFract: 2,
      numSep: '.',
      numPos: true,
      numNeg: true,
      numRound: 'round',
      numThousand: true
    });
  }]);
system.controller("WarehouseProductController", WarehouseProductController);
function WarehouseProductController($scope, $http, $rootScope, $timeout, Upload) {
    $scope.baseController = this.__proto__ = new PaginationController($scope, $http, $rootScope, Upload);
    $scope.filters = {
        page_id: 0
    };
    $scope.isLoading = false;
    $scope.printings = printings;
    $scope.warehouses = warehouses;
    $scope.warehouseActives = warehouseActives;
    $scope.items = [];
    $scope.ngShowApplyProduct = false;
    $scope.itemSuggestions = [];
    $scope.showSuggestion = false;
    $scope.countSelected = 0;
    $scope.checkedAll = 0;

    $scope.init = function () {
        $scope.find(true);
    }

    $scope.clear = function () {
        $scope.filters = {
            page_id: 0
        }
        $scope.find(true);
    }

    $scope.find = function (refresh) {
        if (refresh) {
            $scope.filters.page_id = 0;
        }
        var filter = buildFilter();
        var params = getParams(filter);
        var url = '/service/warehouse/product/find';
        if (params.length > 0) {
            url += '?' + params.join('&');
        }
        $scope.isLoading = true;
        $http.get(url)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    var items = [];
                    if (response.data.result.length > 0) {
                        response.data.result.forEach(function(item) {
                            item.is_checked = 0;
                            items.push(item);
                        });
                    }
                    $scope.items = items;
                    $scope.pagesCount = response.data.pagesCount;
                }
                $scope.isLoading = false;
            }, function (error) {
                $scope.isLoading = false;
            })
    }

    function buildFilter() {
        var retVal = {};
        if ($scope.filters.keyword) {
            retVal.keyword = $scope.filters.keyword;
        }
        if ($scope.filters.warehouse_id) {
            retVal.warehouse_id = $scope.filters.warehouse_id;
        }
        if ($scope.filters.printing_code) {
            retVal.printing_code = $scope.filters.printing_code;
        }
        retVal.page_id = $scope.filters.page_id;
        return retVal;
    }

    getParams = function(filter) {
        var params = [];
        for (var key in filter) {
            var filterValue = filter[key];
            var param = '';
            if (typeof filterValue == 'object' || typeof filterValue == 'array') {
                if (filterValue.length > 0) {
                    param = key + '=' + filterValue.join(',');
                }
            } else {
                param = key + '=' + filterValue;
            }
            if (param != '') {
                params.push(param);
            }
        }
        return params;
    }

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.find(false);
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.find(false);
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.find(false);
        }
    };


    $scope.save = function () {
        var data = buildData();
        var invalid = false;
        if (!data.warehouse_id) {
            invalid = true;
            toastr.error('Vui lòng chọn kho');
        }
        if (!data.apply_product || data.apply_product.length == 0) {
            toastr.error('Vui lòng chọn sản phẩm');
            invalid = true;
        }
        if (invalid) {
            return false;
        }
        var url = 'service/warehouse/product/create';
        
        $http.post(url, data)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.find();
                    $scope.showForm = false;
                    toastr.success('Bạn đã lưu sản phẩm thành công');
                    $('#modalForm').modal('toggle');
                } else {
                    toastr.error('Có lỗi xảy ra, vui lòng thử lại.');
                }
            }, function (error) {
                toastr.error('Đã có lỗi xảy ra');
            })
    }

    function buildData () {
        var retVal = angular.copy($scope.item);
        if (retVal.apply_product.length > 0) {
            var apply_product = [];
            retVal.apply_product.forEach(function(item) {
                var newItem = {
                    product_id: item.product_id,
                    product_sku_id: item.product_sku_id
                };
                apply_product.push(newItem);
            });
            retVal.apply_product = apply_product;
        }
        return retVal;
    }

    
    $scope.openModal = function () {
        $scope.item = {
            apply_product: []
        };
        $('#modalForm').modal('toggle');
    }

    var findFlag;
    $scope.suggestion = function() {
        $scope.itemSuggestions = [];
        $scope.showSuggestion = false;
        clearTimeout(findFlag);
        findFlag = setTimeout(function(){
            findSuggestion();
        },300);
    }

    function findSuggestion() {
        var keyword = $scope.warehouse.keyword;
        var url = "/service/warehouse/product-info/find?keyword=" + keyword;
        $http.get(url).then(function (response) {
            if (response.data.status === "successful" && response.data.result.length > 0) {
                $scope.showSuggestion = true;
                $scope.itemSuggestions = response.data.result;
            }
        });
    }

    $scope.applyItem = function() {
        $scope.warehouse.keyword = null;
        var productIds = [];
        $scope.item.apply_product.forEach(function(item) {
            productIds.push(item.id);
        });
        $scope.itemSuggestions.forEach(function(item) {
            if (item.is_checked) {
                if (productIds.indexOf(item.id) < 0) {
                    $scope.item.apply_product.push(item);
                }
            }
        });
        $scope.showSuggestion = false;
    }

    $scope.cancelSuggestion = function() {
        $scope.showSuggestion = false;
        $scope.showGetSuggestion = false;
    }

    $scope.deleteApplyItem = function(index) {
        $scope.item.apply_product.splice(index,1);
    }

    $scope.checkAll = function() {
        if ($scope.checkedAll) {
            $scope.items.forEach(function (item) {
                item.is_checked = 1;
            });
            $scope.countSelected = $scope.items.length;
        } else {
            $scope.items.forEach(function (item) {
                item.is_checked = 0;
            });
            $scope.countSelected = 0;
        }
    }

    $scope.checkedItem = function() {
        var countSelected = 0;
        $scope.items.forEach(function (item) {
            if (item.is_checked) {
                countSelected += 1;
            }
        });
        if (countSelected == $scope.items.length) {
            $scope.checkedAll = 1;
        }
        $scope.countSelected = countSelected;
    }

    $scope.removeItems = function() {
        $.confirm({
            title: 'Xóa sản phẩm!',
            content: 'Bạn có chắc chắn xóa sản phẩm đã chọn',
            buttons: {
                confirm: function () {
                    deletedItems();
                },
                cancel: function () {
                    
                }
            }
        });
    }

    function deletedItems() {
        $scope.isSaving = true;
        let ids = [];
        $scope.items.forEach(function(item) {
            if (item.is_checked) {
                ids.push(item.id);
            }
        });
        let data = {
            'ids': ids
        };
        $http.post('/service/warehouse/product/delete', data)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.find(true);
                    $scope.isSaving = false;
                    toastr.success('Báo cáo spam thành công');
                } else {
                    toastr.error('Có lỗi xảy ra vui lòng thử lại');
                    $scope.isSaving = false;
                }
            });
    }

    $scope.init();
}