system.config(['dynamicNumberStrategyProvider', function(dynamicNumberStrategyProvider){
    dynamicNumberStrategyProvider.addStrategy('price', {
      numInt: 6,
      numFract: 2,
      numSep: '.',
      numPos: true,
      numNeg: true,
      numRound: 'round',
      numThousand: true
    });
  }]);
system.controller("WarehouseProductPrintController", WarehouseProductPrintController);
function WarehouseProductPrintController($scope, $http, $rootScope, $timeout, Upload) {
    $scope.baseController = this.__proto__ = new PaginationController($scope, $http, $rootScope, Upload);
    $scope.filters = {
        page_id: 0
    };
    $scope.isLoading = false;
    $scope.printings = printings;
    $scope.categories = categories;
    $scope.options = options;
    $scope.styles = styles;
    $scope.items = [];
    $scope.countSelected = 0;
    $scope.checkedAll = 0;
    
    $scope.init = function () {
        $scope.find(true);
    }

    $scope.clear = function () {
        $scope.filters = {
            page_id: 0
        }
        $scope.find(true);
    }

    $scope.find = function (refresh) {
        if (refresh) {
            $scope.filters.page_id = 0;
        }
        var filter = buildFilter();
        var params = getParams(filter);
        var url = '/service/warehouse/product-print/find';
        if (params.length > 0) {
            url += '?' + params.join('&');
        }
        $scope.isLoading = true;
        $http.get(url)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    var items = [];
                    if (response.data.result.length > 0) {
                        response.data.result.forEach(function(item) {
                            let itemStyles = [];
                            if (item.style) {
                                let styles = item.style.split(',');
                                for (let index = 0; index < styles.length; index++) {
                                    const element = styles[index];
                                    itemStyles.push($scope.styles[element]);
                                }
                            }
                            item.styles = itemStyles;
                            items.push(item);
                        });
                    }
                    $scope.items = items;
                    $scope.pagesCount = response.data.pagesCount;
                }
                $scope.isLoading = false;
            }, function (error) {
                $scope.isLoading = false;
            })
    }

    function buildFilter() {
        var retVal = {};
        if ($scope.filters.keyword) {
            retVal.keyword = $scope.filters.keyword;
        }
        retVal.page_id = $scope.filters.page_id;
        return retVal;
    }

    getParams = function(filter) {
        var params = [];
        for (var key in filter) {
            var filterValue = filter[key];
            var param = '';
            if (typeof filterValue == 'object' || typeof filterValue == 'array') {
                if (filterValue.length > 0) {
                    param = key + '=' + filterValue.join(',');
                }
            } else {
                param = key + '=' + filterValue;
            }
            if (param != '') {
                params.push(param);
            }
        }
        return params;
    }

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.find(false);
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.find(false);
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.find(false);
        }
    };


    $scope.save = function () {
        var data = buildData();
        var invalid = false;
        if (!data.category_id) {
            invalid = true;
            toastr.error('Vui lòng chọn danh mục');
        }
        if (!data.print_id) {
            invalid = true;
            toastr.error('Vui lòng chọn nhà in');
        }
        if (invalid) {
            return false;
        }
        var url = 'service/warehouse/product-print/create';
        
        $http.post(url, data)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.find();
                    $scope.showForm = false;
                    toastr.success('Bạn đã lưu sản phẩm thành công');
                    $('#modalForm').modal('toggle');
                } else {
                    toastr.error('Có lỗi xảy ra, vui lòng thử lại.');
                }
            }, function (error) {
                toastr.error('Đã có lỗi xảy ra');
            })
    }

    function buildData () {
        var retVal = angular.copy($scope.item);
        if (retVal.style.length > 0) {
            var style = [];
            retVal.style.forEach(function(item) {
                var newItem = item.id;
                style.push(newItem);
            });
            retVal.style = style;
        }
        return retVal;
    }

    
    $scope.openModal = function () {
        $scope.item = {
            style: []
        };
        $('#modalForm').modal('toggle');
    }

    $scope.deleteApplyItem = function(index) {
        $scope.item.style.splice(index,1);
    }

    $scope.removeItem = function(item) {
        $.confirm({
            title: 'Xóa sản phẩm!',
            content: 'Bạn có chắc chắn xóa cấu hình?',
            buttons: {
                confirm: function () {
                    deletedItem(item);
                },
                cancel: function () {
                    
                }
            }
        });
    }

    function deletedItem(item) {
        $scope.isSaving = true;
        let ids = [item.id];
        let data = {
            'ids': ids
        };
        $http.post('/service/warehouse/product-print/delete', data)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.find(true);
                    $scope.isSaving = false;
                    toastr.success('Xoá thành công');
                } else {
                    toastr.error('Có lỗi xảy ra vui lòng thử lại');
                    $scope.isSaving = false;
                }
            });
    }

    $scope.init();
}