system.filter("safeHtml", function($sce) {
    return function(val) {
        return $sce.trustAsHtml(val);
    };
});
system.config([
    "dynamicNumberStrategyProvider",
    function(dynamicNumberStrategyProvider) {
        dynamicNumberStrategyProvider.addStrategy("price", {
            numInt: 6,
            numFract: 2,
            numSep: ".",
            numPos: true,
            numNeg: true,
            numRound: "round",
            numThousand: true,
        });
    },
]);
system.config(['chosenProvider', function (chosenProvider) {
    chosenProvider.setOption({
        no_results_text: 'Not found!',
        placeholder_text_multiple: 'Select',
        placeholder_text: 'Select'
    });
}]);
system.requires.push('chosen-search');
system.controller("WarehouseProviderController", WarehouseProviderController);
function WarehouseProviderController($scope, $http, $rootScope, $timeout, Upload, $window) {
    $scope.baseController = this.__proto__ = new PaginationController($scope, $http, $rootScope, Upload);
    $scope.filters = {
        page_id: 0,
        type: "custom",
    };
    $scope.isLoading = false;
    $scope.countries = countries;
    $scope.printings = printings;
    $scope.categories = categories;
    $scope.warehouseProviders = [];
    $scope.options = options;
    $scope.sizes = [];
    $scope.colors = [];
    $scope.sizeOptionsById = {};
    $scope.colorOptionsById = {};
    $scope.statusses = {
        ACTIVE: "Active",
        INACTIVE: "Inactive",
    };
    $scope.variantStatusses = {
        INSTOCK: "Instock",
        OUTOFSTOCK: "Out of stock",
    };
    $scope.shippingTypes = {
        Standard: "Standard",
        Premium: "Premium",
        Express: "Express",
    };
    $scope.variantTypes = {
        Size: "Size",
        Color: "Color",
    };
    $scope.isDetail = isDetail;
    $scope.provider = {};
    $scope.providerLocation = {};
    $scope.init = async () => {
        if ($scope.isDetail == 1) {
            $scope.id = id;
            $scope.findById();
            $scope.providerLocation = {
                country_id: "-1",
            };
        } else {
            $scope.provider = {
                sizes: [],
                colors: [],
                products: [],
            };
        }
        $(document).ready(function() {
            setTimeout(function() {
                $('[data-toggle="popover"]').popover({
                    html: true,
                    trigger: "hover",
                });
            }, 100);
        });
        await $scope.findVariant();
        await $scope.getProviderInfos();
        if ($scope.isDetail == 1) {
            $scope.buildProviderProducts(angular.copy($scope.provider));
            $scope.tab = "products";
        } else {
            $scope.find(true);
        }
    };

    $scope.changeTab = (tab) => {
        $scope.tab = tab;
        if (tab == "location") {
            $scope.findLocation();
        }
    };

    $scope.findVariant = async () => {
        var url = "/service/warehouse/provider/find-variant?type=size";
        $scope.isLoading = true;
        await $http.get(url).then(
            function(response) {
                if (response.data.status == "successful") {
                    $scope.sizeOptions = response.data.result;
                }
                $scope.isLoading = false;
            },
            function(error) {
                $scope.isLoading = false;
            }
        );
        url = "/service/warehouse/provider/find-variant?type=color";
        $scope.isLoading = true;
        await $http.get(url).then(
            function(response) {
                if (response.data.status == "successful") {
                    $scope.colorOptions = response.data.result;
                }
                $scope.isLoading = false;
            },
            function(error) {
                $scope.isLoading = false;
            }
        );
        $scope.sizeOptionsById = {};
        $scope.colorOptionsById = {};
        for (let index = 0; index < $scope.sizeOptions.length; index++) {
            const element = $scope.sizeOptions[index];
            $scope.sizeOptionsById[element.id] = element.name;
        }
        for (let index = 0; index < $scope.colorOptions.length; index++) {
            const element = $scope.colorOptions[index];
            $scope.colorOptionsById[element.id] = element.name;
        }
    };
    $scope.getProviderInfos = async () => {
        var url = "/service/warehouse/provider/find-provider-info";
        $scope.isLoading = true;
        await $http.get(url).then(
            function(response) {
                if (response.data.status == "successful") {
                    $scope.providerInfos = response.data.result;
                }
                $scope.isLoading = false;
            },
            function(error) {
                $scope.isLoading = false;
            }
        );
    };
    $scope.clear = function() {
        $scope.filters = {
            page_id: 0,
        };
        $scope.find(true);
    };
    $scope.clearLocation = function() {
        $scope.filters = {
            page_id: 0,
        };
        $scope.findLocation(true);
    };

    $scope.find = function(refresh) {
        if (refresh) {
            $scope.filters.page_id = 0;
        }
        var filter = buildFilter();
        var params = getParams(filter);
        var url = "/service/warehouse/provider/find";
        if (params.length > 0) {
            url += "?" + params.join("&");
        }
        $scope.isLoading = true;
        $http.get(url).then(
            function(response) {
                if (response.data.status == "successful") {
                    $scope.warehouseProviders = response.data.result;
                    $scope.pagesCount = response.data.pagesCount;
                }
                $scope.isLoading = false;
            },
            function(error) {
                $scope.isLoading = false;
            }
        );
    };

    $scope.findById = function() {
        var url = "/service/warehouse/provider/find?id=" + $scope.id;
        $id = $scope.isLoading = true;
        $http
            .get(url)
            .then(function(response) {
                if (response.data.status == "successful") {
                    $scope.provider = response.data.result[0];
                    $scope.provider.category_id = $scope.provider.category_id + "";
                    $scope.provider.supplier_id = $scope.provider.supplier_id + "";
                    if ($scope.provider.warehouse_provider_variants.length > 0) {
                        $scope.provider.mappingVariant = [];
                        for (let index = 0; index < $scope.provider.warehouse_provider_variants.length; index++) {
                            const element = $scope.provider.warehouse_provider_variants[index];
                            $scope.provider.mappingVariant.push({
                                id: element.id,
                                option: {
                                    id: element.option_id,
                                    name: $scope.options[element.option_id],
                                },
                                option_id: element.option_id,
                                variant_ids: element.option_value_ids.split(","),
                                variants: element.variants,
                            });
                        }
                    } else {
                        $scope.provider.mappingVariant = [];
                    }
                }
                $scope.isLoading = false;
            })
            .catch(function(error) {
                toastr.error("Error. PLease try again!");
                $scope.isLoading = false;
            });
    };

    function buildFilter() {
        var retVal = {};
        retVal.page_id = $scope.filters.page_id;
        if ($scope.filters.keyword) {
            retVal.keyword = $scope.filters.keyword;
        }
        if ($scope.filters.status) {
            retVal.status = $scope.filters.status;
        }
        if ($scope.filters.supplier) {
            retVal.supplier = $scope.filters.supplier;
        }
        if ($scope.filters.country_id) {
            retVal.country_id = $scope.filters.country_id;
        }
        return retVal;
    }

    getParams = function(filter) {
        var params = [];
        for (var key in filter) {
            var filterValue = filter[key];
            var param = "";
            if (typeof filterValue == "object" || typeof filterValue == "array") {
                if (filterValue.length > 0) {
                    param = key + "=" + filterValue.join(",");
                }
            } else {
                param = key + "=" + filterValue;
            }
            if (param != "") {
                params.push(param);
            }
        }
        return params;
    };

    $scope.getById = function(items, id) {
        var retVal = null;
        items.forEach(function(item) {
            if (item.id == id) {
                retVal = item;
                return;
            }
        });
        return retVal;
    };

    $scope.next = function() {
        if ($scope.increasePageId()) {
            if ($scope.isDetail == 1) {
                $scope.findLocation(false);
            } else {
                $scope.find(false);
            }
        }
    };

    $scope.prev = function() {
        if ($scope.decreasePageId()) {
            if ($scope.isDetail == 1) {
                $scope.findLocation(false);
            } else {
                $scope.find(false);
            }
        }
    };

    $scope.changePage = function(page) {
        if ($scope.changePageId(page)) {
            if ($scope.isDetail == 1) {
                $scope.findLocation(false);
            } else {
                $scope.find(false);
            }
        }
    };

    $scope.openModalCreateProvider = () => {
        $scope.provider = {
            name: "",
            supplier: "",
            category_id: "",
            status: "INACTIVE",
        };
        $("#addProviderModal").toggle();
    };

    $scope.saveCreateProvider = function() {
        var data = buildData();
        if (typeof user != "undefined") {
            data.email = user.email;
        }
        var invalid = false;
        if (!data.name || data.name == "") {
            toastr.error("Please enter a name");
            invalid = true;
        }
        if (!data.supplier_id || data.supplier_id == "") {
            toastr.error("Please enter a supplier");
            invalid = true;
        }
        if (!data.category_id || data.category_id == "") {
            toastr.error("Please enter a category");
            invalid = true;
        }
        if (!data.provider_info_id || data.provider_info_id == "") {
            toastr.error("Please enter a provider info");
            invalid = true;
        }
        if (invalid) {
            return false;
        }
        $scope.isLoading = true;
        var url = "service/warehouse/provider/store";
        $http.post(url, data).then(
            function(response) {
                if (response.data.status == "successful") {
                    toastr.success("Data saved successfully!");
                    if (!$scope.provider.id) {
                        $("#addProviderModal").toggle();
                        $scope.find(true);
                    }
                } else {
                    if (response.data.message) {
                        toastr.error(response.data.message);
                    } else {
                        toastr.error("Error. PLease try again!");
                    }
                }
                $scope.isLoading = false;
            },
            function(error) {
                toastr.error("Error. PLease try again!");
                $scope.isLoading = false;
            }
        );
    };

    $scope.deleteProvider = (item) => {
        $.confirm({
            title: "Delete provider!",
            content: "Are you sure you want to delete this provider?",
            buttons: {
                confirm: function() {
                    var url = "service/warehouse/provider/delete";
                    var data = {
                        id: item.id,
                    };
                    if (typeof user != "undefined") {
                        data.email = user.email;
                    }
                    $scope.isLoading = true;
                    $http
                        .post(url, data)
                        .then(function(response) {
                            if (response.data.status == "successful") {
                                $scope.find(true);
                                toastr.success("Data deleted successfully!");
                            } else {
                                if (response.data.message) {
                                    toastr.error(response.data.message);
                                } else {
                                    toastr.error("Error. PLease try again!");
                                }
                            }
                            $scope.isLoading = false;
                        })
                        .catch(function(error) {
                            toastr.error("Error. PLease try again!");
                            $scope.isLoading = false;
                        });
                },
                cancel: function() {},
            },
        });
    };

    function buildData() {
        let provider = $scope.provider;
        return provider;
    }

    $scope.closeCreateProvider = () => {
        $("#addProviderModal").toggle();
    };

    $scope.addOption = (item) => {
        let data = $scope.buildProducts();
        $scope.provider.products = data;
    };

    $scope.buildProducts = () => {
        const combinations = {};
        // Generate combinations of sizes and colors with prices
        let sizes = $scope.provider.sizes;
        let colors = $scope.provider.colors;
        // Generate combinations of sizes and colors with prices
        if (sizes && colors && sizes.length && colors.length > 0) {
            sizes.forEach((size) => {
                colors.forEach((color) => {
                    const combinationName = generateStrId(size, color);
                    combinations[combinationName] = addCombination(combinationName, size, color);
                });
            });
        } else if (sizes.length > 0) {
            // Handle the case where colors are null
            sizes.forEach((size) => {
                const combinationName = generateStrId(size, null);
                combinations[combinationName] = addCombination(combinationName, size, null);
            });
        } else if (colors.length > 0) {
            // Handle the case where sizes are null
            colors.forEach((color) => {
                const combinationName = generateStrId(null, color);
                combinations[combinationName] = addCombination(combinationName, null, color);
            });
        }
        return combinations;
    };

    function addCombination(combinationName, size, color) {
        let data = {};
        let lastCombine = $scope.provider.products[combinationName] ? $scope.provider.products[combinationName] : {};
        const combinationPrice = lastCombine.cost ? lastCombine.cost : 0;
        const combinationStock = lastCombine.instock || lastCombine.instock == 0 ? lastCombine.instock : 1;
        const combinationId = lastCombine.id ? lastCombine.id : null;
        data = {
            cost: combinationPrice,
            instock: combinationStock,
            size_id: size,
            color_id: color,
            str_id: combinationName,
        };
        if (combinationId) {
            data.id = combinationId;
        }
        return data;
    }

    function generateStrId(size, color) {
        var retVal = "";
        var ids = [];
        if (size) {
            ids.push(size);
        }
        if (color) {
            ids.push(color);
        }
        ids.sort(function(a, b) {
            return a - b;
        });
        if (ids.length > 0) {
            retVal = ids.join("-");
        }
        return retVal;
    }

    $scope.openModalCreateProduct = (item) => {
        $scope.provider = angular.copy(item);
        $scope.buildProviderProducts(item);
        $("#addProductModal").toggle();
    };

    $scope.buildProviderProducts = (item) => {
        $scope.provider.sizes = [];
        $scope.provider.colors = [];
        $scope.provider.products = {};
        $scope.provider.mappingVariant = [];
        if (item.size_value_ids) {
            $scope.provider.sizes = item.size_value_ids.split(",");
            for (let index = 0; index < $scope.provider.sizes.length; index++) {
                let element = $scope.provider.sizes[index];
                $scope.provider.sizes[index] = parseInt(element);
            }
        }
        if (item.color_value_ids) {
            $scope.provider.colors = item.color_value_ids.split(",");
            for (let index = 0; index < $scope.provider.colors.length; index++) {
                let element = $scope.provider.colors[index];
                $scope.provider.colors[index] = parseInt(element);
            }
        }
        if (item.mappingVariant) {
            $scope.provider.mappingVariant = item.mappingVariant;
        }
        $scope.provider.products = $scope.buildProducts();
        let listByStrIds = {};
        item.warehouse_provider_variant_configs.forEach((element) => {
            listByStrIds[element.str_id] = element;
        });
        for (const key in $scope.provider.products) {
            if (Object.hasOwnProperty.call($scope.provider.products, key)) {
                const element = $scope.provider.products[key];
                if (listByStrIds[key]) {
                    element.id = listByStrIds[key].id;
                    element.cost = listByStrIds[key].cost;
                    element.instock = listByStrIds[key].instock;
                }
            }
        }
    };

    $scope.closeCreateProducts = () => {
        $("#addProductModal").toggle();
    };

    $scope.saveProducts = () => {
        $scope.isLoading = true;
        var url = "service/warehouse/provider/store-products";
        let mappingVariant = [];
        for (let index = 0; index < $scope.provider.mappingVariant.length; index++) {
            const element = $scope.provider.mappingVariant[index];
            let dataVariant = {
                option_id: element.option_id,
                variant_ids: element.variant_ids,
            };
            if (element.id) {
                dataVariant.id = element.id;
            }
            mappingVariant.push(dataVariant);
        }
        var data = {
            products: $scope.provider.products,
            colors: $scope.provider.colors,
            sizes: $scope.provider.sizes,
            id: $scope.provider.id,
            mappingVariant: mappingVariant,
        };
        if (typeof user != "undefined") {
            data.email = user.email;
        }
        $http
            .post(url, data)
            .then(function(response) {
                if (response.data.status == "successful") {
                    if (!$scope.id) {
                        $scope.find();
                        $("#addProductModal").toggle();
                    }
                    toastr.success("Data saved successfully!");
                } else {
                    if (response.data.message) {
                        toastr.error(response.data.message);
                    } else {
                        toastr.error("Error. PLease try again!");
                    }
                }
                $scope.isLoading = false;
            })
            .catch(function(error) {
                toastr.error("Error. PLease try again!");
                $scope.isLoading = false;
            });
    };

    $scope.createVariantSizeOption = (term) => {
        $.confirm({
            title: "Create provider variant!",
            content: "Are you sure you want to create " + term + "?",
            buttons: {
                confirm: function() {
                    $scope.isLoading = true;
                    let url = "service/warehouse/provider/create-variant";
                    $http
                        .post(url, {
                            name: term,
                            type: 'size',
                        })
                        .then(function(response) {
                            if (response.data.status == "successful") {
                                $scope.findVariant();
                                toastr.success("Data saved successfully!");
                            } else {
                                toastr.error("Error. PLease try again!");
                            }
                            $scope.isLoading = false;
                        })
                        .catch(function(error) {
                            toastr.error("Error. PLease try again!");
                            $scope.isLoading = false;
                        });
                },
                cancel: function() {},
            },
        });
    };
    $scope.createVariantColorOption = (term) => {
        $.confirm({
            title: "Create provider variant!",
            content: "Are you sure you want to create " + term + "?",
            buttons: {
                confirm: function() {
                    $scope.isLoading = true;
                    let url = "service/warehouse/provider/create-variant";
                    $http
                        .post(url, {
                            name: term,
                            type: 'color',
                        })
                        .then(function(response) {
                            if (response.data.status == "successful") {
                                $scope.findVariant();
                                toastr.success("Data saved successfully!");
                            } else {
                                toastr.error("Error. PLease try again!");
                            }
                            $scope.isLoading = false;
                        })
                        .catch(function(error) {
                            toastr.error("Error. PLease try again!");
                            $scope.isLoading = false;
                        });
                },
                cancel: function() {},
            },
        });
    };

    $scope.openModalCreateLocation = (item, location = null) => {
        $scope.provider = angular.copy(item);
        if (location && location.id) {
            $scope.providerLocation = angular.copy(location);
            $scope.providerLocation.country_id = $scope.providerLocation.country_id + "";
        } else {
            $scope.providerLocation = {
                name: "",
                country_id: "-1",
                status: "ACTIVE",
                shipping_type: "Standard",
                production_min_time: 0,
                production_max_time: 0,
                shipping_min_time: 0,
                shipping_max_time: 0,
                shipping_fee: 0,
                adding_fee: 0,
            };
        }
        $("#addLocationModal").toggle();
    };

    $scope.closeCreateLocation = () => {
        $("#addLocationModal").toggle();
    };

    $scope.saveCreateProviderLocation = () => {
        if (!$scope.providerLocation.name) {
            toastr.error("Please enter a name!");
            return;
        }
        if (!$scope.providerLocation.country_id) {
            toastr.error("Please select country!");
            return;
        }
        $scope.isLoading = true;
        let url = "service/warehouse/provider/store-location";
        let data = angular.copy($scope.providerLocation);
        data.warehouse_provider_id = $scope.provider.id;
        $http
            .post(url, data)
            .then(function(response) {
                if (response.data.status == "successful") {
                    if ($scope.isDetail == 1) {
                        $scope.findLocation();
                    } else {
                        $scope.find();
                    }
                    toastr.success("Data saved successfully!");
                    $("#addLocationModal").toggle();
                } else {
                    if (response.data.message) {
                        toastr.error(response.data.message);
                    } else {
                        toastr.error("Error. PLease try again!");
                    }
                }
                $scope.isLoading = false;
            })
            .catch(function(error) {
                toastr.error("Error. PLease try again!");
                $scope.isLoading = false;
            });
    };

    $scope.findLocation = (refresh = false) => {
        if (refresh) {
            $scope.filters.page_id = 0;
        }
        var url = "/service/warehouse/provider/find-location";
        var filter = buildFilter();
        if ($scope.provider.id) {
            filter.warehouse_provider_id = $scope.provider.id;
        }
        var params = getParams(filter);
        if (params.length > 0) {
            url += "?" + params.join("&");
        }
        $scope.isLoading = true;
        $http
            .get(url)
            .then(function(response) {
                if (response.data.status == "successful") {
                    $scope.warehouseProviderLocations = response.data.result;
                    $scope.pagesCount = response.data.pagesCount;
                }
                $scope.isLoading = false;
            })
            .catch(function(error) {
                toastr.error("Error. PLease try again!");
                $scope.isLoading = false;
            });
    };

    $scope.deleteProviderLocation = (item) => {
        $.confirm({
            title: "Delete location!",
            content: "Are you sure you want to delete this location?",
            buttons: {
                confirm: function() {
                    var url = "service/warehouse/provider/delete-location";
                    var data = {
                        id: item.id,
                    };
                    if (typeof user != "undefined") {
                        data.email = user.email;
                    }
                    $scope.isLoading = true;
                    $http
                        .post(url, data)
                        .then(function(response) {
                            if (response.data.status == "successful") {
                                toastr.success("Data deleted successfully!");
                            } else {
                                if (response.data.message) {
                                    toastr.error(response.data.message);
                                } else {
                                    toastr.error("Error. PLease try again!");
                                }
                            }
                            $scope.isLoading = false;
                            $scope.findLocation(true);
                        })
                        .catch(function(error) {
                            toastr.error("Error. PLease try again!");
                            $scope.isLoading = false;
                        });
                },
                cancel: function() {},
            },
        });
    };

    $scope.editProvider = (item) => {
        window.location.href = "/warehouse/provider/detail/" + item.id;
    };

    $scope.chooseOption = function(option, index) {
        if (option.option != null) {
            option.option_id = option.option.id;
            var check = false;
            var i = 0;
            $scope.options.forEach(function(item) {
                if (item.option_id == option.option_id && index != i) {
                    check = true;
                    return;
                }
                i++;
            });
            if (!check) {
                var url = "/service/warehouse/product/get-option-value";
                var data = {
                    option_id: option.option_id,
                    category_id: $scope.provider.category_id,
                };
                $http.post(url, data).then(function(response) {
                    if (response.data.status == "successful") {
                        option.variants = response.data.result.apply_options;
                    } else {
                        delete option.option;
                        if (typeof option.option_id != "undefined") {
                            delete option.option_id;
                        }
                        $.alert({
                            title: "Warning!",
                            content: "This category does not have products for the variant you have selected. Please choose another attribute.",
                        });
                    }
                });
            } else {
                delete option.option;
                if (typeof option.option_id != "undefined") {
                    delete option.option_id;
                }
                $.alert({
                    title: "Warning!",
                    content: "The attribute has been applied, please select another attribute.",
                });
            }
        }
    };

    $scope.addMappingOption = () => {
        if ($scope.provider.mappingVariant.length == 2) {
            toastr.error("Up to 2 variants only.");
            return;
        }
        $scope.provider.mappingVariant.push({
            option: "",
            variant_ids: "",
        });
    };

    $scope.deleteMappingVariant = (option, index) => {
        $scope.provider.mappingVariant.splice(index, 1);
    };

    $scope.goBack = () => {
        window.location.href = "/warehouse/provider";
    };

    $scope.openModalCreateLocationProducts = (provider, location = null) => {
        $scope.providerLocation = angular.copy(location);
        if ($scope.providerLocation.products.length == 0) {
            $scope.providerLocation.products = angular.copy(provider.products);
            for (const key in $scope.providerLocation.products) {
                if (Object.hasOwnProperty.call($scope.providerLocation.products, key)) {
                    const element = $scope.providerLocation.products[key];
                    element.production_min_time = location.production_min_time;
                    element.production_max_time = location.production_max_time;
                    element.shipping_min_time = location.shipping_min_time;
                    element.shipping_max_time = location.shipping_max_time;
                    element.shipping_fee = location.shipping_fee;
                    element.adding_fee = location.adding_fee;
                    element.warehouse_provider_location_id = $scope.providerLocation.id;
                    delete element.id;
                }
            }
        } else {
            let productByStr = {};
            for (let index = 0; index < $scope.providerLocation.products.length; index++) {
                const element = $scope.providerLocation.products[index];
                productByStr[element.str_id] = element
            }
            for (const key in provider.products) {
                if (Object.hasOwnProperty.call(provider.products, key)) {
                    const element = provider.products[key];
                    element.production_min_time = location.production_min_time;
                    element.production_max_time = location.production_max_time;
                    element.shipping_min_time = location.shipping_min_time;
                    element.shipping_max_time = location.shipping_max_time;
                    element.shipping_fee = location.shipping_fee;
                    element.adding_fee = location.adding_fee;
                    element.warehouse_provider_location_id = $scope.providerLocation.id;
                    delete element.id;
                    if (productByStr[element.str_id]) {
                        let product = productByStr[element.str_id];
                        let variantsIds = product.str_id.split("-");
                        if ($scope.provider.colors.includes(parseInt(variantsIds[0]))) {
                            product.color_id = parseInt(variantsIds[0]);
                            if (variantsIds[1]) {
                                product.size_id = parseInt(variantsIds[1]);
                            }
                        } else {
                            product.size_id = parseInt(variantsIds[0]);
                            if (variantsIds[1]) {
                                product.color_id = parseInt(variantsIds[1]);
                            }
                        }
                        provider.products[key] = product;
                    }
                }
            }
            $scope.providerLocation.products = angular.copy(provider.products)
        }
        $("#addLocationProductModal").toggle();
    };

    $scope.closeCreateLocationProducts = () => {
        $("#addLocationProductModal").toggle();
    };

    $scope.saveLocationProducts = () => {
        $scope.isLoading = true;
        let url = "service/warehouse/provider/store-location-products";
        let data = angular.copy($scope.providerLocation);
        data.warehouse_provider_location_id = data.id;
        $http
            .post(url, data)
            .then(function(response) {
                if (response.data.status == "successful") {
                    if ($scope.isDetail == 1) {
                        $scope.findLocation();
                    } else {
                        $scope.find();
                    }
                    toastr.success("Data saved successfully!");
                    $("#addLocationProductModal").toggle();
                } else {
                    if (response.data.message) {
                        toastr.error(response.data.message);
                    } else {
                        toastr.error("Error. PLease try again!");
                    }
                }
                $scope.isLoading = false;
            })
            .catch(function(error) {
                toastr.error("Error. PLease try again!");
                $scope.isLoading = false;
            });
    };

    $scope.removeBlur = function($event) {
        $($event.currentTarget).val() == 0 ? $($event.currentTarget).val("") : "";
    };
    $scope.handleBlur = function($event) {
        $($event.currentTarget).val() == "" ? $($event.currentTarget).val(0) : 0;
    };

    $scope.createProviderInfo = (term) => {
        $.confirm({
            title: "Create provider info!",
            content: "Are you sure you want to create " + term + "?",
            buttons: {
                confirm: function() {
                    var url = "service/warehouse/provider/store-provider-info";
                    $scope.isLoading = true;
                    $http
                        .post(url, {
                            name: term,
                        })
                        .then(function(response) {
                            if (response.data.status == "successful") {
                                $scope.getProviderInfos();
                                toastr.success("Data saved successfully!");
                            } else {
                                toastr.error("Error. PLease try again!");
                            }
                            $scope.isLoading = false;
                        })
                        .catch(function(error) {
                            console.log(error);
                            toastr.error("Error. PLease try again!");
                            $scope.isLoading = false;
                        });
                },
                cancel: function() {},
            },
        });
    };

    $scope.openModalCloneLocation = (provider) => {
        $scope.cloneProviderId = "";
        $("#cloneLocationModal").toggle();
    };
    $scope.closeModalCloneLocation = () => {
        $("#cloneLocationModal").toggle();
    };

    $scope.saveCloneLocation = (term) => {
        var url = "service/warehouse/provider/clone-location?provider_id=" + $scope.cloneProviderId + "&target_provider_id=" + $scope.provider.id;
        $scope.isLoading = true;
        $http
            .get(url)
            .then(function(response) {
                if (response.data.status == "successful") {
                    $scope.findLocation(true);
                    toastr.success("Clone location successfully!");
                } else {
                    toastr.error("Error. PLease try again!");
                }
                $("#cloneLocationModal").toggle();
                $scope.isLoading = false;
            })
            .catch(function(error) {
                console.log(error);
                toastr.error("Error. PLease try again!");
                $scope.isLoading = false;
            });
    };

    $scope.init();
}
