system.filter("safeHtml", function($sce) {
    return function(val) {
        return $sce.trustAsHtml(val);
    };
});
system.config([
    "dynamicNumberStrategyProvider",
    function(dynamicNumberStrategyProvider) {
        dynamicNumberStrategyProvider.addStrategy("price", {
            numInt: 6,
            numFract: 2,
            numSep: ".",
            numPos: true,
            numNeg: true,
            numRound: "round",
            numThousand: true,
        });
    },
]);
system.config([
    "chosenProvider",
    function(chosenProvider) {
        chosenProvider.setOption({
            no_results_text: "Not found!",
            placeholder_text_multiple: "Select",
            placeholder_text: "Select",
        });
    },
]);
system.requires.push('chosen-search');
system.controller("WarehouseProviderMappingVariantController", WarehouseProviderMappingVariantController);
function WarehouseProviderMappingVariantController($scope, $http, $rootScope, $timeout, Upload, $window) {
    $scope.baseController = this.__proto__ = new PaginationController($scope, $http, $rootScope, Upload);
    $scope.filters = {
        page_id: 0,
        type: "custom",
    };
    $scope.isLoading = false;
    $scope.options = options;
    $scope.providerVariant = providerVariant;
    for (let index = 0; index < $scope.providerVariant.length; index++) {
        const element = $scope.providerVariant[index];
        element.id = element.id + ""
    }
    $scope.init = async () => {
        $(document).ready(function() {
            setTimeout(function() {
                $('[data-toggle="popover"]').popover({
                    html: true,
                    trigger: "hover",
                });
            }, 100);
        });
        $scope.find(true);
    };
    $scope.clear = function() {
        $scope.filters = {
            page_id: 0,
        };
        $scope.find(true);
    };

    $scope.find = function(refresh) {
        if (refresh) {
            $scope.filters.page_id = 0;
        }
        var filter = buildFilter();
        var params = getParams(filter);
        var url = "/service/warehouse/provider/find-mapping-variant";
        if (params.length > 0) {
            url += "?" + params.join("&");
        }
        $scope.isLoading = true;
        $http.get(url).then(
            function(response) {
                if (response.data.status == "successful") {
                    $scope.warehouseProvidersMappingVariant = response.data.result;
                    $scope.pagesCount = response.data.pagesCount;
                }
                $scope.isLoading = false;
            },
            function(error) {
                $scope.isLoading = false;
            }
        );
    };

    function buildFilter() {
        var retVal = {};
        retVal.page_id = $scope.filters.page_id;
        if ($scope.filters.default_option_id) {
            retVal.default_option_id = $scope.filters.default_option_id;
        }
        if ($scope.filters.default_option_value) {
            retVal.default_option_value = $scope.filters.default_option_value;
        }
        if ($scope.filters.provider_option_value) {
            retVal.provider_option_value = $scope.filters.provider_option_value;
        }
        return retVal;
    }

    getParams = function(filter) {
        var params = [];
        for (var key in filter) {
            var filterValue = filter[key];
            var param = "";
            if (typeof filterValue == "object" || typeof filterValue == "array") {
                if (filterValue.length > 0) {
                    param = key + "=" + filterValue.join(",");
                }
            } else {
                param = key + "=" + filterValue;
            }
            if (param != "") {
                params.push(param);
            }
        }
        return params;
    };

    $scope.getById = function(items, id) {
        var retVal = null;
        items.forEach(function(item) {
            if (item.id == id) {
                retVal = item;
                return;
            }
        });
        return retVal;
    };

    $scope.next = function() {
        if ($scope.increasePageId()) {
            if ($scope.isDetail == 1) {
                $scope.findLocation(false);
            } else {
                $scope.find(false);
            }
        }
    };

    $scope.prev = function() {
        if ($scope.decreasePageId()) {
            if ($scope.isDetail == 1) {
                $scope.findLocation(false);
            } else {
                $scope.find(false);
            }
        }
    };

    $scope.changePage = function(page) {
        if ($scope.changePageId(page)) {
            if ($scope.isDetail == 1) {
                $scope.findLocation(false);
            } else {
                $scope.find(false);
            }
        }
    };

    $scope.openModalCreateProviderMappingVariant = () => {
        $scope.providerMapping = {
            option: {},
            default_option_id: "",
            default_option_value: "",
            provider_option_value: "",
            warehouse_provider_id: "",
        };
        $("#addProviderMappingVariantModal").toggle();
    };
    $scope.closeCreateProviderMappingVariant = () => {
        $("#addProviderMappingVariantModal").toggle();
    };

    $scope.saveCreateProviderMappingVariant = function() {
        var data = buildData();
        if (typeof user != "undefined") {
            data.email = user.email;
        }
        var invalid = false;
        if (!data.default_option_id || data.default_option_id == "") {
            toastr.error("Please enter a default option");
            invalid = true;
        }
        if (!data.default_option_value || data.default_option_value == "") {
            toastr.error("Please enter a default variant value");
            invalid = true;
        }
        if (!data.provider_option_value || data.provider_option_value == "") {
            toastr.error("Please enter a provider variant value");
            invalid = true;
        }
        if (!data.warehouse_provider_id || data.warehouse_provider_id == "") {
            toastr.error("Please enter a product");
            invalid = true;
        }
        if (invalid) {
            return false;
        }
        $scope.isLoading = true;
        var url = "service/warehouse/provider/store-mapping-variant";
        $http.post(url, data).then(
            function(response) {
                if (response.data.status == "successful") {
                    toastr.success("Data saved successfully!");
                    $("#addProviderMappingVariantModal").toggle();
                    $scope.find(true);
                } else {
                    if (response.data.message) {
                        toastr.error(response.data.message);
                    } else {
                        toastr.error("Error. PLease try again!");
                    }
                }
                $scope.isLoading = false;
            },
            function(error) {
                toastr.error("Error. PLease try again!");
                $scope.isLoading = false;
            }
        );
    };

    $scope.deleteProviderMappingVariant = (item) => {
        $.confirm({
            title: "Delete mapping variant!",
            content: "Are you sure you want to delete?",
            buttons: {
                confirm: function() {
                    var url = "service/warehouse/provider/delete-mapping-variant";
                    var data = {
                        id: item.id,
                    };
                    if (typeof user != "undefined") {
                        data.email = user.email;
                    }
                    $scope.isLoading = true;
                    $http
                        .post(url, data)
                        .then(function(response) {
                            if (response.data.status == "successful") {
                                toastr.success("Data deleted successfully!");
                            } else {
                                if (response.data.message) {
                                    toastr.error(response.data.message);
                                } else {
                                    toastr.error("Error. PLease try again!");
                                }
                            }
                            $scope.find(true);
                            $scope.isLoading = false;
                        })
                        .catch(function(error) {
                            toastr.error("Error. PLease try again!");
                            $scope.isLoading = false;
                        });
                },
                cancel: function() {},
            },
        });
    };

    function buildData() {
        let provider = $scope.providerMapping;
        if (provider.option && provider.option.id) {
            provider.default_option_id = provider.option.id;
        }
        return provider;
    }

    $scope.chooseOption = function(option, index, type = 'default') {
        if (option.option != null) {
            option.option_id = option.option.id;
            var check = false;
            var i = 0;
            $scope.options.forEach(function(item) {
                if (item.option_id == option.option_id && index != i) {
                    check = true;
                    return;
                }
                i++;
            });
            if (!check) {
                var url = "/service/warehouse/product/get-option-value";
                var data = {
                    option_id: option.option_id,
                };
                $http.post(url, data).then(function(response) {
                    if (response.data.status == "successful") {
                        if (type == 'default') {
                            option.variants = response.data.result.apply_options;
                        } else if (type == 'filter') {
                            $scope.filters.option.variants = response.data.result.apply_options;
                        } else {
                            $scope.providerMapping.option.variants = response.data.result.apply_options;
                        }
                    } else {
                        delete option.option;
                        if (typeof option.option_id != "undefined") {
                            delete option.option_id;
                        }
                        $.alert({
                            title: "Warning!",
                            content: "This category does not have products for the variant you have selected. Please choose another attribute.",
                        });
                    }
                });
            } else {
                delete option.option;
                if (typeof option.option_id != "undefined") {
                    delete option.option_id;
                }
                $.alert({
                    title: "Warning!",
                    content: "The attribute has been applied, please select another attribute.",
                });
            }
        }
    };

    $scope.searchProviders = () => {
        var url = "/service/warehouse/provider/find?keyword=" + $scope.filterProvider;
        $scope.isLoading = true;
        $http.get(url).then(
            function(response) {
                if (response.data.status == "successful") {
                    $scope.providers = response.data.result;
                } else {
                    if (response.data.message) {
                        toastr.error(response.data.message);
                    } else {
                        toastr.error("Error. PLease try again!");
                    }
                }
                $scope.isLoading = false;
            },
            function(error) {
                $scope.isLoading = false;
            }
        );
    }

    $scope.$watch('providerMapping.warehouse_provider_id', function() {
        $scope.$applyAsync(function() {
            $scope.searchProviderVariants()
        });
    });
    $scope.searchProviderVariants = () => {
        if (!$scope.providerMapping || !$scope.providerMapping.warehouse_provider_id) {
            return;
        }
        var url = "/service/warehouse/provider/find-provider-variant?provider_id=" + $scope.providerMapping.warehouse_provider_id;
        $scope.isLoading = true;
        $http.get(url).then(
            function(response) {
                if (response.data.status == "successful") {
                    $scope.providerVariant = response.data.result;
                } else {
                    if (response.data.message) {
                        toastr.error(response.data.message);
                    } else {
                        toastr.error("Error. PLease try again!");
                    }
                }
                $scope.isLoading = false;
            },
            function(error) {
                $scope.isLoading = false;
            }
        );
    }

    $scope.init();
}
