system.config(['dynamicNumberStrategyProvider', function(dynamicNumberStrategyProvider){
    dynamicNumberStrategyProvider.addStrategy('price', {
      numInt: 6,
      numFract: 2,
      numSep: '.',
      numPos: true,
      numNeg: true,
      numRound: 'round',
      numThousand: true
    });
  }]);
system.controller("WarehouseCurrencyRatioController", WarehouseCurrencyRatioController);
function WarehouseCurrencyRatioController($scope, $http, $rootScope, $timeout, Upload) {
    $scope.baseController = this.__proto__ = new PaginationController($scope, $http, $rootScope, Upload);
    $scope.filters = {
        page_id: 0
    };
    $scope.isLoading = false;
    $scope.items = [];
    $scope.currencies = {
        "USD": "USD",
        "EUR": "EUR",
        "GBP": "GBP",
        "CAD": "CAD",
        "AUD": "AUD",
        "JPY": "JPY",
        "VND": "VND",
        "KRW": "KRW"
    };
    $scope.init = function () {
        $scope.find(true);
    }
    $scope.clear = function () {
        $scope.filters = {
            page_id: 0
        }
        $scope.find(true);
    }

    $scope.keypressFilter = function (event) {
        if (event.keyCode === 13) {
            $scope.find(true);
        }
    };

    $scope.find = function (refresh) {
        if (refresh) {
            $scope.filters.page_id = 0;
        }
        var filter = buildFilter();
        var params = getParams(filter);
        var url = '/service/warehouse/ratio/find';
        if (params.length > 0) {
            url += '?' + params.join('&');
        }
        $scope.isLoading = true;
        $http.get(url)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    var items = [];
                    if (response.data.result.length > 0) {
                        response.data.result.forEach(function(item) {
                            items.push(item);
                        });
                    }
                    $scope.items = items;
                    $scope.pagesCount = response.data.pagesCount;
                }
                $scope.isLoading = false;
            }, function (error) {
                $scope.isLoading = false;
            })
    }

    function buildFilter() {
        var retVal = {};
        if ($scope.filters.keyword) {
            retVal.keyword = $scope.filters.keyword;
        }
        retVal.page_id = $scope.filters.page_id;
        return retVal;
    }

    getParams = function(filter) {
        var params = [];
        for (var key in filter) {
            var filterValue = filter[key];
            var param = '';
            if (typeof filterValue == 'object' || typeof filterValue == 'array') {
                if (filterValue.length > 0) {
                    param = key + '=' + filterValue.join(',');
                }
            } else {
                param = key + '=' + filterValue;
            }
            if (param != '') {
                params.push(param);
            }
        }
        return params;
    }

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.find(false);
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.find(false);
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.find(false);
        }
    };


    $scope.saveWarehouseCurrencyRatio = function () {
        var data = buildData();
        if (!data.from_currency) {
            toastr.error('Please select currency from.');
            return;
        }
        if (!data.to_currency) {
            toastr.error('Please select currency to.');
            return;
        }
        if (!data.ratio) {
            toastr.error('Please enter ratio.');
            return;
        }
        var url = 'service/warehouse/ratio/store';
        
        $http.post(url, data)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.find();
                    $scope.showForm = false;
                    toastr.success('Save warehouseCurrencyRatio successfully');
                    $('#addWarehouseCurrencyRatioModal').modal('toggle');
                } else {
                    if (response.data.message) {
                        toastr.error(response.data.message);
                    } else {
                        toastr.error('Error. PLease try again!');
                    }
                }
            }, function (error) {
                toastr.error('Error. PLease try again!');
            })
    }

    function buildData () {
        var retVal = angular.copy($scope.warehouseCurrencyRatio);
        return retVal;
    }

    
    $scope.editWarehouseCurrencyRatio = function (item) {
        $scope.warehouseCurrencyRatio = angular.copy(item);
        $('#addWarehouseCurrencyRatioModal').modal('toggle');
    }
    $scope.openModalCreateWarehouseCurrencyRatio = function () {
        $scope.warehouseCurrencyRatio = {};
        $('#addWarehouseCurrencyRatioModal').modal('toggle');
    }
    $scope.closeCreateWarehouseCurrencyRatio = function () {
        $('#addWarehouseCurrencyRatioModal').modal('toggle');
    }

    $scope.deleteWarehouseCurrencyRatio = (item) => {
        $.confirm({
            title: "Delete warehouseCurrencyRatio!",
            content: "Are you sure you want to delete this warehouseCurrencyRatio?",
            buttons: {
                confirm: function() {
                    var url = "service/warehouse/ratio/delete";
                    var data = {
                        id: item.id,
                    };
                    if (typeof user != "undefined") {
                        data.email = user.email;
                    }
                    $scope.isLoading = true;
                    $http
                        .post(url, data)
                        .then(function(response) {
                            if (response.data.status == "successful") {
                                $scope.find(true);
                                toastr.success("Data deleted successfully!");
                            } else {
                                if (response.data.message) {
                                    toastr.error(response.data.message);
                                } else {
                                    toastr.error("Error. PLease try again!");
                                }
                            }
                            $scope.isLoading = false;
                        })
                        .catch(function(error) {
                            toastr.error("Error. PLease try again!");
                            $scope.isLoading = false;
                        });
                },
                cancel: function() {},
            },
        });
    };

    $scope.init();
}