<div class="modal fade" id="modalWarehouseConfigItemVariant">
    <div class="modal-dialog" style="width: 1200px;">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
                <h4 class="modal-title">
                    Cấu hình phí ship cho biến thể
                </h4>
            </div>
            <div class="modal-body">
                <table class="table table-hover">
                    <tbody>
                        <tr>
                            <th style="width: 230px;">Thuộc tính</th>
                            <th>Biến thể áp dụng</th>
                            <th style="width: 5%; text-align:center">
                                <button type="button" class="btn btn-sm btn-primary" ng-click="addOption(warehouseConfigItemData)" title="Thêm biến thể" data-placement="bottom" tooltip>
                                    <i class="fa fa-fw fa-plus"></i>
                                </button>
                            </th>
                        </tr>
                        <tr ng-repeat="option in warehouseConfigItemData.options">
                            <td>
                                <select class="form-control" chosen style="width: 100%;" ng-model="option.option" ng-options="item.name for item in options track by item.id" ng-change="chooseOptionConfigItem(option, warehouseConfigItemData, $index)" aria-hidden="true">
                                </select>
                            </td>
                            <td>
                                <select class="form-control" chosen multiple style="width: 100%;" ng-model="option.variant_ids" ng-options="k as value for (k, value) in option.variants" ng-change="chooseVariantShipping(warehouseConfigItemData)" aria-hidden="true">
                                </select>
                            </td>
                            <td align="center">
                                <button type="button" class="btn btn-sm btn-danger" ng-click="removeOption($index, warehouseConfigItemData)" title="Xóa biến thể" data-placement="bottom" tooltip>
                                    <i class="fa fa-fw fa-remove"></i>
                                </button>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <div ng-show="warehouseConfigItemData.combination_variants.length > 0 && warehouseConfigItemData.combination_variants[0].length > 0">
                    <h5>Chọn biến thể lọc để thao tác</h5>
                    <div style="display: inline-block; width: 100%">
                        <div class="text-left" ng-repeat="variant in warehouseConfigItemData.combination_variants" style="width: calc((100% - 110px) / 3)">
                            <div class="variant-selector bgGreen @{{ item.bulk_selected ? 'selected' : '' }}" ng-repeat="item in variant" ng-click="selectVariantValue(item, warehouseConfigItemData)">@{{ item.name }}</div>
                        </div>
                    </div>
                </div>
                <div class="slimScrollDiv" style="position: relative; overflow: auto; width: auto; max-height: 450px;" ng-show="warehouseConfigItemData.products.length > 0">
                    <h5>Danh sách sản phẩm <button style="float: right" type="button" ng-if="warehouseConfigItemData.numSelected" ng-click="openFormVariantItemBulk()">Sửa @{{ warehouseConfigItemData.numSelected }} biến thể đã chọn</button></h5>
                    <table class="table table-bordered" style="width: 100%;">
                        <tr>
                            <td style="width: 50px" align="center">
                                <input type="checkbox" ng-model="warehouseConfigItemData.selected" ng-change="togglePropVariantItem()" />
                            </td>
                            <th>Biến thể</th>
                            <th style="width: 65px" align="center">
                                Bulk <span style="cursor: pointer" data-placement="bottom" tooltip title="Đơn đặt từ 30 sản phẩm"><i class="fa fa-question-circle"></i></span>
                            </th>
                            <th style="width: 120px">Phí ship gốc</th>
                            <th style="width: 150px">Phí cộng thêm gốc</th>
                            <th style="width: 130px">Phí ship mặc định</th>
                            <th style="width: 80px">Thuế</th>
                            <th style="width: 110px">Phí cộng thêm</th>
                            <th style="width: 120px">Tỷ giá</th>
                        </tr>
                        <tr ng-repeat="product in warehouseConfigItemData.products">
                            <td align="center">
                                <input type="checkbox" ng-model="product.selected" ng-change="checkVariantItemBulk()" />
                            <td>
                                <div class="variant-selector bgGreen" ng-repeat="item in product.variants">@{{ item.name }}</div>
                            </td>
                            <td align="center">
                                <input type="checkbox" ng-true-value="1" ng-false-value="0" ng-model="product.is_bulk" />
                                <p class="no-margin" ng-if="product.is_bulk">|</p>
                                <p class="no-margin" ng-if="product.is_bulk">|</p>
                                <p class="no-margin" ng-if="product.is_bulk">&nbsp;&nbsp;&nbsp;&nbsp;|__</p>
                            </td>
                            <td align="right">
                                <div class="form-group no-padding">
                                    <input type="text" class="form-control input input-sm" awnum="price" ng-model="product.origin_shipping_fee" ng-change="changeOriginShippingCost('shipping', product, currentConfigItem)" />
                                </div>
                                <div class="form-group no-padding" ng-show="product.is_bulk">
                                    <input type="text" class="form-control input input-sm" awnum="price" ng-model="product.origin_shipping_fee_bulk" ng-change="changeOriginShippingCost('shipping', product, currentConfigItem)" />
                                </div>
                            </td>
                            <td align="right">
                                <div class="form-group no-padding">
                                    <input type="text" class="form-control input input-sm" awnum="price" ng-model="product.origin_adding_fee" ng-change="changeOriginShippingCost('adding', product, currentConfigItem)" />
                                </div>
                                <div class="form-group no-padding" ng-show="product.is_bulk">
                                    <input type="text" class="form-control input input-sm" awnum="price" ng-model="product.origin_adding_fee_bulk" ng-change="changeOriginShippingCost('adding', product, currentConfigItem)" />
                                </div>
                            </td>
                            <td align="right">
                                <div class="form-group no-padding">
                                    <input type="text" class="form-control input input-sm" awnum="price" ng-model="product.default_shipping_fee" />
                                </div>
                                <div class="form-group no-padding" ng-show="product.is_bulk">
                                    <input type="text" class="form-control input input-sm" awnum="price" ng-model="product.default_shipping_fee_bulk" />
                                </div>
                            </td>
                            <td align="right">
                                <div class="form-group no-padding">
                                    <input type="text" class="form-control input input-sm" awnum="price" ng-model="product.tax" />
                                </div>
                                <div class="form-group no-padding" ng-show="product.is_bulk">
                                    <input type="text" class="form-control input input-sm" awnum="price" ng-model="product.tax_bulk" />
                                </div>
                            </td>
                            <td align="right">
                                <div class="form-group no-padding">
                                    <input type="text" class="form-control input input-sm" awnum="price" ng-model="product.default_adding_item" />
                                </div>
                                <div class="form-group no-padding" ng-show="product.is_bulk">
                                    <input type="text" class="form-control input input-sm" awnum="price" ng-model="product.default_adding_item_bulk" />
                                </div>
                            </td>
                            <td>
                                <select class="form-control"
                                    style="width: 100%;" 
                                    chosen
                                    ng-model="product.ratio_id"
                                    ng-options="ratio.id as ratio.name for ratio in currencyRatios"
                                    ng-change="changeRatioShipping(product, 'variant', currentConfigItem)"
                                >
                                    <option value="">Chọn tỷ giá</option>
                                </select>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" ng-click="saveConfigItemVariant(warehouseConfigItemData)" class="btn btn-primary">Xác nhận</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modalVariantItemBulk">
    <div class="modal-dialog modal-sm" style="width: 400px">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
                <h4 class="modal-title">
                    Cấu hình giá trị cho biến thể
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group" ng-show="config.config_type == 'cost'">
                            <label>Phí ship gốc</label>
                            <input type="text" class="form-control" awnum="price" ng-model="variantItemBulk.origin_shipping_fee" ng-change="changeOriginShippingCost('shipping', variantItemBulk, currentConfigItem)" />
                        </div>
                        <div class="form-group" ng-show="config.config_type == 'cost'">
                            <label>Phí cộng thêm gốc</label>
                            <input type="text" class="form-control" awnum="price" ng-model="variantItemBulk.origin_adding_fee" ng-change="changeOriginShippingCost('adding', variantItemBulk, currentConfigItem)" />
                        </div>
                        <div class="form-group">
                            <label>Phí ship mặc định</label>
                            <input type="text" class="form-control" awnum="price" ng-model="variantItemBulk.default_shipping_fee" />
                        </div>
                        <div class="form-group">
                            <label>Thuế</label>
                            <input type="text" class="form-control" awnum="price" ng-model="variantItemBulk.tax" />
                        </div>
                        <div class="form-group">
                            <label>Phí cộng thêm</label>
                            <input type="text" class="form-control" awnum="price" ng-model="variantItemBulk.default_adding_item" />
                        </div>
                        <div class="form-group" ng-show="config.config_type == 'cost'">
                            <label>Tỷ giá</label>
                            <select class="form-control" 
                                    chosen
                                    ng-model="variantItemBulk.ratio_id"
                                    ng-options="ratio.id as ratio.name for ratio in currencyRatios"
                                    ng-change="changeRatioShipping(variantItemBulk, 'variant', currentConfigItem)">
                                    <option value="">Chọn tỷ giá</option>
                                </select>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" ng-click="applyFormVariantItemBulk()" class="btn btn-primary">Áp dụng</button>
            </div>
        </div>
    </div>
</div>