<div class="row">
	<div class="col-md-12">
		<div class="nav-tabs-custom">
			<ul class="nav nav-tabs" style="font-size: 15px">
				<li ng-repeat="tab in tabs" ng-class="{ 'active' : tab.is_active === 1 }">
					<a href="#@{{tab.id}}" ng-click="changeTab(tab)" data-toggle="tab" aria-expanded="true">@{{tab.title}}</a>
				</li>
			</ul>
			<div class="tab-content">
				<div class="tab-pane" ng-class="{ 'active': shippingActive === 1 }" id="shipping">
					<div class="form-group no-padding">
						<label>Chọn loại shipping <span style="cursor: pointer" data-placement="bottom" tooltip title="Cấu hình phí ship cho các danh mục đã được cấu hình cho kho"><i class="fa fa-question-circle"></i></span></label>
						
						<select class="form-control" multiple data-placeholder="Chọn loại ship" chosen ng-model="shipping_config_types" ng-options="key as value for (key, value) in warehouseTypes" ng-change="selectShippingType()" aria-hidden="true">
						</select>
					</div>
					<table class="table table-bordered">
						<tbody>
							<tr>
								<th style="width: 10px;">#</th>
								<th style="width: 160px;">Loại ship</th>
								<th style="width: 320px;">Tên</th>
								<th style="width: 100px;">Trạng thái</th>
								<th>Danh mục không áp dụng</th>
								<th style="width:40px;"></th>
							</tr>
							<tr ng-repeat="config in warehouse.shipping_configs">
								<td>@{{$index + 1}}</td>
								<td>
									<span style="text-transform: capitalize;">@{{config.type}}</span>
								</td>
								<td>
									<input type="text" ng-model="config.name" class="form-control" ng-change="changeConfigName(config, warehouse)" placeholder="Nhập tên" />
								</td>
								<td>
									<div class="form-group no-padding">
										<select class="form-control" ng-model="config.is_active" ng-options="key as value for (key, value) in onoff">
										</select>
									</div>
								</td>
								<td>
									<div class="form-group no-padding">
										<select class="form-control" multiple chosen ng-model="config.invalid_cate" ng-options="key as value for (key, value) in categories" aria-hidden="true">
										</select>
									</div>
								</td>
								<td style="vertical-align: middle;">
									<button type="button" ng-click="openModal(config)" class="btn btn-sm btn-primary"><i class="fa fa-fw fa-edit"></i></button>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
				<div class="tab-pane" ng-class="costActive === 1 ? 'active' : ''" id="cost">
					<div class="form-group no-padding">
						<label>Loại shipping <span style="cursor: pointer" data-placement="bottom" tooltip title="Cấu hình giá vốn cho các danh mục đã được cấu hình cho kho"><i class="fa fa-question-circle"></i></span></label>
						
						<div ng-show="warehouse.type == 'custom'">
							<select class="form-control" multiple data-placeholder="Chọn loại ship" chosen ng-model="cost_config_types" ng-options="key as value for (key, value) in warehouseTypes" ng-disabled="warehouse.type == 'custom'">
							</select>
						</div>
						<div ng-show="warehouse.type == 'default_ship'">
							<select class="form-control" multiple data-placeholder="Chọn loại ship" chosen ng-model="cost_config_types" ng-options="key as value for (key, value) in warehouseTypes" ng-change="selectCostType()">
							</select>
						</div>
					</div>
					<table class="table table-bordered">
						<tbody>
							<tr>
								<th style="width: 10px;">#</th>
								<th style="width: 160px;">Loại ship</th>
								<th style="width: 320px;">Tên</th>
								<th ng-show="warehouse.type == 'custom'"> Tóm tắt </th>
								<th style="width:40px;"></th>
							</tr>
							<tr ng-repeat="config in warehouse.cost_configs">
								<td>@{{$index + 1}}</td>
								<td>
									<span style="text-transform: capitalize;">@{{config.type}}</span>
								</td>
								<td>
									<input type="text" ng-model="config.name" class="form-control" placeholder="Nhập tên" />
								</td>
								<td ng-show="warehouse.type == 'custom'">
									<table class="table table-bordered table-hover">
										<thead ng-show="$index == 0">
											<tr role="row">
												<td>Danh mục</td>
												<td>Phí ship</td>
												<td>Phí cộng thêm</td>
											</tr>
										</thead>
										<tbody>
											<tr role="row" class="odd">
												<td style="width: 20%" align="center">
													<div ng-show="!config.config_items[0].is_default && config.config_items[0].apply_cate != '' && config.config_items[0].apply_cate != null" class="variant-selector bgGreen">
														@{{categories[config_item.apply_cate]}}
													</div>
													<span class="variant-selector bgGreen" ng-show="config.config_items[0].is_default">
														Mặc định
													</span>
												</td>
												<td style="width: 20%" align="right">
													<b>@{{config.config_items[0].default_shipping_fee | awnum:2}}</b>
												</td>
												<td style="width: 20%" align="right">
													<b>@{{config.config_items[0].default_adding_item | awnum:2}}</b>
												</td>
											</tr>
										</tbody>
									</table>
								</td>
								<td style="vertical-align: middle;">
									<button type="button" ng-click="openModal(config)" class="btn btn-sm btn-primary"><i class="fa fa-fw fa-edit"></i></button>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
				<div class="tab-pane" ng-class="productActive === 1 ? 'active' : ''" id="product">
					<div class="callout callout-info" ng-show="warehouse.name != 'Default'" style="margin-bottom: 20px;">
						<h4><i class="fa fa-info"></i> Chú ý:</h4>
						<p>Vui lòng cấu hình sản phẩm trước khi cấu hình phí ship và giá vốn vận chuyển với kho khác Default</p>
						<p>Để cập nhật giá vốn sản phẩm theo tỷ giá vui lòng bấm hiển thị tất cả các cấu hình biến thể của các danh mục</p>
					</div>
					<div class="post" ng-repeat="product_config in warehouse.category_configs">
						<div class="row">
							<span class="badge bg-blue" style="height: 20px; position:absolute">@{{$index + 1}}</span>
							<div class="col-xs-12 col-sm-2">
								<div class="form-group">
									<label>Danh mục áp dụng</label>
									<select class="form-control" chosen style="width: 100%;" ng-model="product_config.category_id" ng-options="key as value for (key, value) in categories" ng-change="chooseCategory(product_config, $index)" aria-hidden="true">
									</select>
								</div>
							</div>
							<div class="col-xs-12 col-sm-2">
								<div class="form-group">
									<label>Giá vốn gốc($)</label>
									<input type="text" class="form-control" ng-model="product_config.origin_cost" awnum="price" ng-change="changeCostProduct('category', product_config)" />
								</div>
							</div>
							<div class="col-xs-12 col-sm-2">
								<div class="form-group">
									<label>Giá vốn mặc định</label>
									<input type="text" class="form-control" ng-model="product_config.cost" awnum="price" />
								</div>
							</div>
							<div class="col-xs-12 col-sm-2">
								<div class="form-group">
									<label>Giá vốn gốc BULK($)</label>
									<input type="text" class="form-control" ng-model="product_config.origin_cost_bulk" awnum="price" ng-change="changeCostProduct('category', product_config)" />
								</div>
							</div>
							<div class="col-xs-12 col-sm-2">
								<div class="form-group">
									<label>Giá vốn mặc định BULK</label>
									<input type="text" class="form-control" ng-model="product_config.cost_bulk" awnum="price" />
								</div>
							</div>
							<div class="col-xs-12 col-sm-1">
								<div class="form-group">
									<label>Tỷ giá</label>
									<select class="form-control" style="width: 100%;" chosen tabindex="-1" aria-hidden="true" ng-model="product_config.ratio_id" ng-options="item.id as item.name for item in currencyRatios" ng-change="changeRatio(product_config, 'item')" ng-disabled="product_config.is_show == 0">
										<option value="">Chọn tỷ giá</option>
									</select>
								</div>
							</div>
							<div class="col-xs-6 col-sm-1">
								<div class="form-group">
									<label>Biến thể</label>
									<div class="product-config-action">
										<label class="show-variables-label" for="show-variables-@{{$index}}">
											<input type="checkbox" id="show-variables-@{{$index}}" class="show-variables-input" ng-click="showVariant(product_config)" ng-checked="product_config.is_show == 1">
											<div class="show-variables-toggle">
												<span></span>
											</div>
										</label>
									</div>
								</div>
							</div>
						</div>
						<div class="row" ng-if="product_config.is_show == 1">
							<div class="col-xs-12 col-sm-12">
								<table class="table">
									<tr>
										<th style="width: 10%">Thuộc tính</th>
										<th>Biến thể áp dụng</th>
										<th style="width: 5%">
											<button type="button" class="btn btn-sm btn-primary" ng-click="addOption(product_config)">
												<i class="fa fa-fw fa-plus"></i>
											</button>
										</th>
									</tr>
									<tr ng-repeat="option in product_config.options">
										<td>
											<div class="form-group no-padding" style="width: 230px; margin-bottom: 0px;">
												<select class="form-control" chosen style="width: 100%;" ng-model="option.option" ng-options="item.name for item in options track by item.id" ng-change="chooseOption(option, product_config, $index)" aria-hidden="true">
												</select>
											</div>
										</td>
										<td>
											<div class="form-group no-padding" style="margin-bottom: 0px;">
												<select class="form-control" chosen multiple style="width: 100%;" ng-model="option.variant_ids" ng-options="k as value for (k, value) in option.variants" ng-change="chooseVariant(product_config)" aria-hidden="true">
												</select>
											</div>
										</td>
										<td>
											<button type="button" class="btn btn-sm btn-danger" ng-click="removeOption($index, product_config)" style="margin-top: 7px;">
												<i class="fa fa-fw fa-remove"></i>
											</button>
										</td>
									</tr>
								</table>
							</div>
							
							<div class="col-xs-12 col-sm-12">
								<div class="form-group" ng-show="product_config.combination_variants.length > 0 && product_config.combination_variants[0].length > 0" >
									<p style="font-weight: bold">Chọn biến thể lọc để thao tác</p>
									<div style="display: inline-block; width: 100%">
										<div class="text-left" ng-repeat="variant in product_config.combination_variants" style="width: calc((100% - 110px) / 3)">
											<div class="variant-selector bgGreen @{{ item.bulk_selected ? 'selected' : '' }}" ng-repeat="item in variant" ng-click="selectVariantValue(item, product_config)">@{{ item.name }}</div>
										</div>
									</div>
								</div>

								<div class="form-group">
									<p style="font-weight: bold" ng-bind="product_config.show_deleted ? 'Danh sách sản phẩm đã xóa': 'Danh sách sản phẩm'" ng-show="product_config.products.length > 0"></p>
									<div class="slimScrollDiv" ng-show="product_config.products.length > 0">
										<table class="table table-bordered table-hover" style="width: 100%;">
											<tr ng-show="product_config.show_action">
												<td colspan="8">
													<div class="form-group no-padding no-margin">
														<button class="btn btn-danger" ng-show="!product_config.show_deleted" ng-click="deleteProduct(product_config)">
															<i class="fa fa-fw fa-trash"></i> Xóa biến thể đã chọn
														</button>
														<button class="btn btn-default" ng-show="!product_config.show_deleted" ng-click="updateProductStatus('instock', product_config)">
															<i class="fa fa-fw fa-check-circle text-primary"></i> Đánh dấu là có hàng
														</button>
														<button class="btn btn-default" ng-show="!product_config.show_deleted" ng-click="updateProductStatus('outstock', product_config)">
															<i class="fa fa-fw fa-circle-o text-primary"></i> Đánh dấu là không có hàng
														</button>
														<button class="btn btn-default" ng-show="!product_config.show_deleted" ng-click="updateCost(product_config)">
															<i class="fa fa-usd"></i> Điền giá vốn cho sản phẩm
														</button>
														<button class="btn btn-default" ng-show="!product_config.show_deleted" ng-click="updateRatio(product_config)">
															<i class="fa fa-usd"></i> Điền tỷ giá cho sản phẩm
														</button>
														<button class="btn btn-default" ng-show="product_config.show_deleted" ng-click="restoreProductSelected(product_config)">
															<i class="fa fa-fw fa-undo"></i> Khôi phục sản phẩm đã chọn
														</button>
													</div>
												</td>
											</tr>
											<tr>
												<th align="center" style="width: 30px;">
													<input type="checkbox" ng-change="checkAll(product_config)" ng-true-value="1" ng-false-value="0" ng-model="product_config.check_all" ng-disabled="isLoading" style="margin-bottom: 5px;" />
												</th>
												<th>Biến thể</th>
												<th style="width: 120px;">Giá vốn gốc($)</th>
												<th style="width: 140px;">Giá vốn</th>
												<th style="width: 160px;">Giá vốn gốc BULK($)</th>
												<th style="width: 140px;">Giá vốn BULK</th>
												<th style="width: 150px;">Tỷ giá</th>
												<th style="width: 100px;">Trạng thái</th>
												<th align="center" style="width: 40px;">
													<button class="btn btn-warning btn-sm" ng-click="showRestoreProduct(product_config)" title="@{{ !product_config.show_deleted ? 'Hiển thị sản phẩm đã xóa' : 'Hiển thị sản phẩm' }}" data-placement="bottom" tooltip>
														<i class="fa fa-fw" ng-class="{ 'fa-undo' : !product_config.show_deleted, 'fa-check-square-o': product_config.show_deleted}"></i>
													</button>
												</th>
											</tr>
											<tr ng-repeat="product in filterProductLists(product_config.products, product_config.show_deleted)">
												<td align="center">
													<input type="checkbox" ng-change="checkedProduct(product, product_config)" ng-true-value="1" ng-false-value="0" ng-model="product.selected" />
												</td>
												<td>
													<div class="variant-selector bgGreen" ng-repeat="item in product.variants">@{{ item.name }}</div>
												</td>
												<td>
													<div class="form-group no-padding">
														<input type="text" class="form-control input input-sm" awnum="price" ng-model="product.origin_cost" ng-change="changeCostProduct('item', product, product_config)" />
													</div>
												</td>
												<td>
													<div class="form-group no-padding">
														<input type="text" class="form-control input input-sm" awnum="price" ng-model="product.cost" />
													</div>
												</td>
												<td>
													<div class="form-group no-padding">
														<input type="text" class="form-control input input-sm" awnum="price" ng-model="product.origin_cost_bulk" ng-change="changeCostProduct('item', product, product_config)" />
													</div>
												</td>
												<td>
													<div class="form-group no-padding">
														<input type="text" class="form-control input input-sm" awnum="price" ng-model="product.cost_bulk" />
													</div>
												</td>
												<td>
													<select class="form-control"
														style="width: 100%;" 
														chosen
														tabindex="-1" 
														aria-hidden="true" 
														ng-model="product.ratio_id"
														ng-options="item.id as item.name for item in currencyRatios"
														ng-change="changeRatio(product, 'item', product_config)"
													>
														<option value="">Chọn tỷ giá</option>
													</select>
												</td>
												<td align="center">
													<i class="fa fa-2x text-primary" ng-class="{'fa-check-circle': product.instock, 'fa-circle-o': !product.instock }" data-placement="bottom" tooltip title="@{{ product.instock ? 'Có hàng' : 'Không có hàng' }}"></i>
												</td>
												<td>
													<button class="btn btn-sm btn-danger" ng-click="removeProduct(product)">
														<i class="fa fa-fw fa-remove"></i>
													</button>
												</td>
											</tr>
										</table>
									</div>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-xs-12 col-sm-12">
								<div class="form-group">
									<button class="btn btn-primary" ng-click="saveCategoryConfig(product_config)" ng-disabled="product_config.is_show == 0 || !warehouse.id || isLoading">
										<i class="fa fa-save"></i> Lưu
									</button>
									<button class="btn btn-primary" ng-click="cloneCategoryConfig(product_config)" ng-disabled="product_config.is_show == 0">
										<i class="fa fa-copy"></i> Copy
									</button>
									<button class="btn btn-danger" ng-show="warehouse.category_configs.length > 1" ng-click="removeProductConfig($index, product_config)">
										<i class="fa fa-trash"></i> Xóa
									</button>
								</div>
							</div>
						</div>
					</div>
					<div class="form-group">
						<button type="button" class="btn btn-btn btn-primary" ng-click="addProductConfig()">
							<i class="fa fa-fw fa-plus"></i> Thêm danh mục
						</button>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>