@extends('system.layout.main')
@section('title')
<title>Quản lý kho - POD</title>
@endsection
@section('css')
<link rel="stylesheet" type="text/css" href="/modules/warehouse-pod/css/custom.css?v={{ config('sa.version') }}" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">
@endsection
@section('script')
<script>
    var printings = <?= json_encode($printings) ?>;
    var countries = <?= json_encode($countries) ?>;
    var categories = <?= json_encode($categories) ?>;
    var options = <?= json_encode($options) ?>;
    var listNotApply = <?= json_encode($listNotApply) ?>;
    var currencyRatios = <?= json_encode($currencyRatios) ?>;
    var ratioByIds = <?= json_encode($ratioByIds) ?>;
</script>

<script src="/system/js/scripts/combinatorics.js?v={{ config('sa.version') }}" charset="utf-8"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>
<script src="/system/js/scripts/angular-chosen-search.js?v={{ config('sa.version') }}" charset="utf-8"></script>
<script src="/system/js/controllers/pagination/pagination-controller.js?v={{ config('sa.version') }}" charset="utf-8"></script>
<script type="text/javascript" src="{{ Module::asset('warehouse-pod/js/warehouse-config-controller.js') . '?v=' . config('sa.version') }}"></script>
@endsection
@section('content')
<div class="content" ng-controller="WarehouseConfigController">
    <div class="index" ng-show="!showForm">
        <div class="header">
            <div class="pull-left">
                <h3>Quản lý kho - POD</h3>
            </div>
            <div class="pull-right" style="margin-top: 20px;">
                <button type="button" class="btn btn-success" ng-click="openForm(null)">
                    <i class="fa fa-fw fa-plus-square-o"></i> Thêm kho
                </button>
            </div>
            <div class="clearfix"></div>
        </div>
        <div class="body">
            <div class="box no-border">
                <div class="box-body" style="margin-bottom: 10px;">
                    <div class="row">
                        <div class="col-md-4">
                            <input type="text" ng-model="filters.keyword" class="form-control" placeholder="Nhập tên kho" ng-keydown="$event.keyCode === 13 && find(true)" />
                        </div>
                        <div class="col-md-3">
                            <select  class="form-control" ng-change="find(true)" ng-model="filters.printing_code" ng-options="key as value for (key, value) in printings">
                                <option value="">Chọn nhà in</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <select  chosen class="form-control" ng-change="find(true)" ng-model="filters.country_id" ng-options="key as value for (key, value) in countries">
                                <option value="">Chọn quốc gia</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select  class="form-control" ng-change="find(true)" ng-model="filters.is_active" ng-options="key as value for (key, value) in statusses">
                                <option value="">Chọn trạng thái</option>
                            </select>
                        </div>
                    </div>
                    <div class="row" style="margin-top: 20px;">
                        <div class="col-md-2">
                            <select chosen class="form-control" ng-change="find(true)" ng-model="filters.category_id" ng-options="key as value for (key, value) in categories">
                                <option value="">Chọn danh mục</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select  class="form-control" ng-change="find(true)" ng-model="filters.ship_type" ng-options="key as value for (key, value) in warehouseTypes">
                                <option value="">Chọn loại ship</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <select  class="form-control" ng-change="find(true)" ng-model="filters.type" ng-options="key as value for (key, value) in types">
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select  class="form-control" ng-change="find(true)" ng-model="filters.has_ratio" ng-options="key as value for (key, value) in filterRatios">
                                <option value="">Lọc kho theo tỉ giá</option>
                            </select>
                        </div>
                    </div>
                    <div class="row" style="margin-top: 20px;">
                        <div class="col-md-12" style="align-items: center; display: flex;">
                            <button type="button" class="btn btn-primary " ng-click="find()">
                                <i class="fa fa-search"></i>
                                Tìm kiếm
                            </button>
                            <button type="button" class="btn btn-default ml-3 " ng-click="clear()">
                                <i class="fa fa-refresh"></i>
                                Xóa form
                            </button>
                            <div style="margin-left: auto;">
                                <span style="color: red">(*) Import cấu hình ship phải có cấu hình giá vốn ship tương ứng</span>
                            </div>
                        </div>
                    </div>
                    <div class="row" style="margin-top: 20px;">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Tên kho</th>
                                            <th>Ngày tạo</th>
                                            <th>Ngày sửa</th>
                                            <th>Nhà in</th>
                                            <th ng-show="filters.type != 'default_cost'">Vận chuyển từ</th>
                                            <th>Tới quốc gia</th>
                                            <th>Trạng thái</th>
                                            <th>Cho phép sửa</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody class="striped-row">
                                        <tr ng-repeat="item in items" ng-if="items.length && !isLoading">
                                            <td>
                                                @{{$index + 1}}
                                            </td>    
                                            <td>
                                                @{{item.name}}
                                                <i class="fa fa-exclamation-triangle" ng-show="item.is_lost_data"
                                                    style="color: orange; font-size: 20px;"
                                                    data-toggle="popover"
                                                    title="<?= __s("Missing shipping cost")?>"
                                                    data-placement="right"
                                                    data-content="<?= __s("Missing shipping cost")?>">
                                                </i>
                                            </td>
                                            <td>
                                                @{{ summarizeDateTime(item.created_at, true) }}
                                            </td>
                                            <td>
                                                @{{ summarizeDateTime(item.updated_at, true) }}
                                            </td>
                                            <td>
                                                @{{printings[item.printing_code]}}
                                            </td>
                                            <td ng-show="item.type != 'default_cost'">
                                                @{{item.location}}
                                            </td>
                                            <td>
                                                <span ng-show="item.country_id != -1">@{{countries[item.country_id]}}</span>
                                                <span ng-show="item.country_id == -1">Tất cả các quốc gia</span>
                                            </td>
                                            <td>
                                                <span ng-show="item.is_active == 1">
                                                        <small class="badge" style="background-color: #00a65a;">
                                                            Hoạt động
                                                        </small> 
                                                    </span>
                                                    <span ng-show="item.is_active == 0">
                                                        <small class="badge" style="background-color: #dd4b39;">
                                                                Dừng hoạt động
                                                        </small> 
                                                </span>
                                            </td>
                                            <td>
                                                <div class="edit-config-action">
                                                    <label class="show-variables-label" for="enable-edit-@{{ item.id }}">
                                                        <input type="checkbox" name="" id="enable-edit-@{{ item.id }}" class="show-variables-input" ng-click="enableEdit(item)" ng-model="item.is_editable" ng-true-value="1" ng-false-value="0">
                                                        <div class="show-variables-toggle">
                                                        <span></span>
                                                        </div>
                                                    </label>
                                                </div>
                                            </td>
                                            <td align="center">
                                                <button class="btn btn-default" ngf-select ng-model="refundFile" accept="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel" ngf-max-size="20MB" ng-change="handleUploadRefund(refundFile, item)" style="height: 34px">
                                                    <i class="fa fa-upload"></i> Import
                                                </button>
                                                <button class="btn btn-primary" title="Xem chi tiết" ng-click="exportConfig(item)">
                                                    <i class="fa fa-upload"></i> Export
                                                </button>
                                                <button class="btn btn-primary" title="Xem chi tiết" ng-click="openForm(item)">
                                                    <i class="fa fa-edit"></i> Sửa
                                                </button>
                                                <button class="btn btn-warning" title="Clone config" ng-click="copyConfig(item)">
                                                   <i class="fa fa-copy"></i> Copy
                                                </button>
                                            </td>
                                        </tr>
                                        <tr ng-if="items.length == 0 && !isLoading">
                                            <td colspan="10">Không có cấu hình nào</td>
                                        </tr>
                                        <tr ng-if="isLoading">
                                            <td colspan="10" align="center">
                                                <img src="/images/loading.gif">
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="box-footer clearfix">
                    <div class="pull-right">
                        @include('warehouse-pod::system.includes.paginator', [
                                    "accessPageId" => "filters.page_id",
                                    "accessPagesCount" => "pagesCount",
                                    "accessFind" => "find()"
                        ])
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="form" ng-show="showForm">
        @include('warehouse-pod::system.config.include.form')
    </div>
    @include('warehouse-pod::system.config.modal')
    @include('warehouse-pod::system.config.include.cost-modal')
    @include('warehouse-pod::system.config.include.ratio-modal')
    @include('warehouse-pod::system.config.include.variant-shipping')
</div>
@endsection
