<div class="modal fade" id="modalForm">
    <div class="modal-dialog" style="width:97%;">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">
                    <i class="fa fa-config-o"></i>
                    <span>
                        Cấu hình chi tiết <span ng-show="config.config_type == 'shipping'">Phí ship</span><span ng-show="config.config_type == 'cost'">Giá vốn</span>
                    </span>
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Tên hiển thị</label>
                            <input type="text" class="form-control" ng-model="config.name" placeholder="Nhập tên Ship"/>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>Loại</label>
                            <input type="text" class="form-control" style="text-transform: capitalize;" disabled ng-model="config.type"/>
                        </div>
                    </div>
                    <div class="col-md-1" ng-show="config.config_type == 'shipping'">
                        <div class="form-group">
                            <label>Bật / Tắt</label>
                            <select class="form-control" 
                                    style="width: 100%;"
                                    ng-model="config.is_active"
                                    ng-options="key as value for (key, value) in onoff"
                                    >
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6" ng-show="config.config_type == 'shipping' && warehouse.type == 'default_ship'">
                        <div class="form-group">
                            <label>Danh mục không áp dụng</label>
                            <select class="form-control" 
                                multiple
                                style="width: 100%;" 
                                chosen
                                ng-model="config.invalid_cate"
                                ng-options="key as value for (key, value) in categories"
                                aria-hidden="true">
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <h5>Chi tiết</h5>
                        </div>
                        <div class="form-group">
                            <input type="text" class="form-control" ng-model="filterCate" placeholder="Tìm kiếm cấu hình" ng-change="filterCategory()" ng-model-options="{ debounce: 200 }"/>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div style="position: relative; overflow: auto; height: 420px;">
                            <table class="table table-bordered table-hover" ng-show="config.config_type == 'cost'" id="table-cost">
                                <tr>
                                    <th style="width: 10px" align="center">#</th>
                                    <th style="width: 165px">Tên</th>
                                    <th style="width: 65px" align="center">
                                        Bulk <span style="cursor: pointer" data-placement="bottom" tooltip title="Đơn đặt từ 30 sản phẩm"><i class="fa fa-question-circle"></i></span>
                                    </th>
                                    <th style="width: 115px">Phí ship gốc($)</th>
                                    <th style="width: 150px">Phí cộng thêm gốc($)</th>
                                    <th style="width: 100px">Phí mặc định</th>
                                    <th style="width: 165px">Phí cộng thêm áp dụng đơn có số lượng từ 2</th>
                                    <th style="width: 150px">Áp dụng theo thứ tự</th>
                                    <th style="width: 100px">Thuế</th>
                                    <th style="width: 200px">Danh mục</th>
                                    <th style="width: 75px">Áp dụng <br /> mặc định<span style="cursor: pointer" data-placement="bottom" tooltip ng-show="warehouse.type == 'custom'" title="Tích chọn mặc định sẽ được áp dụng khi không có danh mục nào được cấu hình phí ship"><i class="fa fa-question-circle"></i></span></th>
                                    <th style="width: 120px">Tỷ giá</th>
                                    <th style="width: 100px"></th>
                                </tr>

                                <tr ng-repeat="item in config.config_items" ng-if="item.is_show == 1">
                                    <td align="center">@{{$index + 1}}</td>
                                    <td>
                                        <input type="text" ng-model="item.name" ng-disabled="config.config_type == 'cost' && item.map_id != null" class="form-control input-sm" placeholder="name"/>
                                    </td>
                                    <td align="center">
                                        <input type="checkbox" ng-true-value="1" ng-false-value="0" ng-model="item.is_bulk" />
                                        <p class="no-margin" ng-if="item.is_bulk">|</p>
                                        <p class="no-margin" ng-if="item.is_bulk">|</p>
                                        <p class="no-margin" ng-if="item.is_bulk">&nbsp;&nbsp;&nbsp;&nbsp;|__</p>
                                    </td>
                                    <td>
                                        <div class="form-group no-padding">
                                            <input type="text" ng-model="item.origin_shipping_fee" class="form-control input-sm" awnum="price" placeholder="@{{ currencyUnit }}" ng-change="changeOriginShippingCost('shipping', item)"/>
                                        </div>
                                        <div class="form-group no-padding" ng-if="item.is_bulk">
                                            <input type="text" ng-model="item.origin_shipping_fee_bulk" class="form-control input-sm" awnum="price" placeholder="@{{ currencyUnit }}"/>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group no-padding">
                                            <input type="text" ng-model="item.origin_adding_fee" class="form-control input-sm" awnum="price" placeholder="@{{ currencyUnit }}" ng-change="changeOriginShippingCost('adding', item)"/>
                                        </div>
                                        <div class="form-group no-padding" ng-if="item.is_bulk">
                                            <input type="text" ng-model="item.origin_adding_fee_bulk" class="form-control input-sm" awnum="price" placeholder="@{{ currencyUnit }}"/>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group no-padding">
                                            <input type="text" ng-model="item.default_shipping_fee" class="form-control input-sm" awnum="price" placeholder="$"/>
                                        </div>
                                        <div class="form-group no-padding" ng-if="item.is_bulk">
                                            <input type="text" ng-model="item.default_shipping_fee_bulk" class="form-control input-sm" awnum="price" placeholder="$"/>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group no-padding">
                                            <input type="text" ng-model="item.default_adding_item" class="form-control input-sm" awnum="price" placeholder="0"/>
                                        </div>
                                        <div class="form-group no-padding" ng-if="item.is_bulk">
                                            <input type="text" ng-model="item.default_adding_item_bulk" class="form-control input-sm" awnum="price" placeholder="$"/>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group no-padding">
                                            <input type="text" ng-model="item.adding_item" class="form-control input-sm" placeholder="1,2,3,.."/>
                                        </div>
                                        <div class="form-group no-padding" ng-if="item.is_bulk">
                                            <input type="text" ng-model="item.adding_item_bulk" class="form-control input-sm" placeholder="1,2,3,.."/>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group no-padding">
                                            <input type="text" ng-model="item.tax" class="form-control input-sm" awnum="price" placeholder="%"/>
                                        </div>
                                        <div class="form-group no-padding" ng-if="item.is_bulk">
                                            <input type="text" ng-model="item.tax_bulk" class="form-control input-sm" awnum="price" placeholder="%"/>
                                        </div>
                                    </td>
                                    <td>
                                        @{{ item.cateName }}
                                    </td>
                                    <td align="center">
                                        <label>
                                            <input type="checkbox" ng-disabled="true" ng-disabled="config.config_type == 'cost' && item.map_id != null" ng-true-value="1" ng-change="updateConfigDefault(item, $index)" ng-model="item.is_default" class="input-sm" ng-false-value="0"/>
                                        </label>
                                    </td>
                                    <td>
                                        <select class="form-control"
                                            style="width: 180px;" 
                                            chosen
                                            tabindex="-1" 
                                            aria-hidden="true" 
                                            ng-model="item.ratio_id"
                                            ng-options="ratio.id as ratio.name for ratio in currencyRatios"
                                            ng-change="changeRatioShipping(item, 'item')"
                                        >
                                            <option value="">Chọn tỷ giá</option>
                                        </select>
                                    </td>
                                    <td align="center">
                                        <div ng-show="config.config_type == 'cost' && warehouse.type == 'default_ship'">
                                            <button type="button" class="btn btn-sm btn-info" ng-click="getConfigItemVariant(item)" ng-show="config.config_items.length > 1 && !item.is_default && item.id" title="Cấu hình biến thể" data-placement="bottom" tooltip>
                                                <i class="fa fa-fw fa-asterisk"></i>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-danger" ng-click="removeConfigItem($index)" ng-show="config.config_items.length > 1 && !item.is_default">
                                                <i class="fa fa-fw fa-remove" title="Xóa cấu hình" data-placement="bottom" tooltip></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                
                                <tr>
                                    <td colspan="12">
                                        <button type="button" class="btn btn-primary" ng-click="addConfigItem()">
                                            <i class="fa fa-fw fa-plus"></i> Thêm cấu hình
                                        </button>
                                    </td>
                                </tr>
                            </table>

                            <table class="table table-bordered" ng-show="config.config_type == 'shipping'" id="table-shipping">
                                <tr>
                                    <th style="width: 10px" align="center">#</th>
                                    <th style="width: 165px">Tên</th>
                                    <th style="width: 65px" align="center">
                                        Bulk <span style="cursor: pointer" data-placement="bottom" tooltip title="Đơn đặt từ 30 sản phẩm"><i class="fa fa-question-circle"></i></span>
                                    </th>
                                    <th style="width: 100px">Phí mặc định</th>
                                    <th style="width: 100px">Tổng tiền đơn hàng đạt</th>
                                    <th style="width: 90px">Thì áp dụng phí</th>
                                    <th style="width: 165px">Phí cộng thêm áp dụng đơn có số lượng từ 2</th>
                                    <th style="width: 90px">Áp dụng theo thứ tự</th>
                                    <th style="width: 115px">Thời gian đóng gói tối thiểu</th>
                                    <th style="width: 115px">Thời gian đóng gói tối đa</th>
                                    <th style="width: 100px">Thời gian ship tối thiểu</th>
                                    <th style="width: 85px">Thời gian ship tối đa</th>
                                    <th style="width: 200px">Danh mục</th>
                                    <th style="width: 75px">Áp dụng <br /> mặc định<span style="cursor: pointer" data-placement="bottom" tooltip ng-show="warehouse.type == 'custom'" title="Tích chọn mặc định sẽ được áp dụng khi không có danh mục nào được cấu hình phí ship"><i class="fa fa-question-circle"></i></span></th>
                                    <th style="width: 110px"></th>
                                </tr>

                                <tr ng-repeat="item in config.config_items" ng-if="item.is_show == 1">
                                    <td align="center">@{{$index + 1}}</td>
                                    <td>
                                        <input type="text" ng-model="item.name" ng-disabled="config.config_type == 'cost' && item.map_id != null" class="form-control input-sm" placeholder="name"/>
                                    </td>
                                    <td align="center">
                                        <input type="checkbox" ng-true-value="1" ng-false-value="0" ng-model="item.is_bulk" />
                                        <p class="no-margin" ng-if="item.is_bulk">|</p>
                                        <p class="no-margin" ng-if="item.is_bulk">|</p>
                                        <p class="no-margin" ng-if="item.is_bulk">&nbsp;&nbsp;&nbsp;&nbsp;|__</p>
                                    </td>
                                    <td>
                                        <div class="form-group no-padding">
                                            <input type="text" ng-model="item.default_shipping_fee" class="form-control input-sm" awnum="price" placeholder="$"/>
                                        </div>
                                        <div class="form-group no-padding" ng-if="item.is_bulk">
                                            <input type="text" ng-model="item.default_shipping_fee_bulk" class="form-control input-sm" awnum="price" placeholder="$"/>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group no-padding">
                                            <input type="text" ng-model="item.fee_limit" class="form-control input-sm" awnum="price" placeholder="$"/>
                                        </div>
                                        <div class="form-group no-padding" ng-if="item.is_bulk">
                                            <input type="text" ng-model="item.fee_limit_bulk" class="form-control input-sm" awnum="price" placeholder="$"/>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group no-padding">
                                            <input type="text" ng-model="item.fee_if_limit" class="form-control input-sm" awnum="price" placeholder="$"/>
                                        </div>
                                        <div class="form-group no-padding" ng-if="item.is_bulk">
                                            <input type="text" ng-model="item.fee_if_limit_bulk" class="form-control input-sm" awnum="price" placeholder="$"/>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group no-padding">
                                            <input type="text" ng-model="item.default_adding_item" class="form-control input-sm" awnum="price" placeholder="0"/>
                                        </div>
                                        <div class="form-group no-padding" ng-if="item.is_bulk">
                                            <input type="text" ng-model="item.default_adding_item_bulk" class="form-control input-sm" awnum="price" placeholder="0"/>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group no-padding">
                                            <input type="text" ng-model="item.adding_item" class="form-control input-sm" placeholder="1,2,3,.."/>
                                        </div>
                                        <div class="form-group no-padding" ng-if="item.is_bulk">
                                            <input type="text" ng-model="item.adding_item_bulk" class="form-control input-sm" placeholder="1,2,3,.."/>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group no-padding">
                                            <input type="text" ng-model="item.handling_min_time" class="form-control input-sm" awnum="price" placeholder="ngày"/>
                                        </div>
                                        <div class="form-group no-padding" ng-if="item.is_bulk">
                                            <input type="text" ng-model="item.handling_min_time_bulk" class="form-control input-sm" placeholder="1,2,3,.."/>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group no-padding">
                                            <input type="text" ng-model="item.handling_max_time" class="form-control input-sm" awnum="price" placeholder="ngày"/>
                                        </div>
                                        <div class="form-group no-padding" ng-if="item.is_bulk">
                                            <input type="text" ng-model="item.handling_max_time_bulk" class="form-control input-sm" awnum="price" placeholder="ngày"/>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group no-padding">
                                            <input type="text" ng-model="item.shipping_min_time" class="form-control input-sm" awnum="price" placeholder="ngày"/>
                                        </div>
                                        <div class="form-group no-padding" ng-if="item.is_bulk">
                                            <input type="text" ng-model="item.shipping_min_time_bulk" class="form-control input-sm" awnum="price" placeholder="ngày"/>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group no-padding">
                                            <input type="text" ng-model="item.shipping_max_time" class="form-control input-sm" awnum="price" placeholder="ngày"/>
                                        </div>
                                        <div class="form-group no-padding" ng-if="item.is_bulk">
                                            <input type="text" ng-model="item.shipping_max_time_bulk" class="form-control input-sm" awnum="price" placeholder="ngày"/>
                                        </div>
                                    </td>
                                    <td>
                                        <div ng-if="item.is_edit == 0"> @{{ item.cateName }} </div>
                                        <div ng-if="item.is_edit == 1">
                                            <div ng-if="warehouse.type == 'default_ship'">
                                                <select class="form-control input-sm"
                                                        ng-disabled="item.is_default"
                                                        multiple
                                                        style="width: 100%;" 
                                                        chosen
                                                        ng-model="item.apply_cate"
                                                        ng-options="key as value for (key, value) in categories"
                                                        aria-hidden="true">
                                                </select>
                                            </div>
                                            <div ng-if="warehouse.type == 'custom'">
                                                <select class="form-control input-sm"
                                                        multiple
                                                        ng-disabled="item.is_default"
                                                        style="width: 100%;" 
                                                        chosen
                                                        ng-model="item.apply_cate"
                                                        ng-options="key as value for (key, value) in configCategories"
                                                        aria-hidden="true"
                                                        ng-change="chooseConfigCategory(item.apply_cate, config.config_items, $index)"
                                                        >
                                                </select>
                                            </div>
                                        </div>
                                    </td>
                                    <td align="center">
                                        <label>
                                            <input type="checkbox" ng-disabled="true" ng-disabled="config.config_type == 'cost' && item.map_id != null" ng-true-value="1" ng-change="updateConfigDefault(item, $index)" ng-model="item.is_default" class="input-sm" ng-false-value="0"/>
                                        </label>
                                    </td>
                                    <td align="center">
                                        <p ng-if="item.is_variant_bulk" style="display: block; font-size: 12px">Đã cấu hình BULK cho biến thể</p>
                                        <button type="button" class="btn btn-sm btn-info" ng-click="getConfigItemVariant(item)" ng-show="config.config_items.length > 1 && !item.is_default && item.id" title="Cấu hình biến thể" data-placement="bottom" tooltip>
                                            <i class="fa fa-fw fa-asterisk"></i>
                                        </button>
                                        <button type="button" class="btn btn-sm btn-success" ng-click="saveApplyCate($index)" ng-show="config.config_items.length > 1 && !item.is_default" ng-if="item.is_edit == 1" title="Lưu cấu hình" data-placement="bottom" tooltip>
                                            <i class="fa fa-fw fa-check"></i>
                                        </button>
                                        <button type="button" class="btn btn-sm btn-primary" ng-click="editConfigItem($index)" ng-show="config.config_items.length > 1 && !item.is_default" ng-if="item.is_edit == 0" title="Sửa cấu hình" data-placement="bottom" tooltip>
                                            <i class="fa fa-fw fa-edit"></i>
                                        </button>
                                        <button type="button" class="btn btn-sm btn-danger" ng-click="removeConfigItem($index)" ng-show="config.config_items.length > 1 && !item.is_default" title="Xóa cấu hình" data-placement="bottom" tooltip>
                                            <i class="fa fa-fw fa-remove"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr ng-show="config.config_type == 'shipping'">
                                    <td colspan="14">
                                        <button type="button" class="btn btn-primary" ng-click="addConfigItem()">
                                            <i class="fa fa-fw fa-plus"></i> Thêm cấu hình
                                        </button>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" ng-click="updateConfig(config)" class="btn btn-primary"><i class="fa fa-check" aria-hidden="true"></i> Xác nhận</button>
            </div>
        </div>
    </div>
</div>
