@extends('system.layout.main')
@section('title')
<title>Warehouse Currency Ratio</title>
@endsection
@section('css')
<link rel="stylesheet" type="text/css" href="/modules/warehouse-pod/css/s-provider.css?v=<?= time() ?>" />
<link rel="stylesheet" type="text/css" href="/modules/warehouse-pod/css/custom.css?v=<?= time() ?>" />
@endsection
@section('script')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">
<script src="/system/js/scripts/combinatorics.js?v={{ config('sa.version') }}" charset="utf-8"></script>
<script src="/system/js/scripts/chosen-add-option.js?v={{ config('sa.version') }}" charset="utf-8"></script>
<script src="/system/js/scripts/angular-chosen-search.js?v={{ config('sa.version') }}" charset="utf-8"></script>
<script src="/system/js/scripts/dynamic-number.min.js?v={{ config('sa.version') }}" charset="utf-8"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>
<script src="/system/js/controllers/pagination/pagination-controller.js" charset="utf-8"></script>
<script type="text/javascript" src="{{ Module::asset('warehouse-pod/js/warehouseCurrencyRatio-controller.js') }}?v=<?= time() ?>"></script>
@endsection
@section('content')

<div class="content" ng-controller="WarehouseCurrencyRatioController">
    <div class="index">
        <div class="header">
            <div class="pull-left">
                <h3 class="">Currency Ratio Management</h3>
            </div>
            <button type="button" name="button" class="btn btn-success pull-right" ng-click="openModalCreateWarehouseCurrencyRatio()">
                <i class="fa fa-fw fa-plus-square-o"></i>
                <b>Add Currency Ratio</b>
            </button>
            <div class="clearfix"></div>
        </div>
        <div class="body">
            <div class="box no-border">
                <div class="box-body">
                    <div class="form-search-supplier">
                        <div class="row" style=" display: flex; align-items: flex-end; ">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Search</label>
                                    <input ng-keyup="keypressFilter($event)" type="text" class="form-control" placeholder="keyword" aria-invalid="false" ng-model="filters.keyword">
                                </div>
                            </div>
                            <div class="col-md-3 text-right">
                                <div class="form-group">
                                    <button type="button" class="btn btn-primary" ng-click="find()" ng-disabled="isLoading">
                                        <i class="fa fa-search"></i> Find </button>
                                    <button type="button" class="btn btn-default ml-3 " ng-click="clear()" ng-disabled="isLoading">
                                        <i class="fa fa-refresh"></i> Clear </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-list-supplier">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th></th>
                                                <th>From Currency</th>
                                                <th>To Currency</th>
                                                <th>Ratio</th>
                                                <th class="text-center"></th>
                                            </tr>
                                        </thead>
                                        <tbody class="striped-row">
                                            <tr ng-repeat="item in items">
                                                <td>@{{ $index + 1 }}</td>
                                                <td>@{{ item.from_currency }}</td>
                                                <td>@{{ item.to_currency }}</td>
                                                <td>@{{ item.ratio }}</td>
                                                <td class="text-right">
                                                    <button type="button" name="button" class="btn" ng-click="editWarehouseCurrencyRatio(item)">
                                                        <i class="fa fa-eye"></i>
                                                    </button>
                                                    <button type="button" name="button" class="btn" ng-click="deleteWarehouseCurrencyRatio(item)">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <div class="box-footer clearfix">
                                        <div class="pull-right">
                                            @include('warehouse-pod::system.includes.paginator', [
                                                "accessPageId" => "filters.page_id",
                                                "accessPagesCount" => "pagesCount",
                                                "accessFind" => "find()"
                                            ])
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('warehouse-pod::system.currency-ratio.inc.add-ratio-modal')
</div>
<script>
    (function() {
        var runMyCode = function($) {
            $(document).ready(function() {
                $("body").tooltip({
                    selector: '[data-toggle=tooltip]'
                });
            });
        };

        var timer = function() {
            if (window.jQuery && window.jQuery.ui) {
                runMyCode(window.jQuery);
            } else {
                window.setTimeout(timer, 100);
            }
        };
        timer();
    })();
</script>
@endsection