@extends('system.layout.main')
@section('title')
<title>Cảnh báo sai lợi nhuận ước tính</title>
@endsection
<?php 
    $apiDomain = config('warehouse-pod::sa.api_domain', 'api.printerval.com');
?>
@section('css')
<style type="text/css">
 .header {
        margin-bottom: 25px;
 }
</style>
<link rel="stylesheet" type="text/css" href="/modules/warehouse-pod/css/custom.css?v=<?= time() ?>" />
@endsection
@section('script')
<script>
</script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>
<script src="/system/js/controllers/pagination/pagination-controller.js" charset="utf-8"></script>
<script type="text/javascript" src="{{ Module::asset('warehouse-pod/js/order-warning-controller.js') }}?v=<?= time() ?>"></script>
@endsection
@section('content')
<div class="content" ng-controller="OrderWarningController">
    <div class="index">
        <div class="header">
            <div class="pull-left">
                <h3 class="">Cảnh báo đơn sai lợi nhuận ước tính</h3>
            </div>
            <div class="clearfix">
            </div>
        </div>
        <div class="body">
            <div class="box no-border">
                <!-- /.box-header -->
                <div class="box-body" style="margin-bottom: 10px;">
                    <div class="row">
                        <div class="col-md-4">
                            <input type="text" ng-model="filters.keyword" class="form-control" placeholder="Nhập từ khóa tìm kiếm sản phẩm" ng-keydown="$event.keyCode === 13 && find(true)" />
                        </div>
                        <div class="col-md-2">
                        <input my-date-picker type="text" ng-model="filters.date_from" class="form-control" placeholder="Tạo từ ngày"/>
                        </div>
                        <div class="col-md-2">
                            <input my-date-picker type="text" ng-model="filters.date_to" class="form-control" placeholder="Tạo đến ngày"/>
                        </div>
                    </div>
                    <div class="row" style="margin-top: 20px;">
                        <div class="col-md-12">
                            <button type="button" class="btn btn-primary " ng-click="find()">
                                <i class="fa fa-search"></i>
                                Tìm kiếm
                            </button>
                            <button type="button" class="btn btn-default ml-3 " ng-click="clear()">
                                <i class="fa fa-refresh"></i>
                                Xóa form
                            </button>
                            <button type="button" class="btn btn-default ml-3 " ng-click="export()">
                                <i class="fa fa-upload"></i>
                                Export
                            </button>
                        </div>
                    </div>
                    <div class="row" style="margin-top: 20px;">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>
                                                <input type="checkbox"
                                                ng-change="checkAll()" 
                                                ng-true-value="1" ng-false-value="0"
                                                ng-model="checkedAll"
                                                ng-disabled="isLoading"
                                                style="margin-bottom: 5px;"
                                                />
                                            </th>
                                            <th ng-show="countSelected == 0">Mã đơn</th>
                                            <th ng-show="countSelected == 0">
                                                <div class="flex-b align-c align-l">
                                                    Profit
                                                    <span style="display: inline-flex;" class="flex-dc">
                                                        <svg ng-click="find(true, 'profit-asc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-up-fill sort-image" viewBox="0 0 16 16">
                                                            <path d="m7.247 4.86-4.796 5.481c-.566.647-.106 1.659.753 1.659h9.592a1 1 0 0 0 .753-1.659l-4.796-5.48a1 1 0 0 0-1.506 0z"/>
                                                        </svg>
                                                        <svg ng-click="find(true, 'profit-desc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-down-fill sort-image" viewBox="0 0 16 16">
                                                            <path d="M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z"/>
                                                        </svg>
                                                    </span>
                                                    <span ng-if="filters.sort == 'profit-asc' || filters.sort == 'profit-desc'" style="display: inline-flex;" class="flex-dc">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-filter" viewBox="0 0 16 16">
                                                            <path d="M6 10.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5z"/>
                                                        </svg>
                                                    </span>
                                                </div>
                                            </th>
                                            <th ng-show="countSelected == 0">
                                                <div class="flex-b align-c align-l">
                                                    Amount
                                                    <span style="display: inline-flex;" class="flex-dc">
                                                        <svg ng-click="find(true, 'amount-asc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-up-fill sort-image" viewBox="0 0 16 16">
                                                            <path d="m7.247 4.86-4.796 5.481c-.566.647-.106 1.659.753 1.659h9.592a1 1 0 0 0 .753-1.659l-4.796-5.48a1 1 0 0 0-1.506 0z"/>
                                                        </svg>
                                                        <svg ng-click="find(true, 'amount-desc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-down-fill sort-image" viewBox="0 0 16 16">
                                                            <path d="M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z"/>
                                                        </svg>
                                                    </span>
                                                    <span ng-if="filters.sort == 'amount-asc' || filters.sort == 'amount-desc'" style="display: inline-flex;" class="flex-dc">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-filter" viewBox="0 0 16 16">
                                                            <path d="M6 10.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5z"/>
                                                        </svg>
                                                    </span>
                                                </div>
                                            </th>
                                            <th ng-show="countSelected == 0">
                                            <div class="flex-b align-c align-l">
                                                    Profit rate
                                                    <span style="display: inline-flex;" class="flex-dc">
                                                        <svg ng-click="find(true, 'ratio_profit-asc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-up-fill sort-image" viewBox="0 0 16 16">
                                                            <path d="m7.247 4.86-4.796 5.481c-.566.647-.106 1.659.753 1.659h9.592a1 1 0 0 0 .753-1.659l-4.796-5.48a1 1 0 0 0-1.506 0z"/>
                                                        </svg>
                                                        <svg ng-click="find(true, 'ratio_profit-desc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-down-fill sort-image" viewBox="0 0 16 16">
                                                            <path d="M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z"/>
                                                        </svg>
                                                    </span>
                                                    <span ng-if="filters.sort == 'ratio_profit-asc' || filters.sort == 'ratio_profit-desc'" style="display: inline-flex;" class="flex-dc">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-filter" viewBox="0 0 16 16">
                                                            <path d="M6 10.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5z"/>
                                                        </svg>
                                                    </span>
                                                </div>
                                                
                                            </th>
                                            <th ng-show="countSelected == 0">
                                                <div class="flex-b align-c align-l">
                                                    Tax
                                                    <span style="display: inline-flex;" class="flex-dc">
                                                        <svg ng-click="find(true, 'tax-asc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-up-fill sort-image" viewBox="0 0 16 16">
                                                            <path d="m7.247 4.86-4.796 5.481c-.566.647-.106 1.659.753 1.659h9.592a1 1 0 0 0 .753-1.659l-4.796-5.48a1 1 0 0 0-1.506 0z"/>
                                                        </svg>
                                                        <svg ng-click="find(true, 'tax-desc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-down-fill sort-image" viewBox="0 0 16 16">
                                                            <path d="M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z"/>
                                                        </svg>
                                                    </span>
                                                    <span ng-if="filters.sort == 'tax-asc' || filters.sort == 'tax-desc'" style="display: inline-flex;" class="flex-dc">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-filter" viewBox="0 0 16 16">
                                                            <path d="M6 10.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5z"/>
                                                        </svg>
                                                    </span>
                                                </div>
                                                
                                            </th>
                                            <th ng-show="countSelected == 0">
                                                <div class="flex-b align-c align-l">
                                                    Payment Gate Fee
                                                    <span style="display: inline-flex;" class="flex-dc">
                                                        <svg ng-click="find(true, 'paymen_gate_fee-asc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-up-fill sort-image" viewBox="0 0 16 16">
                                                            <path d="m7.247 4.86-4.796 5.481c-.566.647-.106 1.659.753 1.659h9.592a1 1 0 0 0 .753-1.659l-4.796-5.48a1 1 0 0 0-1.506 0z"/>
                                                        </svg>
                                                        <svg ng-click="find(true, 'paymen_gate_fee-desc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-down-fill sort-image" viewBox="0 0 16 16">
                                                            <path d="M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z"/>
                                                        </svg>
                                                    </span>
                                                    <span ng-if="filters.sort == 'paymen_gate_fee-asc' || filters.sort == 'paymen_gate_fee-desc'" style="display: inline-flex;" class="flex-dc">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-filter" viewBox="0 0 16 16">
                                                            <path d="M6 10.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5z"/>
                                                        </svg>
                                                    </span>
                                                </div>
                                                
                                            </th>
                                            <th ng-show="countSelected == 0">
                                                <div class="flex-b align-c align-l">
                                                    Shipping Fee
                                                    <span style="display: inline-flex;" class="flex-dc">
                                                        <svg ng-click="find(true, 'shipping_fee-asc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-up-fill sort-image" viewBox="0 0 16 16">
                                                            <path d="m7.247 4.86-4.796 5.481c-.566.647-.106 1.659.753 1.659h9.592a1 1 0 0 0 .753-1.659l-4.796-5.48a1 1 0 0 0-1.506 0z"/>
                                                        </svg>
                                                        <svg ng-click="find(true, 'shipping_fee-desc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-down-fill sort-image" viewBox="0 0 16 16">
                                                            <path d="M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z"/>
                                                        </svg>
                                                    </span>
                                                    <span ng-if="filters.sort == 'shipping_fee-asc' || filters.sort == 'shipping_fee-desc'" style="display: inline-flex;" class="flex-dc">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-filter" viewBox="0 0 16 16">
                                                            <path d="M6 10.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5z"/>
                                                        </svg>
                                                    </span>
                                                </div>
                                                
                                            </th>
                                            <th ng-show="countSelected == 0">
                                                <div class="flex-b align-c align-l">
                                                    Shipping Fee Cost
                                                    <span style="display: inline-flex;" class="flex-dc">
                                                        <svg ng-click="find(true, 'shipping_fee_cost-asc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-up-fill sort-image" viewBox="0 0 16 16">
                                                            <path d="m7.247 4.86-4.796 5.481c-.566.647-.106 1.659.753 1.659h9.592a1 1 0 0 0 .753-1.659l-4.796-5.48a1 1 0 0 0-1.506 0z"/>
                                                        </svg>
                                                        <svg ng-click="find(true, 'shipping_fee_cost-desc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-down-fill sort-image" viewBox="0 0 16 16">
                                                            <path d="M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z"/>
                                                        </svg>
                                                    </span>
                                                    <span ng-if="filters.sort == 'shipping_fee_cost-asc' || filters.sort == 'shipping_fee_cost-desc'" style="display: inline-flex;" class="flex-dc">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-filter" viewBox="0 0 16 16">
                                                            <path d="M6 10.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5z"/>
                                                        </svg>
                                                    </span>
                                                </div>
                                                
                                            </th>
                                            <th ng-show="countSelected == 0">
                                                <div class="flex-b align-c align-l">
                                                    Total Fee
                                                    <span style="display: inline-flex;" class="flex-dc">
                                                        <svg ng-click="find(true, 'total_fee-asc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-up-fill sort-image" viewBox="0 0 16 16">
                                                            <path d="m7.247 4.86-4.796 5.481c-.566.647-.106 1.659.753 1.659h9.592a1 1 0 0 0 .753-1.659l-4.796-5.48a1 1 0 0 0-1.506 0z"/>
                                                        </svg>
                                                        <svg ng-click="find(true, 'total_fee-desc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-down-fill sort-image" viewBox="0 0 16 16">
                                                            <path d="M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z"/>
                                                        </svg>
                                                    </span>
                                                    <span ng-if="filters.sort == 'total_fee-asc' || filters.sort == 'total_fee-desc'" style="display: inline-flex;" class="flex-dc">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-filter" viewBox="0 0 16 16">
                                                            <path d="M6 10.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5z"/>
                                                        </svg>
                                                    </span>
                                                </div>
                                            </th>
                                            <th ng-show="countSelected == 0">
                                                <div class="flex-b align-c align-l">
                                                    Order Time
                                                    <span style="display: inline-flex;" class="flex-dc">
                                                        <svg ng-click="find(true, 'order_time-asc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-up-fill sort-image" viewBox="0 0 16 16">
                                                            <path d="m7.247 4.86-4.796 5.481c-.566.647-.106 1.659.753 1.659h9.592a1 1 0 0 0 .753-1.659l-4.796-5.48a1 1 0 0 0-1.506 0z"/>
                                                        </svg>
                                                        <svg ng-click="find(true, 'order_time-desc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-down-fill sort-image" viewBox="0 0 16 16">
                                                            <path d="M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z"/>
                                                        </svg>
                                                    </span>
                                                    <span ng-if="filters.sort == 'order_time-asc' || filters.sort == 'order_time-desc'" style="display: inline-flex;" class="flex-dc">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-filter" viewBox="0 0 16 16">
                                                            <path d="M6 10.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5z"/>
                                                        </svg>
                                                    </span>
                                                </div>
                                            </th>
                                            <th ng-show="countSelected > 0" colspan="4">
                                                <div class="btn-group" style="position: inherit;">
                                                    <a href="javascript:;" class="btn btn-default" ng-show="countSelected > 0" ng-click="removeItems()" data-toggle="tooltip" title="Xóa tất cả sản phẩm đã chọn">
                                                        <i class="fa fa-fw fa-trash-o"></i>
                                                    </a>
                                                </div>
                                            </th>
                                        </tr>
                                    </thead>
                                    <?php 
                                        $locate = env('APP_LOCALE');
                                        $apiUrl = '';
                                        if ($locate == 'us' || $locate == null) {
                                            $locate = '';
                                            $apiUrl .= 'https://' . $apiDomain;
                                        } else {
                                            $locate = '/' . $locate;
                                            $apiUrl .= 'https://'. $locate . '.' . $apiDomain;
                                        }
                                    ?>
                                    <tbody class="striped-row">
                                        <tr  ng-repeat="item in items" ng-if="items.length && !isLoading">
                                            <td>
                                                @{{$index + 1}}
                                            </td> 
                                            <td>
                                                <input type="checkbox"
                                                    ng-change="checkedItem()"
                                                    ng-true-value="1" ng-false-value="0"
                                                    ng-model="item.is_checked"/>
                                            </td>   
                                            <td>
                                                <a href="{{$locate}}/admin/orders?id=@{{item.order_id}}" target="_blank">
                                                    @{{item.code}}
                                                </a>
                                            </td>
                                            <td align="right">
                                                @{{item.profit}}
                                            </td>
                                            <td align="right">
                                                @{{item.amount}}
                                            </td>
                                            <td align="right">
                                                @{{item.ratio_profit}} %
                                            </td>
                                            <td align="right">
                                                @{{item.tax}}
                                            </td>
                                            <td align="right">
                                                @{{item.payment_gate_fee}}
                                            </td>
                                            <td align="right">
                                                @{{item.shipping_fee}}
                                            </td>
                                            <td align="right">
                                                @{{item.shipping_fee_cost}}
                                            </td>
                                            <td align="right">
                                                @{{item.total_fee}}
                                            </td>
                                            <td>
                                                @{{item.order_time}}
                                            </td>
                                            <td>
                                                <a href="{{$apiUrl}}/api/get-profit-info?code=@{{item.code}}" target="_blank">
                                                    Check
                                                </a>
                                            </td>
                                        </tr>
                                        <tr ng-if="items.length == 0 && !isLoading">
                                            <td colspan="6">Không có đơn hàng nào</td>
                                        </tr>
                                        <tr ng-if="isLoading">
                                            <td colspan="6" class="text-center">
                                                <div class="empty-contain flex-box align-c flex-c">
                                                    <img src="/images/loading.gif" alt="">
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.box-body -->
                <div class="box-footer clearfix">
                    <div class="pull-right">
                        @include('warehouse-pod::system.includes.paginator', [
                                        "accessPageId" => "filters.page_id",
                                        "accessPagesCount" => "pagesCount",
                                        "accessFind" => "find()"
                            ])
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('warehouse-pod::system.product.modal')
</div>
@endsection
