@extends('system.layout.main')
@section('title')
<title>Cấu hình Sản phẩm - Nhà in</title>
@endsection
@section('css')
<style type="text/css">
 .header {
        margin-bottom: 25px;
 }

button.add {
    margin-top: 30px;
}
.chosen-container {
    width: 100%!important;
}
.chosen-container > .chosen-choices {
    line-height: 34px;
}

.chosen-single{
    height: 34px!important;
}

.chosen-container > .chosen-choices {
    border-radius: 3px !important;
    min-height: 34px !important;
    border: 1px solid #ced4da;
}
.search-field > input {
    width: 100%!important;
}
</style>
<link rel="stylesheet" type="text/css" href="/modules/warehouse-pod/css/custom.css?v=<?= time() ?>" />
@endsection
@section('script')
<script>
    var printings = <?= json_encode($printings) ?>;
    var categories = <?= json_encode($categories) ?>;
    var options = <?= json_encode($options) ?>;
    var styles = <?= json_encode($styles) ?>;
</script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>
<script src="/system/js/controllers/pagination/pagination-controller.js" charset="utf-8"></script>
<script type="text/javascript" src="{{ Module::asset('warehouse-pod/js/warehouse-product-print-controller.js') }}?v=<?= Config::get("sa.version") ?>"></script>
@endsection
@section('content')
<div class="content" ng-controller="WarehouseProductPrintController">
    <div class="index">
        <div class="header">
            <div class="pull-left">
                <h3 class="">Cấu hình Sản phẩm - Nhà in</h3>
            </div>
            <button 
                    type="button" 
                    name="button" 
                    class="btn btn-success pull-right"
                    style="margin-top: 20px;"
                    ng-click="openModal(null)"
                >
                    <i class="fa fa-fw fa-plus-square-o"></i> <b>Thêm Sản phẩm - Nhà in</b>
            </button>
            <div class="clearfix">
            </div>
        </div>
        <div class="body">
            <div class="box no-border">
                <!-- /.box-header -->
                <div class="box-body" style="margin-bottom: 10px;">
                    <div class="row">
                        <div class="col-md-4">
                            <input type="text" ng-model="filters.keyword" class="form-control" placeholder="Nhập từ khóa tìm kiếm sản phẩm" ng-keydown="$event.keyCode === 13 && find(true)" />
                        </div>
                        <div class="col-md-2">
                            <select name="" class="form-control" ng-change="find(true)" ng-model="filters.printing_code" ng-options="key as value for (key, value) in printings">
                                <option value="">Tất cả nhà in</option>
                            </select>
                        </div>
                    </div>
                    <div class="row" style="margin-top: 20px;">
                        <div class="col-md-12">
                            <button type="button" class="btn btn-primary " ng-click="find()">
                                <i class="fa fa-search"></i>
                                Tìm kiếm
                            </button>
                            <button type="button" class="btn btn-default ml-3 " ng-click="clear()">
                                <i class="fa fa-refresh"></i>
                                Xóa form
                            </button>
                        </div>
                    </div>
                    <div class="row" style="margin-top: 20px;">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Danh mục</th>
                                            <th>Nhà in</th>
                                            <th style="width: 50%">Style</th>
                                            <th style="width: 80px;"></th>
                                        </th>
                                        </tr>
                                    </thead>
                                    <tbody class="striped-row">
                                        <tr  ng-repeat="item in items" ng-if="items.length && !isLoading">
                                            <td>
                                                @{{$index + 1}}
                                            </td> 
                                            <td>
                                                @{{ categories[item.category_id] }}
                                            </td>
                                            <td>
                                                @{{ printings[item.print_id] }}
                                            </td>
                                            <td>
                                                <span class="label label-success" style="margin-right: 5px;" ng-repeat="style in item.styles">@{{ style.name }}</span>
                                            </td>
                                            <td>
                                                <a href="javascript:;" class="btn btn-danger" ng-click="removeItem(item)" data-toggle="tooltip" title="Xóa cấu hình">
                                                    <i class="fa fa-fw fa-trash-o"></i>
                                                </a>
                                            </td>
                                        </tr>
                                        <tr ng-if="items.length == 0 && !isLoading">
                                            <td colspan="6">Không có cấu hình nào</td>
                                        </tr>
                                        <tr ng-if="isLoading">
                                            <td colspan="6" class="text-center">
                                                <div class="empty-contain flex-box align-c flex-c">
                                                    <img src="/images/loading.gif" alt="">
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.box-body -->
                <div class="box-footer clearfix">
                    <div class="pull-right">
                        @include('warehouse-pod::system.includes.paginator', [
                                        "accessPageId" => "filters.page_id",
                                        "accessPagesCount" => "pagesCount",
                                        "accessFind" => "find()"
                            ])
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('warehouse-pod::system.product-print.modal')
</div>
@endsection
