@extends('system.layout.main')
@section('title')
<title>Cấu hình Sản phẩm - Kho vận</title>
@endsection
@section('css')
<style type="text/css">
 .header {
        margin-bottom: 25px;
 }

button.add {
    margin-top: 30px;
}
.chosen-container {
    width: 100%!important;
}
.chosen-container > .chosen-choices {
    line-height: 34px;
}

.chosen-single{
    height: 34px!important;
}

.chosen-container > .chosen-choices {
    border-radius: 3px !important;
    min-height: 34px !important;
    border: 1px solid #ced4da;
}
.search-field > input {
    width: 100%!important;
}
</style>
<link rel="stylesheet" type="text/css" href="/modules/warehouse-pod/css/custom.css?v=<?= time() ?>" />
@endsection
@section('script')
<script>
    var printings = <?= json_encode($printings) ?>;
    var warehouses = <?= json_encode($warehouses) ?>;
    var warehouseActives = <?= json_encode($warehouseActives)?>;
</script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>
<script src="/system/js/controllers/pagination/pagination-controller.js" charset="utf-8"></script>
<script type="text/javascript" src="{{ Module::asset('warehouse-pod/js/warehouse-product-controller.js') }}?v=<?= Config::get("sa.version") ?>"></script>
@endsection
@section('content')
<div class="content" ng-controller="WarehouseProductController">
    <div class="index">
        <div class="header">
            <div class="pull-left">
                <h3 class="">Cấu hình Sản phẩm - Kho vận</h3>
            </div>
            <button 
                    type="button" 
                    name="button" 
                    class="btn btn-success pull-right"
                    style="margin-top: 20px;"
                    ng-click="openModal(null)"
                >
                    <i class="fa fa-fw fa-plus-square-o"></i> <b>Thêm Sản phẩm - Kho vận</b>
            </button>
            <div class="clearfix">
            </div>
        </div>
        <div class="body">
            <div class="box no-border">
                <!-- /.box-header -->
                <div class="box-body" style="margin-bottom: 10px;">
                    <div class="row">
                        <div class="col-md-4">
                            <input type="text" ng-model="filters.keyword" class="form-control" placeholder="Nhập từ khóa tìm kiếm sản phẩm" ng-keydown="$event.keyCode === 13 && find(true)" />
                        </div>
                        <div class="col-md-2">
                            <select name="" class="form-control" ng-change="find(true)" ng-model="filters.warehouse_id" ng-options="key as value for (key, value) in warehouses">
                                <option value="">Tất cả kho</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select name="" class="form-control" ng-change="find(true)" ng-model="filters.printing_code" ng-options="key as value for (key, value) in printings">
                                <option value="">Tất cả nhà in</option>
                            </select>
                        </div>
                    </div>
                    <div class="row" style="margin-top: 20px;">
                        <div class="col-md-12">
                            <button type="button" class="btn btn-primary " ng-click="find()">
                                <i class="fa fa-search"></i>
                                Tìm kiếm
                            </button>
                            <button type="button" class="btn btn-default ml-3 " ng-click="clear()">
                                <i class="fa fa-refresh"></i>
                                Xóa form
                            </button>
                        </div>
                    </div>
                    <div class="row" style="margin-top: 20px;">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>
                                                <input type="checkbox"
                                                ng-change="checkAll()" 
                                                ng-true-value="1" ng-false-value="0"
                                                ng-model="checkedAll"
                                                ng-disabled="isLoading"
                                                style="margin-bottom: 5px;"
                                                />
                                            </th>
                                            <th ng-show="countSelected == 0">Kho</th>
                                            <th ng-show="countSelected == 0">Nhà in </th>
                                            <th ng-show="countSelected == 0">Sản phẩm</th>
                                            <th ng-show="countSelected == 0">Ảnh</th>
                                            <th ng-show="countSelected == 0"></th>
                                            <th ng-show="countSelected > 0" colspan="4">
                                            <div class="btn-group" style="position: inherit;">
                                                <a href="javascript:;" class="btn btn-default" ng-show="countSelected > 0" ng-click="removeItems()" data-toggle="tooltip" title="Xóa tất cả sản phẩm đã chọn">
                                                    <i class="fa fa-fw fa-trash-o"></i>
                                                </a>
                                            </div>
                                        </th>
                                        </tr>
                                    </thead>
                                    <tbody class="striped-row">
                                        <tr  ng-repeat="item in items" ng-if="items.length && !isLoading">
                                            <td>
                                                @{{$index + 1}}
                                            </td> 
                                            <td>
                                                <input type="checkbox"
                                                    ng-change="checkedItem()"
                                                    ng-true-value="1" ng-false-value="0"
                                                    ng-model="item.is_checked"/>
                                            </td>   
                                            <td>
                                                @{{item.warehouse_name}}
                                            </td>
                                            <td>
                                                @{{printings[item.printing_code]}}
                                            </td>
                                            <td>
                                                <a href="/@{{item.slug}}" target="_blank">
                                                    @{{item.name}}
                                                    <p>SKU: @{{item.sku}}</p>
                                                </a>
                                            </td>
                                            <td>
                                                <img src="@{{item.image_url}}" style="max-width: 50px;"/>
                                            </td>
                                            <td>
                                            </td>
                                        </tr>
                                        <tr ng-if="items.length == 0 && !isLoading">
                                            <td colspan="6">Không có cấu hình nào</td>
                                        </tr>
                                        <tr ng-if="isLoading">
                                            <td colspan="6" class="text-center">
                                                <div class="empty-contain flex-box align-c flex-c">
                                                    <img src="/images/loading.gif" alt="">
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.box-body -->
                <div class="box-footer clearfix">
                    <div class="pull-right">
                        @include('warehouse-pod::system.includes.paginator', [
                                        "accessPageId" => "filters.page_id",
                                        "accessPagesCount" => "pagesCount",
                                        "accessFind" => "find()"
                            ])
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('warehouse-pod::system.product.modal')
</div>
@endsection
