<div class="modal fade" id="modalForm" tabindex="-1">
    <div class="modal-dialog" style="width:65%;">
        <div class="modal-content" style="border-radius: 5px;">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">
                    <i class="fa fa-config-o"></i>
                    <span>
                        Thêm sản phẩm thuộc kho
                    </span>
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label>Chọn kho</label>
                            <div style="padding: 0 10px 0 10px;">
                                <select class="form-control" 
                                    style="width: 100%;" 
                                    chosen
                                    ng-model="item.warehouse_id"
                                    ng-options="key as value for (key, value) in warehouseActives"
                                    aria-hidden="true">
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label>Tìm sản phẩm</label>
                            <div class="form-group" style="width: 100%;">
                                <span class="select2-container select2-container--default select2-container--open" style="width: 100%;">
                                    <span class="select2-dropdown" dir="ltr" style="width: 100%; position: initial; top: auto; border-radius: 2px;">
                                        <span class="select2-search select2-search--dropdown">
                                            <input class="select2-search__field" 
                                                                style="padding: 4px;" 
                                                                type="search" 
                                                                autocomplete="off" 
                                                                autocorrect="off" 
                                                                autocapitalize="none" 
                                                                spellcheck="false" 
                                                                role="textbox" 
                                                                placeholder="Tìm sản phẩm cần áp dụng"
                                                                ng-model="warehouse.keyword"
                                                                ng-keyup="suggestion('buy')"
                                                                \>
                                        </span>
                                    </span>
                                    <span class="select2-results" ng-show="showSuggestion" style="position: absolute; top: 100%; width: 100%; background: #fff; box-shadow: 0 0 3px rgba(11, 11, 11, 0.5); border-radius: 0 0 4px 4px; z-index: 9999;">
                                        <div class="box-body table-responsive no-padding">
                                            <div style="max-height: 250px; overflow-y: auto; overflow-x: hidden">
                                                <table class="table table-hover">
                                                    <tbody>
                                                        <tr>
                                                            <th>#</th>
                                                            <th>Ảnh</th>
                                                            <th>Tên sản phẩm</th>
                                                        </tr>
                                                        <tr ng-repeat="item in itemSuggestions">
                                                            <td style="width: 10px;"><input type="checkbox" ng-model="item.is_checked" ng-true-value="1" ng-false-value="0"/></td>
                                                            <td>
                                                                <img src="@{{item.image_url}}" style="height: 30px;"/>
                                                            </td>
                                                            <td>@{{item.name}}</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                            <div class="pull-right" style="margin: 6px; background: #fff;width: 100%;display: flex;justify-content: flex-end;padding: 6px;margin-bottom: 20px;">
                                                <button type="button" class="btn btn-primary" ng-click="applyItem()" id="btn-save-2" style="margin-right: 5px;"><i class="fa fa-fw fa-check-square"></i> Chọn</button>
                                                <button type="button" class="btn btn-default" ng-click="cancelSuggestion()" id="btn-cancel"><i class="fa fa-times"></i> Hủy</button>
                                            </div>
                                        </div>
                                    </span>
                                </span>

                                <div class="box-body table-responsive no-padding" ng-show="item.apply_product.length > 0" style="max-height: 400px; overflow-y: auto; overflow-x: hidden">
                                    <table class="table table-hover">
                                        <tbody>
                                            <tr>
                                                <th>#</th>
                                                <th>Ảnh</th>
                                                <th>Tên sản phẩm</th>
                                                <th></th> 
                                            </tr>
                                            <tr ng-repeat="it in item.apply_product">
                                                <td>@{{$index + 1 }}</td>
                                                <td>
                                                    <img src="@{{it.image_url}}" style="height: 30px;"/>
                                                </td>
                                                <td>@{{it.name}}</td>
                                                <td>
                                                    <button type="button" class="btn btn-danger btn-sm" title="Xóa sản phẩm" ng-click="deleteApplyItem($index);">
                                                        <i class="fa fa-trash" aria-hidden="true"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" ng-click="save(item)" class="btn btn-primary">Lưu</button>
            </div>
        </div>
    </div>
</div>
