<div id="addLocationProductModal" class="modal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title">Location Product Variant</h3>
                <button type="button" class="close" ng-click="closeCreateLocationProducts()">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" style="max-height: 70vh; overflow-y: auto;">
                <table class="table table-bordered" aria-disabled="false">
                    <tbody>
                        <tr>
                            <td style="width: 20%;">
                                <div role="button" tabindex="0">
                                    <select disabled chosen multiple class="form-control chosen-select" ng-change="addOption(size)" ng-model="provider.sizes" ng-options="size.id as size.name for size in sizeOptions" create-option-text="'Create variant'" persistent-create-option="true" create-option="createVariantOption">
                                    </select>
                                </div>
                            </td>
                            <td style="width: 20%;">
                                <div role="button" tabindex="0">
                                    <select disabled chosen multiple class="form-control" ng-change="addOption(color)" ng-model="provider.colors" ng-options="color.id as color.name for color in colorOptions" create-option-text="'Create variant'" persistent-create-option="true" create-option="createVariantOption">
                                    </select>
                                </div>
                            </td>
                        </tr>
                        <tr ng-show="provider.colors.length > 0 || provider.sizes.length > 0">
                            <td>Size</td>
                            <td>Color</td>
                            <td style="width: 10%;">Production min time</td>
                            <td style="width: 10%;">Production max time</td>
                            <td style="width: 10%;">Shipping min time</td>
                            <td style="width: 10%;">Shipping max time</td>
                            <td style="width: 10%;">First item</td>
                            <td style="width: 10%;">Additional item</td>
                        </tr>
                        <tr ng-repeat="(key, item) in providerLocation.products">
                            <td>
                                <div role="button" tabindex="0">
                                    @{{ item.size_id ? sizeOptionsById[item.size_id] : "-" }}
                                </div>
                            </td>
                            <td>
                                <div role="button" tabindex="0">
                                    @{{ item.color_id ? colorOptionsById[item.color_id] : "-" }}
                                </div>
                            </td>
                            <td>
                                <div class="input-group">
                                    <input type="text" placeholder="days" class="form-control" aria-invalid="false" ng-model="item.production_min_time" ng-focus="removeBlur($event)" ng-blur="handleBlur($event)">
                                </div>
                            </td>
                            <td>
                                <div class="input-group">
                                    <input type="text" placeholder="days" class="form-control" aria-invalid="false" ng-model="item.production_max_time" ng-focus="removeBlur($event)" ng-blur="handleBlur($event)">
                                </div>
                            </td>
                            <td>
                                <div class="input-group">
                                    <input type="text" placeholder="days" class="form-control" aria-invalid="false" ng-model="item.shipping_min_time" ng-focus="removeBlur($event)" ng-blur="handleBlur($event)">
                                </div>
                            </td>
                            <td>
                                <div class="input-group">
                                    <input type="text" placeholder="days" class="form-control" aria-invalid="false" ng-model="item.shipping_max_time" ng-focus="removeBlur($event)" ng-blur="handleBlur($event)">
                                </div>
                            </td>
                            <td>
                                <div class="input-group">
                                    <input type="text" class="form-control" aria-invalid="false" ng-model="item.shipping_fee" ng-focus="removeBlur($event)" ng-blur="handleBlur($event)">
                                </div>
                            </td>
                            <td>
                                <div class="input-group">
                                    <input type="text" class="form-control" aria-invalid="false" ng-model="item.adding_fee" ng-focus="removeBlur($event)" ng-blur="handleBlur($event)">
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="btn-save-2" ng-click="saveLocationProducts()" ng-disabled="isLoading">
                    <i class="fa fa-save"></i> Save
                </button>
                <button type="button" class="btn btn-default" id="btn-cancel" ng-click="closeCreateLocationProducts()">
                    <i class="fa fa-times"></i> Cancel
                </button>
            </div>
        </div>
    </div>
</div>