<div id="addProductModal" class="modal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title">Product Variant</h3>
                <button type="button" class="close" ng-click="closeCreateProducts()">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="card">
                    <div class="sb-variants">
                        <div class="box-body-addnew tab-content">
                            <div class="tab-pane active">
                                <table class="table table-bordered" aria-disabled="false">
                                    <tbody>
                                        <tr>
                                            <td style="width: 30%;">
                                                <div role="button" tabindex="0">
                                                    <select chosen multiple class="form-control chosen-select" ng-change="addOption(size)" ng-model="provider.sizes" ng-options="size.id as size.name for size in sizeOptions" create-option-text="'Create variant'" persistent-create-option="true" create-option="createVariantOption">
                                                    </select>
                                                </div>
                                            </td>
                                            <td style="width: 30%;">
                                                <div role="button" tabindex="0">
                                                    <select chosen multiple class="form-control" ng-change="addOption(color)" ng-model="provider.colors" ng-options="color.id as color.name for color in colorOptions" create-option-text="'Create variant'" persistent-create-option="true" create-option="createVariantOption">
                                                    </select>
                                                </div>
                                            </td>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                        <tr ng-show="provider.colors.length > 0 || provider.sizes.length > 0">
                                            <td>Size</td>
                                            <td>Color</td>
                                            <td>Cost</td>
                                            <td>Instock</td>
                                        </tr>
                                        <tr ng-repeat="(key, item) in provider.products">
                                            <td>
                                                <div role="button" tabindex="0">
                                                    @{{ item.size_id ? sizeOptionsById[item.size_id] : "-" }}
                                                </div>
                                            </td>
                                            <td>
                                                <div role="button" tabindex="0">
                                                    @{{ item.color_id ? colorOptionsById[item.color_id] : "-" }}
                                                </div>
                                            </td>
                                            <td>
                                                <div class="input-group">
                                                    <input type="text" class="form-control" aria-invalid="false" awnum="price" ng-model="item.cost" ng-focus="removeBlur($event)" ng-blur="handleBlur($event)">
                                                </div>
                                            </td>
                                            <td>
                                                <div class="input-group">
                                                    <div class="edit-config-action">
                                                        <label class="show-variables-label" for="enable-edit-@{{ key }}">
                                                            <input type="checkbox" name="" id="enable-edit-@{{ key }}" class="show-variables-input" ng-model="item.instock" ng-true-value="1" ng-false-value="0">
                                                            <div class="show-variables-toggle">
                                                                <span></span>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="btn-save-2" ng-click="saveProducts()" ng-disabled="isLoading">
                    <i class="fa fa-save"></i> Save
                </button>
                <button type="button" class="btn btn-default" id="btn-cancel" ng-click="closeCreateProducts()">
                    <i class="fa fa-times"></i> Cancel
                </button>
            </div>
        </div>
    </div>
</div>