<div class="tab-pane fade @{{ tab == 'location' ? 'active in' : '' }}">
    <div class="form-search-location">
        <div class="row" style=" display: flex; align-items: flex-end; margin-top: 15px;">
            <div class="col-md-6">
                <div class="form-group">
                    <label>Search</label>
                    <input type="text" class="form-control" placeholder="keyword" aria-invalid="false" ng-model="filters.keyword">
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label>Status</label>
                    <select class="form-control" ng-change="findLocation(true)" ng-model="filters.status" ng-options="key as value for (key, value) in statusses">
                        <option value="">Select status</option>
                    </select>
                </div>
            </div>
            <div class="col-md-3 text-right">
                <div class="form-group">
                    <button type="button" class="btn btn-primary" ng-click="findLocation()" ng-disabled="isLoading">
                        <i class="fa fa-search"></i> Find </button>
                    <button type="button" class="btn btn-primary" ng-click="openModalCloneLocation()" ng-disabled="isLoading">
                        <i class="fa fa-search"></i> Clone </button>
                    <button type="button" class="btn btn-default ml-3 " ng-click="clearLocation()" ng-disabled="isLoading">
                        <i class="fa fa-refresh"></i> Clear </button>
                </div>
            </div>
        </div>
    </div>
    <div class="form-list-location">
        <div class="row">
            <div class="col-md-12">
                <h4>Danh sách location</h4>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th></th>
                                <th>Name</th>
                                <th>Status</th>
                                <th>Shipping type</th>
                                <th>Country</th>
                                <th class="text-center">Production time (days)</th>
                                <th class="text-center">Shipping time (days)</th>
                                <th class="text-center">First item</th>
                                <th class="text-center">Additional item</th>
                            </tr>
                        </thead>
                        <tbody class="striped-row">
                            <tr ng-repeat="item in warehouseProviderLocations">
                                <td>@{{ $index + 1 }}</td>
                                <td>@{{ item.name }}</td>
                                <td>
                                    <span class="stt-active" ng-if="item.status == 'ACTIVE'">Active</span>
                                    <span class="stt-no-active" ng-if="item.status == 'INACTIVE'">Inactive</span>
                                </td>
                                <td class="text-center">
                                    @{{ item.shipping_type }}
                                </td>
                                <td class="text-center">
                                    @{{ countries[item.country_id] }}
                                </td>
                                <td class="text-center">
                                    @{{ item.production_min_time }} - @{{ item.production_max_time }}
                                </td>
                                <td class="text-center">
                                    @{{ item.shipping_min_time }} - @{{ item.shipping_max_time }}
                                </td>
                                <td class="text-center">
                                    @{{ item.shipping_fee }}
                                </td>
                                <td class="text-center">
                                    @{{ item.adding_fee }}
                                </td>
                                <td class="text-right">
                                    <button type="button" name="button" class="btn" ng-click="openModalCreateLocationProducts(provider, item)">
                                        <i class="fa fa-tags"></i>
                                    </button>
                                    <button type="button" name="button" class="btn" ng-click="openModalCreateLocation(provider, item)">
                                        <i class="fa fa-pencil"></i>
                                    </button>
                                    <button type="button" name="button" class="btn" ng-click="deleteProviderLocation(item)">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <div class="box-footer clearfix">
                        <div class="pull-right">
                            @include('warehouse-pod::system.includes.paginator', [
                            "accessPageId" => "filters.page_id",
                            "accessPagesCount" => "pagesCount",
                            "accessFind" => "find()"
                            ])
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>