<div class="tab-pane fade @{{ tab == 'products' ? 'active in' : '' }}" ng-show="tab == 'products'">
    <div class="form-list-product">
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label>Product name</label>
                    <input type="text" class="form-control" placeholder="Name" aria-invalid="false" ng-model="provider.name">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>Supplier</label>
                    <select chosen class="form-control" ng-model="provider.supplier_id" ng-options="key as value for (key, value) in printings">
                    </select>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label>Provider info</label>
                    <select chosen class="form-control" ng-model="provider.provider_info_id" ng-options="item.id as item.name for item in providerInfos" create-option-text="'Create provider info'" persistent-create-option="true" create-option="createProviderInfo">
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>Status</label>
                    <select class="form-control" ng-change="find(true)" ng-model="provider.status" ng-options="key as value for (key, value) in statusses">
                    </select>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label>Category ({{  config("app.name", 'Printerval') }})</label>
                    <select chosen class="form-control" ng-model="provider.category_id" ng-options="key as value for (key, value) in categories">
                        <option value="">Select category</option>
                    </select>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="form-group pull-right">
                    <button type="button" class="btn btn-primary" id="btn-save-2" ng-click="saveCreateProvider()" ng-disabled="isLoading">
                        <i class="fa fa-save"></i> Save
                    </button>
                </div>
            </div>
        </div>
    </div>
    <div class="form-list-product">
        <div class="row">
            <div class="col-md-12">
                <h4>{{  config("app.name", 'Printerval') }} variant</h4>
            </div>
            <div class="col-md-12" ng-repeat="option in provider.mappingVariant">
                <div class="form-group">
                    <div class="col-md-3">
                        <select class="form-control" chosen style="width: 100%;" ng-model="option.option" ng-options="item.name for item in options track by item.id" ng-change="chooseOption(option, $index)" aria-hidden="true">
                        </select>
                    </div>
                    <div class="col-md-3">
                        <select class="form-control" chosen multiple style="width: 100%;" ng-model="option.variant_ids" ng-options="k as value for (k, value) in option.variants" aria-hidden="true">
                        </select>
                    </div>
                    <div class="col-md-3">
                        <button type="button" name="button" class="btn" ng-click="deleteMappingVariant(option, $index)">
                            <i class="fa fa-trash"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="col-md-12">
                <div class="form-group">
                    <div class="col-md-3">
                        <button type="button" name="button" class="btn btn-green-light" ng-click="addMappingOption()">
                            <b>Add variant</b>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <h4>Provider variants</h4>
                <table class="table table-bordered" aria-disabled="false">
                    <tbody>
                        <tr>
                            <td style="width: 30%;">
                                <div role="button" tabindex="0">
                                    <select chosen multiple class="form-control chosen-select" ng-change="addOption(size)" ng-model="provider.sizes" ng-options="size.id as size.name for size in sizeOptions" create-option-text="'Create variant size'" persistent-create-option="true" create-option="createVariantSizeOption">
                                    </select>
                                </div>
                            </td>
                            <td style="width: 30%;">
                                <div role="button" tabindex="0">
                                    <select chosen multiple class="form-control" ng-change="addOption(color)" ng-model="provider.colors" ng-options="color.id as color.name for color in colorOptions" create-option-text="'Create variant color'" persistent-create-option="true" create-option="createVariantColorOption">
                                    </select>
                                </div>
                            </td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr ng-show="provider.colors.length > 0 || provider.sizes.length > 0">
                            <td>Size</td>
                            <td>Color</td>
                            <td>Cost</td>
                            <td>Instock</td>
                        </tr>
                        <tr ng-repeat="(key, item) in provider.products">
                            <td>
                                <div role="button" tabindex="0">
                                    @{{ item.size_id ? sizeOptionsById[item.size_id] : "-" }}
                                </div>
                            </td>
                            <td>
                                <div role="button" tabindex="0">
                                    @{{ item.color_id ? colorOptionsById[item.color_id] : "-" }}
                                </div>
                            </td>
                            <td>
                                <div class="input-group">
                                    <input type="text" class="form-control" aria-invalid="false" awnum="price" ng-model="item.cost" ng-focus="removeBlur($event)" ng-blur="handleBlur($event)">
                                </div>
                            </td>
                            <td>
                                <div class="input-group">
                                    <div class="edit-config-action">
                                        <label class="show-variables-label" for="enable-edit-@{{ key }}">
                                            <input type="checkbox" name="" id="enable-edit-@{{ key }}" class="show-variables-input" ng-model="item.instock" ng-true-value="1" ng-false-value="0">
                                            <div class="show-variables-toggle">
                                                <span></span>
                                            </div>
                                        </label>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="pull-right">
                    <button type="button" class="btn btn-primary" id="btn-save-2" ng-click="saveProducts()" ng-disabled="isLoading">
                        <i class="fa fa-save"></i> Save
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>