@extends('system.layout.main')
@section('title')
<title>Warehouse Provider</title>
@endsection
@section('css')
<link rel="stylesheet" type="text/css" href="/modules/warehouse-pod/css/s-provider.css?v=<?= time() ?>" />
<link rel="stylesheet" type="text/css" href="/modules/warehouse-pod/css/custom.css?v=<?= time() ?>" />
@endsection
@section('script')
<script>
    var countries = <?= json_encode($countries) ?>;
    var printings = <?= json_encode($printings) ?>;
    var categories = <?= json_encode($categories) ?>;
    var options = <?= json_encode($options) ?>;
    var isDetail = '<?= $isDetail ? 1 : 0 ?>';
</script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">
<script src="/system/js/scripts/combinatorics.js?v={{ config('sa.version') }}" charset="utf-8"></script>
<script src="/system/js/scripts/chosen-add-option.js?v={{ config('sa.version') }}" charset="utf-8"></script>
<script src="/system/js/scripts/angular-chosen-search.js?v={{ config('sa.version') }}" charset="utf-8"></script>
<script src="/system/js/scripts/dynamic-number.min.js?v={{ config('sa.version') }}" charset="utf-8"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>
<script src="/system/js/controllers/pagination/pagination-controller.js" charset="utf-8"></script>
<script type="text/javascript" src="{{ Module::asset('warehouse-pod/js/warehouse-provider-controller.js') }}?v=<?= time() ?>"></script>
@endsection
@section('content')

<div class="content" ng-controller="WarehouseProviderController">
    <div class="index">
        <div class="header">
            <div class="pull-left">
                <h3 class="">Provider Management</h3>
            </div>
            <button type="button" name="button" class="btn btn-success pull-right" ng-click="openModalCreateProvider()">
                <i class="fa fa-fw fa-plus-square-o"></i>
                <b>Add provider</b>
            </button>
            <div class="clearfix"></div>
        </div>
        <div class="body">
            <div class="box no-border">
                <div class="box-body">
                    <div class="form-search-supplier">
                        <div class="row" style=" display: flex; align-items: flex-end; ">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Search</label>
                                    <input type="text" class="form-control" placeholder="keyword" aria-invalid="false" ng-model="filters.keyword">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Status</label>
                                    <select  class="form-control" ng-change="find(true)" ng-model="filters.status" ng-options="key as value for (key, value) in statusses">
                                        <option value="">Select status</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3 text-right">
                                <div class="form-group">
                                    <button type="button" class="btn btn-primary" ng-click="find()" ng-disabled="isLoading">
                                        <i class="fa fa-search"></i> Find </button>
                                    <button type="button" class="btn btn-default ml-3 " ng-click="clear()" ng-disabled="isLoading">
                                        <i class="fa fa-refresh"></i> Clear </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-list-supplier">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th></th>
                                                <th>Name</th>
                                                <th>Supplier</th>
                                                <th>Status</th>
                                                <th class="text-center">Variants</th>
                                                <th class="text-center">Location</th>
                                                <th class="text-center"></th>
                                            </tr>
                                        </thead>
                                        <tbody class="striped-row">
                                            <tr ng-repeat="item in warehouseProviders">
                                                <td>@{{ $index + 1 }}</td>
                                                <td>@{{ item.name }}</td>
                                                <td>@{{ printings[item.supplier_id] }}</td>
                                                <td>
                                                    <span class="stt-active" ng-if="item.status == 'ACTIVE'">Active</span>
                                                    <span class="stt-no-active" ng-if="item.status == 'INACTIVE'">Inactive</span>
                                                </td>
                                                <td class="text-center">
                                                    <button type="button" name="button" class="btn btn-purple" ng-click="openModalCreateProduct(item)">
                                                        <i class="fa fa-fw fa-plus -square-o"></i>
                                                        <b>Add variant</b>
                                                    </button>
                                                </td>
                                                <td class="text-center">
                                                    <button type="button" name="button" class="btn btn-green-light" ng-click="openModalCreateLocation(item)">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-geo-fill" viewBox="0 0 16 16">
                                                            <path fill-rule="evenodd" d="M4 4a4 4 0 1 1 4.5 3.969V13.5a.5.5 0 0 1-1 0V7.97A4 4 0 0 1 4 3.999zm2.493 8.574a.5.5 0 0 1-.411.575c-.712.118-1.28.295-1.655.493a1.319 1.319 0 0 0-.37.265.301.301 0 0 0-.057.09V14l.002.008a.147.147 0 0 0 .016.033.617.617 0 0 0 .145.15c.165.13.435.27.813.395.751.25 1.82.414 3.024.414s2.273-.163 3.024-.414c.378-.126.648-.265.813-.395a.619.619 0 0 0 .146-.15.148.148 0 0 0 .015-.033L12 14v-.004a.301.301 0 0 0-.057-.09 1.318 1.318 0 0 0-.37-.264c-.376-.198-.943-.375-1.655-.493a.5.5 0 1 1 .164-.986c.77.127 1.452.328 1.957.594C12.5 13 13 13.4 13 14c0 .426-.26.752-.544.977-.29.228-.68.413-1.116.558-.878.293-2.059.465-3.34.465-1.281 0-2.462-.172-3.34-.465-.436-.145-.826-.33-1.116-.558C3.26 14.752 3 14.426 3 14c0-.599.5-1 .961-1.243.505-.266 1.187-.467 1.957-.594a.5.5 0 0 1 .575.411z" />
                                                        </svg>
                                                        <b>Add location</b>
                                                    </button>
                                                </td>
                                                <td class="text-right">
                                                    <button type="button" name="button" class="btn" ng-click="editProvider(item)">
                                                        <i class="fa fa-eye"></i>
                                                    </button>
                                                    <button type="button" name="button" class="btn" ng-click="deleteProvider(item)">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <div class="box-footer clearfix">
                                        <div class="pull-right">
                                            @include('warehouse-pod::system.includes.paginator', [
                                            "accessPageId" => "filters.page_id",
                                            "accessPagesCount" => "pagesCount",
                                            "accessFind" => "find()"
                                            ])
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('warehouse-pod::system.provider.inc.add-provider-modal')
    @include('warehouse-pod::system.provider.inc.add-product-modal')
    @include('warehouse-pod::system.provider.inc.add-location-modal')
</div>
<script>
    (function() {
        var runMyCode = function($) {
            $(document).ready(function() {
                $("body").tooltip({
                    selector: '[data-toggle=tooltip]'
                });
            });
        };

        var timer = function() {
            if (window.jQuery && window.jQuery.ui) {
                runMyCode(window.jQuery);
            } else {
                window.setTimeout(timer, 100);
            }
        };
        timer();
    })();
</script>
@endsection