@extends('system.layout.main')
@section('title')
<title>Warehouse Provider</title>
@endsection
@section('css')
<link rel="stylesheet" type="text/css" href="/modules/warehouse-pod/css/s-provider.css?v=<?= time() ?>" />
<link rel="stylesheet" type="text/css" href="/modules/warehouse-pod/css/custom.css?v=<?= time() ?>" />
@endsection
@section('script')
<script>
    var options = <?= json_encode($options) ?>;
    var providerVariant = <?= json_encode($providerVariant) ?>;
</script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">
<script src="/system/js/scripts/combinatorics.js?v={{ config('sa.version') }}" charset="utf-8"></script>
<script src="/system/js/scripts/chosen-add-option.js?v={{ config('sa.version') }}" charset="utf-8"></script>
<script src="/system/js/scripts/angular-chosen-search.js?v={{ config('sa.version') }}" charset="utf-8"></script>
<script src="/system/js/scripts/dynamic-number.min.js?v={{ config('sa.version') }}" charset="utf-8"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>
<script src="/system/js/controllers/pagination/pagination-controller.js" charset="utf-8"></script>
<script type="text/javascript" src="{{ Module::asset('warehouse-pod/js/warehouse-provider-mapping-variant-controller.js') }}?v=<?= time() ?>"></script>
@endsection
@section('content')

<div class="content" ng-controller="WarehouseProviderMappingVariantController">
    <div class="index">
        <div class="header">
            <div class="pull-left">
                <h3 class="">Provider Variant Mapping</h3>
            </div>
            <button type="button" name="button" class="btn btn-success pull-right" ng-click="openModalCreateProviderMappingVariant()">
                <i class="fa fa-fw fa-plus-square-o"></i>
                <b>Add mapping</b>
            </button>
            <div class="clearfix"></div>
        </div>
        <div class="body">
            <div class="box no-border">
                <div class="box-body">
                    <div class="form-search-supplier">
                        <div class="row" style=" display: flex; align-items: flex-end; ">

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Option</label>
                                    <select class="form-control" chosen style="width: 100%;" ng-model="filters.option" ng-options="item.name for item in options track by item.id" ng-change="chooseOption(filters, $index, 'filter')" aria-hidden="true">
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Variant value</label>
                                    <select class="form-control" chosen style="width: 100%;" ng-model="filters.default_option_value" ng-options="k as value for (k, value) in filters.option.variants" aria-hidden="true" ng-change="find()">
                                        <option value="">Select</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Provider variant value</label>
                                    <select chosen class="form-control" ng-model="filters.provider_option_value" ng-options="item.id as item.name for item in providerVariant" ng-change="find()">
                                        <option value="">Select</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row" style=" display: flex; align-items: flex-end; ">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <button type="button" class="btn btn-primary" ng-click="find()" ng-disabled="isLoading">
                                        <i class="fa fa-search"></i> Find </button>
                                    <button type="button" class="btn btn-default ml-3 " ng-click="clear()" ng-disabled="isLoading">
                                        <i class="fa fa-refresh"></i> Clear </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-list-supplier">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th></th>
                                                <th>Option</th>
                                                <th>Variant Value</th>
                                                <th>Provider Variant Value</th>
                                                <th>Product</th>
                                                <th class="text-center"></th>
                                            </tr>
                                        </thead>
                                        <tbody class="striped-row">
                                            <tr ng-repeat="item in warehouseProvidersMappingVariant">
                                                <td>@{{ $index + 1 }}</td>
                                                <td>@{{ item.option_name }}</td>
                                                <td>@{{ item.variant_name }}</td>
                                                <td>@{{ item.provider_option_name }}</td>
                                                <td>@{{ item.provider_name }}</td>
                                                <td>
                                                    @{{ optionns[item.default_option_id] }}
                                                </td>
                                                <td class="text-right">
                                                    <button type="button" name="button" class="btn" ng-click="deleteProviderMappingVariant(item)">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <div class="box-footer clearfix">
                                        <div class="pull-right">
                                            @include('warehouse-pod::system.includes.paginator', [
                                            "accessPageId" => "filters.page_id",
                                            "accessPagesCount" => "pagesCount",
                                            "accessFind" => "find()"
                                            ])
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('warehouse-pod::system.provider.inc.add-mapping-modal')
</div>
<script>
    (function() {
        var runMyCode = function($) {
            $(document).ready(function() {
                $("body").tooltip({
                    selector: '[data-toggle=tooltip]'
                });
            });
        };

        var timer = function() {
            if (window.jQuery && window.jQuery.ui) {
                runMyCode(window.jQuery);
            } else {
                window.setTimeout(timer, 100);
            }
        };
        timer();
    })();
</script>
@endsection