<div class="row" ng-show="(tab == 'shipping' || tab == 'cost') && isShowVariantConfig">
    <div class="col-md-12">
        <h3>Preview shipping variant</h3>
    </div>
    
    <div class="col-md-12">
        <table class="table table-bordered">
            <tr ng-if="tab == 'shipping'">
                <th></th>
                <th colspan="2" style="text-align: center">Standard</th>
                <th colspan="2" style="text-align: center; color: #FFA400;">Premium</th>
                <th colspan="2" style="text-align: center; color: #DA5E69;">Express</th>
            </tr>
            <tr>
                <th>Name</th>
                <th>Shipping fee</th>
                <th>Adding fee</th>
                <th>Shipping fee</th>
                <th>Adding fee</th>
                <th>Shipping fee</th>
                <th>Adding fee</th>
            </tr>
            <tr ng-repeat="(str, name) in listVariantConfigByStrId">
                <td>
                    @{{ name }}
                </td>
                <td>
                    @{{ listVariantConfig['standard'][str].default_shipping_fee ? listVariantConfig['standard'][str].default_shipping_fee : '-' }}
                </td>
                <td>
                    @{{ listVariantConfig['standard'][str].default_adding_item ? listVariantConfig['standard'][str].default_adding_item : '-' }}
                </td>
                <td>
                    @{{ listVariantConfig['premium'][str].default_shipping_fee ? listVariantConfig['premium'][str].default_shipping_fee : '-' }}
                </td>
                <td>
                    @{{ listVariantConfig['premium'][str].default_adding_item ? listVariantConfig['premium'][str].default_adding_item : '-' }}
                </td>
                <td>
                    @{{ listVariantConfig['express'][str].default_shipping_fee ? listVariantConfig['express'][str].default_shipping_fee : '-' }}
                </td>
                <td>
                    @{{ listVariantConfig['express'][str].default_adding_item ? listVariantConfig['express'][str].default_adding_item : '-' }}
                </td>
            </tr>
        </table>
    </div>
</div>

<div class="row" ng-show="tab == 'shipping' || tab == 'cost'">
    <div class="col-md-12">
        <h3>Preview shipping category</h3>
        <div class="form-group no-padding">
            <select class="form-control"
                data-placeholder="Chọn danh mục" 
                style="width: 100%;" 
                chosen
                multiple
                ng-model="previewCateFilter"
                ng-options="key as value for (key, value) in categories"
                ng-change="findCategory()"
                aria-hidden="true">
            </select>
        </div>
    </div>

    <div class="col-md-12">
        <table class="table table-bordered">
            <tr ng-if="tab == 'shipping'">
                <th></th>
                <th colspan="4" style="text-align: center" ng-if="standardShipping">Standard</th>
                <th colspan="4" style="text-align: center; color: #FFA400;" ng-if="premiumShipping">Premium</th>
                <th colspan="4" style="text-align: center; color: #DA5E69;" ng-if="expressShipping">Express</th>
            </tr>
            <tr ng-if="tab == 'cost'">
                <th></th>
                <th colspan="4" style="text-align: center" ng-if="standardCost">Standard</th>
                <th colspan="4" style="text-align: center; color: #FFA400;" ng-if="premiumCost">Premium</th>
                <th colspan="4" style="text-align: center; color: #DA5E69;" ng-if="expressCost">Express</th>
            </tr>
            <tr>
                <td>Category</td>
                <td ng-if="standardShipping">Handing time (days)</td>
                <td ng-if="standardShipping">Shipping time (days)</td>
                <td ng-if="standardShipping">1st item</td>
                <td ng-if="standardShipping">Adding fee</td>
                <td ng-if="premiumShipping">Handing time (days)</td>
                <td ng-if="premiumShipping">Shipping time (days)</td>
                <td ng-if="premiumShipping">1st item</td>
                <td ng-if="premiumShipping">Adding fee</td>
                <td ng-if="expressShipping">Handing time (days)</td>
                <td ng-if="expressShipping">Shipping time (days)</td>
                <td ng-if="expressShipping">1st item</td>
                <td ng-if="expressShipping">Adding fee</td>
            </tr>
        
            <tr ng-if="warehouse.allCateConfig.length > 0 && tab == 'shipping'" ng-repeat="cate in warehouse.allCateConfig" data-id="@{{ cate }}">
                <td>
                    <span style="@{{ !standardShippingOld || !standardShippingOld[cate] ? 'color: green; font-weight: bold;' : '' }}">
                        @{{ categories[cate] ? categories[cate] : $index == 0 ? 'Default' : "-" }}
                    </span>
                    <span ng-if="!standardShippingOld || !standardShippingOld[cate]" style="color: green; font-weight: bold;">
                        (New)
                    </span>
                </td>
                <td ng-if="standardShipping" ng-bind-html="bindPreviewTime(standardShipping, warehouse.standard_shipping_invalid_cate, cate) | safeHtml">
                </td>
                <td ng-if="standardShipping" ng-bind-html="bindPreviewTime(standardShipping, warehouse.standard_shipping_invalid_cate, cate, 'shipping') | safeHtml">
                </td>
                <td ng-if="standardShipping" ng-bind-html="bindShippingFee(standardShipping, warehouse.standard_shipping_invalid_cate, cate, standardShippingOld, 'shipping') | safeHtml">
                </td>
                <td ng-if="standardShipping" ng-bind-html="bindShippingFee(standardShipping, warehouse.standard_shipping_invalid_cate, cate, standardShippingOld) | safeHtml">
                </td>
        
        
        
                <td ng-if="premiumShipping" ng-bind-html="bindPreviewTime(premiumShipping, warehouse.premium_shipping_invalid_cate, cate) | safeHtml">
                </td>
                <td ng-if="premiumShipping" ng-bind-html="bindPreviewTime(premiumShipping, warehouse.premium_shipping_invalid_cate, cate, 'shipping') | safeHtml">
                </td>
                <td ng-if="premiumShipping" ng-bind-html="bindShippingFee(premiumShipping, warehouse.premium_shipping_invalid_cate, cate, premiumShippingOld, 'shipping') | safeHtml">
                </td>
                <td ng-if="premiumShipping" ng-bind-html="bindShippingFee(premiumShipping, warehouse.premium_shipping_invalid_cate, cate, premiumShippingOld) | safeHtml">
                </td>
        
        
                
                <td ng-if="expressShipping" ng-bind-html="bindPreviewTime(expressShipping, warehouse.express_shipping_invalid_cate, cate) | safeHtml">
                </td>
                <td ng-if="expressShipping" ng-bind-html="bindPreviewTime(expressShipping, warehouse.express_shipping_invalid_cate, cate, 'shipping') | safeHtml">
                </td>
                <td ng-if="expressShipping" ng-bind-html="bindShippingFee(expressShipping, warehouse.express_shipping_invalid_cate, cate, expressShippingOld, 'shipping') | safeHtml">
                </td>
                <td ng-if="expressShipping" ng-bind-html="bindShippingFee(expressShipping, warehouse.express_shipping_invalid_cate, cate, expressShippingOld) | safeHtml">
                </td>
            </tr>
            <tr ng-if="warehouse.allCateConfig.length > 0 && tab == 'cost'" ng-repeat="cate in warehouse.allCateConfig" data-id="@{{ cate }}">
                <td>
                    <span style="@{{ !standardCostOld || !standardCostOld[cate] ? 'color: green; font-weight: bold;' : '' }}">
                        @{{ categories[cate] ? categories[cate] : $index == 0 ? 'Default' : "-" }}
                    </span>
                    <span ng-if="!standardCostOld || !standardCostOld[cate]" style="color: green; font-weight: bold;">
                        (New)
                    </span>
                </td>
                <td ng-if="standardCost">
                    <p>-</p>
                </td>
                <td ng-if="standardCost">
                    <p>-</p>
                </td>
                <td ng-if="standardCost" ng-bind-html="bindShippingFee(standardCost, warehouse.standard_cost_invalid_cate, cate, standardCostOld, 'shipping') | safeHtml">
                </td>
                <td ng-if="standardCost" ng-bind-html="bindShippingFee(standardCost, warehouse.standard_cost_invalid_cate, cate, standardCostOld) | safeHtml">
                </td>
        
        
        
                <td ng-if="premiumCost">
                    <p>-</p>
                </td>
                <td ng-if="premiumCost">
                    <p>-</p>
                </td>
                <td ng-if="premiumCost" ng-bind-html="bindShippingFee(premiumCost, warehouse.premium_cost_invalid_cate, cate, premiumCostOld, 'shipping') | safeHtml">
                </td>
                <td ng-if="premiumCost" ng-bind-html="bindShippingFee(premiumCost, warehouse.premium_cost_invalid_cate, cate, premiumCostOld) | safeHtml">
                </td>
        
                
        
                <td ng-if="expressCost">
                    <p>-</p>
                </td>
                <td ng-if="expressCost">
                    <p>-</p>
                </td>
                <td ng-if="expressCost" ng-bind-html="bindShippingFee(expressCost, warehouse.express_cost_invalid_cate, cate, expressCostOld, 'shipping') | safeHtml">
                </td>
                <td ng-if="expressCost" ng-bind-html="bindShippingFee(expressCost, warehouse.express_cost_invalid_cate, cate, expressCostOld) | safeHtml">
                </td>
            </tr>
            <tr ng-if="warehouse.allShippingCateConfigOld.length > 0 && tab == 'shipping' && previewCateFilter == ''" ng-repeat="cate in warehouse.allShippingCateConfigOld">
                <td ng-if="!warehouse.allCateConfig.includes(cate)" style="color: red">
                    @{{ categories[cate] ? categories[cate] : $index == 0 ? 'Default' : cate }}
                </td>
            </tr>
            <tr ng-if="warehouse.allCostCateConfigOld.length > 0 && tab == 'cost' && previewCateFilter == ''" ng-repeat="cate in warehouse.allCostCateConfigOld">
                <td ng-if="!warehouse.allCateConfig.includes(cate)" style="color: red">
                    @{{ categories[cate] ? categories[cate] : $index == 0 ? 'Default' : cate }}
                </td>
            </tr>
        </table>
    </div>
</div>
