<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */

Route::group(['prefix' => 'warehouse', 'middleware' => ['web', 'frontend']], function () {
    Route::post('/detect', [
        'as' => 'warehouse::detect',
        'uses' => 'WarehouseConfigController@detect',
    ]);
});


Route::group(['prefix' => 'warehouse', 'middleware' => config('app.system_auth_middleware')], function () {
    Route::get('/config', [
        'as' => 'warehouse::config',
        'uses' => 'WarehouseConfigController@config',
    ]);
    Route::get('/product', [
        'as' => 'warehouse::product',
        'uses' => 'WarehouseProductController@index',
    ]);
    Route::get('/order/warning', [
        'as' => 'warehouse::order::warning',
        'uses' => 'WarehouseConfigController@orderWarning',
    ]);
    Route::get('/product-print', [
        'as' => 'warehouse::product-print',
        'uses' => 'ProductPrintConfigController@index',
    ]);
    Route::get('/provider', [
        'as' => 'warehouse::provider',
        'uses' => 'WarehouseProviderController@index',
    ]);
    Route::get('/provider/detail/{id}', [
        'as' => 'warehouse::provider',
        'uses' => 'WarehouseProviderController@detail',
    ]);
    Route::get('/provider/mapping-variant', [
        'as' => 'warehouse::mapping-variant',
        'uses' => 'WarehouseProviderController@mappingVariant',
    ]);
    Route::get('/provider/v2', [
        'as' => 'warehouse::provider::v2',
        'uses' => 'ProviderController@index',
    ]);
    Route::get('/printing', [
        'as' => 'warehouse::printing',
        'uses' => 'PrintingController@index',
    ]);
    Route::get('/ratio', [
        'as' => 'warehouse::ratio::index',
        'uses' => 'WarehouseCurrencyRatioController@index',
    ]);
});

Route::group(['prefix' => 'service/warehouse'], function () {
    Route::get('/warning/order', [
        'as' => 'warehouse::warning::order',
        'uses' => 'Services\WarehouseConfigService@warningOrder'
    ]);

    Route::get('/order/warning/find', [
        'as' => 'warehouse::warning::order::find',
        'uses' => 'Services\WarehouseConfigService@warningOrderFind'
    ]);

    Route::get('/order/warning/export', [
        'as' => 'warehouse::warning::order::export',
        'uses' => 'Services\WarehouseConfigService@warningOrderExport'
    ]);

    Route::post('/product/delete', [
        'as' => 'warehouse::warning::order::delete',
        'uses' => 'Services\WarehouseConfigService@warningOrderDelete'
    ]);

    Route::post('/config/create', [
        'as' => 'warehouse::config::create',
        'uses' => 'Services\WarehouseConfigService@store'
    ]);

    Route::post('/config/clone', [
        'as' => 'warehouse::config::clone',
        'uses' => 'Services\WarehouseConfigService@cloneConfig'
    ]);
    Route::get('/config/clone', [
        'as' => 'warehouse::config::clone',
        'uses' => 'Services\WarehouseConfigService@cloneConfig'
    ]);

    Route::post('/config/clone-shipping-cost', [
        'as' => 'warehouse::config::clone-shipping-cost',
        'uses' => 'Services\WarehouseConfigService@cloneShippingCost'
    ]);

    Route::post('category/find', [
        'as' => 'warehouse::category::find',
        'uses' => 'Services\WarehouseConfigService@getWarehouseCategory'
    ]);
    Route::post('category/save', [
        'as' => 'warehouse::category::save',
        'uses' => 'Services\WarehouseConfigService@storeWarehouseCategory'
    ]);
    Route::post('category/delete', [
        'as' => 'warehouse::category::delete',
        'uses' => 'Services\WarehouseConfigService@deleteWarehouseCategoryById'
    ]);

    Route::post('/config/update', [
        'as' => 'warehouse::config::update',
        'uses' => 'Services\WarehouseConfigService@store'
    ]);

    Route::get('/config/find', [
        'as' => 'warehouse::config::find',
        'uses' => 'Services\WarehouseConfigService@find'
    ]);

    Route::get('/product/find', [
        'as' => 'warehouse::product::find',
        'uses' => 'Services\WarehouseProductService@find'
    ]);

    Route::post('/product/create', [
        'as' => 'warehouse::product::create',
        'uses' => 'Services\WarehouseProductService@store'
    ]);

    Route::post('/product/delete', [
        'as' => 'warehouse::product::delete',
        'uses' => 'Services\WarehouseProductService@delete'
    ]);

    Route::get('/product-info/find', [
        'as' => 'warehouse::product-info::find',
        'uses' => 'Services\WarehouseProductService@product'
    ]);

    Route::get('/product/rebuild', [
        'as' => 'warehouse::product::rebuild',
        'uses' => 'Services\WarehouseProductService@rebuild'
    ]);

    Route::post('product/get-option-value', [
        'as' => 'warehouse::product::option::value',
        'uses' => 'Services\WarehouseConfigService@getOptionValue'
    ]);

    Route::get('/product/build/status', [
        'as' => 'warehouse::product::build::status',
        'uses' => 'Services\WarehouseConfigService@buildStatus'
    ]);

    Route::get('/product/update/status', [
        'as' => 'warehouse::product::update::status',
        'uses' => 'Services\WarehouseConfigService@updateStatus'
    ]);

    Route::get('/sync/product-status', [
        'as' => 'warehouse::product::sync::product-status',
        'uses' => 'Services\WarehouseConfigService@syncProductStatus'
    ]);

    Route::get('/cron/category-variant', [
        'as' => 'warehouse::product::cron::category-variant',
        'uses' => 'Services\WarehouseConfigService@categoryVariant'
    ]);
    Route::get('/build-handling', [
        'as' => 'warehouse::build-handling-time',
        'uses' => 'Services\WarehouseConfigService@buildHandlingTime'
    ]);
    Route::get('/rebuild-handling', [
        'as' => 'warehouse::rebuild-handling-time',
        'uses' => 'Services\WarehouseConfigService@rebuildHandlingTime'
    ]);
    Route::get('/export', [
        'as' => 'warehouse::export',
        'uses' => 'Services\WarehouseConfigService@exportExcel'
    ]);
    Route::post('/import', [
        'as' => 'warehouse::import',
        'uses' => 'Services\WarehouseConfigService@importExcel'
    ]);
    Route::get('/dupplicate-cost', [
        'as' => 'warehouse::dupplicate-cost',
        'uses' => 'Services\WarehouseConfigService@duplicateCost'
    ]);
    Route::post('/enable-edit', [
        'as' => 'warehouse::enable-edit',
        'uses' => 'Services\WarehouseConfigService@enableEdit'
    ]);

    Route::get('/product-print/find', [
        'as' => 'warehouse::product-print::find',
        'uses' => 'Services\WarehouseProductPrintService@find'
    ]);

    Route::post('/product-print/create', [
        'as' => 'warehouse::product-print::create',
        'uses' => 'Services\WarehouseProductPrintService@store'
    ]);

    Route::post('/product-print/delete', [
        'as' => 'warehouse::product-print::delete',
        'uses' => 'Services\WarehouseProductPrintService@delete'
    ]);

    Route::get('/product-print/check', [
        'as' => 'warehouse::product-print::print-by-printify',
        'uses' => 'Services\WarehouseProductPrintService@isPrintByPrintify',
    ]);

    //WarehouseProvider
    Route::group(['prefix' => 'provider'], function () {
        Route::get('/find', [
            'as' => 'warehouse::provider::find',
            'uses' => 'Services\WarehouseProviderService@find',
        ]);
        Route::post('/store', [
            'as' => 'warehouse::provider::store',
            'uses' => 'Services\WarehouseProviderService@store',
        ]);
        Route::post('/delete', [
            'as' => 'warehouse::provider::delete',
            'uses' => 'Services\WarehouseProviderService@delete',
        ]);
        Route::get('/find-variant', [
            'as' => 'warehouse::provider::find-variant',
            'uses' => 'Services\WarehouseProviderService@findVariant',
        ]);
        Route::post('/create-variant', [
            'as' => 'warehouse::provider::create-variant',
            'uses' => 'Services\WarehouseProviderService@createProviderVariant',
        ]);
        Route::get('/find-location', [
            'as' => 'warehouse::provider::find-location',
            'uses' => 'Services\WarehouseProviderService@findProviderLocation',
        ]);
        Route::post('/store-location', [
            'as' => 'warehouse::provider::store-location',
            'uses' => 'Services\WarehouseProviderService@storeProviderLocation',
        ]);
        Route::post('/delete-location', [
            'as' => 'warehouse::provider::delete-location',
            'uses' => 'Services\WarehouseProviderService@deleteProviderLocation',
        ]);
        Route::post('/store-location-products', [
            'as' => 'warehouse::provider::store-location-products',
            'uses' => 'Services\WarehouseProviderService@saveProviderLocationProducts',
        ]);
        Route::get('/map-product', [
            'as' => 'warehouse::provider::map-product',
            'uses' => 'Services\WarehouseProviderService@mappingProduct',
        ]);
        Route::post('/store-products', [
            'as' => 'warehouse::provider::store-products',
            'uses' => 'Services\WarehouseProviderService@storeProviderProducts',
        ]);
        Route::get('/find-mapping-variant', [
            'as' => 'warehouse::provider::find-mapping-variant',
            'uses' => 'Services\WarehouseProviderService@findProviderMappingVariant',
        ]);
        Route::post('/store-mapping-variant', [
            'as' => 'warehouse::provider::store-mapping-variant',
            'uses' => 'Services\WarehouseProviderService@storeProviderMappingVariant',
        ]);
        Route::post('/delete-mapping-variant', [
            'as' => 'warehouse::provider::delete-mapping-variant',
            'uses' => 'Services\WarehouseProviderService@deleteProviderMappingVariant',
        ]);
        Route::get('/find-provider-info', [
            'as' => 'warehouse::provider::find-provider-info',
            'uses' => 'Services\WarehouseProviderService@findProviderInfo',
        ]);
        Route::post('/store-provider-info', [
            'as' => 'warehouse::provider::store-provider-info',
            'uses' => 'Services\WarehouseProviderService@storeProviderInfo',
        ]);
        Route::get('/find-provider-variant', [
            'as' => 'warehouse::provider::find-provider-variant',
            'uses' => 'Services\WarehouseProviderService@findProviderVariant',
        ]);
        Route::post('/store-printify-variant', [
            'as' => 'warehouse::provider::store-printify-variant',
            'uses' => 'Services\WarehouseProviderService@storePrintifyVariant',
        ]);
        Route::post('/store-printify-product', [
            'as' => 'warehouse::provider::store-printify-product',
            'uses' => 'Services\WarehouseProviderService@storePrintifyProduct',
        ]);
        Route::get('/clone-location', [
            'as' => 'warehouse::provider::clone-location',
            'uses' => 'Services\WarehouseProviderService@cloneLocation',
        ]);
    });

    //Provider
    Route::group(['prefix' => 'provider/v2'], function () {
        Route::get('/find', [
            'as' => 'warehouse::provider::v2::find',
            'uses' => 'Services\ProviderService@find',
        ]);
        Route::post('/store', [
            'as' => 'warehouse::provider::v2::store',
            'uses' => 'Services\ProviderService@store',
        ]);
        Route::post('/delete', [
            'as' => 'warehouse::provider::v2::delete',
            'uses' => 'Services\ProviderService@delete',
        ]);
    });
    //Printing
    Route::group(['prefix' => 'printing'], function () {
        Route::get('/find', [
            'as' => 'warehouse::printing::find',
            'uses' => 'Services\PrintingService@find',
        ]);
        Route::post('/store', [
            'as' => 'warehouse::printing::store',
            'uses' => 'Services\PrintingService@store',
        ]);
        Route::post('/delete', [
            'as' => 'warehouse::printing::delete',
            'uses' => 'Services\PrintingService@delete',
        ]);
    });

    //Ratio
    Route::group(['prefix' => 'ratio'], function () {
        Route::get('/find', [
            'as' => 'warehouse::ratio::find',
            'uses' => 'Services\WarehouseCurrencyRatioService@find',
        ]);
        Route::post('/store', [
            'as' => 'warehouse::ratio::store',
            'uses' => 'Services\WarehouseCurrencyRatioService@store',
        ]);
        Route::post('/delete', [
            'as' => 'warehouse::ratio::delete',
            'uses' => 'Services\WarehouseCurrencyRatioService@delete',
        ]);
    });

     Route::group(['prefix' => 'config/item'], function () {
        Route::get('/check-bulk', [
            'as' => 'warehouse::config::item::check-bulk',
            'uses' => 'Services\WarehouseConfigService@checkBulk',
        ]);
        Route::post('/find', [
            'as' => 'warehouse::config::item::find',
            'uses' => 'Services\WarehouseConfigService@getConfigItemVariant',
        ]);
        Route::post('/save', [
            'as' => 'warehouse::config::item::save',
            'uses' => 'Services\WarehouseConfigService@storeConfigItemVariant',
        ]);
    });

    
});
