<?php

return [
    'auth' => [
        'scheme' => env('ELASTICSEARCH_SCHEME', 'http'),
        'host' => env('ELASTICSEARCH_HOST', '192.168.1.172'),
        'port' => env('ELASTICSEARCH_PORT', 9200),
        'user' => env('ELASTICSEARCH_USER', null),
        'pass' => env('ELASTICSEARCH_PASS', null),
    ],
    'pined' => [],
    'term_decor' => 10,
    'defaultFrom' => 0,
    'defaultSize' => 10000,
    'index' => 'printerval',
    'category_index' => env('ELASTICSEARCH_CATEGORY_INDEX', 'category_printerval'),
    'detail_index' => env('ELASTICSEARCH_PRODUCT_DETAIL_INDEX', 'product_detail_printerval'),
    'type' => [
        'products' => [
            'searchFields' => ['name', 'tag.title'],
            'fuzziness' =>  0.8,
            'shouldMatch' => '90%', // https://www.elastic.co/guide/en/elasticsearch/reference/5.4/query-dsl-minimum-should-match.html
            'mappingFields' => [
                // "keyword" => array("type" => "text|keyword|date|long|double|boolean|ip", "index" => "analyzed|not_analyzed"),
            ]
        ],
        'categories' => [

        ],
        'blogs' => [

        ],
        'product_n_category_top' => [ 
            'mappingFields' => [
                'brand_id' => [
                        'type' => 'long'
                ],
                'categories' => [
                    'properties' => [
                        'id' => [
                            'type' => 'long'
                        ],
                        'image_url' => [
                            'type' => 'text',
                            'fields' => [
                                'keyword' => [
                                    'type' => 'keyword',
                                    'ignore_above' => 256
                                ]
                            ]
                        ],
                        'name' => [
                            'type' => 'text',
                            'fields' => [
                                'keyword' => [
                                    'type' => 'keyword',
                                    'ignore_above' => 256
                                ]
                            ]
                        ],
                        'slug' => [
                            'type' => 'text',
                            'fields' => [
                                'keyword' => [
                                    'type' => 'keyword',
                                    'ignore_above' => 256
                                ]
                            ]
                        ]
                    ]
                ],
                'category_id' => [
                    'type' => 'long'
                ],
                'cr' => [
                    'type' => 'long'
                ],
                'display_high_price' => [
                    'type' => 'text',
                    'fields' => [
                        'keyword' => [
                            'type' => 'keyword',
                            'ignore_above' => 256
                        ]
                    ]
                ],
                'display_price' => [
                    'type' => 'text',
                    'fields' => [
                        'keyword' => [
                            'type' => 'keyword',
                            'ignore_above' => 256
                        ]
                    ]
                ],
                'high_price' => [
                    'type' => 'text',
                    'fields' => [
                        'keyword' => [
                            'type' => 'keyword',
                            'ignore_above' => 256
                        ]
                    ]
                ],
                'horder' => [
                    'type' => 'long'
                ],
                'id' => [
                    'type' => 'long'
                ],
                'image_url' => [
                    'type' => 'text',
                    'fields' => [
                        'keyword' => [
                            'type' => 'keyword',
                            'ignore_above' => 256
                        ]
                    ]
                ],
                'inventory' => [
                    'type' => 'long'
                ],
                'name' => [
                    'type' => 'text',
                    'fields' => [
                        'keyword' => [
                            'type' => 'keyword',
                            'ignore_above' => 256
                        ]
                    ]
                ],
                'percent_sale' => [
                    'type' => 'long'
                ],
                'price' => [
                    'type' => 'text',
                    'fields' => [
                        'keyword' => [
                            'type' => 'keyword',
                            'ignore_above' => 256
                        ]
                    ]
                ],
                'product_created_at' => [
                    'type' => 'text',
                    'fields' => [
                        'keyword' => [
                            'type' => 'keyword',
                            'ignore_above' => 256
                        ]
                    ]
                ],
                'product_n_category_top_id' => [
                    'type' => 'long'
                ],
                'random_image' => [
                    'type' => 'text',
                    'fields' => [
                        'keyword' => [
                            'type' => 'keyword',
                            'ignore_above' => 256
                        ]
                    ]
                ],
                'rating_count' => [
                    'type' => 'long'
                ],
                'rating_value' => [
                    'type' => 'float'
                ],
                'score' => [
                    'type' => 'long'
                ],
                'sku' => [
                    'type' => 'text',
                    'fields' => [
                        'keyword' => [
                            'type' => 'keyword',
                            'ignore_above' => 256
                        ]
                    ]
                ],
                'slug' => [
                    'type' => 'text',
                    'fields' => [
                        'keyword' => [
                            'type' => 'keyword',
                            'ignore_above' => 256
                        ]
                    ]
                ],
                'sold' => [
                    'type' => 'long'
                ],
                'status' => [
                    'type' => 'text',
                    'fields' => [
                        'keyword' => [
                            'type' => 'keyword',
                            'ignore_above' => 256
                        ]
                    ]
                ],
                'tags' => [
                    'type' => 'long'
                ],
                'template_id' => [
                    'type' => 'long'
                ],
                'total_click' => [
                    'type' => 'long'
                ],
                'total_sale' => [
                    'type' => 'long'
                ],
                'updated_at' => [
                    'type' => 'date'
                ],
                'url' => [
                    'type' => 'text',
                    'fields' => [
                        'keyword' => [
                            'type' => 'keyword',
                            'ignore_above' => 256
                        ]
                    ]
                ],
                'user' => [
                    'properties' => [
                        'id' => [
                            'type' => 'long'
                        ],
                        'name' => [
                            'type' => 'text',
                            'fields' => [
                                'keyword' => [
                                    'type' => 'keyword',
                                    'ignore_above' => 256
                                ]
                            ]
                        ],
                        'slug' => [
                            'type' => 'text',
                            'fields' => [
                                'keyword' => [
                                    'type' => 'keyword',
                                    'ignore_above' => 256
                                ]
                            ]
                        ]
                    ]
                ],
                'variant_options' => [
                    'properties' => [
                        '1' => [
                            'properties' => [
                                'options' => [
                                    'properties' => [
                                        'id' => [
                                            'type' => 'long'
                                        ],
                                        'name' => [
                                            'type' => 'text',
                                            'fields' => [
                                                'keyword' => [
                                                    'type' => 'keyword',
                                                    'ignore_above' => 256
                                                ]
                                            ]
                                        ],
                                        'slug' => [
                                            'type' => 'text',
                                            'fields' => [
                                                'keyword' => [
                                                    'type' => 'keyword',
                                                    'ignore_above' => 256
                                                ]
                                            ]
                                        ]
                                    ]
                                ],
                                'variant_id' => [
                                    'type' => 'long'
                                ],
                                'variant_name' => [
                                    'properties' => [
                                        'name' => [
                                            'type' => 'text',
                                            'fields' => [
                                                'keyword' => [
                                                    'type' => 'keyword',
                                                    'ignore_above' => 256
                                                ]
                                            ]
                                        ],
                                        'slug' => [
                                            'type' => 'text',
                                            'fields' => [
                                                'keyword' => [
                                                    'type' => 'keyword',
                                                    'ignore_above' => 256
                                                ]
                                            ]
                                        ],
                                        'type' => [
                                            'type' => 'text',
                                            'fields' => [
                                                'keyword' => [
                                                    'type' => 'keyword',
                                                    'ignore_above' => 256
                                                ]
                                            ]
                                        ]
                                    ]
                                ]
                            ]
                        ],
                        '2' => [
                            'properties' => [
                                'options' => [
                                    'properties' => [
                                        'id' => [
                                            'type' => 'long'
                                        ],
                                        'name' => [
                                            'type' => 'text',
                                            'fields' => [
                                                'keyword' => [
                                                    'type' => 'keyword',
                                                    'ignore_above' => 256
                                                ]
                                            ]
                                        ],
                                        'slug' => [
                                            'type' => 'text',
                                            'fields' => [
                                                'keyword' => [
                                                    'type' => 'keyword',
                                                    'ignore_above' => 256
                                                ]
                                            ]
                                        ]
                                    ]
                                ],
                                'variant_id' => [
                                    'type' => 'long'
                                ],
                                'variant_name' => [
                                    'properties' => [
                                        'name' => [
                                            'type' => 'text',
                                            'fields' => [
                                                'keyword' => [
                                                    'type' => 'keyword',
                                                    'ignore_above' => 256
                                                ]
                                            ]
                                        ],
                                        'slug' => [
                                            'type' => 'text',
                                            'fields' => [
                                                'keyword' => [
                                                    'type' => 'keyword',
                                                    'ignore_above' => 256
                                                ]
                                            ]
                                        ],
                                        'type' => [
                                            'type' => 'text',
                                            'fields' => [
                                                'keyword' => [
                                                    'type' => 'keyword',
                                                    'ignore_above' => 256
                                                ]
                                            ]
                                        ]
                                    ]
                                ]
                            ]
                        ],
                        '5' => [
                            'properties' => [
                                'options' => [
                                    'properties' => [
                                        'id' => [
                                            'type' => 'long'
                                        ],
                                        'name' => [
                                            'type' => 'text',
                                            'fields' => [
                                                'keyword' => [
                                                    'type' => 'keyword',
                                                    'ignore_above' => 256
                                                ]
                                            ]
                                        ],
                                        'slug' => [
                                            'type' => 'text',
                                            'fields' => [
                                                'keyword' => [
                                                    'type' => 'keyword',
                                                    'ignore_above' => 256
                                                ]
                                            ]
                                        ]
                                    ]
                                ],
                                'variant_id' => [
                                    'type' => 'long'
                                ],
                                'variant_name' => [
                                    'properties' => [
                                        'name' => [
                                            'type' => 'text',
                                            'fields' => [
                                                'keyword' => [
                                                    'type' => 'keyword',
                                                    'ignore_above' => 256
                                                ]
                                            ]
                                        ],
                                        'slug' => [
                                            'type' => 'text',
                                            'fields' => [
                                                'keyword' => [
                                                    'type' => 'keyword',
                                                    'ignore_above' => 256
                                                ]
                                            ]
                                        ],
                                        'type' => [
                                            'type' => 'text',
                                            'fields' => [
                                                'keyword' => [
                                                    'type' => 'keyword',
                                                    'ignore_above' => 256
                                                ]
                                            ]
                                        ]
                                    ]
                                ]
                            ]
                        ]
                    ]
                ],
                'view_count' => [
                    'type' => 'long'
                ]
            ]
        ]
    ],
    'settings' => [
        'index.mapping.total_fields.limit' => 5000,
        'analysis' => [
            'analyzer' => [
                'default' => [
                    'tokenizer' => 'standard', //ASCII Folding Token Filter
                    'filter' => ["standard", "asciifolding", "lowercase"]
                ],
                'autocomplete' => [ //auto complete
                    "tokenizer" => "standard",
                    "filter" => ["lowercase", "autocompleteFilter"],
                    "char_filter" => ["html_strip"],
                    "type" => "custom",
                    "tokenizer" => "standard"
                ],
                'strip_tags' => [
                    "tokenizer" => "keyword", 
                    "char_filter" => ["html_strip"]
                ],
                'synonym_filter' => [
                    "tokenizer" => "standard",
                    "filter" => ["lowercase", "synonym_filter"]
                ], 
                'quotes_analyzer' => [ //quotes filter ve used the characters themselves: "‘=>'"
                    "tokenizer" => "standard", 
                    "char_filter" => ["quotes"]
                ],
                'replace_analyzer' => [ //replace Pattern Replace Char Filter
                    'tokenizer' => 'standard',
                    'char_filter' => ['my_char_filter']
                ],
                'cusNgram_analyzer' => [ //Allow symbol
                    "tokenizer" => "cusNgram_tokenizer"
                ],
                'cus_analyzer' => [ // search quotes
                    "tokenizer" => "cusTokenizer"
                ],
                'kuromoji_normalize' => [
                    'char_filter' => ['icu_normalizer'],
                    'tokenizer' => 'kuromoji_tokenizer',
                    'filter' => ["kuromoji_baseform", "kuromoji_part_of_speech", "cjk_width", "ja_stop", "kuromoji_stemmer", "lowercase"]
                ]
            ],
            'index_analyzer' => [
                'part_word_analyzer' => [ //search for a part of a word
                    "type" => "custom",
                    "tokenizer" => "standard",
                    "filter" => ["asciifolding", "lowercase", "mynGram"]
                ]
            ],
            'search_analyzer' => [
                'search_analyzer' => [
                    "type" => "custom",
                    "tokenizer" => "standard",
                    "filter" => ["asciifolding", "standard", "lowercase", "mynGram"]
                ]
            ],
            'tokenizer' => [
                'cusNgram_tokenizer' => [
                    "type" => "nGram",
                    "token_chars" => ["letter", "digit", "whitespace", "punctuation", "symbol"]
                ],
                'cusTokenizer' => [
                    "type" => "pattern"
                ]
            ],
            'filter' => [
                'autocompleteFilter' => [
                    "max_shingle_size" => 5,
                    "min_shingle_size" => 2,
                    "type" => "shingle",
                ],
                'mynGram' => [
                    "type" => "nGram",
                    "min_gram" => 2,
                    "max_gram" => 50
                ],
                'synonym_filter' => [
                    "type" => "synonym",
                    "synonyms" => [
                        "mã giảm giá, ma giam gia => coupon", 
                        "miễn phí, mien phi => free", 
                        "khuyến mại, hạ giá, khuyen mai, ha gia => sale", 
                        "quà, qua, quà tặng, qua tang => gift", 
                        "mã, ma => code", 
                        "kohls => kohl's,kohls"
                    ] // từ đồng nghĩa
                ]
            ],
            'char_filter' => [
                'quotes' => [
                    "type" => "mapping",
                    "mappings" => ["\\u0091=>\\u0027", "\\u0092=>\\u0027", "\\u2018=>\\u0027", "\\u2019=>\\u0027", "\\u201B=>\\u0027"]
                ],
                'my_char_filter' => [
                    'type' => 'pattern_replace',
                    'pattern' => "'|".'"',
                    'replacement' => ''
                ]
            ]
        ]
    ]
];

?>