<?php

namespace Modules\ZSearch\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\View;
use Modules\ZSearch\Models\Option;
use App\Modules\ZSearch\Services\ElasticSearchIndexLite;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Modules\ZSearch\Services\CampaignService;
use Modules\ZSearch\Services\ElasticSearchIndex;
use Modules\ZSearch\Services\ElasticsearchIndexHistory;
use Illuminate\Support\Facades\Config;
use Modules\ZSearch\Services\SearchDataDecor;
use Modules\ZSearch\Services\ElasticSearchService;
use Modules\ZSearch\Services\EtsyDataDecor;
use Modules\ZSearch\Services\TagService;

class ApiController extends Controller
{
    public function __construct()
    {

        $elasticSearchConfig = Config::get('z-search::elasticsearch');
        $this->elasticServiceConfig = $elasticSearchConfig;
        $this->elasticService = new ElasticSearchService($elasticSearchConfig);
    }

    public function searchByCategories() {
        set_time_limit(120);
        $categoryIds = request()->input('category_ids');
        $limit = request()->input('limit', 50);
        $categoryIds = explode(',', $categoryIds);
        $result = [];
        if ($categoryIds) {
            $elasticParams = [
                'size' => $limit,
                '_source' => ['_id'],
            ];
            $elasticParams['query']['bool']['must'] = [
                [
                    'terms' => [
                        "category_id" =>  $categoryIds,
                    ],
                ],
            ];
            $res = $this->elasticService->searchDocument($elasticParams, 'products', $this->elasticServiceConfig['index']);
            $result = $this->parseProductId($res);
        }
        return response()->json([
            'status' => 'successful',
            'result' => $result,
        ]);
    }

    protected function parseProductId($response)
    {
        $result = [];
        if (isset($response['hits']['hits'])) {
            foreach ($response['hits']['hits'] as $hit) {
                $result[] = $hit['_id'];
            }
        }
        return $result;

    }

    public function searchVariantOptions(Request $request)
    {
        $productIds = $request->input('product_ids');
        $variantId = $request->input('variant_id');
        $productIds = explode(',', $productIds);
        if (!$productIds || !$variantId) {
            return response()->json([]);
        }
        $elasticParams = $this->buildSearchParams($productIds, $variantId);
        $searchData = $this->elasticService->searchDocument($elasticParams, 'products', $this->elasticServiceConfig['index']);

        $result = $this->filter($searchData, $variantId);
        return response()->json([
            'status' => 'successful',
            'result' => $result,

        ]);
    }

    protected function filter($response, $variantId)
    {
        $result = [];
        if (isset($response['hits']['hits'])) {
            foreach ($response['hits']['hits'] as $hit) {
                $hit = $hit['_source'];
                if (isset($hit['variant'][$variantId]['options']) && $hit['variant'][$variantId]['options'])
                    $result = array_merge($result, $hit['variant'][$variantId]['options']);
            }
        }
        return array_values(array_unique($result));

    }

    protected function buildSearchParams($productIds, $variantId)
    {
        $elasticParams = [
            'query' => [
                'bool' => [
                    'must' => [
                        [
                            'terms' => [
                                '_id' => $productIds,
                            ],
                        ],
                    ],
                ],
            ],
            '_source' => ['_id', "variant.$variantId"]
        ];
        $elasticParams['query']['bool']['must'][]['match'] = ["variant.$variantId.variant_id" => $variantId];
        return $elasticParams;
    }
}