<?php

namespace Modules\ZSearch\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Support\Facades\Config;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    protected function recordsCountToPagesCount($recordsCount, $pageSize) {
        $retVal = (int)($recordsCount / $pageSize);
        if ($recordsCount % $pageSize > 0) {
            $retVal++;
        }
        return $retVal;
    }

    public function clRoute($path) {
        $retval = $path;
        $prefix = env('APP_LOCALE');
        $defaultLocale = Config::get('localization::module.default_locale', 'us');
        if ($defaultLocale) {
            if (strpos($path, $prefix . '/') !== false) {
                return $retval;
            }
            $isLocalization = env('LOCALIZATION');
            $listPath = explode('/',$path);
            $listPath = array_filter($listPath);
            if (in_array($prefix, $listPath)) {
                unset($listPath[$prefix]);
            }
            if ($isLocalization && $defaultLocale != $prefix) {
                array_unshift($listPath, $prefix);
                array_unshift($listPath, "");
            }
            $retval = implode('/', $listPath);
        }

        return $retval;
    }

    protected  function getMetaData($data, $total) {
        $pageId = 0;
        $pageSize = 20;
        if (!empty($data['page_size'])) {
            $pageSize = $data['page_size'];
        }
        if (!empty($data['page_id'])) {
            $pageId = $data['page_id'];
        }
        $meta = [
            'page_id' => $pageId,
            'page_size' => $pageSize,
            'has_next' => false,
            'total_count' => $total,
        ];
        $meta['page_count'] = ceil($total / $pageSize);
        if ($pageId < $meta['page_count'] - 1) {
            $meta['has_next'] = true;
        }

        return $meta;
    }

    protected function prepareOutPut($result, $filters)
    {
        $return = [
            'meta' => [
                'page_size' => !empty($filters['page_size']) ? $filters['page_size'] : 20,
                'page_id' => !empty($filters['page_id']) ? $filters['page_id'] : 1,
                'total_count' => 0,
                'page_count' => 0,
                'has_next' => false,
                'off_set' => !empty($filters['from']) ? $filters['from'] : 0
            ], 
            'result' => []
        ];
        $totalCount = $pageCount = 0;
        if (!empty($result['hits']) &&
            !empty($result['hits']['total'])
        ) {
            if (!is_array($result['hits']['total'])) {
                $totalCount = $result['hits']['total'];
            } elseif (isset($result['hits']['total']['value'])) {
                $totalCount = $result['hits']['total']['value'];
            }
            $pageCount = (int) ($totalCount / $return['meta']['page_size']);
            if ($totalCount % $return['meta']['page_size']) {
                $pageCount++; 
            }
            $return['meta']['total_count'] = $totalCount;
            $return['meta']['page_count'] = $pageCount;
            if ($return['meta']['page_id'] < $pageCount) {
                $return['meta']['has_next'] = true;
            }
        }
        if (!empty($result['hits']) && $result['hits']['hits']) {
            $return['result'] = array_column($result['hits']['hits'], '_source');
        }
        return $return;
    }
}
