<?php
/**
 * Created by PhpStorm.
 * User: DiemND
 * Date: 7/7/21
 * Time: 1:17 PM
 */

namespace Modules\ZSearch\Controllers;


use Illuminate\Http\Request;
use Illuminate\Routing\Route;
use Illuminate\Support\Facades\Log;
use Modules\ZSearch\Controllers\Controller;
use Modules\ZSearch\Services\AmazonService;

class CrawlController extends Controller
{
    public function amazonSearch (Request $request) {
        $countryCode = env('APP_LOCALE');
        if ($countryCode) {
            $request->request->add(['country_code' => $countryCode]);
        }
        if (\Module::isActive('CrawlProduct')) {
            $data = app()->call('\Modules\CrawlProduct\Controllers\HomeController@crawlSearch');
            return $data;
        } else {
            return  response()->json([
                'status' => 'fail',
                'message' => 'CrawlProduct module not active'
            ]);
        }
    }

    public function amazonCrawlProduct (Request $request) {
        $countryCode = env('APP_LOCALE');
        if ($countryCode) {
            $request->request->add(['country_code' => $countryCode]);
        }
        if (\Module::isActive('CrawlProduct')) {
            $data = app()->call('\Modules\CrawlProduct\Controllers\HomeController@index');
            return $data;
        } else {
            return  response()->json([
                'status' => 'fail',
                'message' => 'CrawlProduct module not active'
            ]);
        }

    }

    public function amazonCrawlMultiProduct(Request $request) {
        $items = $request->input('items', '');
        $items = json_decode($items, true);
        $urls = [];
        foreach ($items as $item) {
            $url = \route('z-search::amazonCrawlProduct', [
                'url' => $item['url'],
                'is_overwrite_product' => 1,
            ]);
            $urls[] = $url;
        }
        $data = $this->multiCurl($urls);
        return  response()->json([
            'status' => 'successful',
            'data' => $data
        ]);

    }


    protected function multiCurl($urls = [], $data = [], $method = "GET",$auth = null, $dataByUrl = [])
    {
        ini_set('MAX_EXECUTION_TIME', 300);
        $listChannel = array();
        $mh = curl_multi_init();
        foreach ($urls as $url) {
            if (isset($dataByUrl[$url])) {
                $data = $dataByUrl[$url];
            }
            $ch = curl_init();
            if (!empty($auth)){
                curl_setopt($ch, CURLOPT_USERPWD, $auth);
            }
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
            curl_setopt($ch, CURLOPT_MAXREDIRS, 3);
            curl_setopt($ch, CURLOPT_POSTREDIR, 1);
            if (isset($data['timeout'])) {
                curl_setopt($ch, CURLOPT_TIMEOUT, $data['timeout']);
            } else {
                curl_setopt($ch, CURLOPT_TIMEOUT, 10);
            }
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
            curl_multi_add_handle($mh, $ch);
            $listChannel[$url] = $ch;
        }
        $index = null;
        $result = [];
        do {
            curl_multi_exec($mh, $index);
        } while ($index > 0);

        foreach ($listChannel as $url => $ch) {
            $result[$url] = curl_multi_getcontent($ch);
            curl_multi_remove_handle($mh, $ch);
        }
        curl_multi_close($mh);
        return $result;
    }
}
