<?php

namespace App\Modules\ZSearch\Controllers\Feature;

use App\Utils;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Modules\ZSearch\Models\Product;
use Modules\Seller\Models\ProductMeta;

class BulkFeature
{
    static $cacheDefaultSku = [];
    static $templateSkuValueByTemplateId = [];
    static $categoriesIsShirt = [];
    static $categories = [];
    static $configDescription = [];
    private $skuValues = [];
    private $templateSkus = [];
    private $skus = [];
    private $seoDescriptions = [];
    private $isShowContentDatas = [];
    private $boughtTogethers = [];
    private $manualBoughtTogethers = [];
    private $productNTemplateChunk = [];
    private $productContentChunk = [];

    public function handleChunk($productIds, &$items)
    {
        self::initChunk($productIds, $items);
        $allBtgProductIds = [];
        foreach ($items as &$item) {
            $this->handleDescription($item);

            // bought together
            $btgProductIds = isset($this->boughtTogethers[$item['product']['id']]) ? json_decode($this->boughtTogethers[$item['product']['id']]->value, true) : [];
            $manualBtgProductIds = isset($this->manualBoughtTogethers[$item['product']['id']]) ? json_decode($this->manualBoughtTogethers[$item['product']['id']]->value, true) : [];
            $item['btg_product_ids'] = [];
            if (is_array($manualBtgProductIds) && is_array($btgProductIds)) {
                $item['btg_product_ids'] = array_slice(array_merge($manualBtgProductIds, $btgProductIds), 0, 8);
            } else if (is_array($btgProductIds)) {
                $item['btg_product_ids'] = $btgProductIds;
            }else if (is_array($manualBtgProductIds)) {
                $item['btg_product_ids'] = $manualBtgProductIds;
            }
            $allBtgProductIds = array_merge($allBtgProductIds, $item['btg_product_ids']);
        }

        $productCustoms = $this->buildBtgProductCustom($allBtgProductIds);
        foreach ($productCustoms as $productCustomItem) {
            $productCustomsData[$productCustomItem->product_id] = $productCustomItem;
        }

        $productNTemplates = $this->buildBtgProductNTemplate($allBtgProductIds);
        $templateIds = [];
        foreach ($productNTemplates as $productNTemplateItem) {
            $productNTemplatesData[$productNTemplateItem->product_id] = $productNTemplateItem;
            $templateIds[] = $productNTemplateItem->template_id;
        }
        foreach ($templateIds as $templateId) {
            $defaultSkusData[$templateId] = $this->buildDefaultSku($templateId);
        }

        $productNDesigns = $this->buildBtgProductNDesign($allBtgProductIds);
        $designIds = [];
        foreach ($productNDesigns as $productNDesignItem) {
            $productNDesignsData[$productNDesignItem->product_id] = $productNDesignItem;
            $designIds[] = $productNDesignItem->design_id;
        }
        $podDesignMetas = $this->buildBtgPodDesignMeta($designIds);
        foreach ($podDesignMetas as $podDesignMetaItem) {
            $podDesignMetasData[$podDesignMetaItem->design_id] = $podDesignMetaItem;
        }


        foreach ($items as &$item) {
            foreach ($item['btg_product_ids'] as $btgProductId) {
                if (isset($productCustomsData[$btgProductId])) {
                    $item['btg_product_custom'][$btgProductId] = $productCustomsData[$btgProductId];
                }

                if (isset($productNTemplatesData[$btgProductId])) {
                    $item['btg_product_n_template'][$btgProductId] = $productNTemplatesData[$btgProductId];
                    if (isset($defaultSkusData[$productNTemplatesData[$btgProductId]->template_id])) {
                        $item['btg_default_sku'][$productNTemplatesData[$btgProductId]->template_id] = $defaultSkusData[$productNTemplatesData[$btgProductId]->template_id];
                    }
                }

                if (isset($productNDesignsData[$btgProductId])) {
                    $item['btg_product_n_design'][$btgProductId] = $productNDesignsData[$btgProductId];
                    if (isset($podDesignMetasData[$productNDesignsData[$btgProductId]->design_id])) {
                        $item['btg_pod_design_meta'][$productNDesignsData[$btgProductId]->design_id] = $podDesignMetasData[$productNDesignsData[$btgProductId]->design_id];
                    }
                }
            }
        }

        foreach ($items as &$item) {
            $this->handleBtg($item);
        }
    }

    private function buildBtgProductCustom($productIds)
    {
        return DB::table('product_custom')
            ->whereIn('product_id', $productIds)
            ->get()
            ->toArray();
    }

    private function buildBtgProductNTemplate($productIds)
    {
        return DB::table('product_n_template')
            ->whereIn('product_id', $productIds)
            ->get()
            ->toArray();
    }

    private function buildBtgPodDesignMeta($designIds)
    {
        return DB::table('pod_design_meta')
            ->whereIn('design_id', $designIds)
            ->get()
            ->toArray();
    }

    private function buildBtgProductNDesign($productIds)
    {
        return DB::table('product_n_design')
            ->whereIn('product_id', $productIds)
            ->get()
            ->toArray();
    }

    private function buildDefaultSku($templateId)
    {

        if (array_key_exists($templateId, self::$cacheDefaultSku)) {
            return self::$cacheDefaultSku[$templateId];
        }
        $key = decorCacheKey('product_template_sku::' . $templateId);
        $result = Cache::get($key);
        if (!$result) {
            $result = DB::table('product_template_sku')
                ->where('template_id', $templateId)
                ->where('is_default', 1)
                ->first();
            Cache::put($key, $result, 1440);
        }
        self::$cacheDefaultSku[$templateId] = $result;
        return $result;

    }

    private function initChunk($productIds, $items)
    {
        $spids = array_map(function ($item) {
            return $item['variant_default_id'];
        }, $items);

        $this->skuValues = DB::table("product_sku_value as product_sku_value")
            ->whereIn('product_sku_value.sku_id', $spids)
            ->join('product_variant', 'product_variant.id', '=', 'product_sku_value.variant_id')
            ->join('product_variant_option', 'product_variant_option.id', '=', 'product_sku_value.variant_option_id')
            ->get(['product_sku_value.sku_id',
                'product_sku_value.variant_id', 'product_sku_value.variant_option_id',
                'product_variant.name', 'product_variant_option.name as option_name',
                'product_variant_option.slug'
            ])
            ->groupBy('sku_id')
            ->toArray();
        $this->templateSkus = DB::table('product_template_sku')
            ->whereIn('id', $spids)
            ->get(['id', 'sku'])
            ->keyBy('id')
            ->toArray();
        $this->skus = DB::table('product_sku')
            ->whereIn('id', $spids)
            ->get(['id', 'sku'])
            ->keyBy('id')
            ->toArray();
        $this->seoDescriptions = ProductMeta::whereIn('product_id', $productIds)
            ->where('key', 'seo_description')
            ->get()
            ->keyBy('product_id')
            ->toArray();
        $this->isShowContentDatas = DB::table('product_meta')
            ->whereIn('product_id', $productIds)
            ->where('key', 'is_show_product_content')
            ->get(['value', 'product_id'])
            ->keyBy('product_id')
            ->toArray();
        $this->boughtTogethers = DB::table('product_meta')
            ->whereIn('product_id', $productIds)
            ->where('key', '=', 'bought_together_products')
            ->get()
            ->keyBy('product_id')
            ->toArray();
        $this->manualBoughtTogethers = DB::table('product_meta')
            ->whereIn('product_id', $productIds)
            ->where('key', '=', 'manual_bought_together_products')
            ->get()
            ->keyBy('product_id')
            ->toArray();
        $this->productNTemplateChunk = DB::table('product_n_template')
            ->whereIn('product_id', $productIds)
            ->select('template_id')
            ->get()
            ->keyBy('product_id')
            ->toArray();
        $this->productContentChunk = DB::table('product_content')
            ->whereIn('product_id', $productIds)
            ->select('content', 'product_id')
            ->get()
            ->keyBy('product_id')
            ->toArray();
    }

    // description feature
    public function handleDescription(&$result)
    {
        $description = $this->getConfigDescription($result);

        if ($description) {
            $result['product']['description'] = $description;
        } else {
            $result['product']['description'] = stripSciptTag($result['product']['description']);
        }
    }

    private function getConfigDescription($result)
    {
        $spid = $result['product']['variant_default']['id'] ?? null;
        if (request()->input('spid')) {
            $spid  = request()->input('spid');
        }

        $input = [
            'product' => $result['product'],
            'product_id' => $result['product']['id'],
            'spid' => $spid,
            'featureTag' => $result['product']['featureTag'],
            'category' => $result['category'],
            'variant_default' => $result['product']['variant_default'] ?? null,
            'result' => $result
        ];

        return $this->getProductDescriptionNew($input);

    }

    public function getProductDescriptionNew($data, $renderPropertiesTable = true)
    {
        $isTemplate = isset($this->productNTemplateChunk[$data['product_id']]);
        $skuValues = $this->getTemplateSkuValue($data['product']['template_id']);
        if (empty($skuValues)) {
            $skuValues = $this->skuValues[$data['result']['variant_default_id']] ?? [];
        }
        $sku = $this->templateSkus[$data['product_id']] ?? $this->skus[$data['product_id']] ?? null;
        $product = isset($data['product']) ? $data['product'] : null;

        if (!isset($data['category'])) {
            $category = DB::table('product_n_category')
                ->join('category', 'category.id', 'product_n_category.category_id')
                ->where('product_n_category.product_id', $data['product_id'])
                ->where('product_n_category.is_parent', 0)
                ->first(['category.id', 'category.name', 'category.slug', 'category.breadcrumb']);
            $data['category'] = (array) $category;
        }
        if (!$product) {
            $product = DB::table('product')->where('id', $data['product_id'])
                ->select(['id', 'sku', 'name', 'description', 'content'])
                ->first();
            $product = (array) $product;
            $data['product'] = $product;
        }

        $data['sku_values'] = $skuValues;
        $data['sku'] = $sku;
        $data['is_template'] = $isTemplate;
        $data['sku_data'] = $this->parseSkuValues($skuValues);
        $skuData = $data['sku_data'];
        $result = $this->getConfiguredDescriptionNew(isset($data['category']['id']) ? $data['category']['id'] : '', $skuData['style_id'], $skuData['type_id']);
        $retVal = $result['option_description'];
        if (!$retVal && $product['description']) {
            $retVal = $product['description'];
        }
        //cache
        $seoDescription = isset($this->seoDescriptions[$data['product_id']]) ? json_decode($this->seoDescriptions[$data['product_id']]['value']) : null;
        $textSku = preg_replace('/\s+/', ' ', $skuData['type'] . ' ' . $skuData['color']);

        $featureTag = '';
        if (isset($data['category']['name']))
        {
            $featureTag = $data['category']['name'];
        }
        $escapedDescription = stripSciptTag($retVal);
        if ($seoDescription) {
            $siteName = config("app.name", "Printerval");
            $seoDescriptionStart    = $seoDescription->start . ' ' . sprintf( __("%s For %s belong theme %s at %s"), $product['name'], $textSku, $featureTag, $siteName);
            $seoDescriptionEnd      = $seoDescription->first_part_of_end . sprintf(" " . __("%s or see more %s products") . " ", $product['name'], $featureTag) . $seoDescription->last_part_of_end;
            $seoDescriptionStart    = str_replace('{Type}', $skuData['type'], $seoDescriptionStart);
            $seoDescriptionEnd      = str_replace('{Type}', $skuData['type'], $seoDescriptionEnd);
            $escapedDescription = '<p>' . $seoDescriptionStart . '</p>' . $escapedDescription . '<p>' . $seoDescriptionEnd . '</p>';
        }
        //@todo cache
        $isShowContentData = $this->isShowContentDatas[$data['product_id']] ?? null;
        if ($isShowContentData && $isShowContentData->value == 1) {
            $escapedDescription =  $product['content'] . $escapedDescription;
        }
        $headingDescription = $this->getHeadingDescription($data['product_id']);
        if ($headingDescription) {
            $escapedDescription = $headingDescription . ' ' . $escapedDescription;
        }

        if ($renderPropertiesTable) {
            $tableProductProperties = $this->renderProductPropertiesV2($data);
            if ($tableProductProperties) {
                $escapedDescription =  $tableProductProperties . $escapedDescription;
            }
        }
        return $escapedDescription;
    }

    private function getTemplateSkuValue($templateId)
    {
        if (isset(self::$templateSkuValueByTemplateId[$templateId])) {
            return self::$templateSkuValueByTemplateId[$templateId];
        }
        $templateSku = DB::table('product_template_sku')
            ->where('template_id', $templateId)
            ->where('is_default', 1)
            ->first();
        if ($templateSku) {
            $templateSkuValue = DB::table('product_template_sku_value as product_sku_value')
                ->where('sku_id', $templateSku->id)
                ->join('product_variant', 'product_variant.id', '=', 'product_sku_value.variant_id')
                ->join('product_variant_option', 'product_variant_option.id', '=', 'product_sku_value.variant_option_id')
                ->get(['product_sku_value.sku_id',
                    'product_sku_value.variant_id', 'product_sku_value.variant_option_id',
                    'product_variant.name', 'product_variant_option.name as option_name',
                    'product_variant_option.slug'
                ])
                ->toArray();
            self::$templateSkuValueByTemplateId[$templateId] = $templateSkuValue;

            return $templateSkuValue;
        }

        return [];
    }

    protected function getSkuValues($skuId, $isTemplate = false) {
        $skuTable = 'product_sku_value';
        if ($isTemplate) {
            $skuTable = 'product_template_sku_value';
        }
        return DB::table("$skuTable as product_sku_value")
            ->where('product_sku_value.sku_id', $skuId)
            ->join('product_variant', 'product_variant.id', '=', 'product_sku_value.variant_id')
            ->join('product_variant_option', 'product_variant_option.id', '=', 'product_sku_value.variant_option_id')
            ->get(['product_sku_value.sku_id',
                'product_sku_value.variant_id', 'product_sku_value.variant_option_id',
                'product_variant.name', 'product_variant_option.name as option_name',
                'product_variant_option.slug'
            ]);
    }

    protected function getSku($skuId, $isTemplate) {
        $skuTable = 'product_sku';
        if ($isTemplate) {
            $skuTable = 'product_template_sku';
        }
        return DB::table($skuTable)->where('id', $skuId)->first(['id', 'sku']);
    }

    protected function parseSkuValues($skuValues) {
        $skuData = [
            'type_id' => null,
            'style_id' => null,
            'size' => null,
            'color' => null,
            'type' => null,
            'variants' => []
        ];
        if ($skuValues) {
            foreach ($skuValues as $value) {
                $nameSlug = str_slug($value->name);
                $skuData[$nameSlug] = $value->option_name;
                $skuData[$nameSlug . '_id'] = $value->variant_option_id;
                $skuData[$nameSlug . '_slug'] = $value->slug;
                $skuData['variants'][$nameSlug] = $value->option_name;
            }
        }

        return $skuData;
    }

    private function getConfiguredDescriptionNew($categoryId, $styleId = null, $typeId = null)
    {
        $configDescription = null;
        if ($categoryId) {
            $configDescription = $this->getCategoryConfigDescription($categoryId, $styleId, $typeId);
            if (!$configDescription) {
                $configDescription = $this->getCategoryConfigDescription($categoryId, null, null);
            }
        }

        $result['option_description'] = $configDescription;
        $result['categories'] = null;
        return $result;
    }

    protected function getCategoryConfigDescription($categoryId, $styleId = null, $typeId = null) {
        $result = null;
        $key = 'getCategoryConfigDescription::' . $categoryId;
        if ($styleId) {
            $key .= '::style' . $styleId;
        }
        if ($typeId) {
            $key .= '::type' . $typeId;
        }
        $key = decorCacheKey($key);
        if (array_key_exists($key, self::$configDescription)) {
            return self::$configDescription[$key];
        }
        $result = Cache::get($key);
        if (!$result) {
            $configDescriptionNCategory = $this->buildQuery($categoryId, $styleId, $typeId)
                ->orderBy('level', 'asc')
                ->first(['config_id']);
            if (isset($configDescriptionNCategory->config_id)) {
                $configDescription = $this->getConfigDescriptionById($configDescriptionNCategory->config_id);
                $result = isset($configDescription->description) ? $this->nl2p($configDescription->description) : null;
            }
            Cache::put($key, $result, 1440);
        }
        self::$configDescription[$key] = $result;
        return $result;
    }

    protected function buildQuery($categoryId, $styleId, $typeId) {
        $query = DB::table('config_description_n_category')
            ->where('category_id', $categoryId);
        if ($styleId) {
            $query->where('style_id', $styleId);
        } else {
            $query->whereNull('style_id');
        }
        if ($typeId) {
            $query->where('type_id', $typeId);
        } else {
            $query->whereNull('type_id');
        }
        return $query;
    }

    protected function getConfigDescriptionById($id) {
        return DB::table('config_description_product_description')->where('id', $id)->first();
    }

    private function nl2p($text)
    {
        $lines = explode("\n", $text);
        $html = '';
        foreach ($lines as $line) {
            if (trim($line) !== '') {
                $html .= "<p>" . $line . "</p>";
            }
        }
        return $html ?? $text;
    }

    protected function getHeadingDescription($productId)
    {
        $headProductContent = isset($this->productContentChunk[$productId]) ? $this->productContentChunk[$productId] : null;

        if ($headProductContent && $headProductContent->content) {
            return "<h2 style=\"font-size:16px\">" . $headProductContent->content . "</h2>";
        }

        return null;
    }

    private function renderProductPropertiesV2($data)
    {
        $productProperties = [];

        try {
            $breadcrumb = [];
            $mainCategory = null;
            if (isset($data['category']['breadcrumb'])) {
                $breadcrumb = $data['category']['breadcrumb'];
                if ($breadcrumb) {
                    $productProperties[__('Categories')] = $breadcrumb;
                    $data['category']['url'] = $breadcrumb[count($breadcrumb)-1]['url'];
                }

            }

            $prodSku = $data['product']['sku'];
            if (isset($data['sku']->id)) {
                $prodSku = $data['sku']->sku;
                if (strpos($prodSku, '-') === 0) {
                    $prodSku = 'P' . $data['product']['id'] . $prodSku;
                }
            }
            $productProperties[__('SKU')] = $prodSku;
            if (isset($data['category']) && isset($data['sku_data']))
            {

                $langCode = env('LANGUAGE_CODE');
                $mainCategoryUrl = isset($data['category']['url']) ? $data['category']['url'] : categoryUrl($data['category']['slug']);
                $specialVariant = [
                   'color', 'type'
                ];
                foreach ($specialVariant as $variantName) {
                    $key = __(ucfirst($variantName));
                    if (isset($data['sku_data'][$variantName]) && isset($data['sku_data'][$variantName . '_slug'])) {
                        $space = strpos($langCode, 'en') === 0 ? "'s " : " ";
                        $productProperties[$key][] = [
                            'name' => $data['sku_data'][$variantName] . $space . $data['category']['name'],
                            'url' => $mainCategoryUrl. '/' . $data['sku_data'][$variantName . '_slug']
                        ];
                    }
                }

                if (isset($data['sku_data']['variants'])) {
                    foreach ($data['sku_data']['variants'] as $variant => $variantName) {
                        if (!isset($data['sku_data'][$variant]) || in_array($variant, $specialVariant)) {
                            continue;
                        }
                        $productProperties[__(ucfirst($variant))] = $variantName;
                    }
                }
            }
            return view('z-search::common.product-properties', ['productProperties' => $productProperties])->render();

        } catch (\Exception $ex) {
             \Log::error('Error getProductProperties ', [$ex->getLine().' in '.$ex->getFile()] );
        }
    }

    // btg
    public function handleBtg(&$result)
    {
        $data['bought-together'] = $this->findBoughtTogetherProducts($result['product']['id'], 3, $result);
        unset($result['btg_product_ids']);
        unset($result['btg_product_custom']);
        unset($result['btg_product_n_template']);
        unset($result['btg_default_sku']);
        unset($result['btg_product_n_design']);
        unset($result['btg_pod_design_meta']);

        if (!empty($data['bought-together']['result'])) {
//            $btgMainProduct = $result['product'];
//            $btgMainProduct['category'] = $result['category'];
//            $btgMainProduct['is_valid_print_back'] = $result['is_valid_print_back'];
//            $result['btgMainProduct'] = $btgMainProduct;
            $products = $data['bought-together']['result'];
            foreach ($products as &$item) {
                $item['variantName'] = "";
                $item['print_location'] = "front";
                if (!empty($item['variant_default'])) {
                    $item['variantName'] = $item['variant_default'][0]['product_name'];
                    $item['price'] = $item['variant_default'][0]['price'];
                    $item['high_price'] = $item['variant_default'][0]['high_price'];
                    $item['display_price'] = formatPrice(doubleval($item['price']));
                    $item['display_high_price'] = formatPrice(doubleval($item['high_price']));

                    $item['product_sku_id'] = $item['variant_default'][0]['id'];
                    $item['status'] = $item['variant_default'][0]['status'];
                }
                $item['is_select'] = false;
                if (!$item['is_custom_design']) {
                    $item['is_select'] = true;
                }
            }
            $result['btgProducts'] = $products;
        }
    }

    protected function getBoughtTogetherIds($productId, $key) {
        $productMeta = DB::table('product_meta')->where('product_id', '=', $productId)
            ->where('key', '=', $key)
            ->first();
        return isset($productMeta->value) ? json_decode($productMeta->value, true) : [];

    }

    public function findBoughtTogetherProducts($productId, $limit = 3, $result) {
        $products = [];
        $count = 0;
        $bgProductIds = $result['btg_product_ids'] ?? [];
        if ($bgProductIds && is_array($bgProductIds)) {
            $items = $this->buildBoughtTogetherQuery($bgProductIds)
                ->limit($limit)
                ->get(['product.id', 'product.sku', 'product.name', 'product.slug', 'product.status',
                    'product.image_url', 'product.price', 'product.high_price', 'product.created_at',
                    'product_n_category.category_id'
                ]);
            if (count($items) > 0) {
                foreach ($items as $item) {
                    $product = (array) $item;
                    $isShirt = $this->isShirt($product['category_id']);
                    $category = $this->getCategory($product['category_id']);
                    $validPrintBack = false;
                    if (isset($category->is_valid_print_back) && $category->is_valid_print_back == 1) {
                        $validPrintBack = true;
                    }
                    $isCustomDesign = isset($result['btg_product_custom'][$product['id']]);
                    $isMultipleDesign = false;
                    $isDoubleSided = false;
                    $product["is_custom_design"] = $isCustomDesign;
                    $attributes = $this->getAttributes($product["id"], ['multiple_design', 'is_double_sided']);
                    foreach ($attributes as $key => $attr) {
                        if ($key == "multiple_design") {
                            $isMultipleDesign = true;
                        }
                        if ($key == "is_double_sided" && $attr == 1) {
                            $isDoubleSided = true;
                        }
                    }
                    if (!$isShirt || $isMultipleDesign || $isCustomDesign || $isDoubleSided) {
                        $validPrintBack = false;
                    }
                    $product["is_valid_print_back"] = $validPrintBack;
                    $product['variant_default'] = [];
                    $products[] = $product;
                }
            }
        }
        
        return [
            "status" => "successful",
            "result" => $products,
            'count' => count($products)
        ];
    }

    public function getAttributes($productId, $keys = []) {
        $retval = [];
        $query = DB::table('product_meta')->where('product_id', $productId);
        if ($keys) {
            $query->whereIn('key', $keys);
        }
        $attributes =$query->get(['value', 'key']);
        foreach ($attributes as $key => $value) {
            $retval[$value->key] = $value->value;
            if($value->value){
                if ($value->value[0] == '[' || $value->value[0] == '{') {
                    $valueJson =  json_decode($value->value, true);
                    if (json_last_error() === JSON_ERROR_NONE) {
                        $retval[$value->key] = $valueJson;
                    }
                }
            }
        }

        return $retval;
    }


    protected function getParentCategory($productId) {
        $pnc = DB::table('product_n_category')
            ->where('product_id', $productId)
            ->where('is_parent', '0')
            ->first(['category_id']);

        return $pnc ? $pnc->category_id : null;
    }

    public function buildBoughtTogetherQuery($productIds) {
        return DB::table('product')->where("product.status", "ACTIVE")
            ->join('product_n_category', function($join) {
                $join->on('product_n_category.product_id', '=', 'product.id')
                    ->where('product_n_category.is_parent', 0);
            })
            ->whereIn("product.id", array_slice($productIds, 0, 8));
    }


    protected function isShirt($categoryId) {
        if (!self::$categoriesIsShirt) {
            $category = DB::table('category')->where('id', 6)->first(['_lft', '_rgt']);
            self::$categoriesIsShirt = DB::table('category')
                ->where('_lft', '>=', $category->_lft)
                ->where('_lft', '<=', $category->_rgt)
                ->pluck('id', 'id')
                ->toArray();
        }
        return isset(self::$categoriesIsShirt[$categoryId]) ? 1 : 0;
    }


    protected function getShirtCategories() {
        if (!self::$categoriesIsShirt) {
            $category = DB::table('category')->where('id', 6)->first(['_lft', '_rgt']);
            self::$categoriesIsShirt = DB::table('category')
                ->where('_lft', '>=', $category->_lft)
                ->where('_lft', '<=', $category->_rgt)
                ->pluck('id', 'id')
                ->toArray();
        }
        return self::$categoriesIsShirt;

    }

    protected function getCategory($categoryId) {
        if (!array_key_exists($categoryId, self::$categories)) {
            self::$categories[$categoryId] = DB::table('category')
                ->where('id', $categoryId)
                ->first([
                    'id', 'name', 'slug', 'breadcrumb', 'is_valid_print_back',
                    'parent_id', '_lft', '_rgt'
                ]);
        }
        return self::$categories[$categoryId];

    }
}
