<?php

namespace App\Modules\ZSearch\Controllers\Feature;

use App\Utils;
use Illuminate\Support\Facades\DB;
use Modules\ZSearch\Models\Product;

class MainFeature
{
    static $cache = [];
    static $templatePrintLocation = [];
    static $variantByTemplate = [];
    static $templateDesignCode = [];
    static $colorBySku = [];
    static $productNCategory = [];
    static $productNUser = [];
    static $productNRelated = [];
    static $productNTemplate = [];
    static $productNDesign = [];
    static $designNProduct = [];
    static $productCustom = [];
    static $productContent = [];
    //sp default
    static $productTemplateGalleryMainOverwrite = [];
    static $productTemplateGalleryOverwrite = [];
    static $productHasTemplateGalleryOverwrite = [];
    static $productScore = [];
    static $productVideo = [];
    static $productFeatureTag = [];
    static $productSku = [];
    static $productGallery = [];
    static $productSkuOverwrite = [];
    static $productNTags = [];
    static $categories = [];
    static $templateGallery = [];
    static $podProductTemplate = [];
    static $listCustomCategoryIds = [];

    private static $productAttrs = [];
    const MAX_ITEM_TAGS = 12;

    public function handleChunk($productIds)
    {
        if (!$productIds) {
            return [];
        }
        self::initChunk($productIds);
        $products = $this->find([
            'ids' => $productIds,
            'statuses' => ['ACTIVE', 'INACTIVE'],
        ])->keyBy('id')->toArray();

        $result = [];
        foreach ($products as $product) {
            $product['design_id'] = isset(self::$productNDesign[$product['id']][0]->design_id) ? self::$productNDesign[$product['id']][0]->design_id : 0;
            $product['is_flash_sale'] = 0;
            $product['template_id'] = isset(self::$productNTemplate[$product['id']]) ? self::$productNTemplate[$product['id']] : 0;
            $product['score'] = $this->getScore($product['id']);
            $product['tags'] = isset(self::$productNTags[$product['id']]) ?  $this->buildProductNTag(self::$productNTags[$product['id']]) : [];
            $product['user'] = isset(self::$productNUser[$product['id']]) ? (array) self::$productNUser[$product['id']] : [];
            $product['attributes'] = isset(self::$productAttrs[$product['id']]) ? self::$productAttrs[$product['id']] : [] ;
            if ($product['template_id']) {
                $product['variant_by_template'] = $this->variantByTemplate($product['template_id']);
            }

            $item['id'] = $product['id'];
            $item['product'] = $product;
            $item['category'] = $this->getCategory($product['id']);
            $item['isShirt'] = isset($item['category']['isShirt']) ? $item['category']['isShirt'] : 0;
            $item['variant_default_id'] = $product['id'];
            $item['related'] = [];
            $defaultVariant = $this->getDefaultVariant($product['id'], $product['template_id']);
            $item['product']['variant_default'] = (array) $defaultVariant;
            if ($defaultVariant && isset($defaultVariant->id)) {
                $item['variant_default_id'] = $defaultVariant->id;
                list($isChangeImage, $imageUrl) = self::getImageUrl($product, $defaultVariant, $product['template_id']);
                list($isChangeGalleries, $galleries) = self::getGallery(
                    $item['product'],
                    $product['template_id'],
                    $defaultVariant,
                    $isChangeImage
                );
                $item['product']['galleries'] = $this->toArray($galleries);
                if ($isChangeImage) {
                    $item['product']['image_url'] = $imageUrl;
                    $item['product']['variant_default']['image_url'] = $imageUrl;
                } else {
                    $item['product']['variant_default']['image_url'] = $item['product']['image_url'];
                }
            }
            $categoryId = isset($item['category']->id) ? $item['category']->id : null;
            $item['product']['featureTag'] = $this->getProductFeatureTag($product['id'], $categoryId);
            $item['videos'] = isset(self::$productVideo[$product['id']]) ? self::$productVideo[$product['id']] : [];
            $item['alsoAvailable'] = $this->getAlsoAvailable($product['id']);
            $item['related'] = $this->getRelatedProduct($product['id']);

            $this->handleMetaData($item);
            $this->handleCustom($item);
            $this->handlePrintLocation($item);
            $result[] = $item;
        }
        return $result;
    }

    protected function getRelatedProduct($productId) {
        return array_key_exists($productId, self::$productNRelated) ? array_values(self::$productNRelated[$productId]) : [];
    }

    private function handleCustom(&$item) {
        $isCustomDesign = 0;
        $customizationTemplateType = 0;
        if (isset(self::$productCustom[$item['product']['id']])) {
            $item['product']['attributes']['custom_design_type'] = self::$productCustom[$item['product']['id']]->type;
            $item['product']['attributes']['is_custom_design'] = 1;
            $isCustomDesign = 1;
        } else {
            //@todo cache
            if (array_key_exists($item['category']['id'], self::$listCustomCategoryIds)) {
                $item['product']['attributes']['is_custom_design'] = 1;
                $item['product']['attributes']['custom_design_type'] = 'auto-image-text';
                $item['customDesignType'] = 'auto-image-text';
            }
        }
        $item['customizationTemplateType'] = $customizationTemplateType;
        $item['hasCustomizationTemplate'] = $customizationTemplateType ? 1 : 0;
        $item['isCustomDesign'] = $isCustomDesign;
    }

    private function handlePrintLocation(&$result) {
        $productId = $result['product']['id'];
        $validPrintBack = 0;
        if (!empty($result['category']['is_valid_print_back']) && $result['category']['is_valid_print_back'] == 1) {
            $validPrintBack = 1;
        }
        if (array_key_exists($productId, self::$productCustom)) {
            $validPrintBack = 0;
        }

        $result['product']["is_multiple_design"] = isset(self::$productAttrs[$productId]) && array_key_exists('is_multiple_design', self::$productAttrs[$productId]) ? self::$productAttrs[$productId]['is_multiple_design'] : 0;
        $result['product']["is_double_sided"] = isset(self::$productAttrs[$productId]) &&  array_key_exists('is_double_sided', self::$productAttrs[$productId]) ? self::$productAttrs[$productId]['is_double_sided'] : 0;
        $result['product']["is_custom_design"] = isset(self::$productAttrs[$productId]) &&  array_key_exists('is_custom_design', self::$productAttrs[$productId]) ? self::$productAttrs[$productId]['is_custom_design'] : 0;

        if (!isset($result['product']['attributes']['print_locations'])
            && !empty($result['product']['template_id'])) {
            $result['product']['attributes']['print_locations'] = $this->getPrintLocationByTemplate($result['product']['template_id']);
        }

        if (
            (isset($result['product']["is_multiple_design"]) && $result['product']["is_multiple_design"] == 1)
            || (isset($result['product']["is_double_sided"]) && $result['product']["is_double_sided"] == 1)
            || (isset($result['product']["is_custom_design"]) && $result['product']["is_custom_design"] == 1)
        ) {
            $validPrintBack = 0;
        }

        $result['validPrintBack'] = $validPrintBack;

    }

    private function getPrintLocationByTemplate($templateId) {
         if (!array_key_exists($templateId, self::$templatePrintLocation)) {
             $item =  DB::table('product_template')
                 ->join('product_meta', 'product_template.product_id_fake', '=', 'product_meta.product_id')
                 ->where('product_template.id', $templateId)
                 ->where('product_meta.key', 'print_locations')
                 ->value('product_meta.value');
             self::$templatePrintLocation[$templateId] = json_decode($item, true);
         }
         return self::$templatePrintLocation[$templateId];

    }
    private function variantByTemplate($templateId) {
        if (!array_key_exists($templateId, self::$variantByTemplate)) {
            $variantByTemplateData = getOption('variant_by_template');
            if (isset($variantByTemplateData->{$templateId})) {
                self::$variantByTemplate[$templateId] = $variantByTemplateData->{$templateId};
            } else {
                self::$variantByTemplate[$templateId] = null;
            }
        }
        return self::$variantByTemplate[$templateId];

    }
    private function handleMetaData(&$result) {
        $ogImage = "";
        $productId = $result['product']['id'];
        if(isset($item['product']['image_url'])) {
            $ogImage = $item['product']['image_url'];
        }
        $result['metaImage'] = $ogImage;
        $metaData = isset(self::$productAttrs[$productId]['seo']) ? self::$productAttrs[$productId]['seo'] : [];
        if ($metaData) {
            if (isset($metaData->meta_title) ) {
                $result['metaTitle'] = $metaData->meta_title;
            }
            if (isset($metaData->meta_description) ) {
                $result['metaDescription'] = $metaData->meta_description;
            }
            if (isset($metaData->meta_keywords) ) {
                $result['metaKeywords'] = $metaData->meta_keywords;
            }
        }
        $result['nameTemplate'] = isset(self::$productAttrs[$productId]['name_template']) ? self::$productAttrs[$productId]['name_template'] : "";
        $result['urlCanonical'] = url(clroute($result['product']['url']));
        $result['canonical_url'] = url(clroute($result['product']['url']));

    }

    private function initChunk($productIds)
    {
        self::$productNCategory = DB::table('product_n_category')
            ->whereIn('product_id', $productIds)
            ->where('is_parent', 0)
            ->pluck('category_id', 'product_id')
            ->toArray();
        self::$productNUser = DB::table('product_n_user')
            ->join('users', 'product_n_user.user_id', 'users.id')
            ->whereIn('product_id', $productIds)
            ->get(['users.id', 'users.name', 'users.slug', 'product_n_user.product_id'])
            ->keyBy('product_id')
            ->toArray();
        self::$productNTemplate = DB::table('product_n_template')
            ->whereIn('product_id', $productIds)
            ->pluck('template_id', 'product_id')
            ->toArray();
        self::$productNDesign = DB::table('product_n_design')
            ->whereIn('product_id', $productIds)
            ->where('is_primary', 1)
            ->get(['product_id', 'design_id'])
            ->groupBy('product_id')
            ->toArray();
        $productIdsWithTemplate = array_keys(self::$productNTemplate);
        $productIdsWithoutTemplate = array_diff($productIds, $productIdsWithTemplate);

        if ($productIdsWithTemplate) {
            self::$productSkuOverwrite = DB::table('product_template_sku_overwrite')
                ->whereIn('product_id', $productIdsWithTemplate)
                ->get()
                ->keyBy('product_id')
                ->toArray();
            self::$productHasTemplateGalleryOverwrite = DB::table('product_template_gallery_overwrite')
                ->whereIn('product_id', $productIdsWithTemplate)
                ->groupBy('product_id')
                ->pluck('product_id', 'product_id')
                ->toArray();
            self::$templateDesignCode = DB::table('product_template_design_code')
                ->whereIn('product_id', $productIds)
                ->get(['product_id', 'design_code', 'color_id'])
                ->groupBy('product_id')
                ->toArray();

        } else {
            self::$productSkuOverwrite = [];
            self::$productTemplateGalleryMainOverwrite = [];
            self::$productTemplateGalleryOverwrite = [];
            self::$templateDesignCode = [];
        }
        self::$productSku = [];
        if ($productIdsWithoutTemplate) {
            self::$productSku = DB::table('product_sku')
                ->whereIn('product_id', $productIdsWithoutTemplate)
                ->where('is_default', 1)
                ->get()
                ->keyBy('product_id')
                ->toArray();
            self::$productGallery = [];
            if (self::$productSku) {
                $skuIds = [];
                if (self::$productSku) {
                    foreach (self::$productSku as $sku) {
                        $skuIds[] = $sku->id;
                    }
                }
                self::$productGallery = DB::table('product_gallery')
                    ->where('product_id', $skuIds)
                    ->where('type', 'VARIANT')
                    ->get()
                    ->groupBy('product_id');
            }

        }


        self::$productCustom = DB::table('product_custom')
            ->whereIn('product_id', $productIds)
            ->get()
            ->keyBy('product_id')
            ->toArray();

        self::$productNTags = DB::table('tag_refer as tr')
            ->join('tag as t', 'tr.tag_id', '=', 't.id')
            ->where('tr.refer_type', 'PRODUCT')
            ->whereIn('tr.refer_id', $productIds)
            ->select('tr.refer_id as product_id', 't.id', 't.title', 't.slug')
            ->get()
            ->groupBy('product_id');


        self::$productAttrs = [];
        $items = DB::table('product_meta')
            ->whereIn('product_id', $productIds)
            ->whereIn('key', ['seo', 'name_template', 'multiple_design',
                'double_sided', 'is_custom_design', 'print_locations', 'is_trending'])
            ->get(['product_id', 'key', 'value']);
        foreach ($items as $item) {
            if ($item->key == 'seo') {
                $item->value = json_decode($item->value);
            } else if ($item->key == 'print_locations') {
                $item->value = json_decode($item->value, true);
            }
            self::$productAttrs[$item->product_id][$item->key] = $item->value;
        }

        self::$productContent = DB::table('product_content')
            ->whereIn('product_id', $productIds)
            ->select('content', 'product_id')
            ->get()
            ->keyBy('product_id')
            ->toArray();

        self::$productScore = DB::table('score_product')
            ->whereIn('id', $productIds)
            ->pluck('score', 'id')
            ->toArray();

        self::$productVideo = DB::table('product_video')
            ->whereIn('product_id', $productIds)
            ->get()
            ->groupBy('product_id')
            ->toArray();

        self::$productFeatureTag = DB::table('product_feature_tag')
            ->whereIn('product_id', $productIds)
            ->get([
                'tag_id as id',
                'tag_title as title',
                'tag_slug as slug',
                'product_id',
            ])
            ->keyBy('product_id')
            ->toArray();
        if (!self::$listCustomCategoryIds) {
            $listCustomCategoryIds = getOption("list_custom_category_ids", []);
            foreach ($listCustomCategoryIds as $categoryId) {
                self::$listCustomCategoryIds[$categoryId] = 1;
            }
        }
        $this->buildProductNRelated($productIds);
        $this->buildDesignNProduct();
    }


    protected function buildProductNRelated($productIds) {
        self::$productNRelated = [];
        foreach (array_chunk($productIds, 50)  as $chunkProductIds) {
            self::$productNRelated += $this->getProductNRelated($chunkProductIds);
        }
    }

    protected function getProductNRelated($productIds) {
        $result = [];
        $items = DB::table('product_n_related as pnr')
            ->join('product as p', 'pnr.related_id', '=', 'p.id')
            ->whereIn('pnr.product_id', $productIds)
            ->get(['pnr.product_id', 'p.id', 'sku', 'name', 'slug', 'image_url', 'price', 'high_price']);
        foreach ($items as $item) {
            $result[$item->product_id][$item->id] = [
                'id' => $item->id,
                'sku' => $item->sku,
                'name' => $item->name,
                'slug' => $item->slug,
                'image_url' => $item->image_url,
                'price' => $item->price,
                'high_price' => $item->high_price,
            ];
        }
        return $result;
    }

    protected function buildDesignNProduct() {
        self::$designNProduct = [];
        if (!self::$productNDesign) {
            return;
        }
        $designIds = [];
        foreach (self::$productNDesign as $items) {
            //@todo only one
            foreach ($items as $item) {
                $designIds[] = $item->design_id;
            }
        }
        foreach (array_chunk($designIds, 50) as $chunkDesignId) {
            $items = DB::table('product_n_design')
                ->join('product_n_category as pnc', 'pnc.product_id', '=', 'product_n_design.product_id')
                ->join('product', 'product.id', '=', 'pnc.product_id')
                ->where('pnc.is_parent', 0)
                ->where('product.status', 'ACTIVE')
                ->whereIn('pnc.category_id', [7, 1208, 794, 171, 156, 61, 8, 54, 58, 51, 48])
                ->whereIn('product_n_design.design_id', $chunkDesignId)
                ->get([
                    'pnc.category_id', 'product_n_design.design_id', 'product.id',
                    'product.sku', 'product.name', 'product.slug', 'product.image_url',
                    'product.price', 'product.high_price', 'product.created_at', 'product.sold']);
            foreach ($items as $item) {
                if (!isset(self::$designNProduct[$item->design_id])) {
                    self::$designNProduct[$item->design_id] = [];
                }
                $item->categories = [$this->getCategoryById($item->category_id)];
                self::$designNProduct[$item->design_id][$item->id] = $item;
            }
        }
    }


    protected function getAlsoAvailable($productId) {
        $result = [];
        $designs = array_key_exists($productId, self::$productNDesign) ? self::$productNDesign[$productId] : [];
        if ($designs) {
            //@todo
            foreach ($designs as $design) {
                $result += $this->getProductFromDesign($design->design_id);
            }
            if (array_key_exists($productId, $result)) {
                unset($result[$productId]);
            }
            $result = array_values($result);
        }
        return $result;
    }

    protected function getProductFromDesign($designId) {
        $result = [];
        if (array_key_exists($designId, self::$designNProduct)) {
            $result = self::$designNProduct[$designId];
        }
        return $result;
    }

    protected function getCategoryById($id) {
        $key = 'category::' . $id;
        if (!array_key_exists($key, self::$cache)) {
            self::$cache[$key] = DB::table('category')->where('id', $id)
                ->first(['id', 'name', 'slug']);
        }
        return self::$cache[$key];
    }



    protected function getScore($productId) {
        return isset(self::$productScore[$productId]) ? self::$productScore[$productId] : 0;
    }

    protected function buildProductNTag($items) {
        $result = [];
        if ($items) {
            foreach ($items as $k => $item) {
                if ($k >= self::MAX_ITEM_TAGS) {
                    break;
                }
                $item = (array) $item;
                unset($item['product_id']);
                $result[] = $item;
            }
        }
        return $result;
    }
    protected function toArray($items) {
        $result = [];
        if ($items) {
            foreach ($items as $item) {
                $result[] = (array) $item;
            }
        }
        return $result;
    }
    

    public static function getGallery($product, $templateId, $skuDefault, $defaultImageIsChange) {
        $skuId = $skuDefault->id;
        $isTemplate = $templateId ? 1 : 0;
        $retVal = [false, []];
        if (isset(self::$productHasTemplateGalleryOverwrite[$product['id']])) {
            $items = self::getOverwriteImageUrls($product['id'], $skuId, 0);
            if (count($items)) {
                return [true, $items];
            } else {
                $primaryOverwrite = self::getOverwriteImageUrls($product['id'], $skuId, 1);
                if (count($primaryOverwrite)) {
                    $product['galleries'] = collect();
                    return [true, $items];
                } else {
                    $items = self::getOverwriteImageUrls($product['id'], 0, 0);
                    if (count($items)) {
                        return [true, $items];
                    }
                }
            }
        }

        if (!$isTemplate) {
            $items = isset(self::$productGallery[$skuId]) ? self::$productGallery[$skuId] : '';
            if ($items && count($items) > 0) {
                $retVal = [true, $items];
            } else if ($defaultImageIsChange) {
                $retVal = [true,  collect()];
            }
        } else {
            $colorId = self::getColorId($skuId);
            $design = self::getTemplateDesign($product['id'], $colorId);
            $galleries = self::getTemplateGallery($skuId);
            $productGalleries = collect();
            foreach ($galleries as $item) {
                $parseUrl = self::replaceTemplateDesignImageUrl($design, $item->image_url);
                if ($parseUrl) {
                    $item->image_url = $parseUrl;
                    $productGalleries->push($item);
                }
            }
            if (count($productGalleries)) {
                $retVal = [true, $productGalleries];
            }
        }


        // add product image_url to end of galleries when override
        try {
            $isLiveview = false;
            $imageUrlParts = parse_url($product['image_url']);
            if (
                (isset($imageUrlParts['host']) && (
                        $imageUrlParts['host'] == 'liveview.printerval.com' ||
                        strpos($imageUrlParts['host'], 'liveview') !== false)
                ) ||
                (isset($imageUrlParts['host']) && strpos($imageUrlParts['host'], 'liveview') !== false) ||
                strpos($product['image_url'], 'cdn.printerval.com/image') !== false ||
                strpos($product['image_url'], 'cdn.printerval.com/sticker') !== false
            ) {
                $isLiveview = true;
            }

            if (!$isLiveview && isset($product['image_url'], $retVal[1])) {
                if (gettype($retVal[1]) == 'object') {
                    $isFound = false;
                    foreach ($retVal[1] as $value) {
                        if ($value->image_url == $product['image_url']) {
                            $isFound = true;
                            break;
                        }
                    }
                    if (!$isFound) {
                        $retVal[0] = true;
                        $retVal[1]->push(['image_url' => $product['image_url']]);
                    }
                } else {
                    $isFound = array_filter($retVal[1], function($item) use ($product) {
                        return $product['image_url'] == $item->image_url;
                    });
                    if (!count($isFound)) {
                        $retVal[0] = true;
                        $retVal[1][] = ['image_url' => $product['image_url']];
                    }
                }
            }
        } catch (\Exception $ex) {
            \Log::error('ZSearch::MainFeature::getGallery', $ex->getMessage());
        }

        return $retVal;
    }


    public static function getOverwriteImageUrls($productId, $productSkuId, $isPrimary) {
        return DB::table('product_template_gallery_overwrite')
            ->where('product_id', $productId)
            ->where('product_sku_id', $productSkuId)->where('is_primary', $isPrimary)
            ->get(['product_sku_id', 'is_primary', 'image_url']);
    }


    public static function firstOverwriteImageUrls($productId, $productSkuId, $isPrimary) {
        return DB::table('product_template_gallery_overwrite')
            ->where('product_id', $productId)
            ->where('product_sku_id', $productSkuId)->where('is_primary', $isPrimary)
            ->first(['product_sku_id', 'is_primary', 'image_url']);
    }

    public function getDefaultVariant($productId, $templateId) {
        $result = null;
        if ($templateId) {
            if (isset(self::$productSkuOverwrite[$productId])) {
                self::$productSkuOverwrite[$productId]->id =  self::$productSkuOverwrite[$productId]->sku_id;
                $result = self::$productSkuOverwrite[$productId];
            } else {
                $result = $this->getDefaultByTemplate($templateId);
            }
        } else if (isset(self::$productSku[$productId])) {
            $result = self::$productSku[$productId];
        }
        return $result;
    }

    public function getDefaultByTemplate($templateId) {
        $key = 'default_' . $templateId;
        if (!array_key_exists($key, self::$cache)) {
            $default = DB::table('product_template_sku')->where('template_id', $templateId)
                ->where('is_default', 1)
                ->first();
            self::$cache[$key] = $default;
        }
        return array_key_exists($key, self::$cache) ? self::$cache[$key] : null;
    }



    public static function getImageUrl($product, $skuDefault, $isTemplate)
    {
        $retVal = [false, $product['image_url']];
        if (isset(self::$productHasTemplateGalleryOverwrite[$product['id']])) {
            $item = self::firstOverwriteImageUrls($product['id'], $skuDefault->id, 1);
            if (isset($item->image_url)) {
                return [true, $item->image_url];
            }
        }
        if (!$isTemplate) {
            if ($skuDefault && $skuDefault->image_url) {
                $product['image_url'] = $skuDefault->image_url;
                $retVal = [true, $product['image_url']];
            }
        } else {
            $imageUrl = self::templateImageUrl($product['id'], $skuDefault);
            if ($imageUrl) {
                $retVal = [true, $imageUrl];
            }
        }
        return $retVal;
    }

    public static function templateImageUrl($productId, $productSku)
    {
        if (isset($productSku->image_url) && isset($productSku->id)) {
            $colorId = self::getColorId($productSku->id);
            $design = self::getTemplateDesign($productId, $colorId);
            if ($design) {
                return self::replaceTemplateDesignImageUrl($design, $productSku->image_url);
            }
        }
        return null;
    }

    public static function getColorId($skuId)
    {
        if (array_key_exists($skuId, self::$colorBySku)) {
            return self::$colorBySku[$skuId];
        }
        $psv = DB::table('product_sku_value')->where('sku_id', $skuId)->where('variant_id', 2)->first();
        if ($psv) {
            self::$colorBySku[$skuId] = $psv->variant_option_id;
            return self::$colorBySku[$skuId];
        }
        return null;
    }


    public static function getTemplateGallery($skuId)
    {
        if (array_key_exists($skuId, self::$templateGallery)) {
            return self::$templateGallery[$skuId];
        }
        $galleries = DB::table('product_template_gallery')
            ->where('type', 'VARIANT')
            ->where('product_id', $skuId)
            ->get(['image_url']);
        if ($galleries) {
            self::$templateGallery[$skuId] = $galleries;
            return self::$templateGallery[$skuId];
        }
        return null;
    }



    public static function getTemplateDesign($productId, $colorId = null)
    {
        $result = null;
        if (array_key_exists($productId, self::$templateDesignCode)) {
            foreach (self::$templateDesignCode[$productId] as $item) {
                $result = $item->design_code;
                if (!$colorId || $item->color_id == $colorId) {
                    break;
                }
            }
        }
        return $result;
    }
    public static function replaceTemplateDesignImageUrl($design, $imageUrl)
    {
        if (!$design) {
            return null;
        }
        return str_replace('[DESIGN_ID]', $design, $imageUrl);
    }


    public function find($filter)
    {
        $appends = ['url'];
        Product::setCustomAppend($appends);
        $query = Product::query();

        if (array_key_exists('with', $filter)) {
            $query->with($filter['with']);
        }

        if (array_key_exists('ids', $filter)) {
            $query->whereIn('id', $filter['ids']);
        }
        if (array_key_exists('status', $filter)) {
            $query->where('status', '=', $filter['status']);
        }
        if (array_key_exists('statuses', $filter)) {
            $query->whereIn('status', $filter['statuses']);
        }
        return $query->get();
    }

    private function getCategory($productId)
    {
        if (array_key_exists($productId, self::$productNCategory)) {
            $categoryId = self::$productNCategory[$productId];
            if (array_key_exists($categoryId, self::$categories)) {
                return (array) self::$categories[$categoryId];
            }
            if (array_key_exists($categoryId, self::$categories)) {
                return (array) self::$categories[$categoryId];
            }
            $category = DB::table('category')
                ->where('id', $categoryId)
                ->first([
                'id', 'name', 'slug', 'breadcrumb', 'is_valid_print_back',
                'parent_id'
            ]);
            if ($category) {
                $category->breadcrumb =  json_decode($category->breadcrumb, true);
                $breadcrumbData = $this->buildBreadcrumb($category);
                $category->isShirt = $breadcrumbData['isShirt'];
                self::$categories[$categoryId] = (array) $category;
                return self::$categories[$categoryId];
            }
        }
        return null;
    }



    private function buildBreadcrumb($category) {
        $key = 'buildBreadcrumb::' . $category->id;
        if (array_key_exists($key, self::$cache)) {
            return self::$cache;
        }
        $isShirt = 0;
        foreach ($category->breadcrumb as $breadcrumb) {
            if ($breadcrumb["id"] == 6) {
                $isShirt = 1;
                break;
            };
        }
        //$schemaBreadcrumbs = $this->buildSchemaBreadcrumbs($breadcrumbs);
        self::$cache[$key] = [
            'isShirt' => $isShirt
        ];
        return self::$cache[$key];

    }


    private function buildSchemaBreadcrumbs($breadcrumbs)
    {
        $result = [];
        foreach ($breadcrumbs as $index => $item){

            if (!isset($item['slug'])) continue;

            $itemLink = $item['slug'];
            if (filter_var($item['slug'], FILTER_VALIDATE_URL) === FALSE) {
                $itemSlug = $item['slug'];
                if(!empty($itemSlug)){
                    $itemSlug = '/' . $itemSlug;
                }
                $itemLink = route('home') . str_replace('//','/',$itemSlug);
            }

            $breadcrumbItem = ['@type' => 'ListItem'];
            $breadcrumbItem['position'] = $index + 1;
            $breadcrumbItem['name'] = $item['name'];
            $breadcrumbItem['item'] = $itemLink;
            $result[] = $breadcrumbItem;
        }

        return $result;
    }


    protected function getProductFeatureTag($productId, $categoryId) {
        $result = isset(self::$productFeatureTag[$productId]) ? self::$productFeatureTag[$productId] : [];
        if (!$result && $categoryId) {
            $result = $this->getProductFeatureTagFromCategory($categoryId);
        }
        return  (array) $result;
    }

    protected function getProductFeatureTagFromCategory($categoryId) {
        $key = 'getProductFeatureTagFromCategory::' . $categoryId;
        if (!array_key_exists($key, self::$cache)) {
            $query = DB::table('product_n_category_top as pnc')
                ->join('tag_refer as tr', 'tr.refer_id', '=', 'pnc.product_id')
                ->join('tag as t', 'tr.tag_id', '=', 't.id')
                ->where('pnc.category_id', $categoryId)
                ->where('tr.refer_type', 'PRODUCT')
                ->limit(10);
            $items = $query->get([
                't.id', 't.title', 't.slug'
            ])->toArray();
            $result = $this->getPriorityTag($items);
            self::$cache[$key] = $result;
        }
        return self::$cache[$key];
    }

    protected function getPriorityTag($tags) {
        $result = null;
        if ($tags) {
            foreach ($tags as $tag) {
                if ($tag && self::isPriority($tag->slug, 'tag')) {
                    $result = $tag;
                    break;
                }
            }
        }
        return $result;
    }

    public static function isPriority($slug, $type) {
        $item = DB::table('slug_manager')
            ->where('slug', $slug)
            ->orderBy('priority')
            ->first(['type']);
        $result = true;
        if ($item && $item->type != $type) {
            $result = false;
        }
        return $result;
    }

    public function setPrintLocations()
    {
        if (empty($result['product']['attributes']['print_locations']) && !empty($result['product']['variant_default']['template_id'])) {
            $printLocations = DB::table('product_template')
                ->join('product_meta', 'product_template.product_id_fake', '=', 'product_meta.product_id')
                ->where('product_template.id', $result['product']['variant_default']['template_id'])
                ->where('product_meta.key', 'print_locations')
                ->value('product_meta.value');
            $result['product']['attributes']['print_locations'] = json_decode($printLocations, true);
        }
    }


}