<?php

namespace Modules\ZSearch\Controllers\Feature;

use App\Helpers\ApiClient;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\View;


class OtherFeature {

    static $podProductTemplate = [];
    static $listCategoryPerfectFit = [];
    public function handle(&$items)
    {
        foreach ($items as &$item) {
            $item['product']['zoom_in'] = false;
            $item['product']['isNofollow'] = checkNofollowImageUrl($item['product']['image_url']);
            if (!isset($item['galleries'])) {
                $item['galleries'] = [];
            }
            if (isset($item['product']['galleries'])) {
                $item['galleries'] = $this->buildGalleries($item['product']);
            }
            $item['isEnableDecoreGalleryByPrintLocation'] = empty($item['customDesignType']) && $this->isEnableDecorGalleryByPrintLocation($item['product']['id']);
            $item['isShowPerfectFit'] = $this->isPefectFit($item['category']['id']);

        }

    }

    protected function isPefectFit($categoryId) {
        if (!self::$listCategoryPerfectFit) {
            self::$listCategoryPerfectFit = $this->listCategoryPerfectFit();
        }
        return array_key_exists($categoryId, self::$listCategoryPerfectFit);
    }

    protected function listCategoryPerfectFit() {
        $result = [];
        $listCategoryPerfectFitIds = getOption("list_category_perfect_fit_ids", []);
        foreach ($listCategoryPerfectFitIds as $categoryId) {
            $result[$categoryId] = 1;
        }

        return $result;
    }


    public function handlePerfectFit(&$result)
    {
        $isShowPerfectFit = false;
        if (isset($result['category']['id'])) {
            $listCategoryPerfectFitIds = getOption("list_category_perfect_fit_ids", []);
            if (in_array($result['category']['id'], $listCategoryPerfectFitIds)) {
                $isShowPerfectFit = true;
            }
        }
        $result['isShowPerfectFit'] = $isShowPerfectFit;
    }

    private function buildGalleries ($product) {
        $retval = [$product['image_url']];
        if ($product['galleries']) {
            foreach ($product['galleries'] as $key => $value) {
                $value = (array) $value;
                $retval[] = $value['image_url'];
            }
        }

        return $retval;
    }

    private function isEnableDecorGalleryByPrintLocation($templateId) {
        if (!array_key_exists($templateId, self::$podProductTemplate)) {
            $genTemplate = DB::table('pod_product_template')->where('product_template_id', $templateId)->first(['has_print_location_preview']);
            $result = true;
            if (!$genTemplate || !$genTemplate->has_print_location_preview) {
                $result = false;
            }
            self::$podProductTemplate[$templateId] = $result;
        }
        return self::$podProductTemplate[$templateId];

    }
}