<?php

namespace Modules\ZSearch\Controllers;

use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\View;
use Modules\ZSearch\Models\Product;
use Illuminate\Http\Request;
use Modules\ZSearch\Controllers\Controller;
use Modules\ZSearch\Services\ElasticSearchService;
use Modules\ZSearch\Services\SearchDataDecor;
use Illuminate\Support\Facades\Auth;
use Theme;
use Module;

class MappingKeywordController extends Controller
{

    public function __construct()
    {
    }

    public function find(Request $request) {
        $categoryId = $request->input('category_id');
        $mappingKeywords = $this->getMappingKeyword();
        $result = $mappingKeywords && array_key_exists($categoryId, $mappingKeywords) ? $mappingKeywords[$categoryId] : [];
        return response()->json([
            'status' => 'successful',
            'data' => $result,
        ]);
    }

    public function store(Request $request) {
        $status = 'fail';
        $categoryId = $request->input('category_id');
        $data = $request->input('data');
        $mappingKeywords = $this->getMappingKeyword();
        $this->log('mappingKeywords', [
            'old' => $mappingKeywords,
            'input' => $request->all(),
            'user' => auth()->user(),
        ]);

        if (is_array($data))  {
            $mappingKeywords[$categoryId] = $data;
            $this->storeMappingKeyword($mappingKeywords);
            $status = 'successful';
        }
        return response()->json([
            'status' => $status,
            'data' => $data,
        ]);

    }

    protected function storeMappingKeyword($data) {
        DB::table('option')
            ->where('key', $this->getKey())
            ->update([
                'value' => json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES),
            ]);
    }

    protected function getMappingKeyword() {
        $result = [];
        $option = DB::table('option')
            ->where('key', $this->getKey())
            ->first(['value', 'type']);
        if ($option) {
            $result = json_decode($option->value, true);
        }
        return $result;
    }

    protected function getKey() {
        return config('z-search::sort.mapping_keyword', 'mapping_keyword');
    }

    protected function log($key, $data) {
        \Log::info($key, $data);
    }



}
