<?php
namespace Modules\ZSearch\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Modules\ZSearch\Controllers\Controller;
use Modules\ZSearch\Services\AmazonService;

class MappingOrderSearch extends SearchReactController
{

    public function cron(Request $request) {
        set_time_limit(300);
        $response = [
            'status' => 'fail',
        ];
        //build filter
        $filter = $this->buildFilterOrder($request);
        $filter['key'] = $this->orderMetaFrom;
        $filter['join_token'] = 1;
        $filter['columns'] = [
            'order.id', 'order.created_at',
            'om.value as from_search_page',
            'om2.value as token'
        ];
        try {
            $orders = $this->getOrder($filter);
            foreach ($orders as $order) {
                if ($order->from_search_page !== null || !$order->token) {
                    continue;
                }
                $this->handleOrder($order);
            }

            $response['status'] = 'successful';
        } catch (\Exception $e) {
            $response['message'] = $e->getMessage() . ' file ' . $e->getFile() . ' line ' . $e->getLine();
        }

        return response()->json($response);
    }

    protected function handleOrder($order) {
        $createDateTime = new \DateTime($order->created_at);
        $to = date('d/m/Y', $createDateTime->getTimestamp());
        $from = date('d/m/Y', $createDateTime->getTimestamp() - 30 * 86400);
        $params = [
            'token' => $order->token,
            'to' => $to,
            'from' => $from,
            'columns' => 'id,url,ip,create_time',
            'site' => $this->trackingClickerParams . '=',
            'order_by' => 'id,desc',
        ];
        //get clicker data
        $items = $this->clickerRequest($params);
        //product from search
        $detachData = $this->parseItems($items);
        $pageSearchKeyWord = [];
        $isFromPageSearch = 0;

        if ($detachData) {
            $productItems = DB::table('order_item')
                ->where('order_id', $order->id)
                ->groupBy('product_id')
                ->pluck(DB::raw('COUNT(*)'), 'product_id')
                ->toArray();
            foreach ($detachData as $item) {
                $isFromPageSearch = 1;
                $pId = $item['product_id'];
                $keyword = $item['qs'];
                if (!array_key_exists($pId, $productItems) || array_key_exists($pId, $pageSearchKeyWord)) {
                    continue;
                }
                $pageSearchKeyWord[$pId] = [
                    'keyword' => $keyword,
                    'number' => 1,
                    'product_id' => $pId,
                ];
            }
        }
        //product exists & get list product -> insert
        $this->createOrUpdateOrderMeta($order->id, $this->orderMetaFrom, $isFromPageSearch);
        if ($pageSearchKeyWord && count($pageSearchKeyWord) > 0) {
            $this->createOrUpdateOrderMeta($order->id, $this->orderMetaTrackingKeyword, json_encode($pageSearchKeyWord));
        }

    }


    protected function createOrUpdateOrderMeta($orderId, $key, $data) {
        DB::table('order_meta')
            ->where('order_id', $orderId)
            ->where('key', $key)
            ->delete();
        DB::table('order_meta')->insert([
            'order_id' => $orderId,
            'key' => $key,
            'value' => $data,
        ]);
    }




}
