<?php

namespace Modules\ZSearch\Controllers;

use App\Utils;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use Modules\ZSearch\Models\Option;
use Modules\ZSearch\Models\Product;
use Modules\ZSearch\Services\ElasticSearchIndex;
use Modules\ZSearch\Services\ElasticSearchIndexSeller;
use Modules\ZSearch\Services\ElasticSearchService;
use Modules\ZSearch\Services\TrademarkService;

class RebuildController extends Controller
{
    protected $elsIndexService;
    protected $key = 'ZSearch::productNUser';

    public function __construct()
    {

        $elasticSearchConfig = Config::get('z-search::elasticsearch');
        $this->elasticServiceConfig = $elasticSearchConfig;
    }
    public function updateSeller(Request $request)
    {
        set_time_limit(3600 * 5);
        ini_set('memory_limit', '4048M');
        $elasticsearch =  Config::get('z-search::elasticsearch');
        $startId = $request->input('from_id', -1);
        $maxId = $request->input('to_id', -1);
        $page = 10000;
        $this->setKey();
        if ($startId == -1) {
            $startId  = $this->getStartId();
        }
        if ($maxId == -1 ) {
            $maxId = $startId  + $page;
        }
        $elsIndexService = new ElasticSearchIndex();
        $elsIndexService->initAllUser();
        $elasticsearch =  Config::get('z-search::elasticsearch');
        $count = 0;
        for ($fromId = $startId; $fromId < $maxId; $fromId += $page) {
            $toId = $fromId + $page;
            $items = DB::table('product_n_user')
                ->where('id', '>=', $fromId)
                ->where('id', '<', $fromId + $page)
                ->get(['product_id', 'user_id']);
            $this->setStartId($toId);
            if (!$items) {
                continue;
            }
            $result = $elsIndexService->multiUpdateSeller($items, $elasticsearch);
            $count += $result['count'];
        }

        return response()->json([
            'status' => 'successful',
            'data' => [
                'start_id' => $startId,
                'max_id' => $maxId,
                'count' => $count,
            ],
        ]);

    }

    public function updateMultiColumn(Request $request)
    {
        set_time_limit(3600 * 5);
        ini_set('memory_limit', '1048M');
        $startId = $request->input('from_id', -1);
        $maxId = $request->input('to_id', -1);
        $startTime  = time();
        $page = 1000;
        $this->setKey('updateMultiColumn');
        if ($startId == -1) {
            $startId  = $this->getStartId();
        }
        if ($maxId == -1 ) {
            $maxId = $startId  + $page;
        }
        $elsIndexService = new ElasticSearchIndex();
        //$elsIndexService->initAllUser();
        //$elsIndexService->initProductVariantOption();
        $elasticsearch =  Config::get('z-search::elasticsearch');
        $count = 0;
        for ($fromId = $startId; $fromId < $maxId; $fromId += $page) {
            $toId = $fromId + $page;
            $items = $this->getProductUpdate($fromId, $toId);
            $this->setStartId($toId);
            $this->logRebuild([
                'from' => $fromId,
                'to' => $toId,
                'items' => count($items),
            ]);
            if (!$items) {
                continue;
            }
            $result = $elsIndexService->multiUpdateInfoProduct($items, $elasticsearch);
            $count += $result['count'];
        }

        return response()->json([
            'status' => 'successful',
            'data' => [
                'start_id' => $startId,
                'max_id' => $maxId,
                'count' => $count,
            ],
            'run_time' => time() - $startTime
        ]);

    }

    public function updateMultiProductTradeMark(Request $request)
    {
        set_time_limit(3600 * 5);
        ini_set('memory_limit', '1048M');
        $startId = $request->input('from_id', -1);
        $maxId = $request->input('to_id', -1);
        $startTime  = time();
        $page = 10000;
        $this->setKey('updateMultiProductTradeMark');
        $elsIndexService = new ElasticSearchIndex();
        $elasticsearch = Config::get('z-search::elasticsearch');
        $count = 0;
        if ($startId > 0 && $maxId > 0 && $maxId > $startId) {
            for ($fromId = $startId; $fromId < $maxId; $fromId += $page) {
                $toId = $fromId + $page;
                $items = $this->getProductTradeMarkUpdate($fromId, $toId);
                $this->logRebuildTradeMark([
                    'from' => $fromId,
                    'to' => $toId,
                    'items' => count($items),
                ]);
                if (!$items) {
                    continue;
                }

                $result = $elsIndexService->multiUpdateProductTradeMark($items, $elasticsearch);
                $count += $result['count'];
            }
        }

        return response()->json([
            'status' => 'successful',
            'data' => [
                'start_id' => $startId,
                'max_id' => $maxId,
                'count' => $count,
            ],
            'run_time' => time() - $startTime
        ]);

    }


    public function updatePaymentStat(Request $request)
    {
        set_time_limit(3600 * 5);
        ini_set('memory_limit', '2048M');
        $startTime = time();
        $startId = DB::table('product_stat')->min('id');
        $maxId = DB::table('product_stat')->max('id');
        $page = 10000;
        $elsIndexService = new ElasticSearchIndex();
        $elasticsearch =  Config::get('z-search::elasticsearch');
        for ($fromId = $startId; $fromId < $maxId; $fromId += $page) {
            $toId = $fromId + $page;
            $items = DB::table('product_stat')
                ->where('id', '>=', $fromId)
                ->where('id', '<', $toId)
                ->get(['product_id', 'total_click', 'total_sale']);
            $elsIndexService->multiUpdatePaymentStatProduct($items, $elasticsearch);
        }
        return response()->json([
            'status' => 'successful',
            'data' => [
                'start_id' => $startId,
                'max_id' => $maxId,
            ],
            'run_time' => time() - $startTime
        ]);

    }

    protected function logRebuild($data) {
        $this->log([
            'target_type' => 'ZSEARCH-rebuild',
            'event_type' => 'updateMultiColumn',
            'target_id' => 0,
            'data' => json_encode($data),
        ]);
    }

    protected function log($data) {
        $data['created_at'] = new \Datetime();
        DB::table('log')->insert($data);
    }

    protected function getProductUpdate($fromId, $toId) {
        $items = DB::table(DB::raw("sb_product as sb_p USE INDEX (PRIMARY)"))
            ->leftJoin('product_n_design as pnd', 'pnd.product_id', '=', 'p.id')
            ->where('p.id', '>=', $fromId)
            ->where('p.id', '<', $toId)
            ->where('p.status', 'ACTIVE')
            ->whereNull('p.deleted_at')
            ->get(['p.id as product_id', 'pnd.design_id', 'pnd.is_primary']);
        return $items;
    }

    protected function getStartId() {
        return Option::getStartId($this->getKey());
    }

    protected function setStartId($id) {
        $maxId = DB::table('product_n_user')->max('id');
        if ($id > $maxId) {
            $id = $maxId;
        }
        Option::setStartId($this->getKey(), $id);
    }

    protected function getKey() {
        return $this->key;
    }

    protected function setKey($value = 'ZSearch::productNUser') {
        $this->key = $value;
    }

    public function duplicateDesign(Request $request) {
        set_time_limit(3600);
        $filter = $this->buildFilter($request);
        $minId = $this->getMinId();
        $maxId = $this->getMaxId();
        $size = 200;
        $this->elasticServiceConfig = Config::get('z-search::elasticsearch');
        $this->elsIndexService = new ElasticSearchIndex();
        Product::$withoutAppends = false;
        $count = 0;
        for($fromId = $minId; $fromId <= $maxId; $fromId += $size) {
            $count += $this->handleDuplicate($fromId, $fromId + $size, $filter);;
        }
        $result['status'] = 'successful';
        $result['count'] = $count;
        $result['data'] = [
            'min_id' => $minId,
            'max_id' => $maxId,
        ];
        return response()->json($result);
    }

    protected function handleDuplicate($fromId, $toId, $filter) {
        $products = $this->getProduct($fromId, $toId, $filter);
        if ($products) {
            $this->elsIndexService->deleteByItems($products, [ElasticSearchIndex::TYPE_PRODUCTS, ElasticSearchIndex::TYPE_PRODUCTS_TOP], $this->elasticServiceConfig['index']);
        }
        return count($products);
    }

    public function getProduct($fromId, $toId, $filter) {
        $result = [];
        $pids = $this->getPids($fromId, $toId);
        if ($pids) {
            $productFilter = array_merge([
                'ids' => $pids,
            ], $filter);
            $result = Product::getProductQuery($productFilter)
                ->get(['id'])
                ->toArray();
        }
        return $result;
    }

    protected function getPids($fromId, $toId) {
        return DB::table('product_template_design_duplicate')
            ->where('id', '>=', $fromId)
            ->where('id', '<', $toId)
            ->groupBy('product_id')
            ->pluck('product_id')
            ->toArray();
    }

    protected function buildFilter($request) {
        $hour = $request->input('hour', 25);
        return [
            'is_all' => $request->input('isAll'),
            'updated_from' =>   date('Y-m-d H:i:s', time() - $hour * 3600),
        ];
    }

    protected function getMinId() {
        return 1;
    }

    protected function getMaxId() {
        $item = DB::table('product_template_design_duplicate')
            ->orderBy('id', 'desc')
            ->limit(1)
            ->first(['id']);
        return isset($item->id) ? $item->id: 5279999;
    }

    protected function initService() {
        $this->elasticService = new ElasticSearchService(Config::get('z-search::elasticsearch'));
    }

    public function rebuildSearchTracking(Request $request) {
        set_time_limit(1800);
        $startId = $request->input('from_id');
        $maxId = $request->input('to_id');
        $page = 100;
        $updateItem = [];
        $deleteItem = [];
        for ($fromId = $startId; $fromId < $maxId; $fromId += $page) {
            $items = DB::table('search_tracking')
                ->where('id', '>=', $fromId)
                ->where('id', '<', $fromId + $page)
                ->get(['id', 'keyword', 'created_at', 'quantity', 'conversion']);
            if ($items) {
                foreach ($items as $item) {
                    if ($item->keyword != html_entity_decode($item->keyword)) {
                        $keyword =  html_entity_decode($item->keyword);
                        $duplicateItem = DB::table('search_tracking')
                            ->where('created_at', $item->created_at)
                            ->where('keyword', $keyword)
                            ->first(['id', 'keyword', 'created_at', 'quantity', 'conversion']);
                        if ($duplicateItem) {
                            DB::table('search_tracking')->where('id', $duplicateItem->id)->update([
                                'quantity' =>  $duplicateItem->quantity + $item->quantity,
                                'conversion' =>  $duplicateItem->conversion + $item->conversion,
                            ]);
                            DB::table('search_tracking')->where('id', $item->id)->delete();
                        } else {
                            DB::table('search_tracking')->where('id', $item->id)->update([
                                'keyword' =>  $keyword
                            ]);
                        }

                        $updateItem[] = $item->id;
                    }
                }
            }
        }
        return [
            'status' => 'successful',
            'result' => $updateItem,
        ];
    }


    public function indexProductStat(Request $request) {
        set_time_limit(3 * 3600);
        ini_set('memory_limit', '2448M');
        $elsIndexService = new ElasticSearchIndex();
        $pids = DB::table('product_stat')
            ->where('total_sale', '>', 0)
            ->orderBy('total_sale', 'desc')
            ->pluck('product_id')
            ->toArray();
        if ($pids) {
            foreach (array_chunk($pids, 200)  as $partIds) {
                $elsIndexService->multiIndexProduct([
                    'ids' => $partIds,
                    'is_all' => 1,
                ], $this->elasticServiceConfig);
            }

        }
        $result = [
            'status' => 'successful',
            'count' => $pids ? count($pids) : 0,
        ];
        return response()->json($result);

    }


    public function indexProductSale(Request $request) {
        set_time_limit(3 * 3600);
        ini_set('memory_limit', '1448M');
        $elsIndexService = new ElasticSearchIndex();
        $fromId = $request->input('from_id');
        $toId = $request->input('to_id');

        $pids = DB::table('product_els')
            ->where('id', '>=',$fromId)
            ->where('id', '<=', $toId)
            ->pluck('product_id')
            ->toArray();
        foreach (array_chunk($pids, 200)  as $partIds) {
            $elsIndexService->multiIndexProduct([
                'ids' => $partIds,
                'is_all' => 1,
            ], $this->elasticServiceConfig);
        }
        $result = [
            'status' => 'successful',
            'count' => $pids ? count($pids) : 0,
            'result' => [
                'fromId' => $fromId,
                'toId' => $toId,
            ],
        ];
        return response()->json($result);
    }

    private function getProductTradeMarkUpdate($fromId, $toId)
    {
        $products = Product::query()
            ->join('product_n_category','product.id', '=', 'product_n_category.product_id')
            ->where('product_id', '>=', $fromId)
            ->where('product_id', '<=', $toId)
            ->where('product_n_category.is_parent', 0)
            ->get(['product.id', 'product_n_category.category_id']);
        $products->each->setAppends([]);

        return $products->toArray();
    }

    protected function logRebuildTradeMark($data) {
        $this->log([
            'target_type' => 'ZSEARCH-rebuild-trademark',
            'event_type' => 'updateMultiProductTradeMark',
            'target_id' => 0,
            'data' => json_encode($data),
        ]);
    }
}