<?php
namespace Modules\ZSearch\Controllers;


use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ReportKeywordController extends Controller
{
    static $cacheName = [];

    public function suggestKeyword(Request $request) {
        $filter = $this->buildFilter($request);
        $keywords = $this->getKeywords($filter);
        $result = [
            'data' => $keywords,
            'status' => 'successful',
        ];
        return response()->json($result);
    }

    public function statisticFromTracking(Request $request) {

        $filter = $this->buildFilter($request);
        $filter['from'] = 'tracking';
        $filter['columns'] = ['order.id', DB::raw('order_meta_search.value'), 'order_item.product_id', 'order_item.product_sku_id'];
        $data = $this->statisticFromOrder($filter);
        $data = array_values($data);
        $data = $this->sortData($data);

        $result = [
            'data' => $data,
            'status' => 'successful',
        ];
        return response()->json($result);
    }

    public function statisticFromSearchData(Request $request) {
        $filter = $this->buildFilter($request);
        $filter['from'] = 'search';
        $filter['product_ids'] = $this->getProductFromSearchData($request, $filter);
        $data = $this->statisticFromOrder($filter);
        $data = array_values($data);
        $data = $this->sortData($data);
        $result = [
            'data' => $data,
            'status' => 'successful',
        ];
        return response()->json($result);
    }

    public function getProductFromSearchData($request, $filter) {
        $result = [];
        $request->request->add([
            'q' => $filter['keyword'],
            's' => 50
        ]);

        $res = app()->call('\Modules\ZSearch\Controllers\HomeController@suggestion', ['request' => $request]);
        $res = $res->getOriginalContent();
        $products = isset($res['products']) ? $res['products'] : [];
        if ($products && count($products) > 0) {
            foreach ($products as $p) {
                $result[] = $p['id'];
            }
        }
        return $result;
    }


    //@todo multi statistic
    public function statisticFromOrder($filter, $result = []) {
        $orders = $this->getOrders($filter);
        foreach ($orders as $order) {
            $skuValues = $this->detachSku($order, $filter);
            if ($skuValues) {
                foreach ($skuValues as $item) {
                    if (!array_key_exists($item->variant_option_id, $result)) {
                        $item->count = 1;
                        $item->variant_name = $this->getVariantName($item->variant_id);
                        $item->variant_option_name = $this->getVariantName($item->variant_option_id, 'product_variant_option');
                        $result[$item->variant_option_id] = $item;
                    } else {
                        $result[$item->variant_option_id]->count++;
                    }
                }
            }

        }
        return $result;
    }

    public function getVariantName($id, $table = 'product_variant') {
        $key = $table . $id;
        if (isset(self::$cacheName[$key])) {
            return self::$cacheName[$key];
        }
        $item = DB::table($table)->where('id', $id)->first(['name']);
        $result = isset($item->name) ? $item->name : '';
        self::$cacheName[$key] = $result;
        return $result;
    }


    protected function detachSku($order, $filter) {
        $result = null;
        if (array_key_exists('from', $filter) && $filter['from'] == 'tracking') {
            $searchData = json_decode($order->value, true);
            $keyword =  strtolower($filter['keyword']);
            foreach ($searchData as $item) {
                $itemKeyword = strtolower($item['keyword']);
                $skuId = 0;
                if ($itemKeyword == $keyword && $order->product_id == $item['product_id']) {
                    $skuId = isset($order->product_sku_id) ? $order->product_sku_id : 0;
                }
                if ($skuId > 0) {
                    $result = $this->getSku($order->product_id, $skuId);
                }
            }
        }

        if (array_key_exists('from', $filter) && $filter['from'] == 'search') {
            $skuId = isset($order->product_sku_id) ? $order->product_sku_id : 0;
            $result = $this->getSku($order->product_id, $skuId);
        }


        return $result;
    }

    protected function getSku($pId, $skuId)
    {
        $result = null;
        if ($skuId > 0) {
            $result = DB::table('product_sku_value')
                ->where('product_id', $pId)
                ->where('sku_id', $skuId)
                ->get(['variant_id', 'variant_option_id'])->toArray();
        }
        return $result;
    }



    public function getOrders($filter) {
        $query = DB::table('order');
        $query->whereBetween('order.created_at', [$filter['dateFrom'], $filter['dateTo']])
              ->where('payment_status','PAID')
            ->join('order_item', 'order.id', '=', 'order_item.order_id');
        if (array_key_exists('from', $filter) && $filter['from'] == 'tracking') {
            $query->join(DB::raw('sb_order_meta as order_meta_search'), function($join) {
                $join->on(DB::raw('order_meta_search.order_id'), '=', 'order.id')
                    ->where(DB::raw('order_meta_search.key'), '=', 'search_keyword');
            })->where(DB::raw('order_meta_search.value'), 'like', '%' . $filter['keyword'] . '%');
        }
        if (array_key_exists('product_ids', $filter)) {
            $query->whereIn('order_item.product_id', $filter['product_ids']);
        }
        return $query->get($filter['columns']);
    }

    public function buildFilter($request) {
        $dateFrom = date('Y-m-d', $request->input('dateFrom', time() - 30 * 86400));
        $dateTo = date('Y-m-d', $request->input('dateTo', time()));
        $keyword = $request->input('keyword');

        return [
            'dateFrom' => $dateFrom,
            'dateTo' => $dateTo,
            'keyword' => $keyword,
            'columns' => ['order.id', 'order_item.product_id', 'order_item.product_sku_id']
        ];
    }

    protected function getKeywords($filter) {
        $query = DB::table('search_tracking')
            ->whereBetween('created_at', [$filter['dateFrom'], $filter['dateTo']])
            ->where('keyword', 'LIKE', '%'. $filter['keyword'] .'%')
            ->groupBy('keyword');
        $result = $query->get(['keyword']);
        return $result;
    }

    protected function sortData($items)
    {
        usort($items, function ($itemA, $itemB)  {
            $aValue = isset($itemA->count) ? $itemA->count : '';
            $bValue = isset($itemB->count) ? $itemB->count : '';
            $result = 0;
            if ($aValue > $bValue) {
                $result = -1;
            } else if ($aValue < $bValue) {
                $result = 1;
            }


            return $result;
        });
        return $items;
    }
}