<?php

namespace Modules\ZSearch\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ReportScoreController extends Controller
{
    public function score(Request $request)
    {
        set_time_limit(3600 * 4);
        ini_set('memory_limit', '1248M');
        $fromId = $request->input('from_id');
        $toId = $request->input('to_id');
        $type = $request->input('type');
        $startTime = time();
        if (is_null($fromId) || is_null($toId) || !$type) {
            return response()->json(['error' => 'Invalid params'], 400);
        }
        $result = [];
        $batchSize = 100000;
        $currentFromId = $fromId;
        while ($currentFromId <= $toId) {
            $currentToId = min($currentFromId + $batchSize - 1, $toId);
            if ($type == 'seller') {
                //pnu user
                $this->updateUserProductTotals($currentFromId, $currentToId);
            } else if ($type == 'crawl') {
                $this->insertReportScoreCrawl($currentFromId, $currentToId);
            } else if ($type == 'merchant') {
                if (!array_key_exists('total', $result)) {
                    $result['total'] = 0;
                }
                $result['total'] += $this->countMerchantProducts($currentFromId, $currentToId);
            } else if ($type == 'score') {
                if (!array_key_exists('total', $result)) {
                    $result['total'] = 0;
                    $result['sum_score'] = 0;
                }
                $item = $this->getScoreProductTotals($currentFromId, $currentToId);
                if ($item && isset($item->total)) {
                    $result['total'] += $item->total;
                    $result['sum_score'] += $item->sum_score;
                }
            }

            $currentFromId += $batchSize;
        }
        $response['result'] = $result;
        $response['status'] = 'successful';
        $response['run_time'] = time() - $startTime;
        return response()->json($response);
    }


    public function keywordStatistic(Request $request)
    {
        set_time_limit(3600 * 4);
        ini_set('memory_limit', '1248M');
        $startTime = time();
        $keywords = $request->input('keywords');
        if (!$keywords) {
            return response()->json(['error' => 'Invalid params'], 400);
        }
        $keywords = DB::table('report_score_keyword_config')->pluck('keyword')->toArray();
        foreach ($keywords as $keyword) {
            $this->handleKeyword($keyword);
        }
        $response['status'] = 'successful';
        $response['run_time'] = time() - $startTime;
        return response()->json($response);
    }

    protected function handleKeyword($keyword) {
        $pageCount = 10;
        for ($i = 0; $i < $pageCount; $i++) {
            $response = $this->getDataFromKeywords($keyword, $i);
            if (isset($response['status']) && $response['status'] == 'successful') {
                $pageCount = $response['meta']['page_count'];
                $this->storeKeywords($response['result'], $keyword);
            } else {
                break;
            }
        }
    }

    protected function storeKeywords($items, $keyword) {
        if (!$items) {
            return;
        }
        $insertData = [];
        foreach ($items as $item) {
            $insertData[] = [
                'product_id' => $item['id'],
                'keyword' => $keyword,
            ];
        }

        DB::table('report_score_keyword')->insert($insertData);
    }



    public function updateUserProductTotals($fromId, $toId)
    {
        $data = $this->getUserProductData($fromId, $toId);
        foreach ($data as $row) {
            DB::table('report_score_seller')->updateOrInsert(
                ['user_id' => $row->user_id, 'is_delete' => $row->is_delete],
                ['total' => DB::raw('total + ' . $row->total)]
            );
        }
    }

    protected function getUserProductData($fromId, $toId)
    {
        return DB::table('product_n_user as pnu')
            ->join('users as u', function($join) {
                $join->on('u.id', '=', 'pnu.user_id')
                     ->where('u.role', 'SELLER')
                     ->where('u.status', 'ACTIVE')
                     ->whereNotNull('u.seller_token');
            })
            ->leftJoin('merchant_product as mp', function($join) {
                $join->on('pnu.product_id', '=', 'mp.product_id')
                     ->where('mp.is_delete', '=', 0);
            })
            ->whereBetween('pnu.id', [$fromId, $toId])
            ->groupBy('pnu.user_id', 'mp.is_delete')
            ->select('pnu.user_id', 'mp.is_delete', DB::raw('count(*) as total'))
            ->get();
    }

    public function insertReportScoreCrawl($fromId, $toId)
    {
        $data = DB::table('product')
            ->select('id', DB::raw('SUBSTRING(note, 1, 10) AS note_prefix'))
            ->whereNotNull('note')
            ->where('note', 'like', '%url%')
            ->whereBetween('id', [$fromId, $toId])
            ->get();
        if (!$data || count($data) == 0) {
            return;
        }
        $insertData = [];
        foreach ($data as $item) {
            $insertData[] = [
                'id' => $item->id,
                'note_prefix' => $item->note_prefix
            ];
        }
        foreach (array_chunk($insertData, 10000) as $chunkItems) {
            DB::table('report_score_crawl')->insert($chunkItems);
        }


        return response()->json(['message' => 'Data inserted successfully']);
    }

    public function countMerchantProducts($fromId, $toId)
    {
        return DB::table('merchant_product')
            ->whereBetween('id', [$fromId, $toId])
            ->where('is_delete', 0)
            ->count();
    }

    public function getScoreProductTotals($fromId, $toId)
    {
        return DB::table('score_product')
            ->select(DB::raw('count(*) as total'), DB::raw('sum(score) as sum_score'))
            ->whereBetween('id', [$fromId, $toId])
            ->first();
    }

    public function getDataFromKeywords($keyword, $pageId = 0) {
        $url = config('app.url')  . "/z-search/trademark/search?page_size=1000&q="  . urlencode($keyword) . '&page_id=' . $pageId;
        return $this->triggerSyncRequest($url);
    }


}