<?php
namespace Modules\ZSearch\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Modules\ZSearch\Controllers\Controller;
use Modules\ZSearch\Models\SearchReact;
use Modules\ZSearch\Services\AmazonService;
use Modules\ZSearch\Models\Option;

class SearchReactController extends Controller
{
    protected $blockIP =  ['118.70.67.73'];
    protected $blockItems =  [];
    protected $orderMetaFrom =  'from_page_search';
    protected $orderMetaTrackingKeyword =  'search_keyword';
    protected $trackingClickerParams =  HomeController::SEARCH_TRACKING;

    protected $locale =  'us';
    const ORDER_META_SEARCH_KEYWORD = 'search_keyword';

    public function cronKeywordReact(Request $request) {
        set_time_limit(120);
        $this->blockIP = ['118.70.67.73'];
        $response = [
            'status' => 'fail',
        ];
        //build filter
        $filter = $this->buildFilter($request);
        try {
            $clickData = $this->getClickData($filter);
            $clickData = $this->groupClickData($clickData);
            $this->multiInsertSearchReact($clickData);
            $conversionData = $this->getConversionData($request);
            $this->multiInsertSearchReact($conversionData['product']);
            $this->updateTracking($conversionData['keyword']);
            $response['status'] = 'successful';
        } catch (\Exception $e) {
            $response['message'] = $e->getMessage() . ' file ' . $e->getFile() . ' line ' . $e->getLine();
        }

        return response()->json($response);
    }


    public function cronBuildKeywordTracking(Request $request) {
        set_time_limit(120);
        $response = [
            'status' => 'fail',
        ];
        try {
            $conversionData = $this->getConversionData($request);
            $this->updateTracking($conversionData['keyword']);
            $response['status'] = 'successful';
        } catch (\Exception $e) {
            $response['message'] = $e->getMessage() . ' file ' . $e->getFile() . ' line ' . $e->getLine();
        }

        return response()->json($response);
    }

    public function cronHomeTags(Request $request) {
        $status = false;
        $result = [];
        // Build top search keywords
        $topSearchKeywords = DB::table('search_tracking')
            ->select('keyword', 'image_url')
            ->where('created_at', '>=', date('Y-m-d', strtotime('-7 days', strtotime(date('Y-m-d')))))
            ->groupBy('keyword')
            ->orderBy(DB::raw('sum(conversion)'), 'DESC')
            ->limit(20)
            ->get();
        $this->decorTopKeywords($topSearchKeywords);
        $trademarkKeywords = DB::table('trademarks')->where('status', 'ACTIVE')->pluck('keyword')->toArray();
        foreach ($topSearchKeywords as $item) {
            $isValidKeyword = true;
            foreach($trademarkKeywords as $trademarkKeyword) {
                if (strpos(strtolower($item->keyword), strtolower($trademarkKeyword)) !== false) {
                    $isValidKeyword = false;
                    break;
                }
            }      
            if (!$isValidKeyword) {
                continue;
            }
            $result[] = [
                "tag_name" => $item->keyword,
                "url" => isset($item->explore_url) ? $item->explore_url : route('search', ['q' => $item->keyword]),
                "image_url" => getImageCdn($item->image_url, 540, 540)
            ];
            if (count($result) >= 6) {
                break;
            }
        }
        // Build top categories
        $topCategories = DB::table('order_item')
            ->select('category.slug', 'category.name', 'category.image_url')
            ->leftJoin('product_n_category', function ($join) {
                $join->on('product_n_category.product_id', '=', 'order_item.product_id')
                    ->where('product_n_category.is_parent', '=', 0);
            })
            ->leftJoin('category', 'category.id', '=', 'product_n_category.category_id')
            ->where('order_item.created_at', '>=', date('Y-m-d', strtotime('-7 days', strtotime(date('Y-m-d')))))
            ->groupBy('category.id')
            ->orderBy(DB::raw('count(sb_category.id)'), 'DESC')
            ->limit(6)
        ->get();
        foreach ($topCategories as $item) {
            $result[] = [
                "tag_name" => $item->name,
                "url" => categoryUrl($item->slug),
                'image_url' => getImageCdn($item->image_url, 540, 540)
            ];
        }
        if (count($result) > 0) {
            Option::updateOrCreate(
                ['key' => 'generated_home_tags'],
                ['value' => json_encode($result)]
            );
            $status = true;
        }        
        return response()->json([
            "status" => $status,
            "result" => $result
        ]);
    }

    protected function updateTracking($items) {
        $data = [];
        foreach ($items as $item) {
            $key = $item['keyword'] . $item['created_at'];
            if (!isset($data[$key])) {
                $data[$key] = [
                    'keyword' => $item['keyword'] ,
                    'created_at' => $item['created_at'],
                    'conversion' => 0
                ];
            }
            $data[$key]['conversion'] += $item['conversion'];
        }
        foreach ($data as $item) {
            $isExists = DB::table('search_tracking')
                ->where('keyword', $item['keyword'])
                ->where('created_at', $item['created_at'])
                ->exists();

            if ($isExists) {
                DB::table('search_tracking')
                    ->where('keyword', $item['keyword'])
                    ->where('created_at',$item['created_at'])
                    ->update($item);
            } else {
                $isExists = DB::table('search_tracking')
                    ->where('keyword', $this->stripKeyword($item['keyword']))
                    ->where('created_at', $item['created_at'])
                    ->exists();
                if ($isExists) {
                    DB::table('search_tracking')
                        ->where('keyword', $this->stripKeyword($item['keyword']))
                        ->where('created_at',$item['created_at'])
                        ->update($item);
                }
            }
        }

    }

    protected function stripKeyword($keyword) {
        $keyword = strip_tags($keyword);
        $keyword = trim(preg_replace('/\s+/', ' ', strtolower($keyword)));
        $keyword = htmlentities($keyword, ENT_QUOTES);
        return $keyword;
    }

    protected function multiInsertSearchReact($items) {
        foreach ($items as $item) {
            SearchReact::createOrUpdateSearchReact($item);
        }
    }



    protected function getConversionData($request) {
        $filter = $this->buildFilterOrder($request);
        $filter['key'] = $this->orderMetaTrackingKeyword;
        $filter['columns'] = [
            'order.id',
            'order.created_at',
            'om.value as data',
        ];
        $orders = $this->getOrder($filter);
        $conversionByProduct = [];
        $conversionByKeyword = [];
        foreach ($orders as $order) {
            if (!$order->data) {
                continue;
            }
            $flagKeyword = [];
            $dateTime = new \DateTime($order->created_at);
            $date = $dateTime->format('Y-m-d');
            $items = json_decode($order->data, true);
            foreach ($items as $item) {
                $productId = $item['product_id'];
                $keyword = strtolower($item['keyword']);
                $keyGBP = $this->keywordReactKey($productId, $keyword, $date);
                $keyGBK = $this->keywordReactKey($order->id, $keyword, $date);
                if (!array_key_exists($keyGBP, $conversionByProduct)) {
                    $conversionByProduct[$keyGBP] = [
                        'date' => $date,
                        'keyword' => $keyword,
                        'conversion' => 0,
                        'product_id' => $productId,
                    ];
                }
                if (!array_key_exists($keyGBK, $conversionByKeyword)) {
                    $conversionByKeyword[$keyGBK] = [
                        'created_at' => $date,
                        'keyword' => $keyword,
                        'conversion' => 0,
                    ];
                }
                $conversionByProduct[$keyGBP]['conversion']++;
                if (!isset($flagKeyword[$keyword])) {
                    $conversionByKeyword[$keyGBK]['conversion']++;
                    $flagKeyword[$keyword] = 1;
                }

            }

        }

        return [
            'product' => $conversionByProduct,
            'keyword' => $conversionByKeyword,
        ];
    }

    private function keywordReactKey($pId, $keyword, $date) {
        return $pId . '::' . $keyword . '::' .$date;
    }

    protected function groupClickData($items) {
        $result = [];
        foreach ($items as $item) {
            $date = $item['date'];
            $keyword = strtolower($item['qs']);
            $productId = $item['product_id'];
            $keyGroup = $this->keywordReactKey($productId, $keyword, $date);
            if (!array_key_exists($keyGroup, $result)) {
                $result[$keyGroup] = [
                    'date' => $date,
                    'product_id' => $productId,
                    'keyword' => $keyword,
                    'click' => 0,
                ];
            }
            $result[$keyGroup]['click']++;
        }
        return $result;
    }


    protected function getPaginator($filter) {
        $pageSize = $filter['page_size'];
        $filter['page_size'] = 1;
        $filter['order_by'] = 'create_time,asc';
        $filter['columns'] = 'id';
        $firstItem = $this->clickerRequest($filter);
        $filter['order_by'] = 'create_time,desc';
        $lastItem = $this->clickerRequest($filter);
        $fromId = $firstItem && isset($firstItem[0]['id']) ? $firstItem[0]['id'] : -1;
        $toId = $lastItem && isset($lastItem[0]['id']) ? $lastItem[0]['id'] : -1;
        return [
            'fromId' => $fromId,
            'toId' => $toId,
            'pageCount' => ceil(($toId - $fromId)/$pageSize),
            'pageSize' => $pageSize,
        ];
    }

    protected function getLocaleFromUrl($path) {
        $locale = 'us';
        if ($path) {
            $pathExplode = explode('/', $path);
            $pathExplode = array_values(array_filter($pathExplode));
            $prefix = isset($pathExplode[0]) ? $pathExplode[0] : '';
            if ($prefix && in_array($prefix, ['au', 'ca', 'es', 'fr', 'jp', 'it', 'pt', 'uk', 'de'])) {
                $locale = $prefix;
            }
        }
        return $locale;
    }

    protected function getClickData($filter) {
        //get paginator
        $paginator = $this->getPaginator($filter);
        //loop
        $data = [];
        $i = 1;
        $pageCount = $paginator['pageCount'];
        $filterFromId = $paginator['fromId'];
        $pageSize = $paginator['pageSize'];
        while ($i <= $pageCount) {
            $fromId = $filterFromId + (($i - 1) * $pageSize);
            $toId = $filterFromId + ($i * $pageSize);
            if ($toId > $paginator['toId']) {
                $toId = $paginator['toId'];
            }
            $clickerParams = array_merge($filter, [
                'from_id' => $fromId,
                'to_id' => $toId,
                'site' => $this->trackingClickerParams . '=',
                'columns' => 'id,url,ip,create_time',
            ]);
            $items = $this->clickerRequest($clickerParams);
            $itemsData = $this->parseItems($items);
            if ($itemsData) {
                $data = array_merge($data, $itemsData);
            }
            $i++;
        }
        return $data;
    }

    protected function parseItems($items) {
        $result = [];
        if ($items) {
            foreach ($items as $item) {
                $item['urlParser'] = parse_url($item['url']);
                if (!$this->validateItem($item)) {
                    continue;
                }
                $itemData = $this->parseItem($item);
                if ($itemData) {
                    $result[] = $itemData;
                }
            }
        }
        return $result;
    }

    protected function validateItem($item) {
        $isOk = true;
        $urlParser = $item['urlParser'];
        if (!$item || (isset($item['ip']) && in_array($item['ip'], $this->blockIP))) {
            $isOk = false;
        }
        if ($this->locale != $this->getLocaleFromUrl($urlParser['path'])) {
            $isOk = false;
        }
        return $isOk;
    }

    protected function parseItem($item) {
        $urlParser = $item['urlParser'];
        $qs = $this->getKeywordFromUrl($item['url']);
        $result = [];
        $productId = null;
        if ($qs) {
            preg_match('/.*-p([0-9]+)\.html$/i', $urlParser['path'], $match);
            if ($match) {
                $productId = isset($match[1]) ? $match[1] : '';
            }
            if (!$match) {
                preg_match('/.*-p([0-9]+)/i', $urlParser["path"], $match);
                $productId = isset($match[1]) ? $match[1] : '';
            }
            if ($productId) {
                $dateExplode = explode(' ', $item['create_time']);
                $result = [
                    'product_id' => $productId,
                    'qs' => $qs,
                    'id' => $item['id'],
                    'date' => $dateExplode[0]
                ];
            }
        }
        return $result;
    }

    protected function getKeywordFromUrl($url) {
        $separator = $this->trackingClickerParams . '=';
        $urlExplode = explode($separator, $url);
        $result = null;
        if ($urlExplode && isset($urlExplode[1]) && $urlExplode[1]) {
            $searchTrackingExplode =  explode('&', $urlExplode[1]);
            $result = $searchTrackingExplode[0];
        }
        return $result;
    }

    protected function buildFilter($request) {
        $currentUrl = $request->url();
        $parseUrl = parse_url($currentUrl);
        $this->locale = $this->getLocaleFromUrl($parseUrl['path']);

        $domain = $parseUrl['host'];
        $from = $request->input('from', 2);
        $to = $request->input('to', 0);
        $fromDay = date('d/m/Y', strtotime("-$from days"));
        $toDay = date('d/m/Y', strtotime("-$to days"));
        $this->handleTrackingParams($request->input('type', ''));
        return [
            'from' => $fromDay,
            'to' => $toDay,
            'site' => $domain,
            'page_size' => 10000,
        ];
    }


    protected function clickerRequest($params = [], $path = '/service/get-data-tracking') {
        $username = config('app.clickerAuthBasic.username');
        $password = config('app.clickerAuthBasic.password');
        $clickerUrl = config("app.clickerDomain");
        if ($username == null || $password == null) {
            throw new \Exception('The module require "clickerAuthBasic.username" and "clickerAuthBasic.password" in /config/app.php');
        }
        $headers = array(
            'Content-Type:application/json',
            'Authorization: Basic '. base64_encode($username . ":" . $password)
        );
        $apiUrl = $clickerUrl . $path;
        if ($params) {
            $query = http_build_query($params);
            $apiUrl = $apiUrl . '?' . $query;
        }
        $response = $this->triggerSyncRequest($apiUrl, 'GET', [], $headers);
        return $response && array_key_exists('data', $response) ? $response['data'] : [];
    }


    protected function triggerSyncRequest($url, $method = 'GET', $params = [], $headers = []) {
        $ch = curl_init();
        $timeout = 200;
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        if ($headers) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        }
        if ($method != 'GET') {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
        }
        curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
        $data = curl_exec($ch);
        curl_close($ch);
        return json_decode($data, true);
    }



    protected function buildFilterOrder($request)
    {
        $this->handleTrackingParams($request->input('type', ''));
        $from = $request->input('from', 2);
        $to = $request->input('to', 0);
        $fromDay = date('Y-m-d 00:00:00', strtotime("-$from days"));
        $toDay = date('Y-m-d 23:59:59', strtotime("-$to days"));
        return [
            'from' => $fromDay,
            'to' => $toDay,
        ];
    }

    public function getOrder($filter) {
        $metaKey = isset($filter['key']) ? $filter['key'] : $this->orderMetaTrackingKeyword;
        $columns = isset($filter['columns']) ? $filter['columns'] : ['*'];
        $query = DB::table('order')
            ->where('order.payment_status', 'PAID')
            ->leftJoin('order_meta as om', function($join) use ($metaKey) {
                $join->on('om.order_id', '=', 'order.id')
                    ->where('om.key', $metaKey);
            });
        if (array_key_exists('join_token', $filter)) {
            $query->leftJoin('order_meta as om2', function($join) {
                $join->on('om2.order_id', '=', 'order.id')
                    ->where('om2.key', 'token');
            });
        }

        $query->where('order.created_at', '>', $filter['from'])
            ->where('order.created_at', '<', $filter['to']);
        $orders = $query->get($columns);

        return $orders;
    }

    public function find(Request $request) {
        $filter = $this->buildFindFilter($request);
        $items = SearchReact::buildQuery($filter)
            ->groupBy('product_id')
            ->get([
                'product_id', 'keyword',
                DB::raw('SUM(click) as total_click, SUM(conversion) as total_conversion')
            ]);
        return response()->json([
            'data' => $items,
            'status' => 'successful'
        ]);

    }

    public function buildFindFilter($request) {
        $dateFrom = $request->input('from_date', date('Y-m-d', time() - 30 *86400));
        $dateTo = $request->input('to_date', date('Y-m-d', time()));
        $keyword = $request->input('keyword');
        $keyword = strtolower($keyword);
        return [
            'keyword' => $keyword,
            'date_gte' => $dateFrom,
            'date_lte' => $dateTo,
        ];
    }

    public function handleTrackingParams($trackingType = '') {
        if ($trackingType) {
            $this->orderMetaFrom = 'from_' . $trackingType;
            $this->orderMetaTrackingKeyword = $trackingType;
            $this->trackingClickerParams = $trackingType;
        }
    }

    private function decorTopKeywords(&$topKeywords)
    {
        $slugs = [];
        foreach ($topKeywords as $key => $topKeyword) {
            $slugKeyword = strToSlug($topKeyword->keyword);
            $topKeywords[$key]->slugKeyword = $slugKeyword;
            if (!in_array($slugKeyword, $slugs)) {
                $slugs[] = $slugKeyword;
            }
        }
        $arrSlugTags = array_unique($this->getArrayTagsFromSlug($slugs));
        foreach ($topKeywords as $key => $topKeyword) {
            if (in_array($topKeyword->slugKeyword, $arrSlugTags)) {
                $topKeywords[$key]->explore_url = route('tag::explore', ['tagTitle' => $topKeyword->slugKeyword]);
            }
            unset($topKeywords[$key]->slugKeyword);
        }
    }

    private function getArrayTagsFromSlug($slugs)
    {
        return DB::table('tag')->whereIn('slug', $slugs)->pluck('slug')->toArray();
    }
}
