<?php

namespace Modules\ZSearch\Controllers;

use App\Utils;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Modules\ZSearch\Services\ElasticSearchIndexSeller;

class SellerController extends Controller
{
    protected $elsSellerService = null;

    public function search(Request $request) {
        $response = [
            'status' => 'fail'
        ];
        try {
            $filter = $this->getRequestFilter($request);
            $data = [];
            if ($filter['seller'] && $filter['keyword']) {
                $data = $this->sellerService()->search($filter);
            }
            $response = [
                'status' => 'successful',
                'meta' => $this->buildMeta($data, $filter),
                'result' => $this->sellerService()->buildSearchData($data),
            ];
        } catch (\Exception $e) {
            //@todo on error
        }
        return response()->json($response);

    }

    public function indexBySeller(Request $request) {
        set_time_limit(3600 * 2);
        $sellerId = $request->input('seller_id');
        if ($sellerId && $this->sellerService()->checkActor($sellerId)) {
            $productIds = $this->getProductBySeller($sellerId);
            $this->sellerService()->multiIndexProductSeller($productIds);
            return response()->json([
                'status' => 'successful',
                'seller_id' => $sellerId,
                'count' => count($productIds),
            ]);
        }
        abort(404);
    }

    public function index(Request $request) {
        $productIds = $request->input('product_ids');
        if ($productIds && is_string($productIds)) {
            $productIds = explode(',', $productIds);
        }

        $res = [
            'status' => 'fail',
        ];
        if ($productIds) {
            $this->sellerService()->multiIndexProductSeller($productIds);
            $res = [
                'status' => 'successful',
                'count' => count($productIds),
            ];
        }
        return response()->json($res);
    }

    protected function getProductBySeller($sellerId) {
        return DB::table('product_n_user')
            ->where('user_id', $sellerId)
            ->pluck('product_id')
            ->toArray();
    }

    protected function sellerService() {
        if (!$this->elsSellerService) {
            $this->elsSellerService = new ElasticSearchIndexSeller();
        }
        return $this->elsSellerService;
    }

    protected function buildMeta($data, $filter) {
        $total = isset($data['hits']['total']) ? $data['hits']['total'] : 0;
        return $this->getMetaData($filter, $total);

    }

    protected function getRequestFilter($request) {
        $filter = [
            'keyword' => $request->input('q'),
            'page_size' => $request->input('page_size', 40),
            'from' => $request->input('page_id', 0) * $request->input('page_size', 40),
            'seller' => $this->sellerService()->getUserByToken($request->input('seller_token'))
        ];
        $columns = ['status', 'category', 'is_violation', 'is_trademark'];
        foreach ($columns as $column) {
            if ($request->has($column)){
                $filter[$column] = $request->input($column);
            }
        }
        return $filter;
    }



}