<?php

namespace Modules\ZSearch\Controllers;

use Illuminate\Http\Request;
use Modules\ZSearch\Controllers\Controller;
use Illuminate\Support\Facades\DB;

class TrackingController extends Controller {

    public function index(Request $request) {

    }

    public function report(Request $request) {
        return view('z-search::tracking.index', []);
    }

    public function find(Request $request) {
        $retVal = ['status' => 'error'];

        if ($request->has('dateFrom') && $request->has('dateTo')) {
            $filter = $request->all();
            $pageId = (int) $request->input('pageId', 0);
            $pageSize = (int) $request->input('pageSize', 50);
            if ($pageId < 0) {
                $pageId = 0;
            } 
            $query = $this->buildQuery($filter);

            $queryCount = clone $query;
                        
            $retVal = ['status' => 'successful', 'data' => []];

            if (!empty($filter['sortBy'])) {
                $sortParam = explode('-', $filter['sortBy']);
                if (count($sortParam) == 2) {
                    $query->orderBy($sortParam[0], $sortParam[1]);
                }
            }

            $items = $query->forPage($pageId + 1, $pageSize)->get();
            
            if ($items) {
                foreach ($items as $item) {
                    $item->conversion_rate = $this->ceiling($item->conversion_rate, 0.01);
                }
            }
            $retVal['data'] = $items;
            $retVal['pageId'] = $pageId;
            $retVal['pagesCount'] = $this->recordsCountToPagesCount($queryCount->get()->count(), $pageSize);

        }

        return response()->json($retVal, 200, [], JSON_NUMERIC_CHECK);
    }

    public function export(Request $request) {
        $filter = $request->all();
        $query = $this->buildQuery($filter);
        $dateFrom = date('Y-m-d',$filter['dateFrom']);
        $dateTo = date('Y-m-d', $filter['dateTo']);
        if (!empty($filter['sortBy'])) {
            $sortParam = explode('-', $filter['sortBy']);
            if (count($sortParam) == 2) {
                $query->orderBy($sortParam[0], $sortParam[1]);
            }
        }
        $items = $query->get();

        if ($items) {
            foreach ($items as $item) {
                $item->conversion_rate = $this->ceiling($item->conversion_rate, 0.01);
            }
        }
        $this->toExcel($items, 'thong_ke_tu_khoa_' . $dateFrom . '-' . $dateTo);

    }

    protected function toExcel($items, $fileName = '') {
        /** Build excel file to export */
        $objPHPExcel = new \PHPExcel();
        /** Setup properties for file excel */
        $objPHPExcel->getProperties()
            ->setCreator("Megaads Technical")
            ->setLastModifiedBy("Megaads Technical")
            ->setTitle("Report Keyword");
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()->SetCellValue('A1', "STT");
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', "Từ khóa");
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', "Số lượng");
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', "Chuyển đổi");
        $objPHPExcel->getActiveSheet()->SetCellValue('E1', "Tỉ lệ chuyển đổi");

        $i = 1;
        foreach ($items as $item) {
            $i++;
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $i, $i - 1);
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $i, $item->keyword);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $i, $item->quantity);
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $i, $item->total_conversion);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $i, $item->conversion_rate);
        }

        $writer = \PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        ob_end_clean();
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $fileName . '.xlsx"');
        header('Cache-Control: max-age=0');
        $writer->save('php://output');
    }

    private function ceiling($number, $significance = 1)
    {
        return (is_numeric($number) && is_numeric($significance)) ? (ceil($number / $significance) * $significance) : 0;
    }

    public function buildQuery($filter) {
        $columns = [
            'search_tracking.keyword',
            DB::raw('SUM(sb_search_tracking.quantity) as quantity'),
            DB::raw('SUM(sb_search_tracking.conversion) as total_conversion'),
            DB::raw('SUM(sb_search_tracking.conversion)/SUM(sb_search_tracking.quantity) * 100  as conversion_rate'),

        ];
        $dateFrom = date('Y-m-d',$filter['dateFrom']);
        $dateTo = date('Y-m-d', $filter['dateTo']);
        $query = DB::table('search_tracking')
            ->whereBetween('search_tracking.created_at', [$dateFrom, $dateTo])
            ->groupBy('search_tracking.keyword');
        if (!empty($filter['keyword'])) {
            $query->where('keyword', 'LIKE', '%'. $filter['keyword'] .'%');
        }
        $query->select($columns);
        return $query;
    }
}