<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSearchTrackingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('search_tracking')) {
            Schema::create('search_tracking', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('keyword', 100);
                $table->integer('quantity')->default(1);
                $table->date('created_at');
                $table->date('updated_at');
                $table->unique(['keyword', 'created_at']);

                $table->charset = 'utf8mb4';
                $table->collation = 'utf8mb4_unicode_ci';
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //Schema::dropIfExists('search_tracking');
    }
}
